/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.messages;

import com.tridium.andoverAC256.enums.BAndoverPromptEnum;
import com.tridium.andoverAC256.messages.AndoverMessageConst;
import com.tridium.basicdriver.message.ReceivedMessage;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.IntHashMap;
import javax.baja.util.Lexicon;

public class AndoverReceivedMessage
extends ReceivedMessage
implements AndoverMessageConst {
    private static final IntHashMap errMap = new IntHashMap();
    private static Lexicon lex = Lexicon.make((String)"andoverAC256");
    public String message;
    public BAndoverPromptEnum prompt;
    public int exceptionCode;
    public int domain;
    public String errorMsg;
    private byte[] byteData;

    public AndoverReceivedMessage() {
        this.byteData = null;
    }

    public AndoverReceivedMessage(byte[] data) {
        this.message = new String(data);
        this.byteData = data;
        this.checkPrompt();
        this.isError();
    }

    public AndoverReceivedMessage(String data) {
        this.message = data;
        this.byteData = data.getBytes();
        this.checkPrompt();
        this.isError();
    }

    public AndoverReceivedMessage(byte[] data, boolean consoleMode) {
        this.message = new String(data);
        this.byteData = data;
    }

    public String getMessage() {
        return this.message;
    }

    public BAndoverPromptEnum getPrompt() {
        if (this.prompt == null) {
            this.checkPrompt();
        }
        return this.prompt;
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        sb.append("0x");
        sb.append(ByteArrayUtil.toHexString((byte[])this.byteData));
        return sb.toString();
    }

    private void checkPrompt() {
        if (this.message.indexOf("Bad Reload Block") != -1) {
            this.prompt = BAndoverPromptEnum.Reloading;
            return;
        }
        if (this.message.indexOf("R>") != -1) {
            this.domain = 0;
            this.prompt = BAndoverPromptEnum.RPrompt;
            return;
        }
        if (this.message.indexOf("P>") != -1) {
            this.domain = 0;
            this.prompt = BAndoverPromptEnum.PPrompt;
            return;
        }
        if (this.message.endsWith("?")) {
            this.prompt = BAndoverPromptEnum.QueryMode;
            return;
        }
        int promptStart = this.message.lastIndexOf("\n") + 1;
        try {
            if (this.message.charAt(promptStart) == '\n') {
                ++promptStart;
            }
            if (this.message.charAt(promptStart) == 'R') {
                if (this.message.charAt(promptStart + 1) == '>') {
                    this.domain = 0;
                } else {
                    String domainString = this.message.substring(promptStart + 2, this.message.indexOf(">"));
                    this.domain = Integer.parseInt(domainString, 10);
                }
                this.prompt = BAndoverPromptEnum.RPrompt;
                return;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            System.out.println("WARNING: unknown message:" + ByteArrayUtil.toHexString((byte[])this.message.getBytes()));
        }
        this.prompt = BAndoverPromptEnum.UnknownPrompt;
    }

    public boolean isError() {
        if (this.message.length() == 0) {
            return true;
        }
        String resp = new String(this.message);
        int bellCharPosition = resp.indexOf("\u0007");
        if (bellCharPosition != -1) {
            String errorString;
            if (resp.indexOf("P>") != -1) {
                return false;
            }
            this.errorMsg = resp.substring(0, bellCharPosition);
            int startPosition = this.errorMsg.indexOf("?");
            int endPosition = this.errorMsg.indexOf("?", startPosition + 1);
            try {
                errorString = this.errorMsg.substring(startPosition + 1, endPosition).trim();
            }
            catch (StringIndexOutOfBoundsException e) {
                this.exceptionCode = 24;
                return true;
            }
            this.exceptionCode = errorString.equalsIgnoreCase("Access Denied") ? 2 : (errorString.equalsIgnoreCase("Ambiguous Keyword") ? 3 : (errorString.equalsIgnoreCase("Bad Number") ? 4 : (errorString.equalsIgnoreCase("Bad Reload Block") ? 5 : (errorString.equalsIgnoreCase("Binary Operator Expected") ? 6 : (errorString.equalsIgnoreCase("Duplicate Symbol Assignment") ? 7 : (errorString.equalsIgnoreCase("Entry Out of Range") ? 8 : (errorString.equalsIgnoreCase("Expression too Complex") ? 9 : (errorString.equalsIgnoreCase("Invalid Drum Number") ? 10 : (errorString.equalsIgnoreCase("Invalid Keyword") ? 11 : (errorString.equalsIgnoreCase("Invalid Line Number") ? 12 : (errorString.equalsIgnoreCase("Invalid Symbol") ? 13 : (errorString.equalsIgnoreCase("Invalid Variable") ? 14 : (errorString.equalsIgnoreCase("Line Lost") ? 15 : (errorString.equalsIgnoreCase("Program Area Full") ? 16 : (errorString.equalsIgnoreCase("Required Entry Missing") ? 17 : (errorString.equalsIgnoreCase("Syntax Error") ? 18 : (errorString.equalsIgnoreCase("Variable Out of Range") ? 19 : (errorString.equalsIgnoreCase("Variable or Unary Operator Expected") ? 20 : (errorString.equalsIgnoreCase("System Error") ? 21 : (errorString.equalsIgnoreCase("THERE IS NO LCU ATTACHED") ? 22 : (errorString.startsWith("Non-existent L") ? 22 : 24)))))))))))))))))))));
            return true;
        }
        if (resp.indexOf("P>") != -1) {
            this.errorMsg = "";
            return false;
        }
        if (resp.indexOf("R>") != -1) {
            this.errorMsg = "";
            return false;
        }
        int lastR = resp.lastIndexOf("\nR");
        if (lastR == -1) {
            this.errorMsg = "missing or invalid prompt";
            return true;
        }
        if (resp.indexOf(">", lastR) == -1) {
            this.errorMsg = "missing or invalid prompt";
            return true;
        }
        return this.exceptionCode != 0;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errmessage) {
        this.errorMsg = errmessage;
    }

    public int getExceptionCode() {
        return this.exceptionCode;
    }

    public void setExceptionCode(int code) {
        this.exceptionCode = code;
    }

    public int getDomain() {
        return this.domain;
    }

    public void setDomain(int domain) {
        this.domain = domain;
    }

    public String getError() {
        String s = (String)errMap.get(this.exceptionCode);
        if (s != null) {
            return s;
        }
        return "Unknown AC256 error:" + this.exceptionCode;
    }

    static {
        errMap.put(24, (Object)lex.getText("errAc256.unknownError"));
        errMap.put(2, (Object)lex.getText("errAc256.accessDenied"));
        errMap.put(3, (Object)lex.getText("errAc256.ambiguousKeyword"));
        errMap.put(4, (Object)lex.getText("errAc256.badNumber"));
        errMap.put(5, (Object)lex.getText("errAc256.badReloadBlock"));
        errMap.put(6, (Object)lex.getText("errAc256.binaryOperatorExpected"));
        errMap.put(7, (Object)lex.getText("errAc256.duplicateSymbolAssignment"));
        errMap.put(8, (Object)lex.getText("errAc256.entryOutOfRange"));
        errMap.put(9, (Object)lex.getText("errAc256.expressionTooComplex"));
        errMap.put(10, (Object)lex.getText("errAc256.invalidDrumNumber"));
        errMap.put(11, (Object)lex.getText("errAc256.invalidKeyword"));
        errMap.put(12, (Object)lex.getText("errAc256.invalidLineNumber"));
        errMap.put(13, (Object)lex.getText("errAc256.invalidSymbol"));
        errMap.put(14, (Object)lex.getText("errAc256.invalidVariable"));
        errMap.put(15, (Object)lex.getText("errAc256.lineLost"));
        errMap.put(16, (Object)lex.getText("errAc256.programAreaFull"));
        errMap.put(17, (Object)lex.getText("errAc256.requiredEntryMissing"));
        errMap.put(18, (Object)lex.getText("errAc256.syntaxError"));
        errMap.put(19, (Object)lex.getText("errAc256.variableOutOfRange"));
        errMap.put(20, (Object)lex.getText("errAc256.variableOrUnaryOperatorExpected"));
        errMap.put(21, (Object)lex.getText("errAc256.systemError"));
        errMap.put(22, (Object)lex.getText("errAc256.missingLcu"));
    }
}

