/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.driver.ping;

import com.tridium.httpClient.BHttpClientService;
import com.tridium.httpClient.comm.client.BIHttpCommClient;
import com.tridium.httpClient.comm.client.BIHttpCommClientWrite;
import com.tridium.httpClient.datatypes.BHttpAddress;
import com.tridium.httpClient.datatypes.BHttpResponseHealth;
import com.tridium.httpClient.datatypes.BHttpTuningPolicy;
import com.tridium.httpClient.datatypes.options.BHttpHeaders;
import com.tridium.httpClient.datatypes.options.BHttpParameters;
import com.tridium.httpClient.datatypes.payload.BRequestBody;
import com.tridium.httpClient.driver.BHttpClientDevice;
import com.tridium.httpClient.driver.BHttpClientNetwork;
import com.tridium.httpClient.util.HttpClientRegister;
import com.tridium.httpClient.util.HttpClientUtils;
import com.tridium.httpClient.util.ParentLegal;
import com.tridium.ndriver.util.SfUtil;
import javax.baja.driver.BDevice;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.httpClient.datatypes.BHttpRequestMethod;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="health", type="BHttpResponseHealth", defaultValue="new BHttpResponseHealth()"), @NiagaraProperty(name="address", type="BHttpAddress", defaultValue="new BHttpAddress()", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}), @NiagaraProperty(name="method", type="BHttpRequestMethod", defaultValue="BHttpRequestMethod.DEFAULT", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}), @NiagaraProperty(name="headers", type="BHttpHeaders", defaultValue="new BHttpHeaders()"), @NiagaraProperty(name="parameters", type="BHttpParameters", defaultValue="new BHttpParameters()"), @NiagaraProperty(name="requestBody", type="BRequestBody", defaultValue="new BRequestBody()")})
public class BHttpClientPingAddress
extends BComponent
implements BIHttpCommClient,
BIHttpCommClientWrite {
    @Generated
    public static final Property health = BHttpClientPingAddress.newProperty((int)0, (BValue)new BHttpResponseHealth(), null);
    @Generated
    public static final Property address = BHttpClientPingAddress.newProperty((int)0, (BValue)new BHttpAddress(), (BFacets)SfUtil.incl((String)"ed"));
    @Generated
    public static final Property method = BHttpClientPingAddress.newProperty((int)0, (BValue)BHttpRequestMethod.DEFAULT, (BFacets)SfUtil.incl((String)"ed"));
    @Generated
    public static final Property headers = BHttpClientPingAddress.newProperty((int)0, (BValue)new BHttpHeaders(), null);
    @Generated
    public static final Property parameters = BHttpClientPingAddress.newProperty((int)0, (BValue)new BHttpParameters(), null);
    @Generated
    public static final Property requestBody = BHttpClientPingAddress.newProperty((int)0, (BValue)new BRequestBody(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHttpClientPingAddress.class);
    private static final BIcon ICON = BIcon.std((String)"gears.png");

    @Override
    @Generated
    public BHttpResponseHealth getHealth() {
        return (BHttpResponseHealth)this.get(health);
    }

    @Override
    @Generated
    public void setHealth(BHttpResponseHealth v) {
        this.set(health, (BValue)v, null);
    }

    @Override
    @Generated
    public BHttpAddress getAddress() {
        return (BHttpAddress)this.get(address);
    }

    @Override
    @Generated
    public void setAddress(BHttpAddress v) {
        this.set(address, (BValue)v, null);
    }

    @Override
    @Generated
    public BHttpRequestMethod getMethod() {
        return (BHttpRequestMethod)this.get(method);
    }

    @Override
    @Generated
    public void setMethod(BHttpRequestMethod v) {
        this.set(method, (BValue)v, null);
    }

    @Override
    @Generated
    public BHttpHeaders getHeaders() {
        return (BHttpHeaders)this.get(headers);
    }

    @Override
    @Generated
    public void setHeaders(BHttpHeaders v) {
        this.set(headers, (BValue)v, null);
    }

    @Override
    @Generated
    public BHttpParameters getParameters() {
        return (BHttpParameters)this.get(parameters);
    }

    @Override
    @Generated
    public void setParameters(BHttpParameters v) {
        this.set(parameters, (BValue)v, null);
    }

    @Override
    @Generated
    public BRequestBody getRequestBody() {
        return (BRequestBody)this.get(requestBody);
    }

    @Generated
    public void setRequestBody(BRequestBody v) {
        this.set(requestBody, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public BHttpTuningPolicy getHttpTuningPolicy() {
        BDevice device;
        BHttpClientNetwork network;
        if (this.getParent().getType().is(BHttpClientDevice.TYPE) && (network = ((BHttpClientDevice)(device = this.getParentDevice()).as(BHttpClientDevice.class)).getHttpNetwork()) != null) {
            BTuningPolicyMap tuning = network.getTuningPolicies();
            return (BHttpTuningPolicy)tuning.getDefaultPolicy();
        }
        throw new BajaRuntimeException("Device ping: cannot find network tuning policy");
    }

    public void started() {
        if (Sys.isStation()) {
            HttpClientRegister.registerClient(this);
        }
    }

    public void stopped() {
        if (Sys.isStation()) {
            HttpClientRegister.unregisterClient(this);
        }
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && property.equals(address)) {
            HttpClientUtils.auditAddressChange(this.getAddress(), context);
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return ParentLegal.is((BComplex)this, (BComplex)parent, BHttpClientDevice.TYPE);
    }

    @Override
    public void writeRequested() {
        this.getParentDevice().ping();
    }

    @Override
    public void send() {
        this.writeRequested();
    }

    @Override
    public String sendSync() throws Exception {
        this.getParentDevice().doPing();
        return this.getLastResponseBody();
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        return BHttpClientService.post(this, action, argument, cx);
    }

    @Override
    public final boolean isDriverBasedClient() {
        return true;
    }

    public String identifierForLogs() {
        return this.getParentDevice().getName() + "-ping";
    }

    private BDevice getParentDevice() {
        BDevice device = (BDevice)HttpClientUtils.getParent((BComplex)this, BHttpClientDevice.class);
        if (device != null) {
            return device;
        }
        throw new IllegalArgumentException("No parent device found for ping address");
    }

    public BIcon getIcon() {
        return ICON;
    }
}

