/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.util.trigger;

import com.tridium.httpClient.comm.client.BIHttpCommClient;
import com.tridium.httpClient.comm.client.HttpCommResponse;
import com.tridium.httpClient.conditions.BConditions;
import com.tridium.httpClient.util.BIHttpConsumer;
import com.tridium.httpClient.util.HttpConsumable;
import com.tridium.httpClient.util.trigger.BFireOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="fireOn", type="BFireOn", defaultValue="BFireOn.DEFAULT"), @NiagaraProperty(name="conditions", type="BConditions", defaultValue="new BConditions()"), @NiagaraProperty(name="triggered", type="boolean", defaultValue="false", flags=1)})
@NiagaraTopic(name="trigger", eventType="BString", flags=8)
public class BResponseTrigger
extends BComponent
implements BIHttpConsumer {
    @Generated
    public static final Property enabled = BResponseTrigger.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property fireOn = BResponseTrigger.newProperty((int)0, (BValue)BFireOn.DEFAULT, null);
    @Generated
    public static final Property conditions = BResponseTrigger.newProperty((int)0, (BValue)new BConditions(), null);
    @Generated
    public static final Property triggered = BResponseTrigger.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Topic trigger = BResponseTrigger.newTopic((int)8, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BResponseTrigger.class);
    private final Object mutex = new Object();
    private int lastResponseCode = -1;

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BFireOn getFireOn() {
        return (BFireOn)this.get(fireOn);
    }

    @Generated
    public void setFireOn(BFireOn v) {
        this.set(fireOn, (BValue)v, null);
    }

    @Generated
    public BConditions getConditions() {
        return (BConditions)this.get(conditions);
    }

    @Generated
    public void setConditions(BConditions v) {
        this.set(conditions, (BValue)v, null);
    }

    @Generated
    public boolean getTriggered() {
        return this.getBoolean(triggered);
    }

    @Generated
    public void setTriggered(boolean v) {
        this.setBoolean(triggered, v, null);
    }

    @Generated
    public void fireTrigger(BString event) {
        this.fire(trigger, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BIHttpCommClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(HttpConsumable consumable) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.isRunning() && this.getEnabled() && consumable instanceof HttpCommResponse) {
                HttpCommResponse response = (HttpCommResponse)consumable;
                boolean shouldFire = this.shouldFire(response);
                if (shouldFire) {
                    this.exec(response);
                }
                this.setTriggered(shouldFire);
                this.lastResponseCode = response.getResponseCode();
            }
        }
    }

    protected void exec(HttpCommResponse response) {
        this.fireTrigger(BString.make((String)response.getBody()));
    }

    private boolean shouldFire(HttpCommResponse response) {
        int responseCode = response.getResponseCode();
        boolean responseCodeCheck = this.getFireOn().equals((Object)BFireOn.always) || this.getFireOn().equals((Object)BFireOn.responseCodeChanged) && this.lastResponseCode != responseCode || this.getFireOn().equals((Object)BFireOn.on200) && responseCode == 200 || this.getFireOn().equals((Object)BFireOn.on2xx) && response.isSuccessResponse() || this.getFireOn().equals((Object)BFireOn.non2xx) && !response.isSuccessResponse() || this.getFireOn().equals((Object)BFireOn.unauthOrForbidden) && (responseCode == 401 || responseCode == 403);
        return responseCodeCheck && this.getConditions().accept(response);
    }

    public BIcon getIcon() {
        return BIcon.std((String)"linkFrom.png");
    }
}

