/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.httpClient;

import com.tridium.httpClient.BHttpClient;
import com.tridium.httpClient.datatypes.BHttpAddress;
import com.tridium.httpClient.datatypes.auth.BBasicHttpAuth;
import com.tridium.httpClient.datatypes.auth.BBearerTokenAuth;
import com.tridium.httpClient.datatypes.auth.BHeaderTokenAuth;
import com.tridium.httpClient.datatypes.auth.BHttpAuthenticator;
import com.tridium.httpClient.datatypes.auth.BNiagaraScramShaDigestAuth;
import com.tridium.httpClient.datatypes.auth.BParameterTokenAuth;
import com.tridium.httpClient.datatypes.auth.BResponseCookieAuth;
import com.tridium.httpClient.datatypes.enums.BHttpMode;
import com.tridium.httpClient.datatypes.payload.BFileSource;
import com.tridium.httpClient.datatypes.payload.BParameterStringSource;
import com.tridium.httpClient.datatypes.payload.BReportPayloadSource;
import com.tridium.httpClient.datatypes.payload.BSlotSource;
import com.tridium.httpClient.util.HttpClientUtils;
import com.tridium.util.PrefixLogUtil;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.httpClient.IHttpClient;
import javax.baja.httpClient.datatypes.BHttpRequestMethod;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.util.BTypeSpec;

public class HttpClientBuilder {
    private String slotPathOrd;
    private String clientName;
    private final BHttpClient httpClient = new BHttpClient();

    private HttpClientBuilder() {
    }

    public static HttpClientBuilder instance() {
        return new HttpClientBuilder();
    }

    public HttpClientBuilder withMethod(BHttpRequestMethod method) {
        this.httpClient.setMethod(method);
        return this;
    }

    public HttpClientBuilder withMethod(String methodStr) {
        try {
            BHttpRequestMethod method = BHttpRequestMethod.make(methodStr.toLowerCase());
            this.httpClient.setMethod(method);
        }
        catch (InvalidEnumException e) {
            BEnumRange range = BHttpRequestMethod.get.getRange();
            String supportedTypes = Arrays.stream(range.getOrdinals()).mapToObj(ordinal -> range.getTag(ordinal).toUpperCase()).collect(Collectors.joining(","));
            throw new IllegalArgumentException("Supported Method Types are " + supportedTypes);
        }
        return this;
    }

    public HttpClientBuilder withAddress(String urlAddress) {
        this.httpClient.getAddress().doPopulateFromUrl(BString.make((String)urlAddress));
        return this;
    }

    public HttpClientBuilder withAddress(boolean secure, String hostAddress, int port, String path) {
        this.httpClient.setAddress(new BHttpAddress(secure ? BHttpMode.secure : BHttpMode.insecure, hostAddress, port, path));
        return this;
    }

    public HttpClientBuilder withHttpAddress(String hostAddress, String path) {
        this.httpClient.setAddress(new BHttpAddress(BHttpMode.insecure, hostAddress, 80, path));
        return this;
    }

    public HttpClientBuilder withHttpsAddress(String hostAddress, String path) {
        this.httpClient.setAddress(new BHttpAddress(BHttpMode.DEFAULT, hostAddress, 443, path));
        return this;
    }

    public HttpClientBuilder withHeader(String headerName, BSimple headerValue) {
        this.httpClient.getHeaders().addNewOption(headerName, (BValue)headerValue);
        return this;
    }

    public HttpClientBuilder withParameter(String parameterName, BSimple parameterValue) {
        this.httpClient.getParameters().addNewOption(parameterName, (BValue)parameterValue);
        return this;
    }

    public HttpClientBuilder withAuthenticator(BTypeSpec authType) {
        BHttpAuthenticator authenticator = new BHttpAuthenticator();
        authenticator.setAuthType(authType);
        authenticator.checkAuthenticator();
        this.httpClient.setAuthenticator(authenticator);
        return this;
    }

    public HttpClientBuilder withBasicAuthenticator(String username, String password) {
        this.httpClient.setAuthenticator(BBasicHttpAuth.createBasicAuthenticator(username, password));
        return this;
    }

    public HttpClientBuilder withHeaderTokenAuthenticator(String headerName, String headerValue) {
        this.httpClient.setAuthenticator(BHeaderTokenAuth.createHeaderTokenAuthenticator(headerName, headerValue));
        return this;
    }

    public HttpClientBuilder withParameterTokenAuthenticator(String parameterName, String parameterValue) {
        this.httpClient.setAuthenticator(BParameterTokenAuth.createParameterTokenAuthenticator(parameterName, parameterValue));
        return this;
    }

    public HttpClientBuilder withBearerAuthenticator(String token) {
        this.httpClient.setAuthenticator(BBearerTokenAuth.createBearerAuthenticator(token));
        return this;
    }

    public HttpClientBuilder withCookieAuthenticator(IHttpClient sourceClient, String cookieName) {
        String handle = ((BComponent)sourceClient).getHandleOrd().toString();
        this.httpClient.setAuthenticator(BResponseCookieAuth.createCookieAuthenticator(handle, cookieName));
        return this;
    }

    public HttpClientBuilder withNiagaraAuthenticator(String username, String password) {
        this.httpClient.setAuthenticator(BNiagaraScramShaDigestAuth.createScramShaAuthenticator(username, password));
        return this;
    }

    public HttpClientBuilder withStringPayload(String data) {
        return this.withStringPayload(data, "");
    }

    public HttpClientBuilder withStringPayload(String data, String userContentType) {
        this.httpClient.getRequestBody().setSourceType(BSlotSource.TYPE.getTypeSpec());
        this.httpClient.getRequestBody().setSource(BSlotSource.make(data));
        this.httpClient.getRequestBody().getContentTypeHeader().setUserContentType(userContentType);
        return this;
    }

    public HttpClientBuilder withFilePayload(BOrd fileOrd, String userContentType) {
        this.httpClient.getRequestBody().setSourceType(BFileSource.TYPE.getTypeSpec());
        this.httpClient.getRequestBody().setSource(BFileSource.make(fileOrd));
        this.httpClient.getRequestBody().getContentTypeHeader().setUserContentType(userContentType);
        return this;
    }

    public HttpClientBuilder withFormPayload() {
        this.httpClient.getRequestBody().setSourceType(BParameterStringSource.TYPE.getTypeSpec());
        this.httpClient.getRequestBody().setSource(new BParameterStringSource());
        return this;
    }

    public HttpClientBuilder withReportPayload(BOrd reportSourceOrd) {
        this.httpClient.getRequestBody().setSourceType(BReportPayloadSource.TYPE.getTypeSpec());
        this.httpClient.getRequestBody().setSource(BReportPayloadSource.make(reportSourceOrd));
        return this;
    }

    public HttpClientBuilder withoutSendOnStart() {
        this.httpClient.getHttpTuningPolicy().setWriteOnStart(false);
        return this;
    }

    public HttpClientBuilder mountAtOrd(String slotPathOrd, String clientName) {
        this.slotPathOrd = slotPathOrd;
        this.clientName = clientName;
        return this;
    }

    public IHttpClient build() {
        if (this.slotPathOrd != null && this.clientName != null) {
            if (!Sys.isStation()) {
                throw new IllegalArgumentException("No running station detected for mounting the http client");
            }
            BObject location = BOrd.make((String)this.slotPathOrd).get((BObject)Sys.getStation());
            if (location instanceof BComponent) {
                String name = SlotPath.escape((String)this.clientName);
                location.asComponent().add(name, (BValue)this.httpClient);
                PrefixLogUtil.logWithPrefix((Logger)HttpClientUtils.MAIN_LOGGER, (Level)Level.FINE, (String)("Added " + name + " to " + location), (Object)this);
            } else {
                throw new IllegalArgumentException("Path supplied for client is not a component");
            }
        }
        return this.httpClient;
    }
}

