/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.haystack;

import com.tridium.driver.file.util.CsvParser;
import com.tridium.haystack.BHaystack3To4MigrationParams;
import com.tridium.haystack.BHaystack4TagDictionary;
import com.tridium.sys.service.ServiceManager;
import com.tridium.sys.tag.ComponentRelations;
import com.tridium.sys.tag.ComponentTags;
import com.tridium.tagdictionary.BNiagaraTagDictionary;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.file.types.text.BCsvFile;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.neql.NeqlEntityEvaluator;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BMarker;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Relations;
import javax.baja.tag.Tag;
import javax.baja.tag.TagDictionary;
import javax.baja.tag.TagGroupInfo;
import javax.baja.tag.TagInfo;
import javax.baja.tag.Tags;
import javax.baja.tagdictionary.BTagGroupInfo;
import javax.baja.tagdictionary.BTagInfo;
import javax.baja.user.BUser;

@NiagaraType
public class BHaystack3To4MigrationJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BHaystack3To4MigrationJob.class);
    private static final int H3_NAME = 0;
    private static final int H3_TYPE = 1;
    private static final int H3_QUERY = 2;
    private static final int H4_NAMES = 3;
    private static final int H4_TYPE = 4;
    private static final Pattern QUERY_NAMESPACE_REPLACEMENT = Pattern.compile("hs:", 16);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final TagAction[] EMPTY_ACTION_ARRAY = new TagAction[0];
    private static final TagInfo POINT_TAG_INFO = new TagInfo(){

        public Optional<TagDictionary> getDictionary() {
            return Optional.empty();
        }

        public String getName() {
            return "point";
        }

        public BIDataValue getDefaultValue() {
            return BMarker.MARKER;
        }
    };
    private final String h3Namespace;
    private final BHaystack4TagDictionary h4Dict;
    private final BOrd configFileOrd;
    private int configLineNum;
    private final Map<String, TagHandler> tagToTagMap = new HashMap<String, TagHandler>();
    private final Map<String, TagGroupHandler> tagToTagGroupMap = new HashMap<String, TagGroupHandler>();
    private final Map<String, TagGroupHandler> tagGroupMap = new HashMap<String, TagGroupHandler>();
    private final Map<String, String> relationMap = new HashMap<String, String>();
    private BComponent component;
    private Tags componentTags;
    private Relations componentRelations;
    private final List<Id> addedTagIds = new ArrayList<Id>();
    private final List<Id> notAddedTagIds = new ArrayList<Id>();
    private final List<Id> addedTagGroupIds = new ArrayList<Id>();
    private final List<Id> addedTagGroupTagIds = new ArrayList<Id>();
    private final List<Id> notAddedTagGroupIds = new ArrayList<Id>();
    private final List<String> addedRelations = new ArrayList<String>();
    private final Set<Id> notAddedRelationIds = new HashSet<Id>();
    private final TagAction tagRemoved = new TagAction("", null);
    private final TagAction[] tagRemovedArray = new TagAction[]{this.tagRemoved};

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHaystack3To4MigrationJob() {
        this.configFileOrd = BOrd.NULL;
        this.h3Namespace = null;
        this.h4Dict = null;
    }

    public BHaystack3To4MigrationJob(BHaystack3To4MigrationParams params, BHaystack4TagDictionary h4Dict) {
        this.configFileOrd = params.getMigrationFilePath();
        this.h3Namespace = params.getHaystack3Namespace();
        this.h4Dict = h4Dict;
    }

    public BOrd submit(Context cx) {
        BHaystack3To4MigrationJob.checkIsSuperUser(cx);
        BComponent jobService = (BComponent)BJobService.getService();
        BJob[] jobs = (BJob[])jobService.getChildren(BHaystack3To4MigrationJob.class);
        if (jobs.length > 0) {
            int disposeIndex = jobs.length - ServiceManager.jobMaxCountPerType;
            for (int i = jobs.length - 1; i >= 0; --i) {
                if (jobs[i].isAlive()) {
                    throw new LocalizableRuntimeException("haystack", "haystack3MigrationJob.jobAlreadyRunning");
                }
                if (i > disposeIndex) continue;
                jobs[i].dispose();
            }
        }
        return super.submit(cx);
    }

    public void run(Context cx) throws Exception {
        BHaystack3To4MigrationJob.checkIsSuperUser(cx);
        this.log().start("haystack", "haystack3MigrationJob.startJob", new String[]{this.configFileOrd.toString()});
        this.processConfigFile();
        Exception lastFailure = null;
        Iterator components = Sys.getStation().getComponentSpace().iterateAllComponents();
        while (components.hasNext()) {
            this.component = (BComponent)components.next();
            this.componentTags = new ComponentTags(this.component);
            this.componentRelations = new ComponentRelations(this.component);
            try {
                this.migrateDirectTags();
                this.migrateTagGroups();
                this.migrateDirectRelations();
            }
            catch (Exception e) {
                lastFailure = e;
                this.log().failed("haystack", "haystack3MigrationJob.componentFailed", this.component.getSlotPath().toString(), (Throwable)e);
            }
        }
        this.log().message("haystack", "haystack3MigrationJob.endJob");
        if (lastFailure != null) {
            throw lastFailure;
        }
        this.log().endSuccess();
    }

    private static void checkIsSuperUser(Context cx) {
        BUser user;
        BUser bUser = user = cx != null ? cx.getUser() : null;
        if (user == null || !user.getPermissions().isSuperUser()) {
            throw new LocalizableRuntimeException("haystack", "haystack3MigrationJob.mustBeSuperUser");
        }
    }

    private void processConfigFile() {
        BIFile configFile = this.resolveConfigFile();
        this.configLineNum = 1;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(configFile.getInputStream()));){
            String[] row;
            CsvParser parser = new CsvParser(reader);
            while ((row = parser.readLine()) != null) {
                if (this.configLineNum == 1) {
                    this.checkHeader(row);
                } else {
                    this.processRow(row);
                }
                ++this.configLineNum;
            }
        }
        catch (LocalizableRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException("haystack", "haystack3MigrationJob.configFile.parsingError", new Object[]{this.configLineNum, this.configFileOrd}, (Throwable)e);
        }
    }

    private BIFile resolveConfigFile() {
        BIFile configFile;
        try {
            configFile = (BIFile)this.configFileOrd.resolve((BObject)this.h4Dict).get();
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException("haystack", "haystack3MigrationJob.configFile.unresolved", new Object[]{this.configFileOrd}, (Throwable)e);
        }
        if (!(configFile instanceof BCsvFile)) {
            throw new LocalizableRuntimeException("haystack", "haystack3MigrationJob.configFile.notCsv", new Object[]{this.configFileOrd});
        }
        return configFile;
    }

    private void checkHeader(String[] headerRow) {
        if (!(headerRow.length == 5 && headerRow[0].equals("h3Name") && headerRow[1].equals("h3Type") && headerRow[2].equals("h3Query") && headerRow[3].equals("h4Names") && headerRow[4].equals("h4Type"))) {
            throw new LocalizableRuntimeException("haystack", "haystack3MigrationJob.configFile.invalidHeader", new Object[]{this.configFileOrd, String.join((CharSequence)",", headerRow)});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processRow(String[] row) {
        if (row.length != 5) {
            throw new LocalizableRuntimeException("haystack", "haystack3MigrationJob.configFile.invalidRowLength", new Object[]{this.configLineNum, this.configFileOrd, String.join((CharSequence)",", row)});
        }
        String h3Name = row[0].trim();
        String h4Names = row[3].trim();
        if (h3Name.isEmpty() || h4Names.isEmpty()) {
            throw new LocalizableRuntimeException("haystack", "haystack3MigrationJob.configFile.invalidNameValue", new Object[]{this.configLineNum, this.configFileOrd, String.join((CharSequence)",", row)});
        }
        String h3Type = row[1].trim();
        String h3Query = row[2].trim();
        String h4Type = row[4].trim();
        if (h3Type.equals("tag")) {
            if (h4Type.equals("tag")) {
                this.tagToTagMap.put(h3Name, new TagHandler().parse(h3Query, h4Names));
                return;
            } else {
                if (!h4Type.equals("tagGroup")) throw new LocalizableRuntimeException("haystack", "haystack3MigrationJob.configFile.invalidH4Type", new Object[]{h4Type, h3Type, this.configLineNum, this.configFileOrd, String.join((CharSequence)",", row)});
                this.tagToTagGroupMap.put(h3Name, new TagGroupHandler().parse(h4Names));
            }
            return;
        } else if (h3Type.equals("tagGroup")) {
            this.tagGroupMap.put(h3Name, new TagGroupHandler().parse(h4Names));
            return;
        } else {
            if (!h3Type.equals("relation")) throw new LocalizableRuntimeException("haystack", "haystack3MigrationJob.configFile.invalidH3Type", new Object[]{h3Type, this.configLineNum, this.configFileOrd, String.join((CharSequence)",", row)});
            if (!h4Type.equals("relation")) throw new LocalizableRuntimeException("haystack", "haystack3MigrationJob.configFile.invalidH4Type", new Object[]{h4Type, h3Type, this.configLineNum, this.configFileOrd, String.join((CharSequence)",", row)});
            this.relationMap.put(h3Name, h4Names);
            this.tagToTagMap.put(h3Name, new TagHandler().parse(h3Query, h4Names));
        }
    }

    private void migrateDirectTags() {
        this.addedTagIds.clear();
        this.notAddedTagIds.clear();
        for (Tag tag : this.componentTags.getAll()) {
            if (!tag.getId().getDictionary().equals(this.h3Namespace)) continue;
            this.addH4TagForH3Tag(tag.getId().getName(), tag.getValue());
        }
        if (!this.addedTagIds.isEmpty()) {
            this.log().message("haystack", "haystack3MigrationJob.tagsAdded", new String[]{this.component.getSlotPath().toString(), this.addedTagIds.toString()});
        }
        if (!this.notAddedTagIds.isEmpty()) {
            this.log().message("haystack", "haystack3MigrationJob.tagsNotAdded", new String[]{this.component.getSlotPath().toString(), this.notAddedTagIds.toString()});
        }
    }

    private void addH4TagForH3Tag(String h3Name, BIDataValue h3Value) {
        TagHandler tagHandler = this.tagToTagMap.get(h3Name);
        if (tagHandler != null) {
            tagHandler.handleTag(h3Name, h3Value);
            return;
        }
        TagGroupHandler tagGroupHandler = this.tagToTagGroupMap.get(h3Name);
        if (tagGroupHandler != null) {
            tagGroupHandler.addTagGroup();
            return;
        }
        this.addH4Tag(h3Name, h3Value, this.addedTagIds);
    }

    private void addH4Tag(String tagName, BIDataValue tagValue, List<Id> tagIdList) {
        Id id = Id.newId((String)this.h4Dict.getNamespace(), (String)tagName);
        if (!this.componentTags.contains(id)) {
            this.componentTags.set(new Tag(id, tagValue));
            tagIdList.add(id);
        }
    }

    private void migrateTagGroups() {
        this.addedTagGroupIds.clear();
        this.addedTagGroupTagIds.clear();
        this.notAddedTagGroupIds.clear();
        for (Relation relation : this.componentRelations.getAll(BNiagaraTagDictionary.TAG_GROUP_RELATION, 2)) {
            TagGroupInfo tagGroup;
            Id tagGroupId;
            Entity endpoint = relation.getEndpoint();
            if (!(endpoint instanceof TagGroupInfo) || !(tagGroupId = (tagGroup = (TagGroupInfo)endpoint).getGroupId()).getDictionary().equals(this.h3Namespace)) continue;
            TagGroupHandler handler = this.tagGroupMap.get(tagGroupId.getName());
            if (handler != null) {
                if (handler.h4TagGroup == null) {
                    this.addTags(tagGroup.getTags());
                    this.notAddedTagGroupIds.add(tagGroupId);
                    continue;
                }
                handler.addTagGroup();
                continue;
            }
            this.addEquivalentH4TagGroup(tagGroup);
        }
        if (!this.addedTagGroupIds.isEmpty()) {
            this.log().message("haystack", "haystack3MigrationJob.tagGroupsAdded", new String[]{this.component.getSlotPath().toString(), this.addedTagGroupIds.toString()});
        }
        if (!this.addedTagGroupTagIds.isEmpty()) {
            this.log().message("haystack", "haystack3MigrationJob.tagGroupsTagsAdded", new String[]{this.component.getSlotPath().toString(), this.addedTagGroupTagIds.toString()});
        }
        if (!this.notAddedTagGroupIds.isEmpty()) {
            this.log().message("haystack", "haystack3MigrationJob.tagGroupsNotAdded", new String[]{this.component.getSlotPath().toString(), this.notAddedTagGroupIds.toString()});
        }
    }

    private void addTags(Iterator<TagInfo> tags) {
        while (tags.hasNext()) {
            TagInfo tag = tags.next();
            this.addH4TagForH3Tag(tag.getName(), tag.getDefaultValue());
        }
    }

    private void addEquivalentH4TagGroup(TagGroupInfo h3TagGroup) {
        Collection<TagInfo> h3Tags = BHaystack3To4MigrationJob.getTags(h3TagGroup);
        ArrayList<TagInfo> h3TagsPlusPoint = new ArrayList<TagInfo>(h3Tags);
        h3TagsPlusPoint.add(POINT_TAG_INFO);
        for (BTagGroupInfo h4TagGroup : (BTagGroupInfo[])this.h4Dict.getTagGroupDefinitions().getChildren(BTagGroupInfo.class)) {
            Collection<TagInfo> h4Tags = BHaystack3To4MigrationJob.getTags((TagGroupInfo)h4TagGroup);
            if (!BHaystack3To4MigrationJob.isEquivalent(h3Tags, h4Tags) && !BHaystack3To4MigrationJob.isEquivalent(h3TagsPlusPoint, h4Tags)) continue;
            this.addH4TagGroup(h4TagGroup);
            return;
        }
        this.addTags(h3Tags.iterator());
        this.notAddedTagGroupIds.add(h3TagGroup.getGroupId());
    }

    private static Collection<TagInfo> getTags(TagGroupInfo tagGroup) {
        ArrayList<TagInfo> tags = new ArrayList<TagInfo>();
        Iterator iterator = tagGroup.getTags();
        while (iterator.hasNext()) {
            tags.add((TagInfo)iterator.next());
        }
        return tags;
    }

    private static boolean isEquivalent(Collection<TagInfo> h3Tags, Collection<TagInfo> h4Tags) {
        if (h3Tags.size() != h4Tags.size()) {
            return false;
        }
        for (TagInfo h3Tag : h3Tags) {
            boolean found = false;
            for (TagInfo h4Tag : h4Tags) {
                if (!h4Tag.getName().equals(h3Tag.getName()) || !h4Tag.getDefaultValue().equals(h3Tag.getDefaultValue())) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private void addH4TagGroup(BTagGroupInfo tagGroup) {
        if (!this.componentRelations.get(BNiagaraTagDictionary.TAG_GROUP_RELATION, (Entity)tagGroup, 2).isPresent()) {
            BRelation relation = new BRelation(BNiagaraTagDictionary.TAG_GROUP_RELATION, tagGroup.getSlotPathOrd());
            this.component.add("r?", (BValue)relation, 1);
            relation.activateRelation();
            this.addedTagGroupIds.add(tagGroup.getGroupId());
        }
    }

    private void migrateDirectRelations() {
        this.addedRelations.clear();
        this.notAddedRelationIds.clear();
        for (Relation relation : this.componentRelations.getAll()) {
            Id id;
            if (relation.isInbound() || !(id = relation.getId()).getDictionary().equals(this.h3Namespace)) continue;
            String h4Name = this.relationMap.get(id.getName());
            if (h4Name == null) {
                h4Name = id.getName();
            }
            if (!h4Name.equals("{removed}")) {
                this.addH4Relation(h4Name, relation);
                continue;
            }
            this.notAddedRelationIds.add(id);
        }
        if (!this.addedRelations.isEmpty()) {
            this.log().message("haystack", "haystack3MigrationJob.relationsAdded", new String[]{this.component.getSlotPath().toString(), String.join((CharSequence)"; ", this.addedRelations)});
        }
        if (!this.notAddedRelationIds.isEmpty()) {
            this.log().message("haystack", "haystack3MigrationJob.relationsNotAdded", new String[]{this.component.getSlotPath().toString(), this.notAddedRelationIds.toString()});
        }
    }

    private void addH4Relation(String h4Name, Relation h3Relation) {
        BComponent endpoint;
        Id h4Id = Id.newId((String)this.h4Dict.getNamespace(), (String)h4Name);
        if (this.componentRelations.get(h4Id, (Entity)(endpoint = (BComponent)h3Relation.getEndpoint()), 2).isPresent()) {
            return;
        }
        BRelation h4Relation = new BRelation(h4Id, endpoint.getHandleOrd());
        this.componentRelations.add((Relation)h4Relation);
        h4Relation.activateRelation();
        this.addedRelations.add(h4Id + " -> \"" + endpoint.getSlotPath() + '\"');
    }

    private TagAction makeCopyValueTagAction(String tagName) {
        this.getTagInfo(tagName);
        return new TagAction(tagName, null);
    }

    private TagAction makeMarkerTagAction(String tagName) {
        BTagInfo tagInfo = this.getTagInfo(tagName);
        if (!tagInfo.getDefaultValue().equals(BMarker.MARKER)) {
            throw new LocalizableRuntimeException("haystack", "haystack3MigrationJob.configFile.valueDecodingError", new Object[]{"null", tagName, this.configLineNum, this.configFileOrd});
        }
        return new TagAction(tagName, (BIDataValue)BMarker.MARKER);
    }

    private TagAction makeValueTagAction(String[] tagNameValue) {
        BIDataValue mappedValue;
        if (tagNameValue.length != 2) {
            throw new LocalizableRuntimeException("haystack", "haystack3MigrationJob.configFile.emptyNameOrValue", new Object[]{this.configLineNum, this.configFileOrd});
        }
        String tagName = tagNameValue[0].trim();
        String tagValue = tagNameValue[1].trim();
        if (tagName.isEmpty() || tagValue.isEmpty()) {
            throw new LocalizableRuntimeException("haystack", "haystack3MigrationJob.configFile.emptyNameOrValue", new Object[]{this.configLineNum, this.configFileOrd});
        }
        BTagInfo tagInfo = this.getTagInfo(tagName);
        try {
            BIDataValue defaultValue = tagInfo.getDefaultValue();
            if (defaultValue instanceof BDynamicEnum) {
                BEnumRange range = ((BDynamicEnum)defaultValue).getRange();
                int ordinal = range.tagToOrdinal(tagValue);
                mappedValue = BDynamicEnum.make((int)ordinal, (BEnumRange)range);
            } else {
                mappedValue = (BIDataValue)defaultValue.decodeFromString(tagValue);
            }
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException("haystack", "haystack3MigrationJob.configFile.valueDecodingError", new Object[]{tagValue, tagName, this.configLineNum, this.configFileOrd}, (Throwable)e);
        }
        return new TagAction(tagName, mappedValue);
    }

    private BTagInfo getTagInfo(String tagName) {
        BTagInfo tagInfo = (BTagInfo)this.h4Dict.getTagDefinitions().get(tagName);
        if (tagInfo == null) {
            throw new LocalizableRuntimeException("haystack", "haystack3MigrationJob.configFile.tagMissing", new Object[]{tagName, this.configLineNum, this.configFileOrd});
        }
        return tagInfo;
    }

    private class TagGroupHandler {
        public BTagGroupInfo h4TagGroup;
        public TagAction additionalTag;

        private TagGroupHandler() {
        }

        public TagGroupHandler parse(String h4Names) {
            if (!h4Names.equals("{removed}")) {
                String[] names = h4Names.split(" ");
                this.h4TagGroup = (BTagGroupInfo)BHaystack3To4MigrationJob.this.h4Dict.getTagGroupDefinitions().get(names[0]);
                if (this.h4TagGroup == null) {
                    throw new LocalizableRuntimeException("haystack", "haystack3MigrationJob.configFile.tagGroupMissing", new Object[]{h4Names, BHaystack3To4MigrationJob.this.configLineNum, BHaystack3To4MigrationJob.this.configFileOrd});
                }
                if (names.length == 2) {
                    String additionalTag = names[1];
                    this.additionalTag = additionalTag.contains("=") ? BHaystack3To4MigrationJob.this.makeValueTagAction(additionalTag.split("=")) : BHaystack3To4MigrationJob.this.makeMarkerTagAction(additionalTag);
                } else if (names.length > 2) {
                    throw new LocalizableRuntimeException("haystack", "haystack3MigrationJob.configFile.tagGroupTooManyNames", new Object[]{BHaystack3To4MigrationJob.this.configLineNum, BHaystack3To4MigrationJob.this.configFileOrd, h4Names});
                }
            }
            return this;
        }

        public void addTagGroup() {
            BHaystack3To4MigrationJob.this.addH4TagGroup(this.h4TagGroup);
            if (this.additionalTag != null) {
                this.additionalTag.addH4Tag(null, BHaystack3To4MigrationJob.this.addedTagGroupTagIds);
            }
        }
    }

    private class TagAction {
        public final String h4Name;
        public final BIDataValue h4Value;

        private TagAction(String h4Name, BIDataValue h4Value) {
            this.h4Name = h4Name;
            this.h4Value = h4Value;
        }

        public void addH4Tag(BIDataValue h3Value, List<Id> tagIdList) {
            BHaystack3To4MigrationJob.this.addH4Tag(this.h4Name, this.h4Value != null ? this.h4Value : h3Value, tagIdList);
        }
    }

    private class TagHandler {
        private Predicate<Entity> entityTester;
        private TagAction[] actionsIfTrue;
        private TagAction[] actionsIfFalse;

        private TagHandler() {
        }

        public TagHandler parse(String h3Query, String h4Names) {
            String[] namesIfFalse;
            String[] namesIfTrue;
            if (!h3Query.isEmpty()) {
                if (!BHaystack3To4MigrationJob.this.h3Namespace.equals("hs")) {
                    h3Query = QUERY_NAMESPACE_REPLACEMENT.matcher(h3Query).replaceAll(Matcher.quoteReplacement(BHaystack3To4MigrationJob.this.h3Namespace + ':'));
                }
                try {
                    this.entityTester = NeqlEntityEvaluator.makePredicate((String)h3Query);
                }
                catch (Exception e) {
                    throw new LocalizableRuntimeException("haystack", "haystack3MigrationJob.configFile.neqlParseFail", new Object[]{h3Query, BHaystack3To4MigrationJob.this.configLineNum, BHaystack3To4MigrationJob.this.configFileOrd});
                }
                String[] nameGroups = h4Names.split("\\|");
                switch (nameGroups.length) {
                    case 1: {
                        namesIfTrue = nameGroups[0].trim().split(" ");
                        namesIfFalse = EMPTY_STRING_ARRAY;
                        break;
                    }
                    case 2: {
                        namesIfTrue = nameGroups[0].trim().split(" ");
                        namesIfFalse = nameGroups[1].trim().split(" ");
                        break;
                    }
                    default: {
                        throw new LocalizableRuntimeException("haystack", "haystack3MigrationJob.configFile.h4NameUnexpectedLength", new Object[]{BHaystack3To4MigrationJob.this.configLineNum, BHaystack3To4MigrationJob.this.configFileOrd, h4Names});
                    }
                }
            } else {
                namesIfTrue = EMPTY_STRING_ARRAY;
                namesIfFalse = h4Names.split(" ");
            }
            this.actionsIfTrue = this.parseActions(namesIfTrue);
            this.actionsIfFalse = this.parseActions(namesIfFalse);
            return this;
        }

        private TagAction[] parseActions(String[] names) {
            if (names.length == 0) {
                return EMPTY_ACTION_ARRAY;
            }
            TagAction[] tagActions = new TagAction[names.length];
            for (int i = 0; i < names.length; ++i) {
                String name = names[i].trim();
                if (name.equals("{removed}")) {
                    return BHaystack3To4MigrationJob.this.tagRemovedArray;
                }
                tagActions[i] = name.contains("=") ? BHaystack3To4MigrationJob.this.makeValueTagAction(name.split("=")) : BHaystack3To4MigrationJob.this.makeCopyValueTagAction(name);
            }
            return tagActions;
        }

        private TagAction[] getTagActions() {
            return this.entityTester != null && this.entityTester.test((Entity)BHaystack3To4MigrationJob.this.component) ? this.actionsIfTrue : this.actionsIfFalse;
        }

        public void handleTag(String h3Name, BIDataValue h3Value) {
            for (TagAction tagAction : this.getTagActions()) {
                if (tagAction == BHaystack3To4MigrationJob.this.tagRemoved) {
                    BHaystack3To4MigrationJob.this.notAddedTagIds.add(Id.newId((String)BHaystack3To4MigrationJob.this.h3Namespace, (String)h3Name));
                    return;
                }
                tagAction.addH4Tag(h3Value, BHaystack3To4MigrationJob.this.addedTagIds);
            }
        }
    }
}

