/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.haystack;

import com.tridium.haystack.BContainmentRelation;
import com.tridium.sys.tag.ComponentRelations;
import java.util.Collection;
import java.util.Optional;
import javax.baja.control.BControlPoint;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BasicRelation;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;

@NiagaraType
public class BHaystack4SiteRelation
extends BContainmentRelation {
    @Generated
    public static final Type TYPE = Sys.loadType(BHaystack4SiteRelation.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public Optional<Relation> getRelation(Entity source) {
        Id siteRefId = this.getSiteRefId();
        if (BHaystack4SiteRelation.hasDirectRelation((BComponent)source, siteRefId)) {
            return Optional.empty();
        }
        Entity site = null;
        if (source instanceof BControlPoint) {
            site = this.getPointSite((BControlPoint)source);
        } else if (this.hasEquipTag(source)) {
            site = this.getEquipSite(source);
        } else if (this.hasSpaceTag(source)) {
            site = this.getSpaceSite(source);
        }
        if (site == null) {
            return Optional.empty();
        }
        return Optional.of(new BasicRelation(siteRefId, site, false));
    }

    private Entity getPointSite(BControlPoint source) {
        BComponent equip = this.getPointEquip(source);
        if (equip == null) {
            return null;
        }
        return this.getSite((Entity)equip);
    }

    private Entity getEquipSite(Entity equip) {
        Entity space;
        Entity site = null;
        Entity parentEquip = this.getEquip(equip);
        if (parentEquip != null) {
            site = this.getSite(parentEquip);
        }
        if (site == null && (space = this.getSpace(equip)) != null) {
            site = this.getSite(space);
        }
        return site;
    }

    private Entity getSpaceSite(Entity space) {
        Entity parentSpace = this.getSpace(space);
        if (parentSpace == null) {
            return null;
        }
        return this.getSite(parentSpace);
    }

    public void addRelations(Entity source, Collection<Relation> relations) {
        Optional<Relation> outbound = this.getRelation(source);
        if (outbound.isPresent()) {
            relations.add(outbound.get());
        }
        if (!(source instanceof BComponent) || !this.hasSiteTag(source)) {
            return;
        }
        BComponent site = (BComponent)source;
        for (Relation siteRef : new ComponentRelations(site).getAll(this.getSiteRefId(), 1)) {
            this.addSiteRelations(siteRef, relations);
        }
    }

    private void addSiteRelations(Relation refRelation, Collection<Relation> relations) {
        BComponent endpoint = (BComponent)refRelation.getEndpoint();
        if (this.hasSpaceTag((Entity)endpoint)) {
            relations.add((Relation)new BasicRelation(this.getSiteRefId(), (Entity)endpoint, true));
            this.addSpaceSiteRelations(endpoint, relations);
        }
        if (this.hasEquipTag((Entity)endpoint)) {
            Id siteRefId = this.getSiteRefId();
            relations.add((Relation)new BasicRelation(siteRefId, (Entity)endpoint, true));
            this.addEquipContainmentRelations((Entity)endpoint, siteRefId, relations);
        }
    }

    private void addSpaceSiteRelations(BComponent space, Collection<Relation> relations) {
        for (Relation spaceRef : new ComponentRelations(space).getAll(this.getSpaceRefId(), 1)) {
            this.addSiteRelations(spaceRef, relations);
        }
    }
}

