/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.haystack;

import com.tridium.haystack.BContainmentRelation;
import com.tridium.sys.tag.ComponentRelations;
import java.util.Collection;
import java.util.Optional;
import javax.baja.control.BControlPoint;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelation;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BasicRelation;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;

@NiagaraType
public class BSpaceRelation
extends BContainmentRelation {
    @Generated
    public static final Type TYPE = Sys.loadType(BSpaceRelation.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public Optional<Relation> getRelation(Entity source) {
        Id spaceRefId = this.getSpaceRefId();
        if (BSpaceRelation.hasDirectRelation((BComponent)source, spaceRefId)) {
            return Optional.empty();
        }
        Entity space = null;
        if (source instanceof BControlPoint) {
            space = this.getPointSpace((BControlPoint)source);
        } else if (this.hasEquipTag(source)) {
            space = this.getEquipSpace(source);
        }
        if (space == null) {
            return Optional.empty();
        }
        return Optional.of(new BasicRelation(spaceRefId, space, false));
    }

    private Entity getPointSpace(BControlPoint source) {
        BComponent equip = this.getPointEquip(source);
        if (equip == null) {
            return null;
        }
        return this.getSpace((Entity)equip);
    }

    private Entity getEquipSpace(Entity source) {
        Entity endpoint;
        if (!(source instanceof BComponent)) {
            return null;
        }
        BRelation direct = BSpaceRelation.getDirectRelation((BComponent)source, this.getSpaceRefId());
        if (direct != null && this.hasSpaceTag(endpoint = direct.getEndpoint())) {
            return endpoint;
        }
        Entity parentEquip = this.getEquip(source);
        if (parentEquip == null) {
            return null;
        }
        return this.getSpace(parentEquip);
    }

    public void addRelations(Entity source, Collection<Relation> relations) {
        Optional<Relation> outbound = this.getRelation(source);
        if (outbound.isPresent()) {
            relations.add(outbound.get());
        }
        if (!(source instanceof BComponent) || !this.hasSpaceTag(source)) {
            return;
        }
        BComponent space = (BComponent)source;
        for (Relation spaceRef : new ComponentRelations(space).getAll(this.getSpaceRefId(), 1)) {
            Entity endpoint = spaceRef.getEndpoint();
            if (!this.hasEquipTag(endpoint)) continue;
            this.addEquipContainmentRelations(endpoint, this.getSpaceRefId(), relations);
        }
    }
}

