/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.iothub;

import com.tridium.cloud.client.BConnectorImpl;
import com.tridium.cloud.client.iothub.BMessageClient;
import com.tridium.cloud.client.iothub.BNullMessageClient;
import java.io.IOException;
import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="messageClient", type="BMessageClient", defaultValue="new BNullMessageClient()")
public abstract class BAbstractIotHubConnectorImpl
extends BConnectorImpl {
    public static final Property messageClient = BAbstractIotHubConnectorImpl.newProperty((int)0, (BValue)new BNullMessageClient(), null);
    public static final Type TYPE = Sys.loadType(BAbstractIotHubConnectorImpl.class);

    public BMessageClient getMessageClient() {
        return (BMessageClient)this.get(messageClient);
    }

    public void setMessageClient(BMessageClient v) {
        this.set(messageClient, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected void doConnect() throws Exception {
        String connectionString = AccessController.doPrivileged(this::getConnectionString);
        if (connectionString.isEmpty()) {
            throw new IOException("No connection string available!");
        }
        this.getMessageClient().onConnect(connectionString);
        if (!this.hasMessageClient()) {
            this.getCloudConnector().connectOk();
        }
    }

    protected void registerDevice() throws Exception {
    }

    protected void doDisconnect() throws Exception {
        this.getMessageClient().onDisconnect();
    }

    public void sendMessage(byte[] payload, Map<String, String> props, CompletableFuture<String> completableFuture) {
        this.getMessageClient().sendMessage(payload, props, completableFuture);
    }

    protected boolean hasMessageClient() {
        return !(this.getMessageClient() instanceof BNullMessageClient);
    }

    protected abstract String getConnectionString();

    public abstract Map<String, String> getConnectionInfo(String var1);
}

