/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.doors;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BISqlQueryFilter;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlQuery;
import com.tridiumx.accessDriver.enums.BOccupancyEnum;
import com.tridiumx.accessDriver.enums.activity.BActivity;
import com.tridiumx.accessDriver.enums.activity.BBadgeActivity;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.BAccessZone;
import com.tridiumx.entsec.access.orion.BAccessZoneRec;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonZoneJoin;
import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.device.BNACController;
import com.tridiumx.nacDriver.doors.BNACActivityAlertExt;
import com.tridiumx.nacDriver.filter.BNACReaderSqlFilter;
import com.tridiumx.nacDriver.message.NACServerTokenRequest;
import com.tridiumx.nacDriver.util.NACRequestUtils;
import com.tridiumx.nacDriver.util.Utils;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BExpression;
import javax.baja.query.util.Predicates;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusString;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="occupancyCriteria", type="BOccupancyEnum", defaultValue="BOccupancyEnum.any", flags=4, override=true), @NiagaraProperty(name="pendingTime", type="BRelTime", defaultValue="BRelTime.DEFAULT", flags=4, override=true), @NiagaraProperty(name="antiPassbackViolationAlert", type="BNACActivityAlertExt", defaultValue="new BNACActivityAlertExt(BBadgeActivity.antiPassbackViolation, initAlarmSourceInfo())", override=true), @NiagaraProperty(name="accessZoneDisabledAlert", type="BNACActivityAlertExt", defaultValue="new BNACActivityAlertExt(BBadgeActivity.accessZoneDisabled, initAlarmSourceInfo())", override=true), @NiagaraProperty(name="occupancyViolationAlert", type="BNACActivityAlertExt", defaultValue="new BNACActivityAlertExt(BBadgeActivity.occupancyViolation, initAlarmSourceInfo())", override=true), @NiagaraProperty(name="supervisorRequiredAlert", type="BNACActivityAlertExt", defaultValue="new BNACActivityAlertExt(BBadgeActivity.supervisorRequired, initAlarmSourceInfo())", flags=4, override=true), @NiagaraProperty(name="grantedButAntiPassbackViolationAlert", type="BNACActivityAlertExt", defaultValue="new BNACActivityAlertExt(BBadgeActivity.grantedButAntiPassbackViolation, initAlarmSourceInfo())", override=true), @NiagaraProperty(name="grantedButOccupancyViolationAlert", type="BNACActivityAlertExt", defaultValue="new BNACActivityAlertExt(BBadgeActivity.grantedButOccupancyViolation, initAlarmSourceInfo())", override=true), @NiagaraProperty(name="grantedButAccessZoneDisabledAlert", type="BNACActivityAlertExt", defaultValue="new BNACActivityAlertExt(BBadgeActivity.grantedButAccessZoneDisabled, initAlarmSourceInfo())", override=true), @NiagaraProperty(name="grantedButSupervisorRequiredAlert", type="BNACActivityAlertExt", defaultValue="new BNACActivityAlertExt(BBadgeActivity.grantedButSupervisorRequired, initAlarmSourceInfo())", flags=4, override=true), @NiagaraProperty(name="controllerLink", type="BStatusString", defaultValue="new BStatusString()", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"nacDriver:NACControllerChooserFE\"")})})
public class BNACAccessZone
extends BAccessZone {
    @Generated
    public static final Property occupancyCriteria = BNACAccessZone.newProperty((int)4, (BValue)BOccupancyEnum.any, null);
    @Generated
    public static final Property pendingTime = BNACAccessZone.newProperty((int)4, (BValue)BRelTime.DEFAULT, null);
    @Generated
    public static final Property antiPassbackViolationAlert = BNACAccessZone.newProperty((int)0, (BValue)new BNACActivityAlertExt((BActivity)BBadgeActivity.antiPassbackViolation, BNACAccessZone.initAlarmSourceInfo()), null);
    @Generated
    public static final Property accessZoneDisabledAlert = BNACAccessZone.newProperty((int)0, (BValue)new BNACActivityAlertExt((BActivity)BBadgeActivity.accessZoneDisabled, BNACAccessZone.initAlarmSourceInfo()), null);
    @Generated
    public static final Property occupancyViolationAlert = BNACAccessZone.newProperty((int)0, (BValue)new BNACActivityAlertExt((BActivity)BBadgeActivity.occupancyViolation, BNACAccessZone.initAlarmSourceInfo()), null);
    @Generated
    public static final Property supervisorRequiredAlert = BNACAccessZone.newProperty((int)4, (BValue)new BNACActivityAlertExt((BActivity)BBadgeActivity.supervisorRequired, BNACAccessZone.initAlarmSourceInfo()), null);
    @Generated
    public static final Property grantedButAntiPassbackViolationAlert = BNACAccessZone.newProperty((int)0, (BValue)new BNACActivityAlertExt((BActivity)BBadgeActivity.grantedButAntiPassbackViolation, BNACAccessZone.initAlarmSourceInfo()), null);
    @Generated
    public static final Property grantedButOccupancyViolationAlert = BNACAccessZone.newProperty((int)0, (BValue)new BNACActivityAlertExt((BActivity)BBadgeActivity.grantedButOccupancyViolation, BNACAccessZone.initAlarmSourceInfo()), null);
    @Generated
    public static final Property grantedButAccessZoneDisabledAlert = BNACAccessZone.newProperty((int)0, (BValue)new BNACActivityAlertExt((BActivity)BBadgeActivity.grantedButAccessZoneDisabled, BNACAccessZone.initAlarmSourceInfo()), null);
    @Generated
    public static final Property grantedButSupervisorRequiredAlert = BNACAccessZone.newProperty((int)4, (BValue)new BNACActivityAlertExt((BActivity)BBadgeActivity.grantedButSupervisorRequired, BNACAccessZone.initAlarmSourceInfo()), null);
    @Generated
    public static final Property controllerLink = BNACAccessZone.newProperty((int)0, (BValue)new BStatusString(), (BFacets)BFacets.make((String)"fieldEditor", (String)"nacDriver:NACControllerChooserFE"));
    @Generated
    public static final Type TYPE = Sys.loadType(BNACAccessZone.class);

    @Generated
    public BStatusString getControllerLink() {
        return (BStatusString)this.get(controllerLink);
    }

    @Generated
    public void setControllerLink(BStatusString v) {
        this.set(controllerLink, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BISqlQueryFilter getEntryReaderFilter() {
        return new BNACReaderSqlFilter();
    }

    public BISqlQueryFilter getExitReaderFilter() {
        return new BNACReaderSqlFilter();
    }

    public void updateNACAlertActivity(BComponent device, BBadgeActivity activity, BAbsTime timestamp, String owner, BBadge badge, String activityInfo, BUuid personId, boolean granted) {
        String badgeDisplayString = badge != null ? badge.toDisplayString(null) : "";
        this.makeBadgeRecord(device, timestamp, activity, owner, badgeDisplayString, activityInfo, granted, personId);
        this.makeAlarm(activity, owner, badgeDisplayString, activityInfo, personId);
    }

    public void makeAlarm(BBadgeActivity activity, String owner, String badge, String activityInfo, BUuid personId) {
        try {
            BNACActivityAlertExt[] alerts;
            for (BNACActivityAlertExt alert : alerts = (BNACActivityAlertExt[])this.getChildren(BNACActivityAlertExt.class)) {
                if (!alert.getActivityType().equals((Object)activity) || !alert.getEnableAlert()) continue;
                alert.generateAlert(badge, owner, activityInfo, personId);
            }
        }
        catch (Exception e) {
            Utils.logException(log, e, Level.SEVERE);
        }
    }

    public void makeBadgeRecord(BComponent device, BAbsTime timestamp, BBadgeActivity activity, String owner, String badge, String activityInfo, boolean granted, BUuid personId) {
        try {
            if (activity.isAlarm()) {
                BNACActivityAlertExt[] alerts;
                for (BNACActivityAlertExt alert : alerts = (BNACActivityAlertExt[])this.getChildren(BNACActivityAlertExt.class)) {
                    if (!alert.getActivityType().equals((Object)activity) || !alert.getEnableLogging()) continue;
                    alert.record(device, timestamp, badge, owner, activity, activityInfo, granted, personId);
                }
            } else {
                BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
                service.addBadgeSwipeOrionRec(device, timestamp, activity, owner, badge, activityInfo, granted, personId);
            }
        }
        catch (Exception e) {
            Utils.logException(log, e, Level.SEVERE);
        }
    }

    public static boolean isZoneAlert(BBadgeActivity badgeActivity) {
        BBadgeActivity[] activities = new BBadgeActivity[]{BBadgeActivity.occupancyViolation, BBadgeActivity.antiPassbackViolation, BBadgeActivity.accessZoneDisabled, BBadgeActivity.grantedButAntiPassbackViolation, BBadgeActivity.grantedButOccupancyViolation, BBadgeActivity.grantedButAccessZoneDisabled};
        return Arrays.asList(activities).contains(badgeActivity);
    }

    public void doRecount() {
        if (this.getNACNetwork() == null || this.getNACNetwork().getSessionToken() == null) {
            this.getFallback().setStatus(BStatus.stale);
            return;
        }
        BAccessControlService.LOG.fine("Recounting for NAC Access Zone: " + this.getDisplayName(null));
        try (OrionSession session = this.getService().createSession(null);){
            BAccessZoneRec rec = (BAccessZoneRec)session.mappedRead((BObject)this);
            if (rec != null) {
                this.clearPersonZoneJoin(rec, session);
                int unid = this.getUnidOnServer(rec);
                this.addPersonZoneJoinFromServer(rec, unid, session);
                int total = rec.getOccupiedCount(session);
                this.getFallback().setStatus(BStatus.ok);
                this.getFallback().setValue((double)total);
                this.doExecute();
                AccessController.doPrivileged(() -> {
                    this.updateServerOccupancy(unid, total);
                    return null;
                });
            }
        }
        catch (Exception e) {
            this.getFallback().setStatus(BStatus.fault);
            BAccessControlService.LOG.log(Level.SEVERE, "Recounting for NAC Access Zone failed: " + this.getDisplayName(null), e);
        }
    }

    public void doResetOccupancy() {
        if (this.getNACNetwork() == null || this.getNACNetwork().getSessionToken() == null) {
            return;
        }
        BAccessControlService.LOG.fine("Resetting for NAC Access Zone: " + this.getDisplayName(null));
        try (OrionSession session = this.getService().createSession(null);){
            BAccessZoneRec rec = (BAccessZoneRec)session.mappedRead((BObject)this);
            int zoneUnid = this.getUnidOnServer(rec);
            JSONArray peopleList = AccessController.doPrivileged(() -> this.getPeopleInZone(zoneUnid));
            this.removeZonePeopleFromServer(peopleList);
            BSqlField recField = new BSqlField(BPersonZoneJoin.ORION_TYPE, BPersonZoneJoin.accessZone);
            session.delete(BPersonZoneJoin.ORION_TYPE, Predicates.eq((BExpression)recField, (BSimple)BRef.make((BIOrionObject)rec)));
            this.getFallback().setValue(0.0);
            this.getFallback().setStatus(BStatus.ok);
            this.scheduleReset();
            AccessController.doPrivileged(() -> {
                this.updateServerOccupancy(zoneUnid, 0);
                return null;
            });
        }
        catch (Exception e) {
            this.getFallback().setStatus(BStatus.fault);
            BAccessControlService.LOG.log(Level.SEVERE, "Resetting for NAC Access Zone failed: " + this.getDisplayName(null), e);
        }
    }

    private void removeZonePeopleFromServer(JSONArray peopleList) throws PrivilegedActionException {
        for (Object person : peopleList) {
            int personUnid = ((JSONObject)person).getJSONObject("credHolder").getInt("unid");
            AccessController.doPrivileged(() -> {
                this.removeZonePersonFromServer(personUnid);
                return null;
            });
        }
    }

    public void removeZonePersonFromServer(int personUnid) throws Exception {
        BLink[] links = this.getLinks((Slot)controllerLink);
        if (links.length == 0) {
            throw new Exception("No NAC controller linked to the zone " + this.getDisplayName(null));
        }
        BLink link = this.getLinks((Slot)controllerLink)[0];
        BNACController controller = (BNACController)link.getSourceComponent();
        String uri = "/json/credHolderStateReset?unid=" + controller.getUnid() + "&credHolderUnid=" + personUnid + "&freeApbPass=true";
        NACServerTokenRequest request = new NACServerTokenRequest(this.getNACNetwork().getHttpConfig().getAddress(), "GET", uri, this.getNACNetwork().getSessionToken());
        this.getNACNetwork().sendHttpRequest(request);
    }

    private int getUnidOnServer(BAccessZoneRec rec) throws PrivilegedActionException {
        JSONObject response = AccessController.doPrivileged(() -> NACRequestUtils.showResource(this.getNACNetwork(), "dev", rec.getUuid().toString(), 4));
        JSONObject instance = response.getJSONObject("instance");
        return instance.getInt("unid");
    }

    private void updateServerOccupancy(int unid, int occupancy) throws Exception {
        String uri = "/json/controlledAreaResetOccupancy?unid=" + unid + "&occupancy=" + occupancy;
        NACServerTokenRequest request = new NACServerTokenRequest(this.getNACNetwork().getHttpConfig().getAddress(), "GET", uri, this.getNACNetwork().getSessionToken());
        this.getNACNetwork().sendHttpRequest(request);
        BAccessControlService.LOG.log(Level.FINE, "Changed occupancy for " + this.getDisplayName(null) + " on NAC server to: " + occupancy);
    }

    private void addPersonZoneJoinFromServer(BAccessZoneRec rec, int zoneUnid, OrionSession session) throws Exception {
        JSONArray peopleList = AccessController.doPrivileged(() -> this.getPeopleInZone(zoneUnid));
        int peopleAdded = 0;
        for (Object person : peopleList) {
            BUuid personUuid = BUuid.make((String)((JSONObject)person).getJSONObject("credHolder").getString("uuid"));
            if (!this.insertPersonZoneJoin(rec, personUuid, session)) continue;
            ++peopleAdded;
        }
        BAccessControlService.LOG.log(Level.FINE, "Total people added for NAC Access Zone " + this.getDisplayName(null) + ": " + peopleAdded);
    }

    public boolean insertPersonZoneJoin(BAccessZoneRec rec, BUuid personUuid, OrionSession session) {
        BPersonZoneJoin personZoneJoin = new BPersonZoneJoin();
        try (OrionCursor cursor = session.select(BSqlQuery.make((OrionType)BPerson.ORION_TYPE).where(Predicates.eq((Property)BPerson.personId, (BSimple)personUuid)));){
            if (!cursor.next()) {
                this.getNACNetwork().getReplication().generateReplicationDataInconsistentAlarm(this.getNACNetwork().getLexicon().getText("replicationDataInconsistent.personRecordDoesNotExist"), this.getNACNetwork().getNetworkName());
                boolean bl = false;
                return bl;
            }
            BPerson person = (BPerson)cursor.get();
            personZoneJoin.setPerson(BRef.make((BIOrionObject)person));
            personZoneJoin.setAccessZone(BRef.make((BIOrionObject)rec));
        }
        if (session.exists((BIOrionObject)personZoneJoin)) {
            return false;
        }
        session.insert((BIOrionObject)personZoneJoin);
        return true;
    }

    public JSONArray getPeopleInZone(int zoneUnid) throws Exception {
        String uri = "/credHolderStateRecord/list?inControlledAreaUnid=" + zoneUnid;
        NACServerTokenRequest request = new NACServerTokenRequest(this.getNACNetwork().getHttpConfig().getAddress(), "GET", uri, this.getNACNetwork().getSessionToken());
        String response = new String(this.getNACNetwork().sendHttpRequest(request).getData());
        return new JSONObject(response).getJSONArray("instanceList");
    }

    private void clearPersonZoneJoin(BAccessZoneRec rec, OrionSession session) {
        BSqlField recField = new BSqlField(BPersonZoneJoin.ORION_TYPE, BPersonZoneJoin.accessZone);
        session.delete(BPersonZoneJoin.ORION_TYPE, Predicates.eq((BExpression)recField, (BSimple)BRef.make((BIOrionObject)rec)));
        BAccessControlService.LOG.log(Level.FINE, "Cleared Person Zone records for: " + this.getDisplayName(null));
    }

    public void updateOccupancyCountFromServer(BAccessZoneRec rec) throws Exception {
        JSONObject record = NACRequestUtils.showResource(this.getNACNetwork(), "controlledAreaStateRecord", rec.getUuid().toString(), 1);
        JSONObject instance = record.getJSONObject("instance");
        if (instance.optJSONObject("controlledAreaState") != null) {
            this.getFallback().setValue((double)instance.getJSONObject("controlledAreaState").getInt("occupancy"));
            return;
        }
        this.getFallback().setValue(0.0);
    }

    private BNACNetwork getNACNetwork() {
        Optional optional = Sys.findService((Type)BNACNetwork.TYPE);
        return optional.orElse(null);
    }

    public Property[] getSubscribedProperties() {
        return new Property[]{lockDown, passbackMode, aboveHighThresholdEnforcement, atHighThresholdEnforcement, belowLowThresholdEnforcement, atLowThresholdEnforcement, passbackTimeout, resetOccupancyEnabled, resetOccupancyTime, highThreshold, lowThreshold, controllerLink};
    }
}

