/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.event;

import com.tridium.json.JSONObject;
import com.tridium.nre.util.tuple.Triple;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.PropertyValue;
import com.tridiumx.accessDriver.enums.BEnforcementEnum;
import com.tridiumx.accessDriver.enums.activity.BBadgeActivity;
import com.tridiumx.accessDriver.enums.activity.BTimeAttendEnum;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.BAccessValidationInfo;
import com.tridiumx.entsec.access.BMappedReaderExt;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BAccessZoneRec;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BExitReaderZoneJoin;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonZoneJoin;
import com.tridiumx.entsec.access.orion.BWiegandFormat;
import com.tridiumx.entsec.access.util.ValidationUtil;
import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.doors.BNACAccessDoor;
import com.tridiumx.nacDriver.doors.BNACAccessZone;
import com.tridiumx.nacDriver.doors.BNACDoor;
import com.tridiumx.nacDriver.doors.BNACReader;
import com.tridiumx.nacDriver.enums.BEventCodeEnum;
import com.tridiumx.nacDriver.enums.BEventSubCodeEnum;
import com.tridiumx.nacDriver.enums.BNACReaderEncryptionEnum;
import com.tridiumx.nacDriver.util.Utils;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.baja.naming.SlotPath;
import javax.baja.query.BExpression;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNameList;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

public class EventRunnable
implements Runnable {
    JSONObject eventRecord;
    BNACNetwork network;
    BAbsTime timestamp;

    public EventRunnable(JSONObject eventRecord, BNACNetwork network) {
        this.eventRecord = eventRecord;
        this.network = network;
    }

    @Override
    public void run() {
        if (this.eventRecord != null) {
            int eventCode = this.eventRecord.getInt("evtCode");
            if (this.network.log().isLoggable(Level.FINE)) {
                this.network.log().log(Level.FINE, "Event occurred : " + BEventCodeEnum.make(eventCode).getTag());
            }
            try {
                this.timestamp = (BAbsTime)BAbsTime.DEFAULT.decodeFromString(this.eventRecord.getString("hwTime"));
                this.processEvent(eventCode);
                this.network.getNACEventWorker().setLastProcessedEvent(this.timestamp);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void processEvent(int eventCode) throws Exception {
        switch (eventCode) {
            case 48: {
                this.processDoorAccessGrantedEvent();
                break;
            }
            case 49: {
                this.processDoorAccessDeniedEvent();
                break;
            }
            case 52: {
                this.processDoorForcedEvent();
                break;
            }
            case 53: {
                this.processDoorNotForcedEvent();
                break;
            }
            case 54: {
                this.processDoorHeldEvent();
                break;
            }
            case 55: {
                this.processDoorNotHeldEvent();
                break;
            }
            case 56: {
                this.processDoorOpenedEvent();
                break;
            }
            case 57: {
                this.processDoorClosedEvent();
                break;
            }
            case 86: {
                this.processExitRequestedEvent();
                break;
            }
            case 248: {
                this.processEncryptionKeysTransferredEvent();
                break;
            }
            case 249: {
                this.processEncryptionKeysTransferFailed();
            }
        }
    }

    private void processDoorAccessGrantedEvent() throws Exception {
        BNACReader reader;
        int eventSubCode = this.eventRecord.optInt("evtSubCode");
        int doorUnid = this.eventRecord.getJSONObject("evtDevRef").getInt("unid");
        BNACDoor door = (BNACDoor)this.network.getComponentByUnid(doorUnid, true);
        if (door != null && (reader = door.getReader()) != null) {
            reader.getBeeper().beepActive(BNACReader.GRANTED_BEEP_TIME);
            BPerson person = this.getPersonFromRef(this.eventRecord.getJSONObject("evtCredHolderRef"));
            BBadge badge = null;
            BNameList badgeFormats = BNameList.DEFAULT;
            JSONObject eventModifiers = this.eventRecord.getJSONObject("evtModifiers");
            if (eventModifiers.optBoolean("usedCard")) {
                badge = this.getBadgeFromRef(this.eventRecord.getJSONObject("evtCredRef"));
                badgeFormats = this.getBadgeFormats(this.eventRecord.getJSONObject("evtCredRef"));
            }
            ArrayList<String> details = this.getDetailsFromEventModifiers(eventModifiers);
            if (eventSubCode == 58 || eventSubCode == 55) {
                BNACAccessZone accessZone;
                if (badge != null) {
                    BAccessValidationInfo info = new BAccessValidationInfo();
                    info.setBadgeId(badge.getBadgeId());
                    if (this.invokeActivationBadge(info)) {
                        details.add(info.getRecord().getDetails());
                    }
                }
                door.updatePendingUse(door.getPendingUse() + 1);
                if (eventModifiers.optBoolean("apb")) {
                    reader.setLastRecord(badge, badgeFormats, person, BBadgeActivity.grantedButAntiPassbackViolation, this.timestamp);
                    accessZone = this.getAccessZoneFromRef(this.eventRecord.getJSONObject("evtControlledAreaRef"));
                    if (accessZone != null) {
                        accessZone.updateNACAlertActivity((BComponent)reader, BBadgeActivity.grantedButAntiPassbackViolation, this.timestamp, person.toDisplayString(null), badge, details.toString(), person.getPersonId(), true);
                    }
                } else if (eventModifiers.optBoolean("watch")) {
                    reader.updateNACAlertActivity(BBadgeActivity.grantedButTrace, this.timestamp, person.toDisplayString(null), badge, badgeFormats, details.toString(), person.getPersonId(), true);
                } else {
                    Triple<Boolean, BBadgeActivity, String> generateSoftOccupancy = this.generateSoftOccupancyAlert(door);
                    if (((Boolean)generateSoftOccupancy.getFirst()).booleanValue()) {
                        reader.setLastRecord(badge, badgeFormats, person, (BBadgeActivity)generateSoftOccupancy.getSecond(), this.timestamp);
                        accessZone = this.getAccessZoneFromRef(this.eventRecord.getJSONObject("evtControlledAreaRef"));
                        if (accessZone != null) {
                            String detailsString = !details.isEmpty() ? details.toString() : "";
                            detailsString = (String)generateSoftOccupancy.getThird() + " " + detailsString;
                            accessZone.updateNACAlertActivity((BComponent)reader, (BBadgeActivity)generateSoftOccupancy.getSecond(), this.timestamp, person.toDisplayString(null), badge, detailsString, person.getPersonId(), true);
                        }
                    } else {
                        reader.setLastRecord(badge, badgeFormats, person, BBadgeActivity.granted, this.timestamp);
                        reader.makeBadgeRecord(badge, !details.isEmpty() ? details.toString() : "");
                    }
                }
                BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
                if (!reader.getAttendance().equals((Object)BTimeAttendEnum.none)) {
                    service.addAttendanceOrionRec(reader.getAttendance(), person.toDisplayString(null), person.getPersonId(), this.timestamp);
                }
                if (eventSubCode == 55) {
                    BNACAccessZone accessZone2;
                    door.updatePendingUse(0);
                    if (this.eventRecord.optJSONObject("evtControlledAreaRef") != null && (accessZone2 = this.getAccessZoneFromRef(this.eventRecord.getJSONObject("evtControlledAreaRef"))) != null) {
                        this.personEnteredZone(accessZone2, person);
                    }
                    this.personExitedZone(reader, person);
                }
            } else if (eventSubCode == 57) {
                door.updatePendingUse(0);
                reader.updateNACAlertActivity(BBadgeActivity.grantedButNotUsed, this.timestamp, person.toDisplayString(null), badge, badgeFormats, details.toString(), person.getPersonId(), true);
            } else if (eventSubCode == 56) {
                BNACAccessZone accessZone;
                door.updatePendingUse(0);
                if (this.eventRecord.optJSONObject("evtControlledAreaRef") != null && (accessZone = this.getAccessZoneFromRef(this.eventRecord.getJSONObject("evtControlledAreaRef"))) != null) {
                    this.personEnteredZone(accessZone, person);
                }
                this.personExitedZone(reader, person);
            }
        }
    }

    private Triple<Boolean, BBadgeActivity, String> generateSoftOccupancyAlert(BNACDoor door) {
        BNACAccessZone accessZone;
        Boolean generateAlert = Boolean.FALSE;
        BBadgeActivity activity = null;
        String details = null;
        if (this.eventRecord.optJSONObject("evtControlledAreaRef") != null && (accessZone = this.getAccessZoneFromRef(this.eventRecord.getJSONObject("evtControlledAreaRef"))) != null) {
            double totalPeople = accessZone.getFallback().getNumeric() + (double)door.getPendingUse();
            if (totalPeople > (double)accessZone.getHighThreshold() && accessZone.getAboveHighThresholdEnforcement().equals((Object)BEnforcementEnum.soft)) {
                generateAlert = Boolean.TRUE;
                activity = BBadgeActivity.grantedButOccupancyViolation;
                details = this.network.getLexicon().getText("details.aboveHighThreshold", new Object[]{totalPeople});
            } else if (totalPeople == (double)accessZone.getHighThreshold() && accessZone.getAtHighThresholdEnforcement().getOrdinal() == 1) {
                generateAlert = Boolean.TRUE;
                activity = BBadgeActivity.grantedButOccupancyViolation;
                details = this.network.getLexicon().getText("details.atHighThreshold", new Object[]{totalPeople});
            } else if (totalPeople == (double)accessZone.getLowThreshold() && accessZone.getAtLowThresholdEnforcement().getOrdinal() == 1) {
                generateAlert = Boolean.TRUE;
                activity = BBadgeActivity.grantedButOccupancyViolation;
                details = this.network.getLexicon().getText("details.atLowThreshold", new Object[]{totalPeople});
            }
        }
        return new Triple((Object)generateAlert, activity, details);
    }

    private void personExitedZone(BNACReader reader, BPerson person) throws Exception {
        try (OrionSession session = this.getOrionSession(null);){
            BMappedReaderExt readerExt = (BMappedReaderExt)reader.getMixIn(BMappedReaderExt.TYPE);
            try (OrionCursor cursor = session.select(BSqlQuery.make((OrionType)BExitReaderZoneJoin.ORION_TYPE).where(Predicates.eq((Property)BExitReaderZoneJoin.reader, (BSimple)BRef.make((BTypeSpec)BAccReaderRec.ORION_TYPE.getTypeSpec(), (BSimple)readerExt.getUuid()))));){
                if (cursor.next()) {
                    BExitReaderZoneJoin exitReaderZoneJoin = (BExitReaderZoneJoin)cursor.get();
                    BAccessZoneRec zoneRec = exitReaderZoneJoin.resolveAccessZone(session);
                    BExpression personCheck = Predicates.eq((Property)BPersonZoneJoin.person, (BSimple)BRef.make((BTypeSpec)BPerson.ORION_TYPE.getTypeSpec(), (BSimple)person.getPersonId()));
                    BExpression zoneCheck = Predicates.eq((Property)BPersonZoneJoin.accessZone, (BSimple)BRef.make((BTypeSpec)BAccessZoneRec.ORION_TYPE.getTypeSpec(), (BSimple)zoneRec.getUuid()));
                    session.delete(BPersonZoneJoin.ORION_TYPE, Predicates.and((BExpression)personCheck, (BExpression)zoneCheck));
                    BNACAccessZone zone = (BNACAccessZone)zoneRec.getMappedOrd().get();
                    AccessController.doPrivileged(() -> {
                        zone.updateOccupancyCountFromServer(zoneRec);
                        return null;
                    });
                }
            }
        }
    }

    private void personEnteredZone(BNACAccessZone zone, BPerson person) throws Exception {
        try (OrionSession session = this.getOrionSession(null);){
            BAccessZoneRec zoneRec = new BAccessZoneRec();
            zoneRec.mapFrom((BObject)zone);
            if (!zone.insertPersonZoneJoin(zoneRec, person.getPersonId(), session)) {
                this.network.log().log(Level.WARNING, "Person Zone Join record not added to zone : " + zoneRec.getZoneName());
            }
            AccessController.doPrivileged(() -> {
                zone.updateOccupancyCountFromServer(zoneRec);
                return null;
            });
        }
    }

    private BNACAccessZone getAccessZoneFromRef(JSONObject controlledAreaRef) {
        try (OrionSession session = this.getOrionSession(null);
             OrionCursor cursor = session.select(BAccessZoneRec.ORION_TYPE, new PropertyValue(BAccessZoneRec.uuid, (BValue)BUuid.make((String)controlledAreaRef.getString("uuid"))));){
            if (cursor.next()) {
                BAccessZoneRec rec = (BAccessZoneRec)cursor.get();
                BNACAccessZone bNACAccessZone = (BNACAccessZone)rec.getMappedOrd().get();
                return bNACAccessZone;
            }
        }
        return null;
    }

    private BNameList getBadgeFormats(JSONObject badgeRef) throws Exception {
        BNameList badgeFormats = BNameList.DEFAULT;
        if (badgeRef != null && badgeRef.has("credTemplateRef")) {
            try (OrionSession session = this.getOrionSession(null);
                 OrionCursor cursor = session.select(BWiegandFormat.ORION_TYPE, new PropertyValue(BWiegandFormat.wiegandFormatId, (BValue)BUuid.make((String)badgeRef.getJSONObject("credTemplateRef").getString("uuid"))));){
                if (cursor.next()) {
                    badgeFormats = BNameList.union((BNameList)badgeFormats, (BNameList)BNameList.make((String)SlotPath.escape((String)((BWiegandFormat)cursor.get()).getWiegandFormatId().encodeToString())));
                }
            }
        }
        return badgeFormats;
    }

    private ArrayList<String> getDetailsFromEventModifiers(JSONObject eventModifiers) {
        ArrayList<String> details = new ArrayList<String>();
        if (eventModifiers.optBoolean("apb")) {
            details.add(this.network.getLexicon().getText("apb"));
        }
        if (eventModifiers.optBoolean("usedCard")) {
            details.add(this.network.getLexicon().getText("usedCard"));
        }
        if (eventModifiers.optBoolean("usedPin")) {
            details.add(this.network.getLexicon().getText("usedPin"));
        }
        if (eventModifiers.optBoolean("watch")) {
            details.add(this.network.getLexicon().getText("trace"));
        }
        return details;
    }

    private BPerson getPersonFromRef(JSONObject personRef) {
        BPerson person = new BPerson();
        person.setFirstName(personRef.optString("first"));
        person.setLastName(personRef.optString("last"));
        person.setPersonId(BUuid.make((String)personRef.getString("uuid")));
        return person;
    }

    private BBadge getBadgeFromRef(JSONObject badgeRef) {
        BBadge badge = new BBadge();
        badge.setCredential(badgeRef.optString("credNum"));
        badge.setFacilityCode(String.valueOf(badgeRef.optInt("facilityCode")));
        if (badgeRef.has("credTemplateRef")) {
            badge.setWiegandFormat(BRef.make((BTypeSpec)BWiegandFormat.ORION_TYPE.getTypeSpec(), (BSimple)BUuid.make((String)badgeRef.getJSONObject("credTemplateRef").getString("uuid"))));
        }
        try (OrionSession session = this.getOrionSession(null);){
            badge.setBadgeId(badge.calculateId(session));
        }
        catch (Exception e) {
            Utils.logException(this.network.log(), e, Level.WARNING);
        }
        return badge;
    }

    private OrionSession getOrionSession(Context cx) {
        BAccessControlService acs = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        OrionSession orionSession = acs.getOrionDatabase().createSession(cx);
        return orionSession;
    }

    private boolean isThreatLevelGroupAssigned(BAccessRight accessRight) {
        return accessRight.getThreatLevelGroup().getId() != null;
    }

    private BAccessRight getAccessRightFromUuid(BUuid accessRightUuid) {
        BAccessRight accessRightRecord = null;
        try (OrionSession session = this.getOrionSession(null);
             OrionCursor accessRightCursor = session.select(BSqlQuery.make((OrionType)BAccessRight.ORION_TYPE).where(Predicates.eq((Property)BAccessRight.accessRightId, (BSimple)accessRightUuid)));){
            if (accessRightCursor.next()) {
                accessRightRecord = (BAccessRight)accessRightCursor.get();
            }
        }
        return accessRightRecord;
    }

    /*
     * Exception decompiling
     */
    private boolean getWhetherAccessDeniedIsDueToThreatLevelGroup(BUuid readerUuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processDoorAccessDeniedEvent() throws Exception {
        BNACReader reader;
        boolean hasCustomDetails = false;
        int doorUnid = this.eventRecord.getJSONObject("evtDevRef").getInt("unid");
        BNACDoor door = (BNACDoor)this.network.getComponentByUnid(doorUnid, true);
        if (door != null && (reader = door.getReader()) != null) {
            reader.getBeeper().beepActive(BNACReader.DENIED_BEEP_TIME);
            if (this.eventRecord.has("evtSubCode")) {
                BMappedReaderExt readerExt;
                BUuid readerUuid;
                Boolean isThreatLevelEvent;
                int evtSubCode = this.eventRecord.getInt("evtSubCode");
                BBadgeActivity badgeActivity = this.getActivityForDoorAccessDeniedEvtSubCode(evtSubCode);
                if (badgeActivity == BBadgeActivity.noAccessRight && (isThreatLevelEvent = Boolean.valueOf(this.getWhetherAccessDeniedIsDueToThreatLevelGroup(readerUuid = (readerExt = (BMappedReaderExt)reader.getMixIn(BMappedReaderExt.TYPE)).getUuid()))).booleanValue()) {
                    badgeActivity = BBadgeActivity.inactiveThreatLevelGroup;
                    hasCustomDetails = true;
                }
                BPerson person = this.eventRecord.has("evtCredHolderRef") ? this.getPersonFromRef(this.eventRecord.getJSONObject("evtCredHolderRef")) : null;
                BBadge badge = this.eventRecord.has("evtCredRef") ? this.getBadgeFromRef(this.eventRecord.getJSONObject("evtCredRef")) : null;
                BNameList badgeFormats = this.getBadgeFormats(this.eventRecord.optJSONObject("evtCredRef"));
                if (badgeActivity != null) {
                    String owner = person != null ? person.toDisplayString(null) : "";
                    BUuid personUuid = person != null ? person.getPersonId() : BUuid.DEFAULT;
                    JSONObject eventModifiers = this.eventRecord.getJSONObject("evtModifiers");
                    String details = hasCustomDetails ? this.network.getLexicon().getText("details.doorAccessDeniedInactiveThreatLevelGroup") + " " + this.getDetailsFromEventModifiers(eventModifiers) : this.network.getLexicon().getText("details." + BEventSubCodeEnum.make(evtSubCode).getTag()) + " " + this.getDetailsFromEventModifiers(eventModifiers);
                    if (BNACAccessZone.isZoneAlert(badgeActivity)) {
                        String badgeString = badge != null ? badge.getBadgeId() : "";
                        reader.setLastRecord(badgeString, badgeFormats, owner, personUuid, badgeActivity, this.timestamp);
                        BNACAccessZone accessZone = this.getAccessZoneFromRef(this.eventRecord.getJSONObject("evtControlledAreaRef"));
                        if (accessZone != null) {
                            accessZone.updateNACAlertActivity((BComponent)reader, badgeActivity, this.timestamp, owner, badge, details, personUuid, false);
                        }
                    } else {
                        reader.updateNACAlertActivity(badgeActivity, this.timestamp, owner, badge, badgeFormats, details, personUuid, false);
                    }
                }
            }
        }
    }

    private BBadgeActivity getActivityForDoorAccessDeniedEvtSubCode(int evtSubCode) {
        switch (evtSubCode) {
            case 14: 
            case 20: {
                return BBadgeActivity.badgeDoesNotExist;
            }
            case 15: 
            case 16: {
                return BBadgeActivity.unknownWiegandFormat;
            }
            case 17: 
            case 27: {
                return BBadgeActivity.invalidPinNumber;
            }
            case 1: {
                return BBadgeActivity.badgeIsLost;
            }
            case 0: 
            case 6: 
            case 7: {
                return BBadgeActivity.badgeIsDisabled;
            }
            case 11: {
                return BBadgeActivity.noActiveSchedule;
            }
            case 22: 
            case 23: 
            case 24: 
            case 41: 
            case 44: 
            case 111: {
                return BBadgeActivity.doorModeDoesNotMatch;
            }
            case 10: {
                return BBadgeActivity.noAccessRight;
            }
            case 38: {
                return BBadgeActivity.antiPassbackViolation;
            }
            case 39: 
            case 40: {
                return BBadgeActivity.occupancyViolation;
            }
        }
        return null;
    }

    private void processDoorForcedEvent() {
    }

    private void processDoorNotForcedEvent() {
    }

    private void processDoorHeldEvent() {
    }

    private void processDoorNotHeldEvent() {
    }

    private void processDoorOpenedEvent() {
    }

    private void processDoorClosedEvent() {
    }

    private void processExitRequestedEvent() throws Exception {
        int doorUnid = this.eventRecord.getJSONObject("evtDevRef").getInt("unid");
        BNACAccessDoor door = (BNACAccessDoor)this.network.getComponentByUnid(doorUnid, true);
        if (door != null && door.getActivateStrikeOnRex()) {
            BAccessControlService accessControlService = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
            accessControlService.addBadgeSwipeOrionRec((BComponent)door, this.timestamp, BBadgeActivity.exitRequest, "", "", "", true, BUuid.NULL);
        }
    }

    private void processEncryptionKeysTransferredEvent() throws Exception {
        int readerUnid = this.eventRecord.getJSONObject("evtDevRef").getInt("unid");
        String keyIdentifier = String.valueOf(this.eventRecord.getString("data"));
        BNACReader reader = (BNACReader)this.network.getComponentByUnid(readerUnid, true);
        if (reader != null) {
            AccessController.doPrivileged(() -> {
                reader.updateEncryptionKeyState(keyIdentifier);
                return null;
            });
        }
    }

    private void processEncryptionKeysTransferFailed() throws Exception {
        BNACReader reader;
        int readerUnid = this.eventRecord.getJSONObject("evtDevRef").getInt("unid");
        String keyIdentifier = "";
        if (this.eventRecord.has("data")) {
            keyIdentifier = String.valueOf(this.eventRecord.getString("data"));
        }
        if ((reader = (BNACReader)this.network.getComponentByUnid(readerUnid, true)) != null) {
            reader.makeAlarm(BNACReaderEncryptionEnum.encryptionKeyTransferFailed, "Encryption Key Transfer Failed  " + keyIdentifier);
        }
    }

    private boolean invokeActivationBadge(BAccessValidationInfo info) {
        boolean activationBadge = false;
        try (OrionSession validationSession = this.getOrionSession(null);){
            activationBadge = ValidationUtil.checkActivationBadges((BAccessValidationInfo)info, (OrionSession)validationSession, null);
        }
        catch (Exception e) {
            Utils.logException(this.network.log(), e, Level.WARNING);
        }
        return activationBadge;
    }
}

