/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.job;

import com.tridium.json.JSONObject;
import com.tridium.ndriver.comm.NCommException;
import com.tridiumx.entsec.orionTools.BMappedEnumScheduleExt;
import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.doors.BNACDoor;
import com.tridiumx.nacDriver.doors.BNACDoorModeSchedule;
import com.tridiumx.nacDriver.util.NACRequestUtils;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BDoorModeMappingToScheduleJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BDoorModeMappingToScheduleJob.class);
    private BNACDoorModeSchedule nacDoorModeSchedule;
    private BNACDoor nacDoor;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDoorModeMappingToScheduleJob() {
    }

    public BDoorModeMappingToScheduleJob(BNACDoorModeSchedule nacDoorModeSchedule, BNACDoor nacDoor) {
        this.nacDoorModeSchedule = nacDoorModeSchedule;
        this.nacDoor = nacDoor;
    }

    public void run(Context context) throws Exception {
        this.doorModeMappingToSchedule();
    }

    private void doorModeMappingToSchedule() throws Exception {
        AtomicBoolean isSuccess = new AtomicBoolean(true);
        try {
            this.progress(10);
            BNACNetwork nacNetwork = this.nacDoor.getNACNetwork();
            if (nacNetwork != null && nacNetwork.getStatus().isValid()) {
                if (nacNetwork.getSessionToken() != null) {
                    StringBuilder mappingScheduleToDoorStringBody = new StringBuilder();
                    this.appendScheduleMappingToDoor((BCompositeSchedule)this.nacDoorModeSchedule, mappingScheduleToDoorStringBody, isSuccess);
                    if (mappingScheduleToDoorStringBody.length() > 0) {
                        BDoorModeMappingToScheduleJob.addDoorMappingToSchedule(mappingScheduleToDoorStringBody.toString(), nacNetwork);
                        this.progress(80);
                    }
                } else {
                    isSuccess.set(false);
                    this.log().failed("Not connected to the server.");
                }
            } else {
                isSuccess.set(false);
                this.log().failed("Door mapping to " + this.nacDoorModeSchedule.getDisplayName(null) + " schedule not initiated. Network status is " + nacNetwork.getStatus());
            }
        }
        catch (Exception ex) {
            isSuccess.set(false);
            this.failed(ex);
        }
        this.progress(100);
        if (!isSuccess.get()) {
            this.failed(new Exception("Door mapping with schedule could not be completed."));
            throw new Exception("Door mapping with schedule could not be completed.");
        }
        this.log().success("Door mapping with schedule completed successfully.");
    }

    public final void appendScheduleMappingToDoor(BCompositeSchedule schedule, StringBuilder stringBody, AtomicBoolean isSuccess) throws Exception {
        BMappedEnumScheduleExt mappedEnumScheduleExt = (BMappedEnumScheduleExt)Arrays.stream(schedule.getChildren(BMappedEnumScheduleExt.class)).findFirst().get();
        if (mappedEnumScheduleExt != null && !mappedEnumScheduleExt.getUuid().toString().isEmpty()) {
            if (this.nacDoor.getUnid() != 0) {
                JSONObject scheduleInstance = this.getInstanceFromServer(mappedEnumScheduleExt.getUuid().toString(), "sched");
                if (scheduleInstance != null) {
                    this.appendDoorMappedWithScheduleStringBody(stringBody, mappedEnumScheduleExt);
                } else {
                    isSuccess.set(false);
                    this.log().failed("Schedule name " + schedule.getDisplayName(null) + " does not exists on the server");
                }
            } else {
                isSuccess.set(false);
                this.log().failed("Door name " + this.nacDoor.getDisplayName(null) + " status is offline");
            }
        } else {
            isSuccess.set(false);
            this.log().failed("Schedule name " + schedule.getDisplayName(null) + " does not contain the UUID");
        }
    }

    public final void appendDoorMappedWithScheduleStringBody(StringBuilder stringBody, BMappedEnumScheduleExt mappedEnumScheduleExt) {
        stringBody.append("devUpdate").append("[").append(0).append("]").append(".unid=").append(this.nacDoor.getUnid());
        stringBody.append("&").append("devUpdate").append("[").append(0).append("]").append(".templatedPolicies[0].sched.uuid=").append(mappedEnumScheduleExt.getUuid());
        stringBody.append("&").append("devUpdate").append("[").append(0).append("]").append(".templatedPolicies[0].type=").append(1);
        stringBody.append("&").append("devUpdate").append("[").append(0).append("]").append(".templatedPolicies[0].ownerDev.unid=").append(this.nacDoor.getUnid());
    }

    private JSONObject getInstanceFromServer(String uuid, String objectName) throws Exception {
        try {
            return NACRequestUtils.showResource(this.nacDoor.getNACNetwork(), objectName, uuid, 0).getJSONObject("instance");
        }
        catch (NCommException e) {
            if (e.getMessage().startsWith("Error 404")) {
                return null;
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static JSONObject addDoorMappingToSchedule(String body, BNACNetwork nacNetwork) throws Exception {
        try {
            return AccessController.doPrivileged(() -> NACRequestUtils.executeMultiDbChangePublic(body, nacNetwork));
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
    }
}

