/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.point;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridiumx.nacDriver.BINACMappable;
import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.device.BNACDevice;
import com.tridiumx.nacDriver.doors.BNACAccessDoor;
import com.tridiumx.nacDriver.point.BNACAuxOut;
import com.tridiumx.nacDriver.point.BNACPointFolder;
import com.tridiumx.nacDriver.point.BNACProxyExt;
import com.tridiumx.nacDriver.point.BNACSensorPoint;
import com.tridiumx.nacDriver.util.NACRequestUtils;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.baja.agent.AgentList;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="tamper", type="BNACSensorPoint", defaultValue="new BNACSensorPoint(false)"), @NiagaraProperty(name="batteryFail", type="BNACSensorPoint", defaultValue="new BNACSensorPoint(false)"), @NiagaraProperty(name="acFail", type="BNACSensorPoint", defaultValue="new BNACSensorPoint(false)"), @NiagaraProperty(name="aux", type="BNACPointFolder", defaultValue="new BNACPointFolder()"), @NiagaraProperty(name="unid", type="int", defaultValue="0", flags=69)})
public class BNACPointDeviceExt
extends BPointDeviceExt
implements BINACMappable {
    @Generated
    public static final Property enabled = BNACPointDeviceExt.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property tamper = BNACPointDeviceExt.newProperty((int)0, (BValue)new BNACSensorPoint(false), null);
    @Generated
    public static final Property batteryFail = BNACPointDeviceExt.newProperty((int)0, (BValue)new BNACSensorPoint(false), null);
    @Generated
    public static final Property acFail = BNACPointDeviceExt.newProperty((int)0, (BValue)new BNACSensorPoint(false), null);
    @Generated
    public static final Property aux = BNACPointDeviceExt.newProperty((int)0, (BValue)new BNACPointFolder(), null);
    @Generated
    public static final Property unid = BNACPointDeviceExt.newProperty((int)69, (int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNACPointDeviceExt.class);
    private final Set<Integer> osdpAddressesInUse = ConcurrentHashMap.newKeySet();
    private final Set<Integer> addressesInUse = ConcurrentHashMap.newKeySet();

    @Override
    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BNACSensorPoint getTamper() {
        return (BNACSensorPoint)this.get(tamper);
    }

    @Generated
    public void setTamper(BNACSensorPoint v) {
        this.set(tamper, (BValue)v, null);
    }

    @Generated
    public BNACSensorPoint getBatteryFail() {
        return (BNACSensorPoint)this.get(batteryFail);
    }

    @Generated
    public void setBatteryFail(BNACSensorPoint v) {
        this.set(batteryFail, (BValue)v, null);
    }

    @Generated
    public BNACSensorPoint getAcFail() {
        return (BNACSensorPoint)this.get(acFail);
    }

    @Generated
    public void setAcFail(BNACSensorPoint v) {
        this.set(acFail, (BValue)v, null);
    }

    @Generated
    public BNACPointFolder getAux() {
        return (BNACPointFolder)this.get(aux);
    }

    @Generated
    public void setAux(BNACPointFolder v) {
        this.set(aux, (BValue)v, null);
    }

    @Override
    @Generated
    public int getUnid() {
        return this.getInt(unid);
    }

    @Generated
    public void setUnid(int v) {
        this.setInt(unid, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final BNACNetwork getNACNetwork() {
        return (BNACNetwork)this.getNetwork();
    }

    public final BNACDevice getNACDevice() {
        return (BNACDevice)this.getDevice();
    }

    public Type getDeviceType() {
        return BNACDevice.TYPE;
    }

    public Type getPointFolderType() {
        return BNACPointFolder.TYPE;
    }

    public Type getProxyExtType() {
        return BNACProxyExt.TYPE;
    }

    @Override
    public void storeMapping(int unid) {
        this.setUnid(unid);
        this.getNACNetwork().storeMapping(unid, this.getHandle());
    }

    @Override
    public void addToServer(boolean partOfSync) {
        this.getNACNetwork().log().log(Level.FINE, "Points folder are not added separately to server");
    }

    @Override
    public void syncToServer() {
    }

    public void syncChildren(JSONObject instance) throws Exception {
        if (instance == null) {
            instance = NACRequestUtils.showResource(this.getNACNetwork(), "dev", String.valueOf(this.getUnid()), 3).getJSONObject("instance");
        }
        JSONArray physicalChildren = instance.getJSONArray("physicalChildren");
        for (Object child : physicalChildren) {
            JSONObject childJson = (JSONObject)child;
            if (childJson.getString("type").equals("Sensor")) {
                this.syncSensorChild(childJson);
                continue;
            }
            if (!childJson.getString("type").equals("Actuator")) continue;
            this.syncActuatorChild(childJson);
        }
    }

    private void syncActuatorChild(JSONObject child) {
        if (child.getString("name").startsWith("Aux Out")) {
            BNACAuxOut auxOut = new BNACAuxOut();
            this.getAux().add(this.getNACNetwork().getLexicon().get("auxOut.name") + "?", (BValue)auxOut);
            auxOut.storeMapping(child.getInt("unid"));
            auxOut.syncToServer();
        }
    }

    private void syncSensorChild(JSONObject child) {
        if (child.getString("name").equals("Tamper")) {
            this.getTamper().storeMapping(child.getInt("unid"));
            this.getTamper().syncToServer();
        } else if (child.getString("name").equals("AC Fail")) {
            this.getAcFail().storeMapping(child.getInt("unid"));
            this.getAcFail().syncToServer();
        } else if (child.getString("name").equals("Battery Fail")) {
            this.getBatteryFail().storeMapping(child.getInt("unid"));
            this.getBatteryFail().syncToServer();
        } else if (child.getString("name").startsWith("Aux In")) {
            BNACSensorPoint auxIn = new BNACSensorPoint(true);
            this.getAux().add(this.getNACNetwork().getLexicon().get("auxIn.name") + "?", (BValue)auxIn);
            auxIn.storeMapping(child.getInt("unid"));
            auxIn.syncToServer();
        }
    }

    public void renamed(Property property, String oldName, Context context) {
        super.renamed(property, oldName, context);
        BValue value = this.get(property);
        if (value instanceof BNACAccessDoor) {
            ((BNACAccessDoor)value).syncServerName();
        }
    }

    public void checkRemove(Property property, Context context) {
        super.checkRemove(property, context);
        BValue value = this.get(property);
        if (value instanceof BNACAccessDoor) {
            throw new LocalizableRuntimeException("nacDriver", "cannotDeleteDoor");
        }
    }

    @Override
    public void updateState(JSONObject devState) {
    }

    @Override
    public void cleanDeviceUnids() {
        this.setUnid(0);
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.toTop("nacDriver:NACPointManager");
        return list;
    }

    public void addOsdpAddress(int osdpAddress) {
        this.osdpAddressesInUse.add(osdpAddress);
    }

    public void removeOsdpAddress(int osdpAddress) {
        this.osdpAddressesInUse.remove(osdpAddress);
    }

    public boolean isOsdpAddressInUse(int osdpAddress) {
        return this.osdpAddressesInUse.contains(osdpAddress);
    }

    public void addAddress(int address) {
        this.addressesInUse.add(address);
    }

    public void removeAddress(int address) {
        this.addressesInUse.remove(address);
    }

    public boolean isAddressInUse(int address) {
        return this.addressesInUse.contains(address);
    }
}

