/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.point;

import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.point.BNACActuatorPoint;
import com.tridiumx.nacDriver.point.BNACCrudActuatorPoint;
import com.tridiumx.nacDriver.point.NACIORequestHandler;
import com.tridiumx.nacDriver.util.NACRequestUtils;
import com.tridiumx.nacDriver.util.Utils;
import java.security.AccessController;
import java.util.logging.Level;

public class NACCrudActuatorRequestHandler
extends NACIORequestHandler {
    public NACCrudActuatorRequestHandler(BNACActuatorPoint point) {
        super(point);
    }

    @Override
    public String getAddToServerBody() {
        BNACCrudActuatorPoint actuator = (BNACCrudActuatorPoint)this.point;
        if (actuator.getLogicalNACParent().getUnid() == 0 || actuator.getPhysicalNACParent().getUnid() == 0) {
            return null;
        }
        return "devInsert[0].devType=3&devInsert[0].devMod=18&devInsert[0].devPlatform=31&devInsert[0].enabled=" + actuator.getEnabled() + "&" + "devInsert" + "[0].devUse=" + actuator.getDevUse() + "&" + "devInsert" + "[0].address=" + actuator.getAddress() + "&" + "devInsert" + "[0].autoSetName=" + true + "&" + "devInsert" + "[0].physicalParent.unid=" + actuator.getPhysicalNACParent().getUnid() + "&" + "devInsert" + "[0].logicalParent.unid=" + actuator.getLogicalNACParent().getUnid();
    }

    @Override
    protected String getSyncParametersBody() {
        BNACCrudActuatorPoint actuator = (BNACCrudActuatorPoint)this.point;
        StringBuilder body = new StringBuilder();
        body.append("address=").append(actuator.getAddress());
        if (super.getSyncParametersBody() != null) {
            body.append("&").append(super.getSyncParametersBody());
        }
        return body.toString();
    }

    public void deleteFromServer(BNACNetwork network) {
        Utils.checkNACPermission();
        network.postAsync(() -> {
            if (this.point.getUnid() != 0) {
                try {
                    AccessController.doPrivileged(() -> {
                        try {
                            NACRequestUtils.removeDevice(network, String.valueOf(this.point.getUnid()));
                            return null;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                catch (Exception e) {
                    Utils.logException(this.getNACNetwork().log(), e, Level.SEVERE, "Actuator was not removed from server. Please sync to update the server");
                }
                finally {
                    network.removeMapping(this.point.getUnid());
                    this.point.cleanDeviceUnids();
                }
            }
        });
    }
}

