/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.ui;

import com.tridium.util.ArrayUtil;
import com.tridium.workbench.fieldeditors.BIntegerFE;
import com.tridiumx.nacDriver.BNACDeviceFolder;
import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.device.BNACController;
import com.tridiumx.nacDriver.device.BNACDevice;
import com.tridiumx.nacDriver.enums.BDevModEnum;
import com.tridiumx.nacDriver.learn.BNACAccessLearnDeviceEntry;
import com.tridiumx.nacDriver.learn.BNACLearnDevicesJob;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"nacDriver:NACDeviceFolder", "nacDriver:NACNetwork"}, requiredPermissions="r")})
public class BNACDeviceManager
extends BDeviceManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BNACDeviceManager.class);
    static Lexicon lex = Lexicon.make(BNACDeviceManager.class);
    static BImage stationIcon = BImage.make((String)"module://icons/x16/device.png");
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(5);
    MgrColumn colDeviceExts = new DeviceExtsColumn((BDevice)new BNACDevice());
    MgrColumn colStatus = new MgrColumn.Prop(BDevice.status);
    MgrColumn colEnabled = new MgrColumn.Prop(BDevice.enabled, 3);
    MgrColumn colHealth = new MgrColumn.Prop(BDevice.health, 0);
    MgrColumn colIpAddress = new MgrColumn.Prop(BNACDevice.ipAddress, 1);
    MgrColumn colPort = new MgrColumn.Prop(BNACDevice.port, 1);
    MgrColumn colNumOfDoors = new MgrColumn.Prop(BNACDevice.numOfDoors, 5);
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colType, this.colDeviceExts, this.colStatus, this.colEnabled, this.colHealth, this.colIpAddress, this.colPort, this.colNumOfDoors};

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNACNetwork getNetwork() {
        BObject owner = this.getCurrentValue();
        if (owner instanceof BNACDeviceFolder) {
            return (BNACNetwork)((BNACDeviceFolder)owner).getNetwork();
        }
        if (owner instanceof BNACNetwork) {
            return (BNACNetwork)owner;
        }
        return null;
    }

    public void doLoadValue(BObject obj, Context cx) {
        super.doLoadValue(obj, cx);
        this.updateLearnData();
    }

    public void updateLearnData() {
        BNACLearnDevicesJob learnJob = (BNACLearnDevicesJob)this.getLearn().getJob();
        if (learnJob != null) {
            this.getLearn().updateRoots(learnJob.getLearnedDevices().getChildren(BNACAccessLearnDeviceEntry.class));
        }
    }

    public BNACDevice[] getSelectedDevices() {
        if (this.getModel() == null || this.getModel().getTable() == null) {
            return new BNACDevice[0];
        }
        BComponent[] selection = this.getModel().getTable().getSelectedComponents();
        Object[] devices = new BNACDevice[]{};
        for (int i = 0; i < selection.length; ++i) {
            if (!selection[i].getType().is(BNACDevice.TYPE)) continue;
            devices = (BNACDevice[])ArrayUtil.addOne((Object[])devices, (Object)((BNACDevice)selection[i]));
        }
        return devices;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    public int openDialog(String title, Object content, int buttons) {
        return BDialog.open((BWidget)this, (String)title, (Object)content, (int)buttons);
    }

    class Controller
    extends DeviceController {
        Controller(BDeviceManager mgr) {
            super(mgr);
        }

        public MgrEdit promptForNew(Context cx) throws Exception {
            MgrModel model = this.getManager().getModel();
            MgrTypeInfo[] types = this.getManager().getModel().getNewTypes();
            if (types == null) {
                BDialog.error((BWidget)this.getManager(), (Object)"Must override BAbstractManager.getNewTypes()");
                return null;
            }
            BListDropDown typeField = new BListDropDown();
            for (MgrTypeInfo type : types) {
                typeField.getList().addItem(type.getIcon(), (Object)type);
            }
            BListDropDown doorField = new BListDropDown();
            doorField.getList().addItem((Object)1);
            doorField.getList().addItem((Object)2);
            doorField.getList().addItem((Object)4);
            BIntegerFE countField = new BIntegerFE();
            countField.loadValue((BObject)BInteger.make((int)1), (Context)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1), (String)"max", (BIDataValue)BInteger.make((int)100), (String)"fieldWidth", (BIDataValue)BInteger.make((int)3)));
            doorField.setSelectedIndex(0);
            typeField.setSelectedIndex(0);
            BGridPane grid = new BGridPane(2);
            grid.add(null, (BValue)new BLabel(lex.getText("add.series")));
            grid.add("series", (BValue)typeField);
            grid.add(null, (BValue)new BLabel(lex.getText("add.numOfDoors")));
            grid.add("numOfDoors", (BValue)doorField);
            grid.add(null, (BValue)new BLabel(Lexicon.make(MgrController.class).getText("add.count")));
            grid.add("count", (BValue)countField);
            String title = this.newCommand.getLabel();
            int r = BNACDeviceManager.this.openDialog(title, grid, 3);
            if (r == 2) {
                return null;
            }
            MgrTypeInfo type = (MgrTypeInfo)typeField.getSelectedItem();
            BNACDevice device = (BNACDevice)model.newInstance(type);
            int numOfDoors = (Integer)doorField.getSelectedItem();
            int count = ((BInteger)countField.saveValue()).getInt();
            try {
                device.validateDoors(numOfDoors);
            }
            catch (Exception e) {
                BDialog.error((BWidget)this.getManager(), (Object)e.getMessage());
                return null;
            }
            MgrEdit edit = this.makeEdit(title);
            for (int i = 0; i < count; ++i) {
                BNACDevice dev = (BNACDevice)model.newInstance(type);
                dev.setNumOfDoors(numOfDoors);
                MgrEditRow row = new MgrEditRow((BComponent)dev, null, types);
                edit.addRow(row);
            }
            return edit;
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            BNACDeviceManager.this.getLearn().setJob(BNACDeviceManager.this.getNetwork().submitDeviceDiscoveryJob());
            return null;
        }
    }

    private static class DeviceTypeCol
    extends MgrColumn {
        public DeviceTypeCol() {
            super(lex.get("deviceTypeCol.displayName"));
        }

        public Object get(Object row) {
            BDevModEnum devMod = ((BNACAccessLearnDeviceEntry)((Object)row)).getDevMod();
            if (devMod.getTag().startsWith("zkInBioSeries")) {
                return lex.get("NACDevice.displayName");
            }
            return lex.get("unsupportedDeviceType");
        }
    }

    class Learn
    extends MgrLearn {
        Learn(BDeviceManager manager) {
            super((BAbstractManager)manager);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BNACAccessLearnDeviceEntry.deviceName), new MgrColumn.Prop(BNACAccessLearnDeviceEntry.address), new DeviceTypeCol(), new MgrColumn.Prop(BNACAccessLearnDeviceEntry.numberOfDoors)};
        }

        public BImage getIcon(Object dis) {
            return stationIcon;
        }

        public MgrTypeInfo[] toTypes(Object discovery) {
            BNACAccessLearnDeviceEntry dis = (BNACAccessLearnDeviceEntry)((Object)discovery);
            if (dis.getDevMod().getTag().startsWith("zkInBioSeries")) {
                return MgrTypeInfo.makeArray((Type)BNACController.TYPE);
            }
            return null;
        }

        public void toRow(Object discovery, MgrEditRow row) {
            BNACAccessLearnDeviceEntry learnEntry = (BNACAccessLearnDeviceEntry)((Object)discovery);
            row.setName(SlotPath.escape((String)learnEntry.getDeviceName()));
            row.setCell(BNACDeviceManager.this.colIpAddress, (BValue)BString.make((String)learnEntry.getAddress()));
            row.setCell(BNACDeviceManager.this.colPort, (BValue)BInteger.make((int)learnEntry.getPort()));
            row.setCell(BNACDeviceManager.this.colNumOfDoors, (BValue)BInteger.make((int)learnEntry.getNumberOfDoors()));
        }

        public boolean isMatchable(Object discovery, BComponent database) {
            if (((BNACAccessLearnDeviceEntry)((Object)discovery)).getNumberOfDoors() != ((BNACDevice)database).getNumOfDoors()) {
                return false;
            }
            return super.isMatchable(discovery, database);
        }

        public boolean isExisting(Object dis, BComponent comp) {
            return false;
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            if (job instanceof BNACLearnDevicesJob) {
                BNACDeviceManager.this.updateLearnData();
            }
        }
    }

    class Model
    extends DeviceModel {
        Model(BDeviceManager manager) {
            super(manager);
        }

        protected MgrColumn[] makeColumns() {
            return BNACDeviceManager.this.cols;
        }

        public MgrTypeInfo[] getNewTypes() {
            return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BNACController.TYPE)};
        }
    }
}

