/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.util;

import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.device.BNACDevice;
import com.tridiumx.nacDriver.point.BNACPointDeviceExt;
import java.security.Permission;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;

public class Utils {
    private static Timer syncTimer = new Timer();

    public static void logException(Logger logger, Exception e, Level level, String message) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(level, message, e);
        } else {
            logger.log(level, message);
        }
    }

    public static void logException(Logger logger, Exception e, Level level) {
        Utils.logException(logger, e, level, e.getMessage());
    }

    public static BNACNetwork getNACNetwork(BComponent component) {
        for (BComplex parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof BNACPointDeviceExt) {
                return ((BNACPointDeviceExt)parent).getNACNetwork();
            }
            if (!(parent instanceof BNACDevice)) continue;
            return ((BNACDevice)parent).getNACNetwork();
        }
        return null;
    }

    public static BNACDevice getNACDevice(BComponent component) {
        for (BComplex parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BNACDevice)) continue;
            return (BNACDevice)parent;
        }
        return null;
    }

    public static void runSyncToServer(final BNACNetwork network, final AtomicBoolean taskInQueue, final Runnable r, long delay) {
        network.postAsync(() -> {
            AtomicBoolean atomicBoolean = taskInQueue;
            synchronized (atomicBoolean) {
                if (!taskInQueue.get()) {
                    taskInQueue.set(true);
                    syncTimer.schedule(new TimerTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            AtomicBoolean atomicBoolean = taskInQueue;
                            synchronized (atomicBoolean) {
                                taskInQueue.set(false);
                            }
                            try {
                                r.run();
                            }
                            catch (Exception e) {
                                Utils.logException(network.log(), e, Level.SEVERE, "Sync to server on timer thread failed : " + e.getMessage());
                            }
                        }
                    }, delay);
                }
            }
        });
    }

    public static void checkNACPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new NiagaraBasicPermission("MANAGE_NAC"));
        }
    }
}

