/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nvideo.event;

import com.tridium.nvideo.event.BVideoEventStatus;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import com.tridium.videoDriver.enums.BVideoEventTypesEnum;
import com.tridium.videoDriver.event.BIVideoEventDetection;
import com.tridium.videoDriver.event.BIVideoEventSource;
import com.tridium.videoDriver.event.BVideoEvent;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BStringPoint;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.license.LicenseException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="mostRecentEvent", type="BVideoEvent", defaultValue="BVideoEvent.makeNoEvent()", flags=1), @NiagaraProperty(name="autoExpiration", type="boolean", defaultValue="true"), @NiagaraProperty(name="autoExpirationInterval", type="BRelTime", defaultValue="DEFAULT_EVENT_EXPIRATION")})
@NiagaraActions(value={@NiagaraAction(name="enableDetection"), @NiagaraAction(name="disableDetection"), @NiagaraAction(name="eventExpired", flags=4)})
@NiagaraTopic(name="videoEventOccurred", eventType="BVideoEvent")
public abstract class BVideoEventProxyExt
extends BProxyExt
implements BIVideoEventSource,
BIVideoEventDetection {
    public static final BRelTime DEFAULT_EVENT_EXPIRATION = BRelTime.makeSeconds((int)45);
    @Generated
    public static final Property mostRecentEvent = BVideoEventProxyExt.newProperty((int)1, (BValue)BVideoEvent.makeNoEvent(), null);
    @Generated
    public static final Property autoExpiration = BVideoEventProxyExt.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property autoExpirationInterval = BVideoEventProxyExt.newProperty((int)0, (BValue)DEFAULT_EVENT_EXPIRATION, null);
    @Generated
    public static final Action enableDetection = BVideoEventProxyExt.newAction((int)0, null);
    @Generated
    public static final Action disableDetection = BVideoEventProxyExt.newAction((int)0, null);
    @Generated
    public static final Action eventExpired = BVideoEventProxyExt.newAction((int)4, null);
    @Generated
    public static final Topic videoEventOccurred = BVideoEventProxyExt.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BVideoEventProxyExt.class);
    public static final BasicContext CONTEXT_PROXY_UPDATE = new BasicContext();
    protected Clock.Ticket eventExpirationTicket;
    protected BVideoEvent currentOffNormalEvent = null;

    @Generated
    public BVideoEvent getMostRecentEvent() {
        return (BVideoEvent)this.get(mostRecentEvent);
    }

    @Generated
    public void setMostRecentEvent(BVideoEvent v) {
        this.set(mostRecentEvent, (BValue)v, null);
    }

    @Generated
    public boolean getAutoExpiration() {
        return this.getBoolean(autoExpiration);
    }

    @Generated
    public void setAutoExpiration(boolean v) {
        this.setBoolean(autoExpiration, v, null);
    }

    @Generated
    public BRelTime getAutoExpirationInterval() {
        return (BRelTime)this.get(autoExpirationInterval);
    }

    @Generated
    public void setAutoExpirationInterval(BRelTime v) {
        this.set(autoExpirationInterval, (BValue)v, null);
    }

    @Generated
    public void enableDetection() {
        this.invoke(enableDetection, null, null);
    }

    @Generated
    public void disableDetection() {
        this.invoke(disableDetection, null, null);
    }

    @Generated
    public void eventExpired() {
        this.invoke(eventExpired, null, null);
    }

    @Generated
    public void fireVideoEventOccurred(BVideoEvent event) {
        this.fire(videoEventOccurred, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        try {
            Sys.getLicenseManager().checkFeature("tridium", "videoDriver");
            this.videoProxyExtStarted();
        }
        catch (LicenseException fnle) {
            this.configFatal(fnle.toString());
        }
        super.started();
    }

    public void videoProxyExtStarted() {
        this.setStale(false, null);
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    public BIVideoDvr getVideoDvr() {
        BComplex parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof BIVideoDvr); parent = parent.getParent()) {
        }
        return (BIVideoDvr)parent;
    }

    public BIVideoCamera getVideoCamera() {
        BComplex parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof BIVideoCamera); parent = parent.getParent()) {
        }
        return (BIVideoCamera)parent;
    }

    public BVideoEventTypesEnum getEventTypeEnum() {
        return BVideoEventTypesEnum.nullEvent;
    }

    public Topic getVideoEventTopic() {
        return videoEventOccurred;
    }

    public void doEventExpired() {
        BVideoEvent expirationEvent = (BVideoEvent)this.getMostRecentEvent().newCopy();
        expirationEvent.setTimestamp(BAbsTime.now());
        expirationEvent.setEventType(BVideoEventTypesEnum.eventExpired);
        expirationEvent.setIsNormal(!expirationEvent.getIsNormal());
        this.readOk(new BVideoEventStatus(expirationEvent));
    }

    public boolean isEventNormal(BVideoEvent videoEvent) {
        return videoEvent.getIsNormal();
    }

    public boolean isEventOffnormal(BVideoEvent videoEvent) {
        return !this.isEventNormal(videoEvent);
    }

    public boolean isAutomaticExpiration(BVideoEvent videoEvent) {
        return true;
    }

    public BRelTime getAutomaticExpirationInterval(BVideoEvent videoEvent) {
        return this.getAutoExpirationInterval();
    }

    public void readOk(BStatusValue newValue) {
        boolean isOffNormalEvent;
        if (!(newValue instanceof BVideoEventStatus)) {
            throw new IllegalArgumentException("Given 'newValue' needs to be an instance of BVideoEventStatus");
        }
        BVideoEventStatus videoEventStatus = (BVideoEventStatus)newValue;
        BVideoEvent videoEvent = videoEventStatus.getVideoEvent();
        this.setMostRecentEvent((BVideoEvent)videoEvent.newCopy());
        this.fireVideoEventOccurred(videoEventStatus.getVideoEvent());
        BControlPoint parentPoint = this.getParentPoint();
        if (this.eventExpirationTicket != null) {
            this.eventExpirationTicket.cancel();
        }
        if (isOffNormalEvent = this.isEventOffnormal(videoEvent)) {
            if (this.currentOffNormalEvent == null) {
                videoEvent.updateProxyAlarmExt((BProxyExt)this, BOrd.NULL);
                this.currentOffNormalEvent = videoEvent;
            }
            if (this.getAutoExpiration()) {
                this.eventExpirationTicket = Clock.schedule((BComponent)this, (BRelTime)this.getAutomaticExpirationInterval(videoEvent), (Action)eventExpired, null);
            }
        } else {
            videoEvent.updateProxyAlarmExt((BProxyExt)this, BOrd.NULL);
            this.currentOffNormalEvent = null;
        }
        if (parentPoint instanceof BINumeric) {
            if (videoEvent.getEventType() != BVideoEventTypesEnum.eventExpired) {
                super.readOk((BStatusValue)new BStatusNumeric((double)videoEvent.getTimestamp().getMillis()));
            }
        } else if (parentPoint instanceof BIBoolean) {
            super.readOk((BStatusValue)new BStatusBoolean(isOffNormalEvent));
        } else if (parentPoint instanceof BIEnum) {
            BStatusEnum e = ((BEnumPoint)parentPoint).getOut();
            super.readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)(this.isEventOffnormal(videoEvent) ? 1 : 0), (BEnumRange)e.getValue().getRange())));
        } else if (parentPoint instanceof BStringPoint) {
            super.readOk((BStatusValue)new BStatusString(videoEvent.toString((Context)CONTEXT_PROXY_UPDATE)));
        } else {
            throw new IllegalArgumentException("Unsupported control point type: " + parentPoint.getType().getTypeSpec());
        }
    }

    public void doEnableDetection() {
        try {
            this.implEnableDetection(true);
            this.writeOk(this.getReadValue());
        }
        catch (Exception e) {
            this.writeFail(e.toString());
        }
    }

    public void doDisableDetection() {
        try {
            this.implEnableDetection(false);
            this.writeOk(this.getReadValue());
        }
        catch (Exception e) {
            this.writeFail(e.toString());
        }
    }

    protected abstract void implEnableDetection(boolean var1) throws Exception;
}

