/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.ui;

import com.tridium.ndio.NdioException;
import com.tridium.ndio.conv.BTabularThermistorConversion;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.ord.BFileOrdChooser;
import java.io.InputStream;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.file.types.text.BXmlFile;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.Position;
import javax.baja.util.Lexicon;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XText;
import javax.baja.xml.XWriter;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="okButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="setModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")})
public class BTabularThermistorDialog
extends BDialog {
    @Generated
    public static final Action okButtonPressed = BTabularThermistorDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action cancelButtonPressed = BTabularThermistorDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action setModified = BTabularThermistorDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTabularThermistorDialog.class);
    static Lexicon ndioLex = Lexicon.make((String)"ndio");
    static BImage editIcon = BImage.make((String)"module://icons/x32/edit.png");
    private BGridPane tablePane;
    private BButton okButton;
    private BTextField desc;
    private int nextIndex;
    private Array<Integer> map = new Array(Integer.class);
    private BTabularThermistorConversion conversion = null;

    @Generated
    public void okButtonPressed(BWidgetEvent parameter) {
        this.invoke(okButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public void setModified(BWidgetEvent parameter) {
        this.invoke(setModified, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static final BTabularThermistorConversion show(BWidget owner, BTabularThermistorConversion src) {
        BTabularThermistorDialog dialog = new BTabularThermistorDialog(owner, src);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getConversion();
    }

    private BTabularThermistorDialog(BWidget parent, BTabularThermistorConversion src) {
        super(parent, ndioLex.get("tabularDialog.title"), true);
        BLabel descLabel = new BLabel(ndioLex.get("tabularDialog.descriptionLabel"));
        this.desc = new BTextField("");
        this.desc.setText(src.getDescription());
        this.desc.getSelection().deselect();
        this.desc.moveCaretPosition(new Position(0, 0));
        this.linkTo(null, (BComponent)this.desc, (Slot)BTextField.textModified, (Slot)setModified);
        BGridPane descPane = new BGridPane(2);
        descPane.add(null, (BValue)descLabel);
        descPane.add(null, (BValue)this.desc);
        descPane.setHalign(BHalign.left);
        descPane.setStretchColumn(1);
        descPane.setColumnAlign(BHalign.fill);
        this.tablePane = new BGridPane(3);
        this.tablePane.setColumnAlign(BHalign.center);
        this.tablePane.setRowAlign(BValign.fill);
        this.tablePane.setValign(BValign.top);
        Array points = src.getPoints();
        this.buildTablePane(points);
        BButton addButton = new BButton((Command)new AddCmd());
        BButton resortButton = new BButton((Command)new ResortCmd());
        BButton deleteAllButton = new BButton((Command)new DeleteAllCmd());
        BButton importButton = new BButton((Command)new ImportCmd());
        BButton exportButton = new BButton((Command)new ExportCmd());
        this.linkTo(null, (BComponent)addButton, (Slot)BButton.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)resortButton, (Slot)BButton.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)deleteAllButton, (Slot)BButton.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)importButton, (Slot)BButton.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)exportButton, (Slot)BButton.actionPerformed, (Slot)setModified);
        BGridPane addbuttonPane = new BGridPane(1);
        addbuttonPane.setUniformColumnWidth(true);
        addbuttonPane.setColumnAlign(BHalign.fill);
        addbuttonPane.setValign(BValign.top);
        addbuttonPane.add(null, (BValue)addButton);
        addbuttonPane.add(null, (BValue)resortButton);
        addbuttonPane.add(null, (BValue)deleteAllButton);
        addbuttonPane.add(null, (BValue)importButton);
        addbuttonPane.add(null, (BValue)exportButton);
        BGridPane okbuttonPane = new BGridPane(2);
        okbuttonPane.setColumnAlign(BHalign.fill);
        okbuttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(ndioLex.get("tabularDialog.okButtonLabel"));
        okbuttonPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(false);
        BButton cancelButton = new BButton(ndioLex.get("tabularDialog.cancelButtonLabel"));
        okbuttonPane.add(null, (BValue)cancelButton);
        this.linkTo("linkB", (BComponent)cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        BEdgePane outerPane = new BEdgePane();
        outerPane.setTop((BWidget)new BBorderPane((BWidget)descPane, 7.0, 7.0, 0.0, 7.0));
        BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.tablePane, 7.0, 7.0, 7.0, 7.0));
        scrollPane.setVpolicy(BScrollBarPolicy.always);
        scrollPane.setHpolicy(BScrollBarPolicy.never);
        scrollPane.setViewportBackground(Theme.widget().getControlBackground());
        BConstrainedPane constrainedPane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)scrollPane, BBorder.inset, BInsets.DEFAULT));
        constrainedPane.setFixedSize(205.0, 250.0);
        outerPane.setCenter((BWidget)new BBorderPane((BWidget)constrainedPane, 7.0, 7.0, 7.0, 7.0));
        outerPane.setRight((BWidget)new BBorderPane((BWidget)addbuttonPane, 7.0, 7.0, 0.0, 0.0));
        outerPane.setBottom((BWidget)new BBorderPane((BWidget)okbuttonPane, 0.0, 0.0, 7.0, 0.0));
        this.setContent((BWidget)outerPane);
        this.setDefaultButton(this.okButton);
    }

    private void buildTablePane(Array points) {
        this.tablePane.removeAll();
        this.map.clear();
        this.nextIndex = 0;
        int size = points.size();
        if (size > 0) {
            this.tablePane.add("xh", (BValue)new BLabel(ndioLex.get("tabularDialog.ohmsColumnLabel")));
            this.tablePane.add("yh", (BValue)new BLabel(ndioLex.get("tabularDialog.celsiusColumnLabel")));
            this.tablePane.add("dh", (BValue)new BNullWidget());
            for (int i = 0; i < size; ++i) {
                BTextField yfield;
                BTextField xfield;
                Object pnt;
                if (points.get(i) instanceof BTabularThermistorConversion.XYPoint) {
                    pnt = (BTabularThermistorConversion.XYPoint)points.get(i);
                    xfield = new BTextField(pnt.x() + "", 10);
                    yfield = new BTextField(pnt.y() + "", 10);
                } else {
                    pnt = (TextXYPoint)points.get(i);
                    xfield = new BTextField(((TextXYPoint)pnt).x(), 10);
                    yfield = new BTextField(((TextXYPoint)pnt).y(), 10);
                }
                DeleteCmd deleteCmd = new DeleteCmd(i);
                BButton dfield = new BButton((Command)deleteCmd);
                this.linkTo(null, (BComponent)dfield, (Slot)BButton.actionPerformed, (Slot)setModified);
                dfield.setButtonStyle(BButtonStyle.toolBar);
                xfield.setExpandHeight(true);
                yfield.setExpandHeight(true);
                this.tablePane.add("x" + i, (BValue)xfield);
                this.tablePane.add("y" + i, (BValue)yfield);
                this.tablePane.add("d" + i, (BValue)dfield);
                this.linkTo(null, (BComponent)xfield, (Slot)BTextField.textModified, (Slot)setModified);
                this.linkTo(null, (BComponent)yfield, (Slot)BTextField.textModified, (Slot)setModified);
                this.linkTo(null, (BComponent)dfield, (Slot)BButton.actionPerformed, (Slot)setModified);
                this.map.add((Object)i);
            }
            this.nextIndex = size;
        }
    }

    public BTabularThermistorConversion getConversion() {
        return this.conversion;
    }

    public void doOkButtonPressed(BWidgetEvent event) {
        BTabularThermistorConversion conv;
        Array arr = new Array(BTabularThermistorConversion.XYPoint.class);
        if (this.map.size() < 2) {
            BDialog.error((BWidget)this, (Object)ndioLex.get("tabularDialog.twoPointsError"));
            return;
        }
        for (int i = 0; i < this.map.size(); ++i) {
            double y;
            double x;
            String xname = "x" + this.map.get(i);
            String yname = "y" + this.map.get(i);
            BTextField xfield = (BTextField)this.tablePane.get(xname);
            BTextField yfield = (BTextField)this.tablePane.get(yname);
            try {
                x = Double.parseDouble(xfield.getText());
                y = Double.parseDouble(yfield.getText());
            }
            catch (NumberFormatException n) {
                BDialog.error((BWidget)this, (Object)ndioLex.get("tabularDialog.invalidFormatError"));
                return;
            }
            arr.add((Object)new BTabularThermistorConversion.XYPoint(x, y));
        }
        arr.sort();
        this.conversion = conv = BTabularThermistorConversion.make((String)this.desc.getText(), (Array)arr);
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent event) {
        this.close();
    }

    public void doSetModified(BWidgetEvent event) {
        this.okButton.setEnabled(true);
    }

    class TextXYPoint
    implements Comparable<Object> {
        String x;
        String y;

        public TextXYPoint(String x, String y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public int compareTo(Object o) {
            if (o instanceof TextXYPoint) {
                TextXYPoint src = (TextXYPoint)o;
                try {
                    double srcxv = Double.parseDouble(src.x);
                    double xv = Double.parseDouble(this.x);
                    if (srcxv > xv) {
                        return -1;
                    }
                    if (srcxv < xv) {
                        return 1;
                    }
                    return 0;
                }
                catch (NumberFormatException e) {
                    return 1;
                }
            }
            throw new ClassCastException("can't compare TextXYPoint");
        }

        public String toString() {
            return "{x=" + this.x + ",y=" + this.y + "}";
        }

        public String x() {
            return this.x;
        }

        public String y() {
            return this.y;
        }
    }

    class ExportCmd
    extends Command {
        public ExportCmd() {
            super((BWidget)BTabularThermistorDialog.this, Lexicon.make((String)"ndio"), "tabularThermistor.exportButton");
        }

        public CommandArtifact doInvoke() {
            BFacets facets = BFacets.make((String)"save", (BIDataValue)BBoolean.TRUE);
            String defaultName = "thermistor_table.xml";
            try {
                defaultName = BTabularThermistorDialog.this.desc.getText();
                defaultName = defaultName.replaceAll("\\s+", "_");
                defaultName = defaultName.replaceAll("[^a-zA-Z0-9_]+", "");
                defaultName = defaultName.toLowerCase();
                if (defaultName.trim().length() == 0) {
                    defaultName = "thermistor_table";
                }
                defaultName = defaultName + ".xml";
            }
            catch (Exception exception) {
                // empty catch block
            }
            facets = BFacets.make((BFacets)facets, (String)"defaultFileName", (BIDataValue)BString.make((String)defaultName));
            BFileOrdChooser chooser = new BFileOrdChooser();
            chooser.addFilter((IFileFilter)new ExtFileFilter("Xml Files (*.xml)", "xml"));
            BOrd ord = chooser.openChooser((BWidget)BTabularThermistorDialog.this, (BObject)BTabularThermistorDialog.this, BOrd.make((String)"file:^"), (Context)facets);
            if (ord == null) {
                return null;
            }
            try {
                this.saveFile(ord);
            }
            catch (NdioException e) {
                BDialog.error((BWidget)BTabularThermistorDialog.this, (String)BDialog.TITLE_ERROR, (Object)ndioLex.get("tabularDialog.exportError"), (Throwable)e);
            }
            return null;
        }

        private void saveFile(BOrd fileOrd) throws NdioException {
            if (BTabularThermistorDialog.this.map.size() < 2) {
                BDialog.error((BWidget)BTabularThermistorDialog.this, (Object)ndioLex.get("tabularDialog.twoPointsError"));
                return;
            }
            XElem xroot = new XElem("thermistor");
            XElem xdesc = new XElem("description");
            xdesc.addContent((XContent)new XText(BTabularThermistorDialog.this.desc.getText()));
            xroot.addContent((XContent)xdesc);
            XElem xtable = new XElem("table");
            xroot.addContent((XContent)xtable);
            for (int i = 0; i < BTabularThermistorDialog.this.map.size(); ++i) {
                String xname = "x" + BTabularThermistorDialog.this.map.get(i);
                String yname = "y" + BTabularThermistorDialog.this.map.get(i);
                BTextField xfield = (BTextField)BTabularThermistorDialog.this.tablePane.get(xname);
                BTextField yfield = (BTextField)BTabularThermistorDialog.this.tablePane.get(yname);
                try {
                    double x = Double.parseDouble(xfield.getText());
                    double y = Double.parseDouble(yfield.getText());
                    XElem point = new XElem("point");
                    point.setAttr("ohms", xfield.getText());
                    point.setAttr("celsius", yfield.getText());
                    xtable.addContent((XContent)point);
                    continue;
                }
                catch (NumberFormatException n) {
                    BDialog.error((BWidget)BTabularThermistorDialog.this, (Object)ndioLex.get("tabularDialog.invalidFormatError"));
                    return;
                }
            }
            try {
                BIFile file = (BIFile)fileOrd.get();
                XWriter xwriter = new XWriter(file.getOutputStream());
                xwriter.prolog();
                xroot.write(xwriter);
                xwriter.close();
            }
            catch (Exception e) {
                BDialog.error((BWidget)BTabularThermistorDialog.this, (String)ndioLex.get("tabularDialog.writingError"), (Object)e);
                return;
            }
        }
    }

    class ImportCmd
    extends Command {
        public ImportCmd() {
            super((BWidget)BTabularThermistorDialog.this, Lexicon.make((String)"ndio"), "tabularThermistor.importButton");
        }

        public CommandArtifact doInvoke() {
            BFileOrdChooser chooser = new BFileOrdChooser();
            chooser.addFilter((IFileFilter)new ExtFileFilter("Xml Files (*.xml)", "xml"));
            BOrd ord = chooser.openChooser((BWidget)BTabularThermistorDialog.this, (BObject)BTabularThermistorDialog.this, BOrd.make((String)"file:^"), null);
            if (ord == null) {
                return null;
            }
            if (BDialog.confirm((BWidget)BTabularThermistorDialog.this, (String)BDialog.TITLE_CONFIRM, (Object)ndioLex.get("tabularDialog.confirmMessage")) == 8) {
                return null;
            }
            try {
                this.loadFile(ord);
            }
            catch (NdioException e) {
                BDialog.error((BWidget)BTabularThermistorDialog.this, (String)BDialog.TITLE_ERROR, (Object)ndioLex.get("tabularDialog.importError"), (Throwable)e);
            }
            return null;
        }

        private void loadFile(BOrd fileOrd) throws NdioException {
            InputStream stream = null;
            BTabularThermistorConversion conv = null;
            Array arr = new Array(BTabularThermistorConversion.XYPoint.class);
            try {
                BXmlFile file = (BXmlFile)fileOrd.get();
                if (file == null) {
                    throw new NdioException("File not defined.");
                }
                stream = file.getInputStream();
                XParser parser = XParser.make((InputStream)stream);
                XElem thermistorElem = parser.parse();
                XElem descriptionElem = thermistorElem.elem("description");
                String description = descriptionElem.string();
                XElem tableElem = thermistorElem.elem("table");
                if (tableElem == null) {
                    throw new NdioException("Improperly formatted file: No 'table' elemnent.");
                }
                XElem[] pointElems = tableElem.elems("point");
                if (pointElems.length < 2) {
                    throw new NdioException("Must have at least two points.");
                }
                for (int i = 0; i < pointElems.length; ++i) {
                    arr.add((Object)new BTabularThermistorConversion.XYPoint(pointElems[i].getd("ohms"), pointElems[i].getd("celsius")));
                }
                arr.sort();
                conv = BTabularThermistorConversion.make((String)description, (Array)arr);
            }
            catch (NdioException n) {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw n;
            }
            catch (Exception e) {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new NdioException(e.getMessage());
            }
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            BTabularThermistorDialog.this.desc.setText(conv.getDescription());
            BTabularThermistorDialog.this.desc.getSelection().deselect();
            BTabularThermistorDialog.this.desc.moveCaretPosition(new Position(0, 0));
            BTabularThermistorDialog.this.buildTablePane(conv.getPoints());
        }
    }

    class DeleteAllCmd
    extends Command {
        public DeleteAllCmd() {
            super((BWidget)BTabularThermistorDialog.this, Lexicon.make((String)"ndio"), "tabularThermistor.deleteAllButton");
        }

        public CommandArtifact doInvoke() {
            if (BTabularThermistorDialog.this.map.size() == 0) {
                return null;
            }
            for (int i = 0; i < BTabularThermistorDialog.this.map.size(); ++i) {
                String xname = "x" + BTabularThermistorDialog.this.map.get(i);
                String yname = "y" + BTabularThermistorDialog.this.map.get(i);
                String dname = "d" + BTabularThermistorDialog.this.map.get(i);
                BTabularThermistorDialog.this.tablePane.remove(xname);
                BTabularThermistorDialog.this.tablePane.remove(yname);
                BTabularThermistorDialog.this.tablePane.remove(dname);
            }
            BTabularThermistorDialog.this.map.clear();
            BTabularThermistorDialog.this.tablePane.remove("xh");
            BTabularThermistorDialog.this.tablePane.remove("yh");
            BTabularThermistorDialog.this.tablePane.remove("dh");
            BTabularThermistorDialog.this.nextIndex = 0;
            BTabularThermistorDialog.this.desc.setText("");
            BTabularThermistorDialog.this.desc.getSelection().deselect();
            BTabularThermistorDialog.this.desc.moveCaretPosition(new Position(0, 0));
            return null;
        }
    }

    class ResortCmd
    extends Command {
        public ResortCmd() {
            super((BWidget)BTabularThermistorDialog.this, Lexicon.make((String)"ndio"), "tabularThermistor.resortButton");
        }

        public CommandArtifact doInvoke() {
            Array array = new Array(TextXYPoint.class);
            for (int i = 0; i < BTabularThermistorDialog.this.map.size(); ++i) {
                String xname = "x" + BTabularThermistorDialog.this.map.get(i);
                String yname = "y" + BTabularThermistorDialog.this.map.get(i);
                BTextField xfield = (BTextField)BTabularThermistorDialog.this.tablePane.get(xname);
                BTextField yfield = (BTextField)BTabularThermistorDialog.this.tablePane.get(yname);
                TextXYPoint pnt = new TextXYPoint(xfield.getText(), yfield.getText());
                array.add((Object)pnt);
            }
            array = array.sort();
            BTabularThermistorDialog.this.buildTablePane(array);
            return null;
        }
    }

    class AddCmd
    extends Command {
        public AddCmd() {
            super((BWidget)BTabularThermistorDialog.this, Lexicon.make((String)"ndio"), "tabularThermistor.addButton");
        }

        public CommandArtifact doInvoke() {
            BTextField xfield = new BTextField("", 10);
            BTextField yfield = new BTextField("", 10);
            DeleteCmd deleteCmd = new DeleteCmd(BTabularThermistorDialog.this.nextIndex);
            BButton dfield = new BButton((Command)deleteCmd);
            dfield.setButtonStyle(BButtonStyle.toolBar);
            BTabularThermistorDialog.this.linkTo(null, (BComponent)dfield, (Slot)BButton.actionPerformed, (Slot)setModified);
            if (BTabularThermistorDialog.this.map.size() == 0) {
                BTabularThermistorDialog.this.tablePane.add("xh", (BValue)new BLabel(ndioLex.get("tabularDialog.ohmsColumnLabel")));
                BTabularThermistorDialog.this.tablePane.add("yh", (BValue)new BLabel(ndioLex.get("tabularDialog.celsiusColumnLabel")));
                BTabularThermistorDialog.this.tablePane.add("dh", (BValue)new BNullWidget());
            }
            xfield.setExpandHeight(true);
            yfield.setExpandHeight(true);
            BTabularThermistorDialog.this.tablePane.add("x" + BTabularThermistorDialog.this.nextIndex, (BValue)xfield);
            BTabularThermistorDialog.this.tablePane.add("y" + BTabularThermistorDialog.this.nextIndex, (BValue)yfield);
            BTabularThermistorDialog.this.tablePane.add("d" + BTabularThermistorDialog.this.nextIndex, (BValue)dfield);
            BTabularThermistorDialog.this.linkTo(null, (BComponent)xfield, (Slot)BTextField.textModified, (Slot)setModified);
            BTabularThermistorDialog.this.linkTo(null, (BComponent)yfield, (Slot)BTextField.textModified, (Slot)setModified);
            BTabularThermistorDialog.this.linkTo(null, (BComponent)dfield, (Slot)BButton.actionPerformed, (Slot)setModified);
            BTabularThermistorDialog.this.map.add((Object)BTabularThermistorDialog.this.nextIndex);
            BTabularThermistorDialog.this.nextIndex++;
            return null;
        }
    }

    class DeleteCmd
    extends Command {
        private int index;

        public DeleteCmd(int index) {
            super((BWidget)BTabularThermistorDialog.this, Lexicon.make((String)"ndio"), "tabularThermistor.deleteButton");
            this.index = index;
        }

        public CommandArtifact doInvoke() {
            BTabularThermistorDialog.this.tablePane.remove("x" + this.index);
            BTabularThermistorDialog.this.tablePane.remove("y" + this.index);
            BTabularThermistorDialog.this.tablePane.remove("d" + this.index);
            BTabularThermistorDialog.this.map.remove((Object)this.index);
            if (BTabularThermistorDialog.this.map.size() == 0) {
                BTabularThermistorDialog.this.tablePane.remove("xh");
                BTabularThermistorDialog.this.tablePane.remove("yh");
                BTabularThermistorDialog.this.tablePane.remove("dh");
            }
            return null;
        }
    }
}

