/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.util;

import com.tridium.html.util.Declarator;
import com.tridium.html.util.Selector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.nre.util.TextUtil;

public class CSSParser {
    private static final int SELECTORS = 0;
    private static final int DECLARATORS = 1;

    private StringBuilder stripComments(String str) {
        StringBuilder sb = new StringBuilder();
        boolean inComment = false;
        for (int n = 0; n < str.length(); ++n) {
            if (inComment) {
                if (str.charAt(n + 0) != '*' || str.charAt(n + 1) != '/') continue;
                inComment = false;
                ++n;
                continue;
            }
            if (str.charAt(n + 0) == '/' && str.charAt(n + 1) == '*') {
                inComment = true;
                continue;
            }
            sb.append(str.charAt(n));
        }
        return sb;
    }

    private List<Selector> getSelectors(String str) {
        ArrayList<Selector> list = new ArrayList<Selector>();
        String[] selectorList = TextUtil.split((String)str, (char)',');
        for (int i = 0; i < selectorList.length; ++i) {
            String selector = selectorList[i];
            String[] tokens = TextUtil.split((String)selector, (char)'.');
            String tagName = tokens[0].trim();
            String className = tokens.length > 1 ? tokens[1].trim() : null;
            list.add(new Selector(tagName.toUpperCase(), className));
        }
        return list;
    }

    private List<Declarator> getDeclarators(String str) {
        ArrayList<Declarator> list = new ArrayList<Declarator>();
        String[] declaratorList = TextUtil.split((String)str, (char)';');
        for (int i = 0; i < declaratorList.length; ++i) {
            String declarator = declaratorList[i];
            String[] tokens = TextUtil.split((String)declarator, (char)':');
            if (tokens.length != 2) continue;
            String name = tokens[0].trim();
            String value = tokens[1].trim();
            list.add(new Declarator(name.toUpperCase(), value));
        }
        return list;
    }

    public final Map<Selector, List<Declarator>> parse(String str) {
        StringBuilder sb = this.stripComments(str);
        int state = 0;
        HashMap<Selector, List<Declarator>> rules = new HashMap<Selector, List<Declarator>>();
        List<Selector> selectors = null;
        List<Declarator> declarators = null;
        int mark = 0;
        block4: for (int n = 0; n < sb.length(); ++n) {
            switch (state) {
                case 0: {
                    if (sb.charAt(n) != '{') continue block4;
                    selectors = this.getSelectors(sb.substring(mark, n));
                    state = 1;
                    mark = n + 1;
                    continue block4;
                }
                case 1: {
                    if (sb.charAt(n) != '}') continue block4;
                    declarators = this.getDeclarators(sb.substring(mark, n));
                    for (int i = 0; i < selectors.size(); ++i) {
                        rules.put(selectors.get(i), declarators);
                    }
                    state = 0;
                    mark = n + 1;
                }
            }
        }
        return rules;
    }
}

