/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.util;

import java.awt.Color;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.baja.nre.util.TextUtil;

public class ColorCodec {
    private static Hashtable<String, Color> toColor = new Hashtable(301);
    private static Hashtable<Color, String> fromColor = new Hashtable(301);
    private static final Logger log;
    public static final Color DEFAULT;

    public static Color decode(String value) {
        return ColorCodec.decode(value, DEFAULT);
    }

    public static Color decode(String value, Color defaultValue) {
        try {
            if (value.charAt(0) == '#') {
                return ColorCodec.decodeNumeric(value);
            }
            Color c = toColor.get(TextUtil.toLowerCase((String)value));
            if (c != null) {
                return c;
            }
            if (value.indexOf(40) > 0) {
                return ColorCodec.decodeFunction(value);
            }
        }
        catch (Exception e) {
            log.warning("Invalid color: " + value);
        }
        return defaultValue;
    }

    public static String encode(Color c) {
        String predefined = fromColor.get(c);
        if (predefined != null) {
            return predefined;
        }
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        StringBuilder s = new StringBuilder(8);
        s.append('#');
        if (r < 16) {
            s.append(0);
        }
        s.append(Integer.toHexString(r));
        if (g < 16) {
            s.append(0);
        }
        s.append(Integer.toHexString(g));
        if (b < 16) {
            s.append(0);
        }
        s.append(Integer.toHexString(b));
        return s.toString();
    }

    private static Color decodeNumeric(String value) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (value.length() == 4) {
            r = ColorCodec.fromHexChar(value.charAt(1));
            r = r << 4 | r;
            g = ColorCodec.fromHexChar(value.charAt(2));
            g = g << 4 | g;
            b = ColorCodec.fromHexChar(value.charAt(3));
            b = b << 4 | b;
        } else if (value.length() == 7) {
            r = ColorCodec.fromHexChar(value.charAt(1)) << 4 | ColorCodec.fromHexChar(value.charAt(2));
            g = ColorCodec.fromHexChar(value.charAt(3)) << 4 | ColorCodec.fromHexChar(value.charAt(4));
            b = ColorCodec.fromHexChar(value.charAt(5)) << 4 | ColorCodec.fromHexChar(value.charAt(6));
        }
        return new Color(r, g, b);
    }

    private static int fromHexChar(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + c - 65;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + c - 97;
        }
        throw new IllegalArgumentException("Invalid hex char '" + c + "'");
    }

    private static Color decodeFunction(String value) {
        if (value.charAt(0) != 'r' || value.charAt(1) != 'g' || value.charAt(2) != 'b' || value.charAt(3) != '(' || value.charAt(value.length() - 1) != ')') {
            return DEFAULT;
        }
        String sub = value.substring(4, value.length() - 1);
        StringTokenizer st = new StringTokenizer(sub, " ,");
        int r = ColorCodec.parseNumeric(st.nextToken());
        int g = ColorCodec.parseNumeric(st.nextToken());
        int b = ColorCodec.parseNumeric(st.nextToken());
        return new Color(r, g, b);
    }

    private static int parseNumeric(String token) {
        if (token.charAt(token.length() - 1) == '%') {
            String sub = token.substring(0, token.length() - 1);
            double percent = (double)Integer.parseInt(sub) / 100.0;
            return (int)(255.0 * percent);
        }
        return Integer.parseInt(token);
    }

    private static void predefine(String key, Color c) {
        toColor.put(key, c);
        fromColor.put(c, key);
    }

    static {
        ColorCodec.predefine("aliceblue", new Color(240, 248, 255));
        ColorCodec.predefine("antiquewhite", new Color(250, 235, 215));
        ColorCodec.predefine("aqua", new Color(0, 255, 255));
        ColorCodec.predefine("aquamarine", new Color(127, 255, 212));
        ColorCodec.predefine("azure", new Color(240, 255, 255));
        ColorCodec.predefine("beige", new Color(245, 245, 220));
        ColorCodec.predefine("bisque", new Color(255, 228, 196));
        ColorCodec.predefine("black", new Color(0, 0, 0));
        ColorCodec.predefine("blanchedalmond", new Color(255, 235, 205));
        ColorCodec.predefine("blue", new Color(0, 0, 255));
        ColorCodec.predefine("blueviolet", new Color(138, 43, 226));
        ColorCodec.predefine("brown", new Color(165, 42, 42));
        ColorCodec.predefine("burlywood", new Color(222, 184, 135));
        ColorCodec.predefine("cadetblue", new Color(95, 158, 160));
        ColorCodec.predefine("chartreuse", new Color(127, 255, 0));
        ColorCodec.predefine("chocolate", new Color(210, 105, 30));
        ColorCodec.predefine("coral", new Color(255, 127, 80));
        ColorCodec.predefine("cornflowerblue", new Color(100, 149, 237));
        ColorCodec.predefine("cornsilk", new Color(255, 248, 220));
        ColorCodec.predefine("crimson", new Color(220, 20, 60));
        ColorCodec.predefine("cyan", new Color(0, 255, 255));
        ColorCodec.predefine("darkblue", new Color(0, 0, 139));
        ColorCodec.predefine("darkcyan", new Color(0, 139, 139));
        ColorCodec.predefine("darkgoldenrod", new Color(184, 134, 11));
        ColorCodec.predefine("darkgray", new Color(169, 169, 169));
        ColorCodec.predefine("darkgreen", new Color(0, 100, 0));
        ColorCodec.predefine("darkgrey", new Color(169, 169, 169));
        ColorCodec.predefine("darkkhaki", new Color(189, 183, 107));
        ColorCodec.predefine("darkmagenta", new Color(139, 0, 139));
        ColorCodec.predefine("darkolivegreen", new Color(85, 107, 47));
        ColorCodec.predefine("darkorange", new Color(255, 140, 0));
        ColorCodec.predefine("darkorchid", new Color(153, 50, 204));
        ColorCodec.predefine("darkred", new Color(139, 0, 0));
        ColorCodec.predefine("darksalmon", new Color(233, 150, 122));
        ColorCodec.predefine("darkseagreen", new Color(143, 188, 143));
        ColorCodec.predefine("darkslateblue", new Color(72, 61, 139));
        ColorCodec.predefine("darkslategray", new Color(47, 79, 79));
        ColorCodec.predefine("darkslategrey", new Color(47, 79, 79));
        ColorCodec.predefine("darkturquoise", new Color(0, 206, 209));
        ColorCodec.predefine("darkviolet", new Color(148, 0, 211));
        ColorCodec.predefine("deeppink", new Color(255, 20, 147));
        ColorCodec.predefine("deepskyblue", new Color(0, 191, 255));
        ColorCodec.predefine("dimgray", new Color(105, 105, 105));
        ColorCodec.predefine("dimgrey", new Color(105, 105, 105));
        ColorCodec.predefine("dodgerblue", new Color(30, 144, 255));
        ColorCodec.predefine("firebrick", new Color(178, 34, 34));
        ColorCodec.predefine("floralwhite", new Color(255, 250, 240));
        ColorCodec.predefine("forestgreen", new Color(34, 139, 34));
        ColorCodec.predefine("fuchsia", new Color(255, 0, 255));
        ColorCodec.predefine("gainsboro", new Color(220, 220, 220));
        ColorCodec.predefine("ghostwhite", new Color(248, 248, 255));
        ColorCodec.predefine("gold", new Color(255, 215, 0));
        ColorCodec.predefine("goldenrod", new Color(218, 165, 32));
        ColorCodec.predefine("gray", new Color(128, 128, 128));
        ColorCodec.predefine("grey", new Color(128, 128, 128));
        ColorCodec.predefine("green", new Color(0, 128, 0));
        ColorCodec.predefine("greenyellow", new Color(173, 255, 47));
        ColorCodec.predefine("honeydew", new Color(240, 255, 240));
        ColorCodec.predefine("hotpink", new Color(255, 105, 180));
        ColorCodec.predefine("indianred", new Color(205, 92, 92));
        ColorCodec.predefine("indigo", new Color(75, 0, 130));
        ColorCodec.predefine("ivory", new Color(255, 255, 240));
        ColorCodec.predefine("khaki", new Color(240, 230, 140));
        ColorCodec.predefine("lavender", new Color(230, 230, 250));
        ColorCodec.predefine("lavenderblush", new Color(255, 240, 245));
        ColorCodec.predefine("lawngreen", new Color(124, 252, 0));
        ColorCodec.predefine("lemonchiffon", new Color(255, 250, 205));
        ColorCodec.predefine("lightblue", new Color(173, 216, 230));
        ColorCodec.predefine("lightcoral", new Color(240, 128, 128));
        ColorCodec.predefine("lightcyan", new Color(224, 255, 255));
        ColorCodec.predefine("lightgoldenrodyellow", new Color(250, 250, 210));
        ColorCodec.predefine("lightgray", new Color(211, 211, 211));
        ColorCodec.predefine("lightgreen", new Color(144, 238, 144));
        ColorCodec.predefine("lightgrey", new Color(211, 211, 211));
        ColorCodec.predefine("lightpink", new Color(255, 182, 193));
        ColorCodec.predefine("lightsalmon", new Color(255, 160, 122));
        ColorCodec.predefine("lightseagreen", new Color(32, 178, 170));
        ColorCodec.predefine("lightskyblue", new Color(135, 206, 250));
        ColorCodec.predefine("lightslategray", new Color(119, 136, 153));
        ColorCodec.predefine("lightslategrey", new Color(119, 136, 153));
        ColorCodec.predefine("lightsteelblue", new Color(176, 196, 222));
        ColorCodec.predefine("lightyellow", new Color(255, 255, 224));
        ColorCodec.predefine("lime", new Color(0, 255, 0));
        ColorCodec.predefine("limegreen", new Color(50, 205, 50));
        ColorCodec.predefine("linen", new Color(250, 240, 230));
        ColorCodec.predefine("magenta", new Color(255, 0, 255));
        ColorCodec.predefine("maroon", new Color(128, 0, 0));
        ColorCodec.predefine("mediumaquamarine", new Color(102, 205, 170));
        ColorCodec.predefine("mediumblue", new Color(0, 0, 205));
        ColorCodec.predefine("mediumorchid", new Color(186, 85, 211));
        ColorCodec.predefine("mediumpurple", new Color(147, 112, 219));
        ColorCodec.predefine("mediumseagreen", new Color(60, 179, 113));
        ColorCodec.predefine("mediumslateblue", new Color(123, 104, 238));
        ColorCodec.predefine("mediumspringgreen", new Color(0, 250, 154));
        ColorCodec.predefine("mediumturquoise", new Color(72, 209, 204));
        ColorCodec.predefine("mediumvioletred", new Color(199, 21, 133));
        ColorCodec.predefine("midnightblue", new Color(25, 25, 112));
        ColorCodec.predefine("mintcream", new Color(245, 255, 250));
        ColorCodec.predefine("mistyrose", new Color(255, 228, 225));
        ColorCodec.predefine("moccasin", new Color(255, 228, 181));
        ColorCodec.predefine("navajowhite", new Color(255, 222, 173));
        ColorCodec.predefine("navy", new Color(0, 0, 128));
        ColorCodec.predefine("none", new Color(0, true));
        ColorCodec.predefine("oldlace", new Color(253, 245, 230));
        ColorCodec.predefine("olive", new Color(128, 128, 0));
        ColorCodec.predefine("olivedrab", new Color(107, 142, 35));
        ColorCodec.predefine("orange", new Color(255, 165, 0));
        ColorCodec.predefine("orangered", new Color(255, 69, 0));
        ColorCodec.predefine("orchid", new Color(218, 112, 214));
        ColorCodec.predefine("palegoldenrod", new Color(238, 232, 170));
        ColorCodec.predefine("palegreen", new Color(152, 251, 152));
        ColorCodec.predefine("paleturquoise", new Color(175, 238, 238));
        ColorCodec.predefine("palevioletred", new Color(219, 112, 147));
        ColorCodec.predefine("papayawhip", new Color(255, 239, 213));
        ColorCodec.predefine("peachpuff", new Color(255, 218, 185));
        ColorCodec.predefine("peru", new Color(205, 133, 63));
        ColorCodec.predefine("pink", new Color(255, 192, 203));
        ColorCodec.predefine("plum", new Color(221, 160, 221));
        ColorCodec.predefine("powderblue", new Color(176, 224, 230));
        ColorCodec.predefine("purple", new Color(128, 0, 128));
        ColorCodec.predefine("red", new Color(255, 0, 0));
        ColorCodec.predefine("rosybrown", new Color(188, 143, 143));
        ColorCodec.predefine("royalblue", new Color(65, 105, 225));
        ColorCodec.predefine("saddlebrown", new Color(139, 69, 19));
        ColorCodec.predefine("salmon", new Color(250, 128, 114));
        ColorCodec.predefine("sandybrown", new Color(244, 164, 96));
        ColorCodec.predefine("seagreen", new Color(46, 139, 87));
        ColorCodec.predefine("seashell", new Color(255, 245, 238));
        ColorCodec.predefine("sienna", new Color(160, 82, 45));
        ColorCodec.predefine("silver", new Color(192, 192, 192));
        ColorCodec.predefine("skyblue", new Color(135, 206, 235));
        ColorCodec.predefine("slateblue", new Color(106, 90, 205));
        ColorCodec.predefine("slategray", new Color(112, 128, 144));
        ColorCodec.predefine("slategrey", new Color(112, 128, 144));
        ColorCodec.predefine("snow", new Color(255, 250, 250));
        ColorCodec.predefine("springgreen", new Color(0, 255, 127));
        ColorCodec.predefine("steelblue", new Color(70, 130, 180));
        ColorCodec.predefine("tan", new Color(210, 180, 140));
        ColorCodec.predefine("teal", new Color(0, 128, 128));
        ColorCodec.predefine("thistle", new Color(216, 191, 216));
        ColorCodec.predefine("tomato", new Color(255, 99, 71));
        ColorCodec.predefine("turquoise", new Color(64, 224, 208));
        ColorCodec.predefine("violet", new Color(238, 130, 238));
        ColorCodec.predefine("wheat", new Color(245, 222, 179));
        ColorCodec.predefine("white", new Color(255, 255, 255));
        ColorCodec.predefine("whitesmoke", new Color(245, 245, 245));
        ColorCodec.predefine("yellow", new Color(255, 255, 0));
        ColorCodec.predefine("yellowgreen", new Color(154, 205, 50));
        log = Logger.getLogger("html");
        DEFAULT = Color.black;
    }
}

