/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.util;

import com.tridium.html.util.HtmlTag;
import com.tridium.html.util.HtmlText;
import javax.baja.nre.util.Array;

public abstract class HtmlNode {
    private HtmlNode parent = null;
    private Array<HtmlNode> kids = null;

    public void add(HtmlNode node) {
        node.parent = this;
        if (this.kids == null) {
            this.kids = new Array(HtmlNode.class);
        }
        this.kids.add((Object)node);
    }

    public HtmlNode getParent() {
        return this.parent;
    }

    public void remove(int idx) {
        this.kids.remove(idx);
    }

    public HtmlNode get(int i) {
        return (HtmlNode)this.kids.get(i);
    }

    public int size() {
        return this.kids == null ? 0 : this.kids.size();
    }

    public HtmlTag getTagNode(String tagName) {
        for (int i = 0; i < this.size(); ++i) {
            HtmlTag t;
            HtmlNode n = this.get(i);
            if (!(n instanceof HtmlTag) || !(t = (HtmlTag)n).getTagName().equals(tagName)) continue;
            return t;
        }
        return null;
    }

    public HtmlTag[] getTagNodes(String tagName) {
        Array arr = new Array(HtmlTag.class);
        for (int i = 0; i < this.size(); ++i) {
            HtmlTag t;
            HtmlNode n = this.get(i);
            if (!(n instanceof HtmlTag) || !(t = (HtmlTag)n).getTagName().equals(tagName)) continue;
            arr.add((Object)t);
        }
        return (HtmlTag[])arr.trim();
    }

    public HtmlText[] getTextNodes() {
        Array arr = new Array(HtmlText.class);
        for (int i = 0; i < this.size(); ++i) {
            HtmlNode n = this.get(i);
            if (!(n instanceof HtmlText)) continue;
            arr.add((Object)((HtmlText)n));
        }
        return (HtmlText[])arr.trim();
    }

    private static void dump(HtmlNode node, Array<String> indents, int depth) {
        if (indents.size() > depth) {
            return;
        }
        if (indents.size() > 0) {
            String x;
            int n;
            for (n = 0; n < indents.size() - 1; ++n) {
                x = (String)indents.get(n);
                System.out.print(x.equals("x") ? "|   " : "    ");
            }
            System.out.println("|");
            for (n = 0; n < indents.size() - 1; ++n) {
                x = (String)indents.get(n);
                System.out.print(x.equals("x") ? "|   " : "    ");
            }
            System.out.print("+---");
        }
        System.out.println(node);
        indents.add((Object)new String("x"));
        for (int i = 0; i < node.size() - 1; ++i) {
            HtmlNode.dump(node.get(i), indents, depth);
        }
        if (node.size() > 0) {
            indents.remove(indents.size() - 1);
            indents.add((Object)new String(""));
            HtmlNode.dump(node.get(node.size() - 1), indents, depth);
        }
        indents.remove(indents.size() - 1);
    }

    public static void dump(HtmlNode node) {
        HtmlNode.dump(node, Integer.MAX_VALUE);
    }

    public static void dump(HtmlNode node, int depth) {
        Array indents = new Array(String.class);
        indents.add((Object)new String(""));
        HtmlNode.dump(node, (Array<String>)indents, depth);
    }
}

