/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.util;

import com.tridium.html.util.ColorCodec;
import com.tridium.html.util.Declarator;
import com.tridium.html.util.HtmlNode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;

public class HtmlTag
extends HtmlNode {
    private int lineNo;
    private String name;
    private Map<String, String> attribs;

    public HtmlTag(String name, Map<String, String> attribs, int lineNo) {
        this.name = name;
        this.attribs = attribs;
        this.lineNo = lineNo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        if (this.attribs.size() > 0) {
            sb.append(" (");
            for (String name : this.attribs.keySet()) {
                String value = this.attribs.get(name);
                sb.append(name).append(", ");
                sb.append(value).append("; ");
            }
            sb.append(")");
        }
        sb.append(" [" + (this.lineNo + 1) + "]");
        return sb.toString();
    }

    public void applyStyleSheetDefaults(ArrayList<Declarator> defaults) {
        if (defaults == null) {
            return;
        }
        for (int i = 0; i < defaults.size(); ++i) {
            Declarator dec = defaults.get(i);
            String attrib = this.getAttribute(dec.getName());
            if (attrib != null) continue;
            this.attribs.put(dec.getName(), dec.getValue());
        }
    }

    public String getTagName() {
        return this.name;
    }

    public int getLineNumber() {
        return this.lineNo;
    }

    public boolean hasAttribute(String key) {
        return this.attribs.containsKey(key);
    }

    public String getAttribute(String key) {
        return this.attribs.get(key);
    }

    public Color getColorAttribute(String key, Color defaultColor) {
        String color = this.getAttribute(key);
        return color == null ? defaultColor : ColorCodec.decode(color, Color.white);
    }

    public int getIntegerAttribute(String key, int defaultVal) {
        String val = this.getAttribute(key);
        return val == null ? defaultVal : Integer.parseInt(val);
    }
}

