/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql;

import com.tridium.bql.Range;
import com.tridium.bql.RangeSet;
import javax.baja.nre.util.Array;

public class RangeSetImpl
implements RangeSet {
    private Array<Range> ranges;

    public RangeSetImpl() {
        this(new Range[0]);
    }

    public RangeSetImpl(Range[] ranges) {
        this.ranges = new Array((Object[])ranges);
    }

    public RangeSetImpl(RangeSet r1, RangeSet r2) {
        int i;
        this.ranges = new Array(Range.class);
        for (i = 0; i < r1.getCount(); ++i) {
            this.add(r1.getRange(i));
        }
        for (i = 0; i < r2.getCount(); ++i) {
            this.add(r2.getRange(i));
        }
    }

    public void add(Range range) {
        this.ranges.add((Object)range);
    }

    public void add(RangeSet set) {
        for (int i = 0; i < set.getCount(); ++i) {
            this.add(set.getRange(i));
        }
    }

    public boolean remove(Range range) {
        return this.ranges.remove((Object)range);
    }

    @Override
    public int getCount() {
        return this.ranges.size();
    }

    @Override
    public Range getRange(int index) {
        return (Range)this.ranges.get(index);
    }

    @Override
    public RangeSet intersection() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAll() {
        for (int i = 0; i < this.ranges.size(); ++i) {
            if (!this.getRange(i).isAll()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNone() {
        for (int i = 0; i < this.ranges.size(); ++i) {
            if (this.getRange(i).isNone()) continue;
            return false;
        }
        return true;
    }

    @Override
    public RangeSet not() {
        if (this.isAll()) {
            return Range.NONE;
        }
        if (this.isNone()) {
            return Range.ALL;
        }
        RangeSetImpl result = new RangeSetImpl();
        result.add(this.getRange(0).not());
        for (int i = 1; i < this.getCount(); ++i) {
            result = (RangeSetImpl)RangeSetImpl.crossProduct(result, this.getRange(i).not());
        }
        return result;
    }

    @Override
    public void sort() {
        this.ranges = this.ranges.sort();
    }

    @Override
    public RangeSet union() {
        if (this.getCount() < 2) {
            return this;
        }
        this.sort();
        RangeSetImpl result = new RangeSetImpl();
        Range r = this.getRange(0);
        for (int i = 1; i < this.getCount(); ++i) {
            result.add(Range.union(r, this.getRange(i)));
            if (result.isAll()) {
                return Range.ALL;
            }
            r = (Range)result.ranges.peek();
            if (i >= this.getCount() - 1) continue;
            result.ranges.pop();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        for (int i = 0; i < this.ranges.size(); ++i) {
            if (i > 0) {
                sb.append(';');
            }
            sb.append(this.getRange(i));
        }
        return sb.toString();
    }

    public static RangeSet crossProduct(RangeSet r1, RangeSet r2) {
        RangeSetImpl result = new RangeSetImpl();
        for (int i = 0; i < r1.getCount(); ++i) {
            for (int j = 0; j < r2.getCount(); ++j) {
                Range r = Range.intersection(r1.getRange(i), r2.getRange(j));
                if (r.isNone()) continue;
                result.add(r);
            }
        }
        if (result.getCount() == 0) {
            return Range.NONE;
        }
        return result;
    }
}

