/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql;

import com.tridium.bql.BBqlExtent;
import com.tridium.bql.BSelect;
import com.tridium.bql.Ordering;
import com.tridium.bql.Range;
import com.tridium.bql.RangeSet;
import com.tridium.bql.RangeUtil;
import com.tridium.bql.collection.BAggregateTable;
import com.tridium.bql.collection.BDistinctTable;
import com.tridium.bql.collection.BTopTable;
import com.tridium.bql.expression.BPath;
import com.tridium.bql.expression.ExprEngine;
import com.tridium.bql.projection.AllProjection;
import com.tridium.bql.projection.SomeProjection;
import com.tridium.bql.query.BqlVisitor;
import com.tridium.collection.BFilteredTable;
import javax.baja.bql.BqlQuery;
import javax.baja.bql.Queryable;
import javax.baja.collection.BITable;
import javax.baja.naming.InvalidOrdBaseException;
import javax.baja.naming.InvalidRootSchemeException;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.IFilter;
import javax.baja.query.BExpression;
import javax.baja.query.BProjectionColumn;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.util.IContextFilter;

public class SelectQuery
extends BqlQuery {
    private BSelect query;
    private Context cx;

    public SelectQuery(BSelect query) {
        this.query = query;
        BqlVisitor v = new BqlVisitor();
        v.visit(query);
        this.setBody(v.getQueryString());
    }

    public RangeSet getRange(String index, Type requiredType, boolean equalityOnly) {
        return this.query.hasPredicate() ? new RangeUtil(this.query.getPredicate().getPredicateExpr(), this.query.getExprEngine(), index, requiredType).solveRange(equalityOnly) : Range.ALL;
    }

    public BSelect getSelect() {
        return this.query;
    }

    public boolean hasPredicate() {
        return this.query.hasPredicate();
    }

    @Override
    public OrdTarget resolve(OrdTarget base) {
        this.cx = base;
        this.query.updateTime();
        boolean skipQuantifier = false;
        BITable<? extends BIObject> result = this.query.hasExtent() && !this.query.getExtent().isBaseExtent() ? ((BBqlExtent)this.query.getExtent()).getExtent(base, this) : this.getExtentFromBase(base);
        OrdTarget extentTarget = new OrdTarget(base, (BObject)result);
        if (this.query.hasPredicate()) {
            result = new BFilteredTable(result, (IFilter)new BooleanFilter(this.query));
        }
        if (this.query.hasAggregates()) {
            result = new BAggregateTable(result, this.query, this.cx);
            skipQuantifier = true;
        }
        if (this.query.hasProjection() && this.query.getProjection().isDistinct() && !skipQuantifier) {
            result = new BDistinctTable<BIObject>(result, this.query, this.cx);
        }
        if (this.query.hasOrdering()) {
            result = new Ordering(this.query).order(result, this.cx);
        }
        if (this.query.getTop() != null) {
            result = new BTopTable<BIObject>(result, this.query.getTop().getLimit());
        }
        if (this.query.hasProjection()) {
            result = this.toProjection(result);
        }
        return new OrdTarget(extentTarget, (BObject)result);
    }

    protected BITable<? extends BIObject> getExtentFromBase(OrdTarget base) {
        if (base == null) {
            throw new InvalidRootSchemeException("bql");
        }
        BObject target = base.get();
        if (target instanceof Queryable) {
            return (BITable)((Queryable)target).bqlQuery(base, this);
        }
        if (target instanceof BComplex) {
            return ((BBqlExtent)this.query.getExtent()).getExtent(base, this);
        }
        if (target instanceof BITable) {
            return (BITable)target;
        }
        throw new InvalidOrdBaseException();
    }

    protected BITable<? extends BIObject> toProjection(BITable<? extends BIObject> inner) {
        if (this.isSelectStar()) {
            return new AllProjection().getTable(inner, this.cx);
        }
        BProjectionColumn[] columns = this.query.getProjection().getProjectionColumns();
        return new SomeProjection(columns, this.query.getExprEngine()).getTable(inner, this.cx);
    }

    protected boolean isSelectStar() {
        if (!this.query.hasProjection()) {
            return false;
        }
        BProjectionColumn[] columns = this.query.getProjection().getProjectionColumns();
        return columns.length == 1 && columns[0].getColumnExpression() instanceof BPath && ((BPath)columns[0].getColumnExpression()).getField().equals("*");
    }

    private static class BooleanFilter
    implements IContextFilter {
        private BExpression boolExpr;
        private ExprEngine engine;

        public BooleanFilter(BSelect query) {
            this(query.getPredicate().getPredicateExpr(), query.getExprEngine());
        }

        public BooleanFilter(BExpression boolExpr, ExprEngine engine) {
            this.boolExpr = boolExpr;
            this.engine = engine;
        }

        public boolean accept(Object o, Context cx) {
            BObject val = this.engine.evaluate(this.boolExpr, (BObject)o, cx);
            return val == BBoolean.TRUE;
        }

        public boolean accept(Object o) {
            return this.accept(o, null);
        }
    }
}

