/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.collection;

import com.tridium.bql.collection.BqlColumnList;
import com.tridium.bql.collection.PropertyColumn;
import com.tridium.util.AbstractStubGen;
import javax.baja.collection.ColumnList;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Property;
import javax.baja.sys.Type;

public class ColumnUtil {
    public static BObject makePrototype(Type type) {
        BObject prototype = null;
        try {
            if (!type.isAbstract() && !type.isInterface()) {
                prototype = type.getInstance();
            } else {
                Class cls = AbstractStubGen.getConcreteClass((Class)type.getTypeClass());
                prototype = (BObject)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (AbstractMethodError ame) {
            if (!type.getSuperType().getTypeName().equals("Object")) {
                return ColumnUtil.makePrototype(type.getSuperType());
            }
            throw new AbstractMethodError("Could not generate an instance of an abstract type for a column lookup.\nThis could be due to a call to an abstract method in an abstract class's constructor.\n" + ame.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prototype;
    }

    public static ColumnList getPropertyColumns(Type type) {
        BqlColumnList list = new BqlColumnList();
        BObject prototype = ColumnUtil.makePrototype(type);
        if (prototype instanceof BComplex) {
            Property[] props = ((BComplex)prototype).getPropertiesArray();
            for (int i = 0; i < props.length; ++i) {
                list.addColumn(new PropertyColumn(props[i]));
            }
        }
        return list;
    }
}

