/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.compiler;

import com.tridium.bql.ExpressionQuery;
import com.tridium.bql.FunctionQuery;
import com.tridium.bql.FunctionSpec;
import com.tridium.bql.SelectQuery;
import com.tridium.bql.compiler.BqlTokenizer;
import com.tridium.bql.compiler.Constants;
import com.tridium.bql.compiler.ExprParser;
import com.tridium.bql.compiler.SelectParser;
import com.tridium.bql.compiler.Token;
import com.tridium.bql.compiler.UnexpectedTokenTypeException;
import java.util.ArrayList;
import javax.baja.bql.BqlQuery;
import javax.baja.nre.util.Array;
import javax.baja.query.BExpression;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.util.Columns;
import javax.baja.sys.Clock;

public class BqlParser
implements Constants {
    private BqlTokenizer tokens;
    private Token current;
    private BqlQuery query;

    public static void main(String[] args) {
        try {
            String bql = args[0];
            long start = Clock.millis();
            BqlQuery query = BqlQuery.make(bql);
            long end = Clock.millis();
            System.out.println("QUERY = " + query);
            System.out.println("Time: " + (end - start) + " ms");
        }
        catch (Exception ex) {
            System.out.println(ex);
            ex.printStackTrace();
        }
    }

    public BqlQuery parse(BqlTokenizer tokens) {
        return this.parse(tokens, false);
    }

    public BqlQuery parse(BqlTokenizer tokens, boolean sub) {
        this.tokens = tokens;
        this.next();
        switch (this.current.type) {
            case 7: {
                if (tokens.peek().type == 13) {
                    this.match(7);
                    tokens.push(this.current);
                    this.query = this.parse(tokens, true);
                    this.match(8);
                    break;
                }
                tokens.push(this.current);
                this.query = ExpressionQuery.make(new ExprParser().parse(tokens));
                break;
            }
            case 13: {
                tokens.push(this.current);
                this.query = new SelectQuery(SelectParser.parse(tokens));
                break;
            }
            case 9: {
                this.match(9);
                tokens.push(this.current);
                this.query = this.parseExpressionSet();
                break;
            }
            case 23: {
                Token isDot = tokens.peek();
                if (isDot.type == 12) {
                    FunctionSpec spec = this.function();
                    if (spec != null) {
                        this.query = new FunctionQuery(spec);
                        break;
                    }
                    tokens.reset();
                    this.next();
                }
            }
            default: {
                tokens.push(this.current);
                this.query = ExpressionQuery.make(new ExprParser().parse(tokens));
            }
        }
        this.next();
        if (!sub) {
            if (this.current.type != 2 && this.current.type != 28) {
                this.match(2);
            }
        } else {
            tokens.push(this.current);
        }
        tokens = null;
        if (this.query != null) {
            return this.query;
        }
        throw new IllegalStateException("No command parsed.");
    }

    private ExpressionQuery.ExprSet parseExpressionSet() {
        Array exprCols = new Array(BProjectionColumn.class);
        ExprParser ep = new ExprParser();
        boolean first = true;
        while (this.current.type != 10) {
            if (!first && this.current.type != 11) {
                throw new UnexpectedTokenTypeException(this.current.index, 11, this.current.type);
            }
            BProjectionColumn col = Columns.make((BExpression)ep.parse(this.tokens));
            this.next();
            if (this.current.type == 14) {
                this.match(14);
                col.as(this.match((int)5).lex);
            }
            exprCols.add((Object)col);
            first = false;
        }
        this.match(10);
        return new ExpressionQuery.ExprSet((BProjectionColumn[])exprCols.trim());
    }

    private FunctionSpec function() {
        String method;
        ArrayList<BqlQuery> params = new ArrayList<BqlQuery>(2);
        String typeSpec = this.match((int)23).lex;
        this.match(12);
        if (!this.current.isWord) {
            return null;
        }
        try {
            method = this.current.lex;
            this.next();
            this.match(7);
            if (this.current.type != 8) {
                while (true) {
                    this.tokens.push(this.current);
                    BqlQuery param = new BqlParser().parse(this.tokens, true);
                    params.add(param);
                    this.next();
                    if (this.current.type != 11) break;
                    this.match(11);
                }
            }
            this.match(8);
        }
        catch (Exception e) {
            return null;
        }
        return params.size() == 0 ? null : new FunctionSpec(typeSpec, method, params.toArray(new BqlQuery[0]));
    }

    private void next() {
        this.current = this.tokens.next();
    }

    private Token match(int matchType) {
        Token result = this.current;
        if (this.current.type != matchType) {
            throw new UnexpectedTokenTypeException(this.current.index, matchType, this.current.type);
        }
        this.next();
        return result;
    }
}

