/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.expression;

import com.tridium.bql.compiler.BqlTokenizer;
import com.tridium.bql.compiler.Constants;
import com.tridium.bql.compiler.ExprParser;
import com.tridium.bql.compiler.ExprUtil;
import com.tridium.bql.query.BqlVisitor;
import javax.baja.nre.util.Array;
import javax.baja.query.BExpression;
import javax.baja.query.expression.BBinaryExpression;
import javax.baja.query.expression.BUnaryExpression;
import javax.baja.query.util.Exprs;

public abstract class NormalForms {
    private static final Transformer NE = new NotEqual();
    private static final Transformer NNF = new NegativeNormal();
    private static final Transformer CNF = new JunctiveNormal(true);
    private static final Transformer DNF = new JunctiveNormal(false);

    public static BExpression cnf(BExpression expr) {
        return CNF.transform(NNF.transform(NE.transform(expr)));
    }

    public static BExpression dnf(BExpression expr) {
        return DNF.transform(NNF.transform(NE.transform(expr)));
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            return;
        }
        ExprParser parser = new ExprParser();
        BqlTokenizer tokens = new BqlTokenizer(args[0]);
        BExpression result = parser.parse(tokens);
        System.out.println("Transforming: " + Transformer.toString(result) + "\n");
        System.out.println("CNF: " + Transformer.toString(NormalForms.cnf(result)));
    }

    protected static class NotEqual
    extends Transformer {
        @Override
        public BExpression transform(BExpression expr) {
            if (ExprUtil.isBinary(expr)) {
                BBinaryExpression binary = (BBinaryExpression)expr;
                switch (ExprUtil.getOpId((BExpression)binary)) {
                    case 6: {
                        BExpression lhs = this.transform(binary.lhs());
                        BExpression rhs = this.transform(binary.rhs());
                        return this.not(this.eq(lhs, rhs));
                    }
                }
                return this.transformBinary(binary);
            }
            if (ExprUtil.isUnary(expr)) {
                return this.transformUnary((BUnaryExpression)expr);
            }
            return expr.newExprCopy();
        }
    }

    protected static class NegativeNormal
    extends Transformer {
        @Override
        public BExpression transform(BExpression expr) {
            if (ExprUtil.isUnary(expr)) {
                BUnaryExpression unary = (BUnaryExpression)expr;
                switch (ExprUtil.getOpId((BExpression)unary)) {
                    case -1: {
                        throw new IllegalStateException();
                    }
                    case 12: {
                        int operandId = ExprUtil.getOpId(unary.operand());
                        if (operandId == 12) {
                            return this.transform(((BUnaryExpression)unary.operand()).operand());
                        }
                        if (operandId == 13) {
                            BBinaryExpression and = (BBinaryExpression)unary.operand();
                            BExpression a = this.transform(and.lhs());
                            BExpression b = this.transform(and.rhs());
                            return this.or(this.transform(this.not(a)), this.transform(this.not(b)));
                        }
                        if (operandId == 14) {
                            BBinaryExpression or = (BBinaryExpression)unary.operand();
                            BExpression a = this.transform(or.lhs());
                            BExpression b = this.transform(or.rhs());
                            return this.and(this.transform(this.not(a)), this.transform(this.not(b)));
                        }
                        return this.transformUnary(unary);
                    }
                }
                return this.transformUnary(unary);
            }
            if (ExprUtil.isBinary(expr)) {
                return this.transformBinary((BBinaryExpression)expr);
            }
            return expr.newExprCopy();
        }
    }

    protected static final class JunctiveNormal
    extends Transformer {
        protected final boolean isConjunctive;
        protected final int distribute;
        protected final int junctive;

        public JunctiveNormal(boolean conjunctive) {
            this.isConjunctive = conjunctive;
            if (conjunctive) {
                this.distribute = 14;
                this.junctive = 13;
            } else {
                this.distribute = 13;
                this.junctive = 14;
            }
        }

        @Override
        public BExpression transform(BExpression expr) {
            if (ExprUtil.isBinary(expr)) {
                BBinaryExpression binary = (BBinaryExpression)expr;
                if (ExprUtil.getOpId((BExpression)binary) == this.distribute) {
                    return this.doTransformation(binary);
                }
                return this.transformBinary(binary);
            }
            if (ExprUtil.isUnary(expr)) {
                return this.transformUnary((BUnaryExpression)expr);
            }
            return expr.newExprCopy();
        }

        private BExpression doTransformation(BBinaryExpression binary) {
            BExpression left = this.transform(binary.lhs());
            BExpression right = this.transform(binary.rhs());
            Array leftParts = new Array(BExpression.class);
            Array rightParts = new Array(BExpression.class);
            this.getParts(left, (Array<BExpression>)leftParts);
            this.getParts(right, (Array<BExpression>)rightParts);
            return this.distribute((Array<BExpression>)leftParts, (Array<BExpression>)rightParts);
        }

        private void getParts(BExpression expr, Array<BExpression> parts) {
            BBinaryExpression binary;
            if (ExprUtil.isBinary(expr) && this.junctive == ExprUtil.getOpId((BExpression)(binary = (BBinaryExpression)expr))) {
                this.getParts(binary.lhs(), parts);
                this.getParts(binary.rhs(), parts);
                return;
            }
            parts.add((Object)expr.newExprCopy());
        }

        private BExpression distribute(Array<BExpression> leftParts, Array<BExpression> rightParts) {
            BExpression result = null;
            int lSize = leftParts.size();
            int rSize = rightParts.size();
            for (int i = 0; i < lSize; ++i) {
                BExpression lCurrent = (BExpression)leftParts.get(i);
                for (int j = 0; j < rSize; ++j) {
                    BExpression rCurrent = (BExpression)rightParts.get(j);
                    BExpression junc = null;
                    if (this.junctive == 13) {
                        junc = this.or(lCurrent.newExprCopy(), rCurrent.newExprCopy());
                        if (i == 0 && j == 0) {
                            result = junc;
                            continue;
                        }
                        result = this.and(result, junc);
                        continue;
                    }
                    junc = this.and(lCurrent.newExprCopy(), rCurrent.newExprCopy());
                    result = i == 0 && j == 0 ? junc : this.or(result, junc);
                }
            }
            return result;
        }
    }

    public static abstract class Transformer
    implements Constants {
        public abstract BExpression transform(BExpression var1);

        public static String toString(BExpression expr) {
            BqlVisitor v = new BqlVisitor();
            v.visit(expr);
            return v.getQueryString();
        }

        protected BExpression transformBinary(BBinaryExpression binary) {
            BExpression lhs = this.transform(binary.lhs());
            BExpression rhs = this.transform(binary.rhs());
            return ExprUtil.tag((BExpression)Exprs.binary((BExpression)lhs, (String)binary.op(), (BExpression)rhs));
        }

        protected BExpression transformUnary(BUnaryExpression unary) {
            BExpression e = this.transform(unary.operand());
            return ExprUtil.tag((BExpression)Exprs.unary((String)unary.op(), (BExpression)e));
        }

        protected BExpression not(BExpression expr) {
            return ExprUtil.tag((BExpression)Exprs.unary((String)OPTYPE_STRINGS[12], (BExpression)expr));
        }

        protected BExpression eq(BExpression lhs, BExpression rhs) {
            return ExprUtil.tag((BExpression)Exprs.binary((BExpression)lhs, (String)OPTYPE_STRINGS[5], (BExpression)rhs));
        }

        protected BExpression or(BExpression lhs, BExpression rhs) {
            return ExprUtil.tag((BExpression)Exprs.binary((BExpression)lhs, (String)OPTYPE_STRINGS[14], (BExpression)rhs));
        }

        protected BExpression and(BExpression lhs, BExpression rhs) {
            return ExprUtil.tag((BExpression)Exprs.binary((BExpression)lhs, (String)OPTYPE_STRINGS[13], (BExpression)rhs));
        }
    }
}

