/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.filter;

import com.tridium.bql.filter.BRangeFilter;
import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.bql.util.BDynamicTimeRangeType;
import javax.baja.bql.BIBqlFilter;
import javax.baja.bql.BqlQuery;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BExpression;
import javax.baja.query.BIQueryFilter;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"baja:AbsTime"})})
@NiagaraProperties(value={@NiagaraProperty(name="startTime", type="BAbsTime", defaultValue="BAbsTime.NULL"), @NiagaraProperty(name="endTime", type="BAbsTime", defaultValue="BAbsTime.NULL"), @NiagaraProperty(name="timeRangeType", type="BDynamicTimeRangeType", defaultValue="BDynamicTimeRangeType.timeRange")})
public class BAbsTimeFilter
extends BRangeFilter
implements BIBqlFilter,
BIQueryFilter {
    @Generated
    public static final Property startTime = BAbsTimeFilter.newProperty((int)0, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property endTime = BAbsTimeFilter.newProperty((int)0, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property timeRangeType = BAbsTimeFilter.newProperty((int)0, (BValue)BDynamicTimeRangeType.timeRange, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAbsTimeFilter.class);

    @Generated
    public BAbsTime getStartTime() {
        return (BAbsTime)this.get(startTime);
    }

    @Generated
    public void setStartTime(BAbsTime v) {
        this.set(startTime, (BValue)v, null);
    }

    @Generated
    public BAbsTime getEndTime() {
        return (BAbsTime)this.get(endTime);
    }

    @Generated
    public void setEndTime(BAbsTime v) {
        this.set(endTime, (BValue)v, null);
    }

    @Generated
    public BDynamicTimeRangeType getTimeRangeType() {
        return (BDynamicTimeRangeType)this.get(timeRangeType);
    }

    @Generated
    public void setTimeRangeType(BDynamicTimeRangeType v) {
        this.set(timeRangeType, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void init(BObject o) {
        if (this.getTimeRangeType() != BDynamicTimeRangeType.timeRange) {
            BAbsTime time = BAbsTime.now();
            BDynamicTimeRange range = BDynamicTimeRange.make(this.getTimeRangeType());
            this.setStartTime(range.getStartTime(time));
            this.setEndTime(range.getEndTime(time));
            this.setMaxEnabled(true);
            this.setMinEnabled(true);
        }
    }

    public void initFromDynamicTimeRange(BDynamicTimeRange range) {
        this.setTimeRangeType(range.getRangeType());
        if (this.getTimeRangeType() == BDynamicTimeRangeType.timeRange) {
            if (range.getFixedStartTime().equals((Object)BAbsTime.NULL)) {
                this.setStartTime(BAbsTime.make());
                this.setMinEnabled(false);
            } else {
                this.setStartTime(range.getFixedStartTime());
                this.setMinEnabled(true);
            }
            if (range.getFixedEndTime().equals((Object)BAbsTime.NULL)) {
                this.setEndTime(BAbsTime.make());
                this.setMaxEnabled(false);
            } else {
                this.setEndTime(range.getFixedEndTime());
                this.setMaxEnabled(true);
            }
        } else {
            this.init(null);
        }
    }

    public BDynamicTimeRange getDynamicTimeRange() {
        this.init(null);
        if (this.getTimeRangeType() == BDynamicTimeRangeType.timeRange) {
            if (this.getMinEnabled() && this.getMaxEnabled()) {
                return BDynamicTimeRange.make(this.getStartTime(), this.getEndTime());
            }
            if (this.getMinEnabled()) {
                return BDynamicTimeRange.make(this.getStartTime(), BAbsTime.DEFAULT);
            }
            if (this.getMaxEnabled()) {
                return BDynamicTimeRange.make(BAbsTime.DEFAULT, this.getEndTime());
            }
            return BDynamicTimeRange.DEFAULT;
        }
        return BDynamicTimeRange.make(this.getTimeRangeType());
    }

    @Override
    public String getPredicate(String columnName) {
        BAbsTime start = this.getStartTime();
        BAbsTime end = this.getEndTime();
        if (!(this.getMinEnabled() && !start.isNull() || this.getMaxEnabled() && !end.isNull())) {
            return null;
        }
        StringBuilder s = new StringBuilder(64);
        if (this.getMinEnabled() && !start.isNull()) {
            s.append(columnName).append(" >= ").append(BqlQuery.toBqlLiteral((BSimple)start));
        }
        if (this.getMaxEnabled() && !end.isNull()) {
            if (s.length() != 0) {
                s.append(" and ");
            }
            s.append(columnName).append(" <= ").append(BqlQuery.toBqlLiteral((BSimple)end));
        }
        return s.toString();
    }

    public BExpression getExpression(BExpression columnExpression) {
        BAbsTime start = this.getStartTime();
        BAbsTime end = this.getEndTime();
        if (!(this.getMinEnabled() && !start.isNull() || this.getMaxEnabled() && !end.isNull())) {
            return null;
        }
        if (this.getMinEnabled() && !start.isNull() && (!this.getMaxEnabled() || end.isNull())) {
            return Predicates.ge((BExpression)columnExpression, (BSimple)start);
        }
        if (this.getMaxEnabled() && !end.isNull() && (!this.getMinEnabled() || start.isNull())) {
            return Predicates.le((BExpression)columnExpression, (BSimple)end);
        }
        return Predicates.and((BExpression)Predicates.ge((BExpression)columnExpression, (BSimple)start), (BExpression)Predicates.le((BExpression)((BExpression)columnExpression.newCopy()), (BSimple)end));
    }

    @Override
    public boolean accept(BObject o) {
        BAbsTime value = (BAbsTime)o;
        BAbsTime start = this.getStartTime();
        BAbsTime end = this.getEndTime();
        if (this.getMinEnabled() && value.isBefore(start)) {
            return false;
        }
        return !this.getMaxEnabled() || !value.isAfter(end);
    }
}

