/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.filter;

import com.tridium.bql.filter.BRangeFilter;
import javax.baja.bql.BIBqlFilter;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BExpression;
import javax.baja.query.BIQueryFilter;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"baja:Integer"})})
@NiagaraProperties(value={@NiagaraProperty(name="minValue", type="int", defaultValue="0"), @NiagaraProperty(name="maxValue", type="int", defaultValue="0")})
public class BIntegerFilter
extends BRangeFilter
implements BIBqlFilter,
BIQueryFilter {
    @Generated
    public static final Property minValue = BIntegerFilter.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property maxValue = BIntegerFilter.newProperty((int)0, (int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BIntegerFilter.class);

    @Generated
    public int getMinValue() {
        return this.getInt(minValue);
    }

    @Generated
    public void setMinValue(int v) {
        this.setInt(minValue, v, null);
    }

    @Generated
    public int getMaxValue() {
        return this.getInt(maxValue);
    }

    @Generated
    public void setMaxValue(int v) {
        this.setInt(maxValue, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void init(BObject o) {
    }

    @Override
    public String getPredicate(String columnName) {
        int min = this.getMinValue();
        int max = this.getMaxValue();
        if (!this.getMinEnabled() && !this.getMaxEnabled()) {
            return null;
        }
        StringBuilder s = new StringBuilder(64);
        if (this.getMinEnabled()) {
            s.append(columnName);
            s.append(" >= ");
            try {
                s.append(BInteger.make((int)min).encodeToString());
            }
            catch (Exception e) {
                e.printStackTrace();
                s.append("error");
            }
        }
        if (this.getMaxEnabled()) {
            if (s.length() != 0) {
                s.append(" and ");
            }
            s.append(columnName);
            s.append(" <= ");
            try {
                s.append(BInteger.make((int)max).encodeToString());
            }
            catch (Exception e) {
                e.printStackTrace();
                s.append("error");
            }
        }
        return s.toString();
    }

    public BExpression getExpression(BExpression columnExpression) {
        BInteger min = BInteger.make((int)this.getMinValue());
        BInteger max = BInteger.make((int)this.getMaxValue());
        if (!this.getMinEnabled() && !this.getMaxEnabled()) {
            return null;
        }
        if (this.getMinEnabled() && !this.getMaxEnabled()) {
            return Predicates.ge((BExpression)columnExpression, (BSimple)min);
        }
        if (this.getMaxEnabled() && !this.getMinEnabled()) {
            return Predicates.le((BExpression)columnExpression, (BSimple)min);
        }
        return Predicates.and((BExpression)Predicates.ge((BExpression)columnExpression, (BSimple)min), (BExpression)Predicates.le((BExpression)((BExpression)columnExpression.newCopy()), (BSimple)max));
    }

    @Override
    public boolean accept(BObject o) {
        int value = ((BInteger)o).getInt();
        int min = this.getMinValue();
        int max = this.getMaxValue();
        boolean retVal = true;
        if (this.getMinEnabled() && value < min) {
            retVal = false;
        }
        if (this.getMaxEnabled() && value > max) {
            retVal = false;
        }
        return retVal;
    }
}

