/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.script;

import com.tridium.script.ScriptField;
import com.tridium.script.ScriptFields;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

public class FacetsScriptFields
extends ScriptFields {
    public FacetsScriptFields() {
        super(BFacets.DEFAULT.getClass(), false);
    }

    @Override
    public ScriptField getField(Object target, String name) {
        BObject value = ((BFacets)target).get(name);
        if (value == null) {
            return null;
        }
        return new FacetField((BFacets)target, name, value);
    }

    @Override
    public ScriptField[] getFields(Object target, boolean operatorOnly) {
        BFacets f = (BFacets)target;
        String[] list = f.list();
        ScriptField[] fields = new ScriptField[list.length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = new FacetField(f, list[i], f.get(list[i]));
        }
        return fields;
    }

    private class FacetField
    implements ScriptField {
        BFacets facets;
        String facetName;
        BObject value;
        String friendly;

        public FacetField(BFacets facets, String facetName, BObject value) {
            this.facets = facets;
            this.facetName = facetName;
            this.value = value;
        }

        @Override
        public String scriptName() {
            return this.facetName;
        }

        @Override
        public String scriptDisplayName(Object target, Context cx) {
            String n;
            if (target != this.facets) {
                throw new IllegalStateException("FacetField is instance specific.");
            }
            String lang = null;
            if (cx != null) {
                lang = cx.getLanguage();
            }
            if (lang == null) {
                lang = Sys.getLanguage();
            }
            if ((n = Lexicon.make((String)"baja", (String)lang).get(this.facetName)) != null) {
                return n;
            }
            return this.friendlyName();
        }

        public String friendlyName() {
            if (this.friendly == null) {
                this.friendly = TextUtil.toFriendly((String)this.facetName);
            }
            return this.friendly;
        }

        @Override
        public boolean isProperty() {
            return false;
        }

        @Override
        public boolean isReusable() {
            return false;
        }

        @Override
        public Class<?> scriptType() {
            return this.value.getClass();
        }

        @Override
        public Object scriptGet(Object target, Context context) throws Exception {
            if (target != this.facets) {
                throw new IllegalStateException("FacetField is instance specific.");
            }
            return this.value;
        }

        @Override
        public int scriptFlags(Object target) {
            return 0;
        }

        @Override
        public BFacets scriptFacets(Object target) {
            return BFacets.NULL;
        }
    }
}

