/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Vector;
import net.percederberg.grammatica.Grammar;
import net.percederberg.grammatica.GrammarException;
import net.percederberg.grammatica.ant.CSharpElement;
import net.percederberg.grammatica.ant.JavaElement;
import net.percederberg.grammatica.ant.ProcessingElement;
import net.percederberg.grammatica.ant.ValidationElement;
import net.percederberg.grammatica.ant.VisualBasicElement;
import net.percederberg.grammatica.parser.ParserLogException;

public class GrammaticaTask {
    private File file = null;
    private boolean failOnError = true;
    private Vector processors = new Vector();

    public void setGrammar(File file) {
        this.file = file;
    }

    public void setFailonerror(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void addValidation(ValidationElement elem) {
        this.processors.add(elem);
    }

    public void addCSharp(CSharpElement elem) {
        this.processors.add(elem);
    }

    public void addJava(JavaElement elem) {
        this.processors.add(elem);
    }

    public void addVisualBasic(VisualBasicElement elem) {
        this.processors.add(elem);
    }

    public void execute() throws RuntimeException {
        Grammar grammar;
        int i;
        if (this.file == null) {
            throw new RuntimeException("missing 'grammar' attribute");
        }
        if (this.processors.size() <= 0) {
            throw new RuntimeException("missing <validate>, <java>, <csharp> or <visualbasic> inner element");
        }
        for (i = 0; i < this.processors.size(); ++i) {
            ((ProcessingElement)this.processors.get(i)).validate();
        }
        try {
            grammar = new Grammar(this.file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (ParserLogException e) {
            this.handleError(e);
            return;
        }
        catch (GrammarException e) {
            this.handleError(e);
            return;
        }
        for (i = 0; i < this.processors.size(); ++i) {
            try {
                ((ProcessingElement)this.processors.get(i)).process(grammar);
                continue;
            }
            catch (RuntimeException e) {
                this.handleError(e);
            }
        }
    }

    private void handleError(Exception e) throws RuntimeException {
        if (this.failOnError) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        System.err.println("ERROR: " + e.getMessage());
    }
}

