/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.java;

import java.io.PrintWriter;
import java.util.LinkedList;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.java.JavaComment;
import net.percederberg.grammatica.code.java.JavaModifier;

public class JavaVariable
extends CodeElement {
    public static final int PUBLIC = 0;
    public static final int PROTECTED = 1;
    public static final int PACKAGE_LOCAL = 2;
    public static final int PRIVATE = 3;
    public static final int STATIC = 4;
    public static final int FINAL = 16;
    public static final int TRANSIENT = 128;
    public static final int VOLATILE = 256;
    private int modifiers;
    private String type;
    private String name;
    private String initValue;
    private LinkedList initValueList;
    private JavaComment comment;

    public JavaVariable(String type, String name) {
        this(0, type, name);
    }

    public JavaVariable(int modifiers, String type, String name) {
        this(modifiers, type, name, null);
    }

    public JavaVariable(String type, String name, String initValue) {
        this(0, type, name, initValue);
    }

    public JavaVariable(int modifiers, String type, String name, String initValue) {
        this.modifiers = modifiers;
        this.type = type;
        this.name = name;
        this.initValue = initValue;
        this.initValueList = new LinkedList();
        this.comment = null;
    }

    public void addComment(JavaComment comment) {
        this.comment = comment;
    }

    public void addArrayInit(String elementValue) {
        if (this.initValue != null) {
            this.initValueList.add(this.initValue);
            this.initValue = null;
        }
        this.initValueList.add(elementValue);
    }

    @Override
    public int category() {
        return (this.modifiers & 4) > 0 ? 4 : 5;
    }

    @Override
    public void print(PrintWriter out, CodeStyle style, int indent) {
        String init;
        String indentStr = style.getIndent(indent);
        String prefix = JavaModifier.createModifierDecl(this.modifiers);
        if (this.comment != null) {
            this.comment.print(out, style, indent);
        }
        if ((init = this.getInitCode(style, indent)) == null) {
            out.println(indentStr + prefix + this.type + " " + this.name + ";");
        } else {
            out.println(indentStr + prefix + this.type + " " + this.name + " = " + init + ";");
        }
    }

    private String getInitCode(CodeStyle style, int indent) {
        String indentStr = style.getIndent(indent);
        String codeIndentStr = style.getIndent(indent + 1);
        if (this.initValueList.size() == 0 && this.initValue == null) {
            return null;
        }
        if (this.initValue != null) {
            return this.initValue;
        }
        StringBuffer res = new StringBuffer("{\n");
        for (int i = 0; i < this.initValueList.size(); ++i) {
            res.append(codeIndentStr);
            res.append(this.initValueList.get(i).toString());
            if (i + 1 < this.initValueList.size()) {
                res.append(",\n");
                continue;
            }
            res.append("\n");
        }
        res.append(indentStr);
        res.append("}");
        return res.toString();
    }
}

