/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import net.percederberg.grammatica.code.csharp.CSharpClass;
import net.percederberg.grammatica.code.csharp.CSharpComment;
import net.percederberg.grammatica.code.csharp.CSharpFile;
import net.percederberg.grammatica.code.csharp.CSharpMethod;
import net.percederberg.grammatica.code.csharp.CSharpNamespace;
import net.percederberg.grammatica.code.csharp.CSharpUsing;
import net.percederberg.grammatica.output.CSharpConstantsFile;
import net.percederberg.grammatica.output.CSharpParserGenerator;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.TokenPattern;

class CSharpAnalyzerFile {
    private static final String TYPE_COMMENT = "<remarks>A class providing callback methods for the\nparser.</remarks>";
    private static final String ENTER_COMMENT = "<summary>Called when entering a parse tree node.</summary>\n\n<param name='node'>the node being entered</param>\n\n<exception cref='ParseException'>if the node analysis\ndiscovered errors</exception>";
    private static final String EXIT_COMMENT = "<summary>Called when exiting a parse tree node.</summary>\n\n<param name='node'>the node being exited</param>\n\n<returns>the node to add to the parse tree, or\n         null if no parse tree should be created</returns>\n\n<exception cref='ParseException'>if the node analysis\ndiscovered errors</exception>";
    private static final String CHILD_COMMENT = "<summary>Called when adding a child to a parse tree\nnode.</summary>\n\n<param name='node'>the parent node</param>\n<param name='child'>the child node, or null</param>\n\n<exception cref='ParseException'>if the node analysis\ndiscovered errors</exception>";
    private CSharpParserGenerator gen;
    private CSharpFile file;
    private CSharpClass cls;
    private CSharpMethod enter;
    private CSharpMethod exit;
    private CSharpMethod child;

    public CSharpAnalyzerFile(CSharpParserGenerator gen) {
        String name = gen.getBaseName() + "Analyzer";
        this.gen = gen;
        this.file = new CSharpFile(gen.getBaseDir(), name);
        int modifiers = gen.getPublicAccess() ? 257 : 260;
        this.cls = new CSharpClass(modifiers, name, "Analyzer");
        modifiers = 129;
        this.enter = new CSharpMethod(modifiers, "Enter", "Node node", "void");
        this.exit = new CSharpMethod(modifiers, "Exit", "Node node", "Node");
        this.child = new CSharpMethod(modifiers, "Child", "Production node, Node child", "void");
        this.initializeCode();
    }

    private void initializeCode() {
        this.file.addUsing(new CSharpUsing("PerCederberg.Grammatica.Runtime"));
        if (this.gen.getNamespace() == null) {
            this.file.addClass(this.cls);
        } else {
            CSharpNamespace n = new CSharpNamespace(this.gen.getNamespace());
            n.addClass(this.cls);
            this.file.addNamespace(n);
        }
        String str = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new CSharpComment(2, str));
        this.cls.addComment(new CSharpComment(TYPE_COMMENT));
        this.enter.addComment(new CSharpComment(ENTER_COMMENT));
        this.enter.addCode("switch (node.Id) {");
        this.cls.addMethod(this.enter);
        this.exit.addComment(new CSharpComment(EXIT_COMMENT));
        this.exit.addCode("switch (node.Id) {");
        this.cls.addMethod(this.exit);
        this.child.addComment(new CSharpComment(CHILD_COMMENT));
        this.child.addCode("switch (node.Id) {");
        this.cls.addMethod(this.child);
    }

    public void addToken(TokenPattern pattern, CSharpConstantsFile constants) {
        String constant = constants.getConstant(pattern.getId());
        if (!pattern.isIgnore()) {
            String name = this.gen.getCodeStyle().getMixedCase(pattern.getName(), true);
            this.addEnterCase(constant, name, "Token");
            this.addEnterMethod(name, "Token");
            this.addExitCase(constant, name, "Token");
            this.addExitMethod(name, "Token");
        }
    }

    public void addProduction(ProductionPattern pattern, CSharpConstantsFile constants) {
        String constant = constants.getConstant(pattern.getId());
        if (!pattern.isSynthetic()) {
            String name = this.gen.getCodeStyle().getMixedCase(pattern.getName(), true);
            this.addEnterCase(constant, name, "Production");
            this.addEnterMethod(name, "Production");
            this.addExitCase(constant, name, "Production");
            this.addExitMethod(name, "Production");
            this.addChildCase(constant, name);
            this.addChildMethod(name);
        }
    }

    private void addEnterCase(String constant, String name, String type) {
        this.enter.addCode("case (int) " + constant + ":");
        this.enter.addCode("    Enter" + name + "((" + type + ") node);");
        this.enter.addCode("    break;");
    }

    private void addExitCase(String constant, String name, String type) {
        this.exit.addCode("case (int) " + constant + ":");
        this.exit.addCode("    return Exit" + name + "((" + type + ") node);");
    }

    private void addChildCase(String constant, String name) {
        this.child.addCode("case (int) " + constant + ":");
        this.child.addCode("    Child" + name + "(node, child);");
        this.child.addCode("    break;");
    }

    private void addEnterMethod(String name, String type) {
        CSharpMethod m = new CSharpMethod(33, "Enter" + name, type + " node", "void");
        m.addComment(new CSharpComment(ENTER_COMMENT));
        this.cls.addMethod(m);
    }

    private void addExitMethod(String name, String type) {
        CSharpMethod m = new CSharpMethod(33, "Exit" + name, type + " node", "Node");
        m.addComment(new CSharpComment(EXIT_COMMENT));
        m.addCode("return node;");
        this.cls.addMethod(m);
    }

    private void addChildMethod(String name) {
        CSharpMethod m = new CSharpMethod(33, "Child" + name, "Production node, Node child", "void");
        m.addComment(new CSharpComment(CHILD_COMMENT));
        m.addCode("node.AddChild(child);");
        this.cls.addMethod(m);
    }

    protected String getClassName() {
        return this.cls.toString();
    }

    public void writeCode() throws IOException {
        this.enter.addCode("}");
        this.exit.addCode("}");
        this.exit.addCode("return node;");
        this.child.addCode("}");
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

