/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import net.percederberg.grammatica.code.visualbasic.VisualBasicClass;
import net.percederberg.grammatica.code.visualbasic.VisualBasicComment;
import net.percederberg.grammatica.code.visualbasic.VisualBasicFile;
import net.percederberg.grammatica.code.visualbasic.VisualBasicImports;
import net.percederberg.grammatica.code.visualbasic.VisualBasicMethod;
import net.percederberg.grammatica.code.visualbasic.VisualBasicNamespace;
import net.percederberg.grammatica.output.VisualBasicConstantsFile;
import net.percederberg.grammatica.output.VisualBasicParserGenerator;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.TokenPattern;

class VisualBasicAnalyzerFile {
    private static final String TYPE_COMMENT = "<remarks>A class providing callback methods for the\nparser.</remarks>";
    private static final String ENTER_COMMENT = "<summary>Called when entering a parse tree node.</summary>\n\n<param name='node'>the node being entered</param>\n\n<exception cref='ParseException'>if the node analysis\ndiscovered errors</exception>";
    private static final String EXIT_COMMENT = "<summary>Called when exiting a parse tree node.</summary>\n\n<param name='node'>the node being exited</param>\n\n<returns>the node to add to the parse tree, or\n         null if no parse tree should be created</returns>\n\n<exception cref='ParseException'>if the node analysis\ndiscovered errors</exception>";
    private static final String CHILD_COMMENT = "<summary>Called when adding a child to a parse tree\nnode.</summary>\n\n<param name='node'>the parent node</param>\n<param name='child'>the child node, or null</param>\n\n<exception cref='ParseException'>if the node analysis\ndiscovered errors</exception>";
    private VisualBasicParserGenerator gen;
    private VisualBasicFile file;
    private VisualBasicClass cls;
    private VisualBasicMethod enter;
    private VisualBasicMethod exit;
    private VisualBasicMethod child;

    public VisualBasicAnalyzerFile(VisualBasicParserGenerator gen) {
        String name = gen.getBaseName() + "Analyzer";
        this.gen = gen;
        this.file = new VisualBasicFile(gen.getBaseDir(), name);
        int modifiers = 8;
        modifiers = gen.getPublicAccess() ? ++modifiers : (modifiers += 4);
        this.cls = new VisualBasicClass(modifiers, name, "Analyzer");
        modifiers = 513;
        this.enter = new VisualBasicMethod(modifiers, "Enter", "ByVal node As Node", "");
        this.exit = new VisualBasicMethod(modifiers, "[Exit]", "ByVal node As Node", "Node");
        this.child = new VisualBasicMethod(modifiers, "Child", "ByVal node As Production, ByVal child As Node", "");
        this.initializeCode();
    }

    private void initializeCode() {
        this.file.addImports(new VisualBasicImports("PerCederberg.Grammatica.Runtime"));
        if (this.gen.getNamespace() == null) {
            this.file.addClass(this.cls);
        } else {
            VisualBasicNamespace n = new VisualBasicNamespace(this.gen.getNamespace());
            n.addClass(this.cls);
            this.file.addNamespace(n);
        }
        String str = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new VisualBasicComment(1, str));
        this.cls.addComment(new VisualBasicComment(TYPE_COMMENT));
        this.enter.addComment(new VisualBasicComment(ENTER_COMMENT));
        this.enter.addCode("Select Case node.Id");
        this.cls.addMethod(this.enter);
        this.exit.addComment(new VisualBasicComment(EXIT_COMMENT));
        this.exit.addCode("Select Case node.Id");
        this.cls.addMethod(this.exit);
        this.child.addComment(new VisualBasicComment(CHILD_COMMENT));
        this.child.addCode("Select Case node.Id");
        this.cls.addMethod(this.child);
    }

    public void addToken(TokenPattern pattern, VisualBasicConstantsFile constants) {
        String constant = constants.getConstant(pattern.getId());
        if (!pattern.isIgnore()) {
            String name = this.gen.getCodeStyle().getMixedCase(pattern.getName(), true);
            this.addEnterCase(constant, name, "Token");
            this.addEnterMethod(name, "Token");
            this.addExitCase(constant, name, "Token");
            this.addExitMethod(name, "Token");
        }
    }

    public void addProduction(ProductionPattern pattern, VisualBasicConstantsFile constants) {
        String constant = constants.getConstant(pattern.getId());
        if (!pattern.isSynthetic()) {
            String name = this.gen.getCodeStyle().getMixedCase(pattern.getName(), true);
            this.addEnterCase(constant, name, "Production");
            this.addEnterMethod(name, "Production");
            this.addExitCase(constant, name, "Production");
            this.addExitMethod(name, "Production");
            this.addChildCase(constant, name);
            this.addChildMethod(name);
        }
    }

    private void addEnterCase(String constant, String name, String type) {
        this.enter.addCode("Case " + constant);
        this.enter.addCode("    Enter" + name + "(CType(node," + type + "))");
        this.enter.addCode("");
    }

    private void addExitCase(String constant, String name, String type) {
        this.exit.addCode("Case " + constant);
        this.exit.addCode("    return Exit" + name + "(CType(node," + type + "))");
        this.exit.addCode("");
    }

    private void addChildCase(String constant, String name) {
        this.child.addCode("Case " + constant);
        this.child.addCode("    Child" + name + "(node, child)");
        this.child.addCode("");
    }

    private void addEnterMethod(String name, String type) {
        VisualBasicMethod m = new VisualBasicMethod(129, "Enter" + name, "ByVal node As " + type, "");
        m.addComment(new VisualBasicComment(ENTER_COMMENT));
        this.cls.addMethod(m);
    }

    private void addExitMethod(String name, String type) {
        VisualBasicMethod m = new VisualBasicMethod(129, "Exit" + name, "ByVal node As " + type, "Node");
        m.addComment(new VisualBasicComment(EXIT_COMMENT));
        m.addCode("Return node");
        this.cls.addMethod(m);
    }

    private void addChildMethod(String name) {
        VisualBasicMethod m = new VisualBasicMethod(129, "Child" + name, "ByVal node As Production, ByVal child As Node", "");
        m.addComment(new VisualBasicComment(CHILD_COMMENT));
        m.addCode("node.AddChild(child)");
        this.cls.addMethod(m);
    }

    protected String getClassName() {
        return this.cls.toString();
    }

    public void writeCode() throws IOException {
        this.enter.addCode("End Select");
        this.exit.addCode("End Select");
        this.exit.addCode("Return node");
        this.child.addCode("End Select");
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

