/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import java.util.HashMap;
import net.percederberg.grammatica.code.visualbasic.VisualBasicClass;
import net.percederberg.grammatica.code.visualbasic.VisualBasicComment;
import net.percederberg.grammatica.code.visualbasic.VisualBasicConstructor;
import net.percederberg.grammatica.code.visualbasic.VisualBasicEnumeration;
import net.percederberg.grammatica.code.visualbasic.VisualBasicFile;
import net.percederberg.grammatica.code.visualbasic.VisualBasicImports;
import net.percederberg.grammatica.code.visualbasic.VisualBasicMethod;
import net.percederberg.grammatica.code.visualbasic.VisualBasicNamespace;
import net.percederberg.grammatica.output.VisualBasicAnalyzerFile;
import net.percederberg.grammatica.output.VisualBasicConstantsFile;
import net.percederberg.grammatica.output.VisualBasicParserGenerator;
import net.percederberg.grammatica.output.VisualBasicTokenizerFile;
import net.percederberg.grammatica.parser.ProductionPattern;
import net.percederberg.grammatica.parser.ProductionPatternAlternative;
import net.percederberg.grammatica.parser.ProductionPatternElement;

class VisualBasicParserFile {
    private static final String TYPE_COMMENT = "<remarks>A token stream parser.</remarks>";
    private static final String ENUM_COMMENT = "<summary>An enumeration with the generated production node\nidentity constants.</summary>";
    private static final String CONSTRUCTOR1_COMMENT = "<summary>Creates a new parser with a default analyzer.</summary>\n\n<param name='input'>the input stream to read from</param>\n\n<exception cref='ParserCreationException'>if the parser\ncouldn't be initialized correctly</exception>";
    private static final String CONSTRUCTOR2_COMMENT = "<summary>Creates a new parser.</summary>\n\n<param name='input'>the input stream to read from</param>\n\n<param name='analyzer'>the analyzer to parse with</param>\n\n<exception cref='ParserCreationException'>if the parser\ncouldn't be initialized correctly</exception>";
    private static final String FACTORY_COMMENT = "<summary>Creates a new tokenizer for this parser. Can be overridden\nby a subclass to provide a custom implementation.</summary>\n\n<param name='input'>the input stream to read from</param>\n\n<returns>the tokenizer created</returns>\n\n<exception cref='ParserCreationException'>if the tokenizer\ncouldn't be initialized correctly</exception>";
    private static final String INIT_METHOD_COMMENT = "<summary>Initializes the parser by creating all the production\npatterns.</summary>\n\n<exception cref='ParserCreationException'>if the parser\ncouldn't be initialized correctly</exception>";
    private VisualBasicParserGenerator gen;
    private VisualBasicFile file;
    private VisualBasicClass cls;
    private VisualBasicEnumeration enm;
    private VisualBasicMethod initMethod;
    private HashMap constantNames = new HashMap();
    private int constantId = 1;

    public VisualBasicParserFile(VisualBasicParserGenerator gen, VisualBasicTokenizerFile tokenizer, VisualBasicAnalyzerFile analyzer) {
        String name = gen.getBaseName() + "Parser";
        this.gen = gen;
        this.file = new VisualBasicFile(gen.getBaseDir(), name);
        int modifiers = gen.getPublicAccess() ? 1 : 4;
        this.cls = new VisualBasicClass(modifiers, name, "RecursiveDescentParser");
        this.enm = new VisualBasicEnumeration(5, "SynteticPatterns");
        this.initMethod = new VisualBasicMethod(5, "CreatePatterns", "", "");
        this.initializeCode(tokenizer, analyzer);
    }

    private void initializeCode(VisualBasicTokenizerFile tokenizer, VisualBasicAnalyzerFile analyzer) {
        this.file.addImports(new VisualBasicImports("System.IO"));
        this.file.addImports(new VisualBasicImports("PerCederberg.Grammatica.Runtime"));
        if (this.gen.getNamespace() == null) {
            this.file.addClass(this.cls);
        } else {
            VisualBasicNamespace n = new VisualBasicNamespace(this.gen.getNamespace());
            n.addClass(this.cls);
            this.file.addNamespace(n);
        }
        String str = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new VisualBasicComment(1, str));
        this.cls.addComment(new VisualBasicComment(TYPE_COMMENT));
        this.cls.addEnumeration(this.enm);
        this.enm.addComment(new VisualBasicComment(ENUM_COMMENT));
        VisualBasicConstructor constr = new VisualBasicConstructor("ByVal input As TextReader");
        this.cls.addConstructor(constr);
        constr.addComment(new VisualBasicComment(CONSTRUCTOR1_COMMENT));
        constr.addCode("MyBase.New(input)");
        constr.addCode("CreatePatterns()");
        constr = new VisualBasicConstructor("ByVal input As TextReader, ByVal analyzer As " + analyzer.getClassName());
        this.cls.addConstructor(constr);
        constr.addComment(new VisualBasicComment(CONSTRUCTOR2_COMMENT));
        constr.addCode("MyBase.New(input, analyzer)");
        constr.addCode("CreatePatterns()");
        VisualBasicMethod method = new VisualBasicMethod(515, "NewTokenizer", "ByVal input As TextReader", "Tokenizer");
        method.addComment(new VisualBasicComment(FACTORY_COMMENT));
        method.addCode("Return New " + tokenizer.getClassName() + "(input);");
        this.cls.addMethod(method);
        this.cls.addMethod(this.initMethod);
        this.initMethod.addComment(new VisualBasicComment(INIT_METHOD_COMMENT));
        this.initMethod.addCode("Dim pattern As ProductionPattern");
        this.initMethod.addCode("Dim alt As ProductionPatternAlternative");
    }

    public void addProductionConstant(ProductionPattern pattern) {
        if (pattern.isSynthetic()) {
            String constant = "SUBPRODUCTION_" + this.constantId;
            this.enm.addConstant(constant, String.valueOf(this.constantId + 3000));
            this.constantNames.put(new Integer(pattern.getId()), constant);
            ++this.constantId;
        }
    }

    public void addProduction(ProductionPattern pattern, VisualBasicConstantsFile constants) {
        StringBuffer code = new StringBuffer();
        code.append("pattern = New ProductionPattern(CInt(");
        code.append(this.getConstant(constants, pattern.getId()));
        code.append("), \"");
        if (pattern.isSynthetic()) {
            String str = (String)this.constantNames.get(new Integer(pattern.getId()));
            code.append(this.gen.getCodeStyle().getMixedCase(str, true));
        } else {
            code.append(pattern.getName());
        }
        code.append("\")");
        this.initMethod.addCode("");
        this.initMethod.addCode(code.toString());
        if (pattern.isSynthetic()) {
            this.initMethod.addCode("pattern.Synthetic = True");
        }
        for (int i = 0; i < pattern.getAlternativeCount(); ++i) {
            this.addProductionAlternative(pattern.getAlternative(i), constants);
        }
        this.initMethod.addCode("AddPattern(pattern)");
    }

    private void addProductionAlternative(ProductionPatternAlternative alt, VisualBasicConstantsFile constants) {
        this.initMethod.addCode("alt = New ProductionPatternAlternative()");
        for (int i = 0; i < alt.getElementCount(); ++i) {
            ProductionPatternElement elem = alt.getElement(i);
            StringBuffer code = new StringBuffer();
            code.append("alt.");
            if (elem.isToken()) {
                code.append("AddToken(");
            } else {
                code.append("AddProduction(");
            }
            code.append("CInt(");
            code.append(this.getConstant(constants, elem.getId()));
            code.append("), ");
            code.append(elem.getMinCount());
            code.append(", ");
            if (elem.getMaxCount() == Integer.MAX_VALUE) {
                code.append("-1");
            } else {
                code.append(elem.getMaxCount());
            }
            code.append(")");
            this.initMethod.addCode(code.toString());
        }
        this.initMethod.addCode("pattern.AddAlternative(alt)");
    }

    private String getConstant(VisualBasicConstantsFile constants, int id) {
        Integer value = new Integer(id);
        if (this.constantNames.containsKey(value)) {
            return "SynteticPatterns." + this.constantNames.get(value);
        }
        return constants.getConstant(id);
    }

    public void writeCode() throws IOException {
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

