/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser.re;

import java.io.IOException;
import java.io.PrintWriter;
import net.percederberg.grammatica.parser.ReaderBuffer;
import net.percederberg.grammatica.parser.re.Element;
import net.percederberg.grammatica.parser.re.Matcher;

class CombineElement
extends Element {
    private Element elem1;
    private Element elem2;

    public CombineElement(Element first, Element second) {
        this.elem1 = first;
        this.elem2 = second;
    }

    @Override
    public Object clone() {
        return new CombineElement(this.elem1, this.elem2);
    }

    @Override
    public int match(Matcher m, ReaderBuffer buffer, int start, int skip) throws IOException {
        int length1 = -1;
        int length2 = 0;
        int skip1 = 0;
        int skip2 = 0;
        while (skip >= 0) {
            length1 = this.elem1.match(m, buffer, start, skip1);
            if (length1 < 0) {
                return -1;
            }
            length2 = this.elem2.match(m, buffer, start + length1, skip2);
            if (length2 < 0) {
                ++skip1;
                skip2 = 0;
                continue;
            }
            ++skip2;
            --skip;
        }
        return length1 + length2;
    }

    @Override
    public void printTo(PrintWriter output, String indent) {
        this.elem1.printTo(output, indent);
        this.elem2.printTo(output, indent);
    }
}

