/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.asn1;

import net.percederberg.grammatica.parser.Analyzer;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.Token;

public abstract class Asn1Analyzer
extends Analyzer {
    boolean debug = false;
    int ccnt = 0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void enter(Node node) throws ParseException {
        if (this.debug) {
            this.pad(this.ccnt++);
            System.out.print("e " + this.asnToString(node.getId()) + "  ");
        }
        try {
            switch (node.getId()) {
                case 1001: {
                    this.enterDot((Token)node);
                    return;
                }
                case 1002: {
                    this.enterDoubleDot((Token)node);
                    return;
                }
                case 1003: {
                    this.enterTripleDot((Token)node);
                    return;
                }
                case 1004: {
                    this.enterComma((Token)node);
                    return;
                }
                case 1005: {
                    this.enterSemiColon((Token)node);
                    return;
                }
                case 1006: {
                    this.enterLeftParen((Token)node);
                    return;
                }
                case 1007: {
                    this.enterRightParen((Token)node);
                    return;
                }
                case 1008: {
                    this.enterLeftBrace((Token)node);
                    return;
                }
                case 1009: {
                    this.enterRightBrace((Token)node);
                    return;
                }
                case 1010: {
                    this.enterLeftBracket((Token)node);
                    return;
                }
                case 1011: {
                    this.enterRightBracket((Token)node);
                    return;
                }
                case 1012: {
                    this.enterMinus((Token)node);
                    return;
                }
                case 1013: {
                    this.enterLessThan((Token)node);
                    return;
                }
                case 1014: {
                    this.enterVerticalBar((Token)node);
                    return;
                }
                case 1015: {
                    this.enterDefinition((Token)node);
                    return;
                }
                case 1016: {
                    this.enterDefinitions((Token)node);
                    return;
                }
                case 1017: {
                    this.enterExplicit((Token)node);
                    return;
                }
                case 1018: {
                    this.enterImplicit((Token)node);
                    return;
                }
                case 1019: {
                    this.enterTags((Token)node);
                    return;
                }
                case 1020: {
                    this.enterBegin((Token)node);
                    return;
                }
                case 1021: {
                    this.enterEnd((Token)node);
                    return;
                }
                case 1022: {
                    this.enterExports((Token)node);
                    return;
                }
                case 1023: {
                    this.enterImports((Token)node);
                    return;
                }
                case 1024: {
                    this.enterFrom((Token)node);
                    return;
                }
                case 1025: {
                    this.enterMacro((Token)node);
                    return;
                }
                case 1026: {
                    this.enterInteger((Token)node);
                    return;
                }
                case 1027: {
                    this.enterReal((Token)node);
                    return;
                }
                case 1028: {
                    this.enterBoolean((Token)node);
                    return;
                }
                case 1029: {
                    this.enterNull((Token)node);
                    return;
                }
                case 1030: {
                    this.enterBit((Token)node);
                    return;
                }
                case 1031: {
                    this.enterOctet((Token)node);
                    return;
                }
                case 1032: {
                    this.enterString((Token)node);
                    return;
                }
                case 1033: {
                    this.enterEnumerated((Token)node);
                    return;
                }
                case 1034: {
                    this.enterSequence((Token)node);
                    return;
                }
                case 1035: {
                    this.enterSet((Token)node);
                    return;
                }
                case 1036: {
                    this.enterOf((Token)node);
                    return;
                }
                case 1037: {
                    this.enterChoice((Token)node);
                    return;
                }
                case 1038: {
                    this.enterUniversal((Token)node);
                    return;
                }
                case 1039: {
                    this.enterApplication((Token)node);
                    return;
                }
                case 1040: {
                    this.enterPrivate((Token)node);
                    return;
                }
                case 1041: {
                    this.enterAny((Token)node);
                    return;
                }
                case 1042: {
                    this.enterDefined((Token)node);
                    return;
                }
                case 1043: {
                    this.enterBy((Token)node);
                    return;
                }
                case 1044: {
                    this.enterObject((Token)node);
                    return;
                }
                case 1045: {
                    this.enterIdentifier((Token)node);
                    return;
                }
                case 1046: {
                    this.enterIncludes((Token)node);
                    return;
                }
                case 1047: {
                    this.enterMin((Token)node);
                    return;
                }
                case 1048: {
                    this.enterMax((Token)node);
                    return;
                }
                case 1049: {
                    this.enterSize((Token)node);
                    return;
                }
                case 1050: {
                    this.enterWith((Token)node);
                    return;
                }
                case 1051: {
                    this.enterComponent((Token)node);
                    return;
                }
                case 1052: {
                    this.enterComponents((Token)node);
                    return;
                }
                case 1053: {
                    this.enterPresent((Token)node);
                    return;
                }
                case 1054: {
                    this.enterAbsent((Token)node);
                    return;
                }
                case 1055: {
                    this.enterOptional((Token)node);
                    return;
                }
                case 1056: {
                    this.enterDefault((Token)node);
                    return;
                }
                case 1057: {
                    this.enterTrue((Token)node);
                    return;
                }
                case 1058: {
                    this.enterFalse((Token)node);
                    return;
                }
                case 1059: {
                    this.enterPlusInfinity((Token)node);
                    return;
                }
                case 1060: {
                    this.enterMinusInfinity((Token)node);
                    return;
                }
                case 1061: {
                    this.enterModuleIdentity((Token)node);
                    return;
                }
                case 1062: {
                    this.enterObjectIdentity((Token)node);
                    return;
                }
                case 1063: {
                    this.enterObjectType((Token)node);
                    return;
                }
                case 1064: {
                    this.enterNotificationType((Token)node);
                    return;
                }
                case 1065: {
                    this.enterTrapType((Token)node);
                    return;
                }
                case 1066: {
                    this.enterTextualConvention((Token)node);
                    return;
                }
                case 1067: {
                    this.enterObjectGroup((Token)node);
                    return;
                }
                case 1068: {
                    this.enterNotificationGroup((Token)node);
                    return;
                }
                case 1069: {
                    this.enterModuleCompliance((Token)node);
                    return;
                }
                case 1070: {
                    this.enterAgentCapabilities((Token)node);
                    return;
                }
                case 1071: {
                    this.enterLastUpdated((Token)node);
                    return;
                }
                case 1072: {
                    this.enterOrganization((Token)node);
                    return;
                }
                case 1073: {
                    this.enterContactInfo((Token)node);
                    return;
                }
                case 1074: {
                    this.enterDescription((Token)node);
                    return;
                }
                case 1075: {
                    this.enterRevision((Token)node);
                    return;
                }
                case 1076: {
                    this.enterStatus((Token)node);
                    return;
                }
                case 1077: {
                    this.enterReference((Token)node);
                    return;
                }
                case 1078: {
                    this.enterSyntax((Token)node);
                    return;
                }
                case 1079: {
                    this.enterBits((Token)node);
                    return;
                }
                case 1080: {
                    this.enterUnits((Token)node);
                    return;
                }
                case 1081: {
                    this.enterAccess((Token)node);
                    return;
                }
                case 1082: {
                    this.enterMaxAccess((Token)node);
                    return;
                }
                case 1083: {
                    this.enterMinAccess((Token)node);
                    return;
                }
                case 1084: {
                    this.enterIndex((Token)node);
                    return;
                }
                case 1085: {
                    this.enterAugments((Token)node);
                    return;
                }
                case 1086: {
                    this.enterImplied((Token)node);
                    return;
                }
                case 1087: {
                    this.enterDefval((Token)node);
                    return;
                }
                case 1088: {
                    this.enterObjects((Token)node);
                    return;
                }
                case 1089: {
                    this.enterEnterprise((Token)node);
                    return;
                }
                case 1090: {
                    this.enterVariables((Token)node);
                    return;
                }
                case 1091: {
                    this.enterDisplayHint((Token)node);
                    return;
                }
                case 1092: {
                    this.enterNotifications((Token)node);
                    return;
                }
                case 1093: {
                    this.enterModule((Token)node);
                    return;
                }
                case 1094: {
                    this.enterMandatoryGroups((Token)node);
                    return;
                }
                case 1095: {
                    this.enterGroup((Token)node);
                    return;
                }
                case 1096: {
                    this.enterWriteSyntax((Token)node);
                    return;
                }
                case 1097: {
                    this.enterProductRelease((Token)node);
                    return;
                }
                case 1098: {
                    this.enterSupports((Token)node);
                    return;
                }
                case 1099: {
                    this.enterVariation((Token)node);
                    return;
                }
                case 1100: {
                    this.enterCreationRequires((Token)node);
                    return;
                }
                case 1101: {
                    this.enterBinaryString((Token)node);
                    return;
                }
                case 1102: {
                    this.enterHexadecimalString((Token)node);
                    return;
                }
                case 1103: {
                    this.enterQuotedString((Token)node);
                    return;
                }
                case 1104: {
                    this.enterIdentifierString((Token)node);
                    if (!this.debug) return;
                    System.out.print(((Token)node).getImage());
                    return;
                }
                case 1105: {
                    this.enterNumberString((Token)node);
                    return;
                }
                case 2001: {
                    this.enterStart((Production)node);
                    return;
                }
                case 2002: {
                    this.enterModuleDefinition((Production)node);
                    return;
                }
                case 2003: {
                    this.enterModuleIdentifier((Production)node);
                    return;
                }
                case 2004: {
                    this.enterModuleReference((Production)node);
                    return;
                }
                case 2005: {
                    this.enterTagDefault((Production)node);
                    return;
                }
                case 2006: {
                    this.enterModuleBody((Production)node);
                    return;
                }
                case 2007: {
                    this.enterExportList((Production)node);
                    return;
                }
                case 2008: {
                    this.enterImportList((Production)node);
                    return;
                }
                case 2009: {
                    this.enterSymbolsFromModule((Production)node);
                    return;
                }
                case 2010: {
                    this.enterSymbolList((Production)node);
                    return;
                }
                case 2011: {
                    this.enterSymbol((Production)node);
                    return;
                }
                case 2012: {
                    this.enterAssignmentList((Production)node);
                    return;
                }
                case 2013: {
                    this.enterAssignment((Production)node);
                    return;
                }
                case 2014: {
                    this.enterMacroDefinition((Production)node);
                    return;
                }
                case 2015: {
                    this.enterMacroReference((Production)node);
                    return;
                }
                case 2016: {
                    this.enterMacroBody((Production)node);
                    return;
                }
                case 2017: {
                    this.enterMacroBodyElement((Production)node);
                    return;
                }
                case 2018: {
                    this.enterTypeAssignment((Production)node);
                    return;
                }
                case 2019: {
                    this.enterType((Production)node);
                    return;
                }
                case 2020: {
                    this.enterDefinedType((Production)node);
                    return;
                }
                case 2021: {
                    this.enterBuiltinType((Production)node);
                    return;
                }
                case 2022: {
                    this.enterNullType((Production)node);
                    return;
                }
                case 2023: {
                    this.enterBooleanType((Production)node);
                    return;
                }
                case 2024: {
                    this.enterRealType((Production)node);
                    return;
                }
                case 2025: {
                    this.enterIntegerType((Production)node);
                    return;
                }
                case 2026: {
                    this.enterObjectIdentifierType((Production)node);
                    return;
                }
                case 2027: {
                    this.enterStringType((Production)node);
                    return;
                }
                case 2028: {
                    this.enterBitStringType((Production)node);
                    return;
                }
                case 2029: {
                    this.enterBitsType((Production)node);
                    return;
                }
                case 2030: {
                    this.enterSequenceType((Production)node);
                    return;
                }
                case 2031: {
                    this.enterSequenceOfType((Production)node);
                    return;
                }
                case 2032: {
                    this.enterSetType((Production)node);
                    return;
                }
                case 2033: {
                    this.enterSetOfType((Production)node);
                    return;
                }
                case 2034: {
                    this.enterChoiceType((Production)node);
                    return;
                }
                case 2035: {
                    this.enterEnumeratedType((Production)node);
                    return;
                }
                case 2036: {
                    this.enterSelectionType((Production)node);
                    return;
                }
                case 2037: {
                    this.enterTaggedType((Production)node);
                    return;
                }
                case 2038: {
                    this.enterTag((Production)node);
                    return;
                }
                case 2039: {
                    this.enterClass((Production)node);
                    return;
                }
                case 2040: {
                    this.enterExplicitOrImplicitTag((Production)node);
                    return;
                }
                case 2041: {
                    this.enterAnyType((Production)node);
                    return;
                }
                case 2042: {
                    this.enterElementTypeList((Production)node);
                    return;
                }
                case 2043: {
                    this.enterElementType((Production)node);
                    return;
                }
                case 2044: {
                    this.enterOptionalOrDefaultElement((Production)node);
                    return;
                }
                case 2045: {
                    this.enterValueOrConstraintList((Production)node);
                    return;
                }
                case 2046: {
                    this.enterNamedNumberList((Production)node);
                    return;
                }
                case 2047: {
                    this.enterNamedNumber((Production)node);
                    return;
                }
                case 2048: {
                    this.enterNumber((Production)node);
                    return;
                }
                case 2049: {
                    this.enterConstraintList((Production)node);
                    return;
                }
                case 2050: {
                    this.enterConstraint((Production)node);
                    return;
                }
                case 2051: {
                    this.enterValueConstraintList((Production)node);
                    return;
                }
                case 2052: {
                    this.enterValueConstraint((Production)node);
                    return;
                }
                case 2053: {
                    this.enterValueRange((Production)node);
                    return;
                }
                case 2054: {
                    this.enterLowerEndPoint((Production)node);
                    return;
                }
                case 2055: {
                    this.enterUpperEndPoint((Production)node);
                    return;
                }
                case 2056: {
                    this.enterSizeConstraint((Production)node);
                    return;
                }
                case 2057: {
                    this.enterAlphabetConstraint((Production)node);
                    return;
                }
                case 2058: {
                    this.enterContainedTypeConstraint((Production)node);
                    return;
                }
                case 2059: {
                    this.enterInnerTypeConstraint((Production)node);
                    return;
                }
                case 2060: {
                    this.enterComponentsList((Production)node);
                    return;
                }
                case 2061: {
                    this.enterComponentsListTail((Production)node);
                    return;
                }
                case 2062: {
                    this.enterComponentConstraint((Production)node);
                    return;
                }
                case 2063: {
                    this.enterComponentValuePresence((Production)node);
                    return;
                }
                case 2064: {
                    this.enterComponentPresence((Production)node);
                    return;
                }
                case 2065: {
                    this.enterValueAssignment((Production)node);
                    return;
                }
                case 2066: {
                    this.enterValue((Production)node);
                    return;
                }
                case 2067: {
                    this.enterDefinedValue((Production)node);
                    return;
                }
                case 2068: {
                    this.enterBuiltinValue((Production)node);
                    return;
                }
                case 2069: {
                    this.enterNullValue((Production)node);
                    return;
                }
                case 2070: {
                    this.enterBooleanValue((Production)node);
                    return;
                }
                case 2071: {
                    this.enterSpecialRealValue((Production)node);
                    return;
                }
                case 2072: {
                    this.enterNumberValue((Production)node);
                    return;
                }
                case 2073: {
                    this.enterBinaryValue((Production)node);
                    return;
                }
                case 2074: {
                    this.enterHexadecimalValue((Production)node);
                    return;
                }
                case 2075: {
                    this.enterStringValue((Production)node);
                    return;
                }
                case 2076: {
                    this.enterBitOrObjectIdentifierValue((Production)node);
                    return;
                }
                case 2077: {
                    this.enterBitValue((Production)node);
                    return;
                }
                case 2078: {
                    this.enterObjectIdentifierValue((Production)node);
                    return;
                }
                case 2079: {
                    this.enterNameValueList((Production)node);
                    return;
                }
                case 2080: {
                    this.enterNameValueComponent((Production)node);
                    return;
                }
                case 2081: {
                    this.enterNameOrNumber((Production)node);
                    return;
                }
                case 2082: {
                    this.enterNameAndNumber((Production)node);
                    return;
                }
                case 2083: {
                    this.enterDefinedMacroType((Production)node);
                    return;
                }
                case 2084: {
                    this.enterDefinedMacroName((Production)node);
                    return;
                }
                case 2085: {
                    this.enterSnmpModuleIdentityMacroType((Production)node);
                    return;
                }
                case 2086: {
                    this.enterSnmpObjectIdentityMacroType((Production)node);
                    return;
                }
                case 2087: {
                    this.enterSnmpObjectTypeMacroType((Production)node);
                    return;
                }
                case 2088: {
                    this.enterSnmpNotificationTypeMacroType((Production)node);
                    return;
                }
                case 2089: {
                    this.enterSnmpTrapTypeMacroType((Production)node);
                    return;
                }
                case 2090: {
                    this.enterSnmpTextualConventionMacroType((Production)node);
                    return;
                }
                case 2091: {
                    this.enterSnmpObjectGroupMacroType((Production)node);
                    return;
                }
                case 2092: {
                    this.enterSnmpNotificationGroupMacroType((Production)node);
                    return;
                }
                case 2093: {
                    this.enterSnmpModuleComplianceMacroType((Production)node);
                    return;
                }
                case 2094: {
                    this.enterSnmpAgentCapabilitiesMacroType((Production)node);
                    return;
                }
                case 2095: {
                    this.enterSnmpUpdatePart((Production)node);
                    return;
                }
                case 2096: {
                    this.enterSnmpOrganizationPart((Production)node);
                    return;
                }
                case 2097: {
                    this.enterSnmpContactPart((Production)node);
                    return;
                }
                case 2098: {
                    this.enterSnmpDescrPart((Production)node);
                    return;
                }
                case 2099: {
                    this.enterSnmpRevisionPart((Production)node);
                    return;
                }
                case 2100: {
                    this.enterSnmpStatusPart((Production)node);
                    return;
                }
                case 2101: {
                    this.enterSnmpReferPart((Production)node);
                    return;
                }
                case 2102: {
                    this.enterSnmpSyntaxPart((Production)node);
                    return;
                }
                case 2103: {
                    this.enterSnmpUnitsPart((Production)node);
                    return;
                }
                case 2104: {
                    this.enterSnmpAccessPart((Production)node);
                    return;
                }
                case 2105: {
                    this.enterSnmpIndexPart((Production)node);
                    return;
                }
                case 2106: {
                    this.enterIndexValueList((Production)node);
                    return;
                }
                case 2107: {
                    this.enterIndexValue((Production)node);
                    return;
                }
                case 2108: {
                    this.enterIndexType((Production)node);
                    return;
                }
                case 2109: {
                    this.enterSnmpDefValPart((Production)node);
                    return;
                }
                case 2110: {
                    this.enterSnmpObjectsPart((Production)node);
                    return;
                }
                case 2111: {
                    this.enterValueList((Production)node);
                    return;
                }
                case 2112: {
                    this.enterSnmpEnterprisePart((Production)node);
                    return;
                }
                case 2113: {
                    this.enterSnmpVarPart((Production)node);
                    return;
                }
                case 2114: {
                    this.enterSnmpDisplayPart((Production)node);
                    return;
                }
                case 2115: {
                    this.enterSnmpNotificationsPart((Production)node);
                    return;
                }
                case 2116: {
                    this.enterSnmpModulePart((Production)node);
                    return;
                }
                case 2117: {
                    this.enterSnmpModuleImport((Production)node);
                    return;
                }
                case 2118: {
                    this.enterSnmpMandatoryPart((Production)node);
                    return;
                }
                case 2119: {
                    this.enterSnmpCompliancePart((Production)node);
                    return;
                }
                case 2120: {
                    this.enterComplianceGroup((Production)node);
                    return;
                }
                case 2121: {
                    this.enterComplianceObject((Production)node);
                    return;
                }
                case 2122: {
                    this.enterSnmpWriteSyntaxPart((Production)node);
                    return;
                }
                case 2123: {
                    this.enterSnmpProductReleasePart((Production)node);
                    return;
                }
                case 2124: {
                    this.enterSnmpModuleSupportPart((Production)node);
                    return;
                }
                case 2125: {
                    this.enterSnmpVariationPart((Production)node);
                    return;
                }
                case 2126: {
                    this.enterSnmpCreationPart((Production)node);
                    return;
                }
            }
            return;
        }
        finally {
            if (this.debug) {
                System.out.println();
            }
        }
    }

    @Override
    protected Node exit(Node node) throws ParseException {
        if (this.debug) {
            this.pad(--this.ccnt);
            System.out.print("x " + this.asnToString(node.getId()));
        }
        try {
            switch (node.getId()) {
                case 1001: {
                    Node node2 = this.exitDot((Token)node);
                    return node2;
                }
                case 1002: {
                    Node node3 = this.exitDoubleDot((Token)node);
                    return node3;
                }
                case 1003: {
                    Node node4 = this.exitTripleDot((Token)node);
                    return node4;
                }
                case 1004: {
                    Node node5 = this.exitComma((Token)node);
                    return node5;
                }
                case 1005: {
                    Node node6 = this.exitSemiColon((Token)node);
                    return node6;
                }
                case 1006: {
                    Node node7 = this.exitLeftParen((Token)node);
                    return node7;
                }
                case 1007: {
                    Node node8 = this.exitRightParen((Token)node);
                    return node8;
                }
                case 1008: {
                    Node node9 = this.exitLeftBrace((Token)node);
                    return node9;
                }
                case 1009: {
                    Node node10 = this.exitRightBrace((Token)node);
                    return node10;
                }
                case 1010: {
                    Node node11 = this.exitLeftBracket((Token)node);
                    return node11;
                }
                case 1011: {
                    Node node12 = this.exitRightBracket((Token)node);
                    return node12;
                }
                case 1012: {
                    Node node13 = this.exitMinus((Token)node);
                    return node13;
                }
                case 1013: {
                    Node node14 = this.exitLessThan((Token)node);
                    return node14;
                }
                case 1014: {
                    Node node15 = this.exitVerticalBar((Token)node);
                    return node15;
                }
                case 1015: {
                    Node node16 = this.exitDefinition((Token)node);
                    return node16;
                }
                case 1016: {
                    Node node17 = this.exitDefinitions((Token)node);
                    return node17;
                }
                case 1017: {
                    Node node18 = this.exitExplicit((Token)node);
                    return node18;
                }
                case 1018: {
                    Node node19 = this.exitImplicit((Token)node);
                    return node19;
                }
                case 1019: {
                    Node node20 = this.exitTags((Token)node);
                    return node20;
                }
                case 1020: {
                    Node node21 = this.exitBegin((Token)node);
                    return node21;
                }
                case 1021: {
                    Node node22 = this.exitEnd((Token)node);
                    return node22;
                }
                case 1022: {
                    Node node23 = this.exitExports((Token)node);
                    return node23;
                }
                case 1023: {
                    Node node24 = this.exitImports((Token)node);
                    return node24;
                }
                case 1024: {
                    Node node25 = this.exitFrom((Token)node);
                    return node25;
                }
                case 1025: {
                    Node node26 = this.exitMacro((Token)node);
                    return node26;
                }
                case 1026: {
                    Node node27 = this.exitInteger((Token)node);
                    return node27;
                }
                case 1027: {
                    Node node28 = this.exitReal((Token)node);
                    return node28;
                }
                case 1028: {
                    Node node29 = this.exitBoolean((Token)node);
                    return node29;
                }
                case 1029: {
                    Node node30 = this.exitNull((Token)node);
                    return node30;
                }
                case 1030: {
                    Node node31 = this.exitBit((Token)node);
                    return node31;
                }
                case 1031: {
                    Node node32 = this.exitOctet((Token)node);
                    return node32;
                }
                case 1032: {
                    Node node33 = this.exitString((Token)node);
                    return node33;
                }
                case 1033: {
                    Node node34 = this.exitEnumerated((Token)node);
                    return node34;
                }
                case 1034: {
                    Node node35 = this.exitSequence((Token)node);
                    return node35;
                }
                case 1035: {
                    Node node36 = this.exitSet((Token)node);
                    return node36;
                }
                case 1036: {
                    Node node37 = this.exitOf((Token)node);
                    return node37;
                }
                case 1037: {
                    Node node38 = this.exitChoice((Token)node);
                    return node38;
                }
                case 1038: {
                    Node node39 = this.exitUniversal((Token)node);
                    return node39;
                }
                case 1039: {
                    Node node40 = this.exitApplication((Token)node);
                    return node40;
                }
                case 1040: {
                    Node node41 = this.exitPrivate((Token)node);
                    return node41;
                }
                case 1041: {
                    Node node42 = this.exitAny((Token)node);
                    return node42;
                }
                case 1042: {
                    Node node43 = this.exitDefined((Token)node);
                    return node43;
                }
                case 1043: {
                    Node node44 = this.exitBy((Token)node);
                    return node44;
                }
                case 1044: {
                    Node node45 = this.exitObject((Token)node);
                    return node45;
                }
                case 1045: {
                    Node node46 = this.exitIdentifier((Token)node);
                    return node46;
                }
                case 1046: {
                    Node node47 = this.exitIncludes((Token)node);
                    return node47;
                }
                case 1047: {
                    Node node48 = this.exitMin((Token)node);
                    return node48;
                }
                case 1048: {
                    Node node49 = this.exitMax((Token)node);
                    return node49;
                }
                case 1049: {
                    Node node50 = this.exitSize((Token)node);
                    return node50;
                }
                case 1050: {
                    Node node51 = this.exitWith((Token)node);
                    return node51;
                }
                case 1051: {
                    Node node52 = this.exitComponent((Token)node);
                    return node52;
                }
                case 1052: {
                    Node node53 = this.exitComponents((Token)node);
                    return node53;
                }
                case 1053: {
                    Node node54 = this.exitPresent((Token)node);
                    return node54;
                }
                case 1054: {
                    Node node55 = this.exitAbsent((Token)node);
                    return node55;
                }
                case 1055: {
                    Node node56 = this.exitOptional((Token)node);
                    return node56;
                }
                case 1056: {
                    Node node57 = this.exitDefault((Token)node);
                    return node57;
                }
                case 1057: {
                    Node node58 = this.exitTrue((Token)node);
                    return node58;
                }
                case 1058: {
                    Node node59 = this.exitFalse((Token)node);
                    return node59;
                }
                case 1059: {
                    Node node60 = this.exitPlusInfinity((Token)node);
                    return node60;
                }
                case 1060: {
                    Node node61 = this.exitMinusInfinity((Token)node);
                    return node61;
                }
                case 1061: {
                    Node node62 = this.exitModuleIdentity((Token)node);
                    return node62;
                }
                case 1062: {
                    Node node63 = this.exitObjectIdentity((Token)node);
                    return node63;
                }
                case 1063: {
                    Node node64 = this.exitObjectType((Token)node);
                    return node64;
                }
                case 1064: {
                    Node node65 = this.exitNotificationType((Token)node);
                    return node65;
                }
                case 1065: {
                    Node node66 = this.exitTrapType((Token)node);
                    return node66;
                }
                case 1066: {
                    Node node67 = this.exitTextualConvention((Token)node);
                    return node67;
                }
                case 1067: {
                    Node node68 = this.exitObjectGroup((Token)node);
                    return node68;
                }
                case 1068: {
                    Node node69 = this.exitNotificationGroup((Token)node);
                    return node69;
                }
                case 1069: {
                    Node node70 = this.exitModuleCompliance((Token)node);
                    return node70;
                }
                case 1070: {
                    Node node71 = this.exitAgentCapabilities((Token)node);
                    return node71;
                }
                case 1071: {
                    Node node72 = this.exitLastUpdated((Token)node);
                    return node72;
                }
                case 1072: {
                    Node node73 = this.exitOrganization((Token)node);
                    return node73;
                }
                case 1073: {
                    Node node74 = this.exitContactInfo((Token)node);
                    return node74;
                }
                case 1074: {
                    Node node75 = this.exitDescription((Token)node);
                    return node75;
                }
                case 1075: {
                    Node node76 = this.exitRevision((Token)node);
                    return node76;
                }
                case 1076: {
                    Node node77 = this.exitStatus((Token)node);
                    return node77;
                }
                case 1077: {
                    Node node78 = this.exitReference((Token)node);
                    return node78;
                }
                case 1078: {
                    Node node79 = this.exitSyntax((Token)node);
                    return node79;
                }
                case 1079: {
                    Node node80 = this.exitBits((Token)node);
                    return node80;
                }
                case 1080: {
                    Node node81 = this.exitUnits((Token)node);
                    return node81;
                }
                case 1081: {
                    Node node82 = this.exitAccess((Token)node);
                    return node82;
                }
                case 1082: {
                    Node node83 = this.exitMaxAccess((Token)node);
                    return node83;
                }
                case 1083: {
                    Node node84 = this.exitMinAccess((Token)node);
                    return node84;
                }
                case 1084: {
                    Node node85 = this.exitIndex((Token)node);
                    return node85;
                }
                case 1085: {
                    Node node86 = this.exitAugments((Token)node);
                    return node86;
                }
                case 1086: {
                    Node node87 = this.exitImplied((Token)node);
                    return node87;
                }
                case 1087: {
                    Node node88 = this.exitDefval((Token)node);
                    return node88;
                }
                case 1088: {
                    Node node89 = this.exitObjects((Token)node);
                    return node89;
                }
                case 1089: {
                    Node node90 = this.exitEnterprise((Token)node);
                    return node90;
                }
                case 1090: {
                    Node node91 = this.exitVariables((Token)node);
                    return node91;
                }
                case 1091: {
                    Node node92 = this.exitDisplayHint((Token)node);
                    return node92;
                }
                case 1092: {
                    Node node93 = this.exitNotifications((Token)node);
                    return node93;
                }
                case 1093: {
                    Node node94 = this.exitModule((Token)node);
                    return node94;
                }
                case 1094: {
                    Node node95 = this.exitMandatoryGroups((Token)node);
                    return node95;
                }
                case 1095: {
                    Node node96 = this.exitGroup((Token)node);
                    return node96;
                }
                case 1096: {
                    Node node97 = this.exitWriteSyntax((Token)node);
                    return node97;
                }
                case 1097: {
                    Node node98 = this.exitProductRelease((Token)node);
                    return node98;
                }
                case 1098: {
                    Node node99 = this.exitSupports((Token)node);
                    return node99;
                }
                case 1099: {
                    Node node100 = this.exitVariation((Token)node);
                    return node100;
                }
                case 1100: {
                    Node node101 = this.exitCreationRequires((Token)node);
                    return node101;
                }
                case 1101: {
                    Node node102 = this.exitBinaryString((Token)node);
                    return node102;
                }
                case 1102: {
                    Node node103 = this.exitHexadecimalString((Token)node);
                    return node103;
                }
                case 1103: {
                    Node node104 = this.exitQuotedString((Token)node);
                    return node104;
                }
                case 1104: {
                    Node node105 = this.exitIdentifierString((Token)node);
                    return node105;
                }
                case 1105: {
                    Node node106 = this.exitNumberString((Token)node);
                    return node106;
                }
                case 2001: {
                    Node node107 = this.exitStart((Production)node);
                    return node107;
                }
                case 2002: {
                    Node node108 = this.exitModuleDefinition((Production)node);
                    return node108;
                }
                case 2003: {
                    Node node109 = this.exitModuleIdentifier((Production)node);
                    return node109;
                }
                case 2004: {
                    Node node110 = this.exitModuleReference((Production)node);
                    return node110;
                }
                case 2005: {
                    Node node111 = this.exitTagDefault((Production)node);
                    return node111;
                }
                case 2006: {
                    Node node112 = this.exitModuleBody((Production)node);
                    return node112;
                }
                case 2007: {
                    Node node113 = this.exitExportList((Production)node);
                    return node113;
                }
                case 2008: {
                    Node node114 = this.exitImportList((Production)node);
                    return node114;
                }
                case 2009: {
                    Node node115 = this.exitSymbolsFromModule((Production)node);
                    return node115;
                }
                case 2010: {
                    Node node116 = this.exitSymbolList((Production)node);
                    return node116;
                }
                case 2011: {
                    Node node117 = this.exitSymbol((Production)node);
                    return node117;
                }
                case 2012: {
                    Node node118 = this.exitAssignmentList((Production)node);
                    return node118;
                }
                case 2013: {
                    Node node119 = this.exitAssignment((Production)node);
                    return node119;
                }
                case 2014: {
                    Node node120 = this.exitMacroDefinition((Production)node);
                    return node120;
                }
                case 2015: {
                    Node node121 = this.exitMacroReference((Production)node);
                    return node121;
                }
                case 2016: {
                    Node node122 = this.exitMacroBody((Production)node);
                    return node122;
                }
                case 2017: {
                    Node node123 = this.exitMacroBodyElement((Production)node);
                    return node123;
                }
                case 2018: {
                    Node node124 = this.exitTypeAssignment((Production)node);
                    return node124;
                }
                case 2019: {
                    Node node125 = this.exitType((Production)node);
                    return node125;
                }
                case 2020: {
                    Node node126 = this.exitDefinedType((Production)node);
                    return node126;
                }
                case 2021: {
                    Node node127 = this.exitBuiltinType((Production)node);
                    return node127;
                }
                case 2022: {
                    Node node128 = this.exitNullType((Production)node);
                    return node128;
                }
                case 2023: {
                    Node node129 = this.exitBooleanType((Production)node);
                    return node129;
                }
                case 2024: {
                    Node node130 = this.exitRealType((Production)node);
                    return node130;
                }
                case 2025: {
                    Node node131 = this.exitIntegerType((Production)node);
                    return node131;
                }
                case 2026: {
                    Node node132 = this.exitObjectIdentifierType((Production)node);
                    return node132;
                }
                case 2027: {
                    Node node133 = this.exitStringType((Production)node);
                    return node133;
                }
                case 2028: {
                    Node node134 = this.exitBitStringType((Production)node);
                    return node134;
                }
                case 2029: {
                    Node node135 = this.exitBitsType((Production)node);
                    return node135;
                }
                case 2030: {
                    Node node136 = this.exitSequenceType((Production)node);
                    return node136;
                }
                case 2031: {
                    Node node137 = this.exitSequenceOfType((Production)node);
                    return node137;
                }
                case 2032: {
                    Node node138 = this.exitSetType((Production)node);
                    return node138;
                }
                case 2033: {
                    Node node139 = this.exitSetOfType((Production)node);
                    return node139;
                }
                case 2034: {
                    Node node140 = this.exitChoiceType((Production)node);
                    return node140;
                }
                case 2035: {
                    Node node141 = this.exitEnumeratedType((Production)node);
                    return node141;
                }
                case 2036: {
                    Node node142 = this.exitSelectionType((Production)node);
                    return node142;
                }
                case 2037: {
                    Node node143 = this.exitTaggedType((Production)node);
                    return node143;
                }
                case 2038: {
                    Node node144 = this.exitTag((Production)node);
                    return node144;
                }
                case 2039: {
                    Node node145 = this.exitClass((Production)node);
                    return node145;
                }
                case 2040: {
                    Node node146 = this.exitExplicitOrImplicitTag((Production)node);
                    return node146;
                }
                case 2041: {
                    Node node147 = this.exitAnyType((Production)node);
                    return node147;
                }
                case 2042: {
                    Node node148 = this.exitElementTypeList((Production)node);
                    return node148;
                }
                case 2043: {
                    Node node149 = this.exitElementType((Production)node);
                    return node149;
                }
                case 2044: {
                    Node node150 = this.exitOptionalOrDefaultElement((Production)node);
                    return node150;
                }
                case 2045: {
                    Node node151 = this.exitValueOrConstraintList((Production)node);
                    return node151;
                }
                case 2046: {
                    Node node152 = this.exitNamedNumberList((Production)node);
                    return node152;
                }
                case 2047: {
                    Node node153 = this.exitNamedNumber((Production)node);
                    return node153;
                }
                case 2048: {
                    Node node154 = this.exitNumber((Production)node);
                    return node154;
                }
                case 2049: {
                    Node node155 = this.exitConstraintList((Production)node);
                    return node155;
                }
                case 2050: {
                    Node node156 = this.exitConstraint((Production)node);
                    return node156;
                }
                case 2051: {
                    Node node157 = this.exitValueConstraintList((Production)node);
                    return node157;
                }
                case 2052: {
                    Node node158 = this.exitValueConstraint((Production)node);
                    return node158;
                }
                case 2053: {
                    Node node159 = this.exitValueRange((Production)node);
                    return node159;
                }
                case 2054: {
                    Node node160 = this.exitLowerEndPoint((Production)node);
                    return node160;
                }
                case 2055: {
                    Node node161 = this.exitUpperEndPoint((Production)node);
                    return node161;
                }
                case 2056: {
                    Node node162 = this.exitSizeConstraint((Production)node);
                    return node162;
                }
                case 2057: {
                    Node node163 = this.exitAlphabetConstraint((Production)node);
                    return node163;
                }
                case 2058: {
                    Node node164 = this.exitContainedTypeConstraint((Production)node);
                    return node164;
                }
                case 2059: {
                    Node node165 = this.exitInnerTypeConstraint((Production)node);
                    return node165;
                }
                case 2060: {
                    Node node166 = this.exitComponentsList((Production)node);
                    return node166;
                }
                case 2061: {
                    Node node167 = this.exitComponentsListTail((Production)node);
                    return node167;
                }
                case 2062: {
                    Node node168 = this.exitComponentConstraint((Production)node);
                    return node168;
                }
                case 2063: {
                    Node node169 = this.exitComponentValuePresence((Production)node);
                    return node169;
                }
                case 2064: {
                    Node node170 = this.exitComponentPresence((Production)node);
                    return node170;
                }
                case 2065: {
                    Node node171 = this.exitValueAssignment((Production)node);
                    return node171;
                }
                case 2066: {
                    Node node172 = this.exitValue((Production)node);
                    return node172;
                }
                case 2067: {
                    Node node173 = this.exitDefinedValue((Production)node);
                    return node173;
                }
                case 2068: {
                    Node node174 = this.exitBuiltinValue((Production)node);
                    return node174;
                }
                case 2069: {
                    Node node175 = this.exitNullValue((Production)node);
                    return node175;
                }
                case 2070: {
                    Node node176 = this.exitBooleanValue((Production)node);
                    return node176;
                }
                case 2071: {
                    Node node177 = this.exitSpecialRealValue((Production)node);
                    return node177;
                }
                case 2072: {
                    Node node178 = this.exitNumberValue((Production)node);
                    return node178;
                }
                case 2073: {
                    Node node179 = this.exitBinaryValue((Production)node);
                    return node179;
                }
                case 2074: {
                    Node node180 = this.exitHexadecimalValue((Production)node);
                    return node180;
                }
                case 2075: {
                    Node node181 = this.exitStringValue((Production)node);
                    return node181;
                }
                case 2076: {
                    Node node182 = this.exitBitOrObjectIdentifierValue((Production)node);
                    return node182;
                }
                case 2077: {
                    Node node183 = this.exitBitValue((Production)node);
                    return node183;
                }
                case 2078: {
                    Node node184 = this.exitObjectIdentifierValue((Production)node);
                    return node184;
                }
                case 2079: {
                    Node node185 = this.exitNameValueList((Production)node);
                    return node185;
                }
                case 2080: {
                    Node node186 = this.exitNameValueComponent((Production)node);
                    return node186;
                }
                case 2081: {
                    Node node187 = this.exitNameOrNumber((Production)node);
                    return node187;
                }
                case 2082: {
                    Node node188 = this.exitNameAndNumber((Production)node);
                    return node188;
                }
                case 2083: {
                    Node node189 = this.exitDefinedMacroType((Production)node);
                    return node189;
                }
                case 2084: {
                    Node node190 = this.exitDefinedMacroName((Production)node);
                    return node190;
                }
                case 2085: {
                    Node node191 = this.exitSnmpModuleIdentityMacroType((Production)node);
                    return node191;
                }
                case 2086: {
                    Node node192 = this.exitSnmpObjectIdentityMacroType((Production)node);
                    return node192;
                }
                case 2087: {
                    Node node193 = this.exitSnmpObjectTypeMacroType((Production)node);
                    return node193;
                }
                case 2088: {
                    Node node194 = this.exitSnmpNotificationTypeMacroType((Production)node);
                    return node194;
                }
                case 2089: {
                    Node node195 = this.exitSnmpTrapTypeMacroType((Production)node);
                    return node195;
                }
                case 2090: {
                    Node node196 = this.exitSnmpTextualConventionMacroType((Production)node);
                    return node196;
                }
                case 2091: {
                    Node node197 = this.exitSnmpObjectGroupMacroType((Production)node);
                    return node197;
                }
                case 2092: {
                    Node node198 = this.exitSnmpNotificationGroupMacroType((Production)node);
                    return node198;
                }
                case 2093: {
                    Node node199 = this.exitSnmpModuleComplianceMacroType((Production)node);
                    return node199;
                }
                case 2094: {
                    Node node200 = this.exitSnmpAgentCapabilitiesMacroType((Production)node);
                    return node200;
                }
                case 2095: {
                    Node node201 = this.exitSnmpUpdatePart((Production)node);
                    return node201;
                }
                case 2096: {
                    Node node202 = this.exitSnmpOrganizationPart((Production)node);
                    return node202;
                }
                case 2097: {
                    Node node203 = this.exitSnmpContactPart((Production)node);
                    return node203;
                }
                case 2098: {
                    Node node204 = this.exitSnmpDescrPart((Production)node);
                    return node204;
                }
                case 2099: {
                    Node node205 = this.exitSnmpRevisionPart((Production)node);
                    return node205;
                }
                case 2100: {
                    Node node206 = this.exitSnmpStatusPart((Production)node);
                    return node206;
                }
                case 2101: {
                    Node node207 = this.exitSnmpReferPart((Production)node);
                    return node207;
                }
                case 2102: {
                    Node node208 = this.exitSnmpSyntaxPart((Production)node);
                    return node208;
                }
                case 2103: {
                    Node node209 = this.exitSnmpUnitsPart((Production)node);
                    return node209;
                }
                case 2104: {
                    Node node210 = this.exitSnmpAccessPart((Production)node);
                    return node210;
                }
                case 2105: {
                    Node node211 = this.exitSnmpIndexPart((Production)node);
                    return node211;
                }
                case 2106: {
                    Node node212 = this.exitIndexValueList((Production)node);
                    return node212;
                }
                case 2107: {
                    Node node213 = this.exitIndexValue((Production)node);
                    return node213;
                }
                case 2108: {
                    Node node214 = this.exitIndexType((Production)node);
                    return node214;
                }
                case 2109: {
                    Node node215 = this.exitSnmpDefValPart((Production)node);
                    return node215;
                }
                case 2110: {
                    Node node216 = this.exitSnmpObjectsPart((Production)node);
                    return node216;
                }
                case 2111: {
                    Node node217 = this.exitValueList((Production)node);
                    return node217;
                }
                case 2112: {
                    Node node218 = this.exitSnmpEnterprisePart((Production)node);
                    return node218;
                }
                case 2113: {
                    Node node219 = this.exitSnmpVarPart((Production)node);
                    return node219;
                }
                case 2114: {
                    Node node220 = this.exitSnmpDisplayPart((Production)node);
                    return node220;
                }
                case 2115: {
                    Node node221 = this.exitSnmpNotificationsPart((Production)node);
                    return node221;
                }
                case 2116: {
                    Node node222 = this.exitSnmpModulePart((Production)node);
                    return node222;
                }
                case 2117: {
                    Node node223 = this.exitSnmpModuleImport((Production)node);
                    return node223;
                }
                case 2118: {
                    Node node224 = this.exitSnmpMandatoryPart((Production)node);
                    return node224;
                }
                case 2119: {
                    Node node225 = this.exitSnmpCompliancePart((Production)node);
                    return node225;
                }
                case 2120: {
                    Node node226 = this.exitComplianceGroup((Production)node);
                    return node226;
                }
                case 2121: {
                    Node node227 = this.exitComplianceObject((Production)node);
                    return node227;
                }
                case 2122: {
                    Node node228 = this.exitSnmpWriteSyntaxPart((Production)node);
                    return node228;
                }
                case 2123: {
                    Node node229 = this.exitSnmpProductReleasePart((Production)node);
                    return node229;
                }
                case 2124: {
                    Node node230 = this.exitSnmpModuleSupportPart((Production)node);
                    return node230;
                }
                case 2125: {
                    Node node231 = this.exitSnmpVariationPart((Production)node);
                    return node231;
                }
                case 2126: {
                    Node node232 = this.exitSnmpCreationPart((Production)node);
                    return node232;
                }
            }
            Node node233 = node;
            return node233;
        }
        finally {
            if (this.debug) {
                System.out.println();
            }
        }
    }

    @Override
    protected void child(Production node, Node child) throws ParseException {
        switch (node.getId()) {
            case 2001: {
                this.childStart(node, child);
                break;
            }
            case 2002: {
                this.childModuleDefinition(node, child);
                break;
            }
            case 2003: {
                this.childModuleIdentifier(node, child);
                break;
            }
            case 2004: {
                this.childModuleReference(node, child);
                break;
            }
            case 2005: {
                this.childTagDefault(node, child);
                break;
            }
            case 2006: {
                this.childModuleBody(node, child);
                break;
            }
            case 2007: {
                this.childExportList(node, child);
                break;
            }
            case 2008: {
                this.childImportList(node, child);
                break;
            }
            case 2009: {
                this.childSymbolsFromModule(node, child);
                break;
            }
            case 2010: {
                this.childSymbolList(node, child);
                break;
            }
            case 2011: {
                this.childSymbol(node, child);
                break;
            }
            case 2012: {
                this.childAssignmentList(node, child);
                break;
            }
            case 2013: {
                this.childAssignment(node, child);
                break;
            }
            case 2014: {
                this.childMacroDefinition(node, child);
                break;
            }
            case 2015: {
                this.childMacroReference(node, child);
                break;
            }
            case 2016: {
                this.childMacroBody(node, child);
                break;
            }
            case 2017: {
                this.childMacroBodyElement(node, child);
                break;
            }
            case 2018: {
                this.childTypeAssignment(node, child);
                break;
            }
            case 2019: {
                this.childType(node, child);
                break;
            }
            case 2020: {
                this.childDefinedType(node, child);
                break;
            }
            case 2021: {
                this.childBuiltinType(node, child);
                break;
            }
            case 2022: {
                this.childNullType(node, child);
                break;
            }
            case 2023: {
                this.childBooleanType(node, child);
                break;
            }
            case 2024: {
                this.childRealType(node, child);
                break;
            }
            case 2025: {
                this.childIntegerType(node, child);
                break;
            }
            case 2026: {
                this.childObjectIdentifierType(node, child);
                break;
            }
            case 2027: {
                this.childStringType(node, child);
                break;
            }
            case 2028: {
                this.childBitStringType(node, child);
                break;
            }
            case 2029: {
                this.childBitsType(node, child);
                break;
            }
            case 2030: {
                this.childSequenceType(node, child);
                break;
            }
            case 2031: {
                this.childSequenceOfType(node, child);
                break;
            }
            case 2032: {
                this.childSetType(node, child);
                break;
            }
            case 2033: {
                this.childSetOfType(node, child);
                break;
            }
            case 2034: {
                this.childChoiceType(node, child);
                break;
            }
            case 2035: {
                this.childEnumeratedType(node, child);
                break;
            }
            case 2036: {
                this.childSelectionType(node, child);
                break;
            }
            case 2037: {
                this.childTaggedType(node, child);
                break;
            }
            case 2038: {
                this.childTag(node, child);
                break;
            }
            case 2039: {
                this.childClass(node, child);
                break;
            }
            case 2040: {
                this.childExplicitOrImplicitTag(node, child);
                break;
            }
            case 2041: {
                this.childAnyType(node, child);
                break;
            }
            case 2042: {
                this.childElementTypeList(node, child);
                break;
            }
            case 2043: {
                this.childElementType(node, child);
                break;
            }
            case 2044: {
                this.childOptionalOrDefaultElement(node, child);
                break;
            }
            case 2045: {
                this.childValueOrConstraintList(node, child);
                break;
            }
            case 2046: {
                this.childNamedNumberList(node, child);
                break;
            }
            case 2047: {
                this.childNamedNumber(node, child);
                break;
            }
            case 2048: {
                this.childNumber(node, child);
                break;
            }
            case 2049: {
                this.childConstraintList(node, child);
                break;
            }
            case 2050: {
                this.childConstraint(node, child);
                break;
            }
            case 2051: {
                this.childValueConstraintList(node, child);
                break;
            }
            case 2052: {
                this.childValueConstraint(node, child);
                break;
            }
            case 2053: {
                this.childValueRange(node, child);
                break;
            }
            case 2054: {
                this.childLowerEndPoint(node, child);
                break;
            }
            case 2055: {
                this.childUpperEndPoint(node, child);
                break;
            }
            case 2056: {
                this.childSizeConstraint(node, child);
                break;
            }
            case 2057: {
                this.childAlphabetConstraint(node, child);
                break;
            }
            case 2058: {
                this.childContainedTypeConstraint(node, child);
                break;
            }
            case 2059: {
                this.childInnerTypeConstraint(node, child);
                break;
            }
            case 2060: {
                this.childComponentsList(node, child);
                break;
            }
            case 2061: {
                this.childComponentsListTail(node, child);
                break;
            }
            case 2062: {
                this.childComponentConstraint(node, child);
                break;
            }
            case 2063: {
                this.childComponentValuePresence(node, child);
                break;
            }
            case 2064: {
                this.childComponentPresence(node, child);
                break;
            }
            case 2065: {
                this.childValueAssignment(node, child);
                break;
            }
            case 2066: {
                this.childValue(node, child);
                break;
            }
            case 2067: {
                this.childDefinedValue(node, child);
                break;
            }
            case 2068: {
                this.childBuiltinValue(node, child);
                break;
            }
            case 2069: {
                this.childNullValue(node, child);
                break;
            }
            case 2070: {
                this.childBooleanValue(node, child);
                break;
            }
            case 2071: {
                this.childSpecialRealValue(node, child);
                break;
            }
            case 2072: {
                this.childNumberValue(node, child);
                break;
            }
            case 2073: {
                this.childBinaryValue(node, child);
                break;
            }
            case 2074: {
                this.childHexadecimalValue(node, child);
                break;
            }
            case 2075: {
                this.childStringValue(node, child);
                break;
            }
            case 2076: {
                this.childBitOrObjectIdentifierValue(node, child);
                break;
            }
            case 2077: {
                this.childBitValue(node, child);
                break;
            }
            case 2078: {
                this.childObjectIdentifierValue(node, child);
                break;
            }
            case 2079: {
                this.childNameValueList(node, child);
                break;
            }
            case 2080: {
                this.childNameValueComponent(node, child);
                break;
            }
            case 2081: {
                this.childNameOrNumber(node, child);
                break;
            }
            case 2082: {
                this.childNameAndNumber(node, child);
                break;
            }
            case 2083: {
                this.childDefinedMacroType(node, child);
                break;
            }
            case 2084: {
                this.childDefinedMacroName(node, child);
                break;
            }
            case 2085: {
                this.childSnmpModuleIdentityMacroType(node, child);
                break;
            }
            case 2086: {
                this.childSnmpObjectIdentityMacroType(node, child);
                break;
            }
            case 2087: {
                this.childSnmpObjectTypeMacroType(node, child);
                break;
            }
            case 2088: {
                this.childSnmpNotificationTypeMacroType(node, child);
                break;
            }
            case 2089: {
                this.childSnmpTrapTypeMacroType(node, child);
                break;
            }
            case 2090: {
                this.childSnmpTextualConventionMacroType(node, child);
                break;
            }
            case 2091: {
                this.childSnmpObjectGroupMacroType(node, child);
                break;
            }
            case 2092: {
                this.childSnmpNotificationGroupMacroType(node, child);
                break;
            }
            case 2093: {
                this.childSnmpModuleComplianceMacroType(node, child);
                break;
            }
            case 2094: {
                this.childSnmpAgentCapabilitiesMacroType(node, child);
                break;
            }
            case 2095: {
                this.childSnmpUpdatePart(node, child);
                break;
            }
            case 2096: {
                this.childSnmpOrganizationPart(node, child);
                break;
            }
            case 2097: {
                this.childSnmpContactPart(node, child);
                break;
            }
            case 2098: {
                this.childSnmpDescrPart(node, child);
                break;
            }
            case 2099: {
                this.childSnmpRevisionPart(node, child);
                break;
            }
            case 2100: {
                this.childSnmpStatusPart(node, child);
                break;
            }
            case 2101: {
                this.childSnmpReferPart(node, child);
                break;
            }
            case 2102: {
                this.childSnmpSyntaxPart(node, child);
                break;
            }
            case 2103: {
                this.childSnmpUnitsPart(node, child);
                break;
            }
            case 2104: {
                this.childSnmpAccessPart(node, child);
                break;
            }
            case 2105: {
                this.childSnmpIndexPart(node, child);
                break;
            }
            case 2106: {
                this.childIndexValueList(node, child);
                break;
            }
            case 2107: {
                this.childIndexValue(node, child);
                break;
            }
            case 2108: {
                this.childIndexType(node, child);
                break;
            }
            case 2109: {
                this.childSnmpDefValPart(node, child);
                break;
            }
            case 2110: {
                this.childSnmpObjectsPart(node, child);
                break;
            }
            case 2111: {
                this.childValueList(node, child);
                break;
            }
            case 2112: {
                this.childSnmpEnterprisePart(node, child);
                break;
            }
            case 2113: {
                this.childSnmpVarPart(node, child);
                break;
            }
            case 2114: {
                this.childSnmpDisplayPart(node, child);
                break;
            }
            case 2115: {
                this.childSnmpNotificationsPart(node, child);
                break;
            }
            case 2116: {
                this.childSnmpModulePart(node, child);
                break;
            }
            case 2117: {
                this.childSnmpModuleImport(node, child);
                break;
            }
            case 2118: {
                this.childSnmpMandatoryPart(node, child);
                break;
            }
            case 2119: {
                this.childSnmpCompliancePart(node, child);
                break;
            }
            case 2120: {
                this.childComplianceGroup(node, child);
                break;
            }
            case 2121: {
                this.childComplianceObject(node, child);
                break;
            }
            case 2122: {
                this.childSnmpWriteSyntaxPart(node, child);
                break;
            }
            case 2123: {
                this.childSnmpProductReleasePart(node, child);
                break;
            }
            case 2124: {
                this.childSnmpModuleSupportPart(node, child);
                break;
            }
            case 2125: {
                this.childSnmpVariationPart(node, child);
                break;
            }
            case 2126: {
                this.childSnmpCreationPart(node, child);
            }
        }
    }

    protected void enterDot(Token node) throws ParseException {
    }

    protected Node exitDot(Token node) throws ParseException {
        return node;
    }

    protected void enterDoubleDot(Token node) throws ParseException {
    }

    protected Node exitDoubleDot(Token node) throws ParseException {
        return node;
    }

    protected void enterTripleDot(Token node) throws ParseException {
    }

    protected Node exitTripleDot(Token node) throws ParseException {
        return node;
    }

    protected void enterComma(Token node) throws ParseException {
    }

    protected Node exitComma(Token node) throws ParseException {
        return node;
    }

    protected void enterSemiColon(Token node) throws ParseException {
    }

    protected Node exitSemiColon(Token node) throws ParseException {
        return node;
    }

    protected void enterLeftParen(Token node) throws ParseException {
    }

    protected Node exitLeftParen(Token node) throws ParseException {
        return node;
    }

    protected void enterRightParen(Token node) throws ParseException {
    }

    protected Node exitRightParen(Token node) throws ParseException {
        return node;
    }

    protected void enterLeftBrace(Token node) throws ParseException {
    }

    protected Node exitLeftBrace(Token node) throws ParseException {
        return node;
    }

    protected void enterRightBrace(Token node) throws ParseException {
    }

    protected Node exitRightBrace(Token node) throws ParseException {
        return node;
    }

    protected void enterLeftBracket(Token node) throws ParseException {
    }

    protected Node exitLeftBracket(Token node) throws ParseException {
        return node;
    }

    protected void enterRightBracket(Token node) throws ParseException {
    }

    protected Node exitRightBracket(Token node) throws ParseException {
        return node;
    }

    protected void enterMinus(Token node) throws ParseException {
    }

    protected Node exitMinus(Token node) throws ParseException {
        return node;
    }

    protected void enterLessThan(Token node) throws ParseException {
    }

    protected Node exitLessThan(Token node) throws ParseException {
        return node;
    }

    protected void enterVerticalBar(Token node) throws ParseException {
    }

    protected Node exitVerticalBar(Token node) throws ParseException {
        return node;
    }

    protected void enterDefinition(Token node) throws ParseException {
    }

    protected Node exitDefinition(Token node) throws ParseException {
        return node;
    }

    protected void enterDefinitions(Token node) throws ParseException {
    }

    protected Node exitDefinitions(Token node) throws ParseException {
        return node;
    }

    protected void enterExplicit(Token node) throws ParseException {
    }

    protected Node exitExplicit(Token node) throws ParseException {
        return node;
    }

    protected void enterImplicit(Token node) throws ParseException {
    }

    protected Node exitImplicit(Token node) throws ParseException {
        return node;
    }

    protected void enterTags(Token node) throws ParseException {
    }

    protected Node exitTags(Token node) throws ParseException {
        return node;
    }

    protected void enterBegin(Token node) throws ParseException {
    }

    protected Node exitBegin(Token node) throws ParseException {
        return node;
    }

    protected void enterEnd(Token node) throws ParseException {
    }

    protected Node exitEnd(Token node) throws ParseException {
        return node;
    }

    protected void enterExports(Token node) throws ParseException {
    }

    protected Node exitExports(Token node) throws ParseException {
        return node;
    }

    protected void enterImports(Token node) throws ParseException {
    }

    protected Node exitImports(Token node) throws ParseException {
        return node;
    }

    protected void enterFrom(Token node) throws ParseException {
    }

    protected Node exitFrom(Token node) throws ParseException {
        return node;
    }

    protected void enterMacro(Token node) throws ParseException {
    }

    protected Node exitMacro(Token node) throws ParseException {
        return node;
    }

    protected void enterInteger(Token node) throws ParseException {
    }

    protected Node exitInteger(Token node) throws ParseException {
        return node;
    }

    protected void enterReal(Token node) throws ParseException {
    }

    protected Node exitReal(Token node) throws ParseException {
        return node;
    }

    protected void enterBoolean(Token node) throws ParseException {
    }

    protected Node exitBoolean(Token node) throws ParseException {
        return node;
    }

    protected void enterNull(Token node) throws ParseException {
    }

    protected Node exitNull(Token node) throws ParseException {
        return node;
    }

    protected void enterBit(Token node) throws ParseException {
    }

    protected Node exitBit(Token node) throws ParseException {
        return node;
    }

    protected void enterOctet(Token node) throws ParseException {
    }

    protected Node exitOctet(Token node) throws ParseException {
        return node;
    }

    protected void enterString(Token node) throws ParseException {
    }

    protected Node exitString(Token node) throws ParseException {
        return node;
    }

    protected void enterEnumerated(Token node) throws ParseException {
    }

    protected Node exitEnumerated(Token node) throws ParseException {
        return node;
    }

    protected void enterSequence(Token node) throws ParseException {
    }

    protected Node exitSequence(Token node) throws ParseException {
        return node;
    }

    protected void enterSet(Token node) throws ParseException {
    }

    protected Node exitSet(Token node) throws ParseException {
        return node;
    }

    protected void enterOf(Token node) throws ParseException {
    }

    protected Node exitOf(Token node) throws ParseException {
        return node;
    }

    protected void enterChoice(Token node) throws ParseException {
    }

    protected Node exitChoice(Token node) throws ParseException {
        return node;
    }

    protected void enterUniversal(Token node) throws ParseException {
    }

    protected Node exitUniversal(Token node) throws ParseException {
        return node;
    }

    protected void enterApplication(Token node) throws ParseException {
    }

    protected Node exitApplication(Token node) throws ParseException {
        return node;
    }

    protected void enterPrivate(Token node) throws ParseException {
    }

    protected Node exitPrivate(Token node) throws ParseException {
        return node;
    }

    protected void enterAny(Token node) throws ParseException {
    }

    protected Node exitAny(Token node) throws ParseException {
        return node;
    }

    protected void enterDefined(Token node) throws ParseException {
    }

    protected Node exitDefined(Token node) throws ParseException {
        return node;
    }

    protected void enterBy(Token node) throws ParseException {
    }

    protected Node exitBy(Token node) throws ParseException {
        return node;
    }

    protected void enterObject(Token node) throws ParseException {
    }

    protected Node exitObject(Token node) throws ParseException {
        return node;
    }

    protected void enterIdentifier(Token node) throws ParseException {
    }

    protected Node exitIdentifier(Token node) throws ParseException {
        return node;
    }

    protected void enterIncludes(Token node) throws ParseException {
    }

    protected Node exitIncludes(Token node) throws ParseException {
        return node;
    }

    protected void enterMin(Token node) throws ParseException {
    }

    protected Node exitMin(Token node) throws ParseException {
        return node;
    }

    protected void enterMax(Token node) throws ParseException {
    }

    protected Node exitMax(Token node) throws ParseException {
        return node;
    }

    protected void enterSize(Token node) throws ParseException {
    }

    protected Node exitSize(Token node) throws ParseException {
        return node;
    }

    protected void enterWith(Token node) throws ParseException {
    }

    protected Node exitWith(Token node) throws ParseException {
        return node;
    }

    protected void enterComponent(Token node) throws ParseException {
    }

    protected Node exitComponent(Token node) throws ParseException {
        return node;
    }

    protected void enterComponents(Token node) throws ParseException {
    }

    protected Node exitComponents(Token node) throws ParseException {
        return node;
    }

    protected void enterPresent(Token node) throws ParseException {
    }

    protected Node exitPresent(Token node) throws ParseException {
        return node;
    }

    protected void enterAbsent(Token node) throws ParseException {
    }

    protected Node exitAbsent(Token node) throws ParseException {
        return node;
    }

    protected void enterOptional(Token node) throws ParseException {
    }

    protected Node exitOptional(Token node) throws ParseException {
        return node;
    }

    protected void enterDefault(Token node) throws ParseException {
    }

    protected Node exitDefault(Token node) throws ParseException {
        return node;
    }

    protected void enterTrue(Token node) throws ParseException {
    }

    protected Node exitTrue(Token node) throws ParseException {
        return node;
    }

    protected void enterFalse(Token node) throws ParseException {
    }

    protected Node exitFalse(Token node) throws ParseException {
        return node;
    }

    protected void enterPlusInfinity(Token node) throws ParseException {
    }

    protected Node exitPlusInfinity(Token node) throws ParseException {
        return node;
    }

    protected void enterMinusInfinity(Token node) throws ParseException {
    }

    protected Node exitMinusInfinity(Token node) throws ParseException {
        return node;
    }

    protected void enterModuleIdentity(Token node) throws ParseException {
    }

    protected Node exitModuleIdentity(Token node) throws ParseException {
        return node;
    }

    protected void enterObjectIdentity(Token node) throws ParseException {
    }

    protected Node exitObjectIdentity(Token node) throws ParseException {
        return node;
    }

    protected void enterObjectType(Token node) throws ParseException {
    }

    protected Node exitObjectType(Token node) throws ParseException {
        return node;
    }

    protected void enterNotificationType(Token node) throws ParseException {
    }

    protected Node exitNotificationType(Token node) throws ParseException {
        return node;
    }

    protected void enterTrapType(Token node) throws ParseException {
    }

    protected Node exitTrapType(Token node) throws ParseException {
        return node;
    }

    protected void enterTextualConvention(Token node) throws ParseException {
    }

    protected Node exitTextualConvention(Token node) throws ParseException {
        return node;
    }

    protected void enterObjectGroup(Token node) throws ParseException {
    }

    protected Node exitObjectGroup(Token node) throws ParseException {
        return node;
    }

    protected void enterNotificationGroup(Token node) throws ParseException {
    }

    protected Node exitNotificationGroup(Token node) throws ParseException {
        return node;
    }

    protected void enterModuleCompliance(Token node) throws ParseException {
    }

    protected Node exitModuleCompliance(Token node) throws ParseException {
        return node;
    }

    protected void enterAgentCapabilities(Token node) throws ParseException {
    }

    protected Node exitAgentCapabilities(Token node) throws ParseException {
        return node;
    }

    protected void enterLastUpdated(Token node) throws ParseException {
    }

    protected Node exitLastUpdated(Token node) throws ParseException {
        return node;
    }

    protected void enterOrganization(Token node) throws ParseException {
    }

    protected Node exitOrganization(Token node) throws ParseException {
        return node;
    }

    protected void enterContactInfo(Token node) throws ParseException {
    }

    protected Node exitContactInfo(Token node) throws ParseException {
        return node;
    }

    protected void enterDescription(Token node) throws ParseException {
    }

    protected Node exitDescription(Token node) throws ParseException {
        return node;
    }

    protected void enterRevision(Token node) throws ParseException {
    }

    protected Node exitRevision(Token node) throws ParseException {
        return node;
    }

    protected void enterStatus(Token node) throws ParseException {
    }

    protected Node exitStatus(Token node) throws ParseException {
        return node;
    }

    protected void enterReference(Token node) throws ParseException {
    }

    protected Node exitReference(Token node) throws ParseException {
        return node;
    }

    protected void enterSyntax(Token node) throws ParseException {
    }

    protected Node exitSyntax(Token node) throws ParseException {
        return node;
    }

    protected void enterBits(Token node) throws ParseException {
    }

    protected Node exitBits(Token node) throws ParseException {
        return node;
    }

    protected void enterUnits(Token node) throws ParseException {
    }

    protected Node exitUnits(Token node) throws ParseException {
        return node;
    }

    protected void enterAccess(Token node) throws ParseException {
    }

    protected Node exitAccess(Token node) throws ParseException {
        return node;
    }

    protected void enterMaxAccess(Token node) throws ParseException {
    }

    protected Node exitMaxAccess(Token node) throws ParseException {
        return node;
    }

    protected void enterMinAccess(Token node) throws ParseException {
    }

    protected Node exitMinAccess(Token node) throws ParseException {
        return node;
    }

    protected void enterIndex(Token node) throws ParseException {
    }

    protected Node exitIndex(Token node) throws ParseException {
        return node;
    }

    protected void enterAugments(Token node) throws ParseException {
    }

    protected Node exitAugments(Token node) throws ParseException {
        return node;
    }

    protected void enterImplied(Token node) throws ParseException {
    }

    protected Node exitImplied(Token node) throws ParseException {
        return node;
    }

    protected void enterDefval(Token node) throws ParseException {
    }

    protected Node exitDefval(Token node) throws ParseException {
        return node;
    }

    protected void enterObjects(Token node) throws ParseException {
    }

    protected Node exitObjects(Token node) throws ParseException {
        return node;
    }

    protected void enterEnterprise(Token node) throws ParseException {
    }

    protected Node exitEnterprise(Token node) throws ParseException {
        return node;
    }

    protected void enterVariables(Token node) throws ParseException {
    }

    protected Node exitVariables(Token node) throws ParseException {
        return node;
    }

    protected void enterDisplayHint(Token node) throws ParseException {
    }

    protected Node exitDisplayHint(Token node) throws ParseException {
        return node;
    }

    protected void enterNotifications(Token node) throws ParseException {
    }

    protected Node exitNotifications(Token node) throws ParseException {
        return node;
    }

    protected void enterModule(Token node) throws ParseException {
    }

    protected Node exitModule(Token node) throws ParseException {
        return node;
    }

    protected void enterMandatoryGroups(Token node) throws ParseException {
    }

    protected Node exitMandatoryGroups(Token node) throws ParseException {
        return node;
    }

    protected void enterGroup(Token node) throws ParseException {
    }

    protected Node exitGroup(Token node) throws ParseException {
        return node;
    }

    protected void enterWriteSyntax(Token node) throws ParseException {
    }

    protected Node exitWriteSyntax(Token node) throws ParseException {
        return node;
    }

    protected void enterProductRelease(Token node) throws ParseException {
    }

    protected Node exitProductRelease(Token node) throws ParseException {
        return node;
    }

    protected void enterSupports(Token node) throws ParseException {
    }

    protected Node exitSupports(Token node) throws ParseException {
        return node;
    }

    protected void enterVariation(Token node) throws ParseException {
    }

    protected Node exitVariation(Token node) throws ParseException {
        return node;
    }

    protected void enterCreationRequires(Token node) throws ParseException {
    }

    protected Node exitCreationRequires(Token node) throws ParseException {
        return node;
    }

    protected void enterBinaryString(Token node) throws ParseException {
    }

    protected Node exitBinaryString(Token node) throws ParseException {
        return node;
    }

    protected void enterHexadecimalString(Token node) throws ParseException {
    }

    protected Node exitHexadecimalString(Token node) throws ParseException {
        return node;
    }

    protected void enterQuotedString(Token node) throws ParseException {
    }

    protected Node exitQuotedString(Token node) throws ParseException {
        return node;
    }

    protected void enterIdentifierString(Token node) throws ParseException {
    }

    protected Node exitIdentifierString(Token node) throws ParseException {
        return node;
    }

    protected void enterNumberString(Token node) throws ParseException {
    }

    protected Node exitNumberString(Token node) throws ParseException {
        return node;
    }

    protected void enterStart(Production node) throws ParseException {
    }

    protected Node exitStart(Production node) throws ParseException {
        return node;
    }

    protected void childStart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterModuleDefinition(Production node) throws ParseException {
    }

    protected Node exitModuleDefinition(Production node) throws ParseException {
        return node;
    }

    protected void childModuleDefinition(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterModuleIdentifier(Production node) throws ParseException {
    }

    protected Node exitModuleIdentifier(Production node) throws ParseException {
        return node;
    }

    protected void childModuleIdentifier(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterModuleReference(Production node) throws ParseException {
    }

    protected Node exitModuleReference(Production node) throws ParseException {
        return node;
    }

    protected void childModuleReference(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterTagDefault(Production node) throws ParseException {
    }

    protected Node exitTagDefault(Production node) throws ParseException {
        return node;
    }

    protected void childTagDefault(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterModuleBody(Production node) throws ParseException {
    }

    protected Node exitModuleBody(Production node) throws ParseException {
        return node;
    }

    protected void childModuleBody(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterExportList(Production node) throws ParseException {
    }

    protected Node exitExportList(Production node) throws ParseException {
        return node;
    }

    protected void childExportList(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterImportList(Production node) throws ParseException {
    }

    protected Node exitImportList(Production node) throws ParseException {
        return node;
    }

    protected void childImportList(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSymbolsFromModule(Production node) throws ParseException {
    }

    protected Node exitSymbolsFromModule(Production node) throws ParseException {
        return node;
    }

    protected void childSymbolsFromModule(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSymbolList(Production node) throws ParseException {
    }

    protected Node exitSymbolList(Production node) throws ParseException {
        return node;
    }

    protected void childSymbolList(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSymbol(Production node) throws ParseException {
    }

    protected Node exitSymbol(Production node) throws ParseException {
        return node;
    }

    protected void childSymbol(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterAssignmentList(Production node) throws ParseException {
    }

    protected Node exitAssignmentList(Production node) throws ParseException {
        return node;
    }

    protected void childAssignmentList(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterAssignment(Production node) throws ParseException {
    }

    protected Node exitAssignment(Production node) throws ParseException {
        return node;
    }

    protected void childAssignment(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterMacroDefinition(Production node) throws ParseException {
    }

    protected Node exitMacroDefinition(Production node) throws ParseException {
        return node;
    }

    protected void childMacroDefinition(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterMacroReference(Production node) throws ParseException {
    }

    protected Node exitMacroReference(Production node) throws ParseException {
        return node;
    }

    protected void childMacroReference(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterMacroBody(Production node) throws ParseException {
    }

    protected Node exitMacroBody(Production node) throws ParseException {
        return node;
    }

    protected void childMacroBody(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterMacroBodyElement(Production node) throws ParseException {
    }

    protected Node exitMacroBodyElement(Production node) throws ParseException {
        return node;
    }

    protected void childMacroBodyElement(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterTypeAssignment(Production node) throws ParseException {
    }

    protected Node exitTypeAssignment(Production node) throws ParseException {
        return node;
    }

    protected void childTypeAssignment(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterType(Production node) throws ParseException {
    }

    protected Node exitType(Production node) throws ParseException {
        return node;
    }

    protected void childType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterDefinedType(Production node) throws ParseException {
    }

    protected Node exitDefinedType(Production node) throws ParseException {
        return node;
    }

    protected void childDefinedType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterBuiltinType(Production node) throws ParseException {
    }

    protected Node exitBuiltinType(Production node) throws ParseException {
        return node;
    }

    protected void childBuiltinType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterNullType(Production node) throws ParseException {
    }

    protected Node exitNullType(Production node) throws ParseException {
        return node;
    }

    protected void childNullType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterBooleanType(Production node) throws ParseException {
    }

    protected Node exitBooleanType(Production node) throws ParseException {
        return node;
    }

    protected void childBooleanType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterRealType(Production node) throws ParseException {
    }

    protected Node exitRealType(Production node) throws ParseException {
        return node;
    }

    protected void childRealType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterIntegerType(Production node) throws ParseException {
    }

    protected Node exitIntegerType(Production node) throws ParseException {
        return node;
    }

    protected void childIntegerType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterObjectIdentifierType(Production node) throws ParseException {
    }

    protected Node exitObjectIdentifierType(Production node) throws ParseException {
        return node;
    }

    protected void childObjectIdentifierType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterStringType(Production node) throws ParseException {
    }

    protected Node exitStringType(Production node) throws ParseException {
        return node;
    }

    protected void childStringType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterBitStringType(Production node) throws ParseException {
    }

    protected Node exitBitStringType(Production node) throws ParseException {
        return node;
    }

    protected void childBitStringType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterBitsType(Production node) throws ParseException {
    }

    protected Node exitBitsType(Production node) throws ParseException {
        return node;
    }

    protected void childBitsType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSequenceType(Production node) throws ParseException {
    }

    protected Node exitSequenceType(Production node) throws ParseException {
        return node;
    }

    protected void childSequenceType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSequenceOfType(Production node) throws ParseException {
    }

    protected Node exitSequenceOfType(Production node) throws ParseException {
        return node;
    }

    protected void childSequenceOfType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSetType(Production node) throws ParseException {
    }

    protected Node exitSetType(Production node) throws ParseException {
        return node;
    }

    protected void childSetType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSetOfType(Production node) throws ParseException {
    }

    protected Node exitSetOfType(Production node) throws ParseException {
        return node;
    }

    protected void childSetOfType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterChoiceType(Production node) throws ParseException {
    }

    protected Node exitChoiceType(Production node) throws ParseException {
        return node;
    }

    protected void childChoiceType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterEnumeratedType(Production node) throws ParseException {
    }

    protected Node exitEnumeratedType(Production node) throws ParseException {
        return node;
    }

    protected void childEnumeratedType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSelectionType(Production node) throws ParseException {
    }

    protected Node exitSelectionType(Production node) throws ParseException {
        return node;
    }

    protected void childSelectionType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterTaggedType(Production node) throws ParseException {
    }

    protected Node exitTaggedType(Production node) throws ParseException {
        return node;
    }

    protected void childTaggedType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterTag(Production node) throws ParseException {
    }

    protected Node exitTag(Production node) throws ParseException {
        return node;
    }

    protected void childTag(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterClass(Production node) throws ParseException {
    }

    protected Node exitClass(Production node) throws ParseException {
        return node;
    }

    protected void childClass(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterExplicitOrImplicitTag(Production node) throws ParseException {
    }

    protected Node exitExplicitOrImplicitTag(Production node) throws ParseException {
        return node;
    }

    protected void childExplicitOrImplicitTag(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterAnyType(Production node) throws ParseException {
    }

    protected Node exitAnyType(Production node) throws ParseException {
        return node;
    }

    protected void childAnyType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterElementTypeList(Production node) throws ParseException {
    }

    protected Node exitElementTypeList(Production node) throws ParseException {
        return node;
    }

    protected void childElementTypeList(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterElementType(Production node) throws ParseException {
    }

    protected Node exitElementType(Production node) throws ParseException {
        return node;
    }

    protected void childElementType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterOptionalOrDefaultElement(Production node) throws ParseException {
    }

    protected Node exitOptionalOrDefaultElement(Production node) throws ParseException {
        return node;
    }

    protected void childOptionalOrDefaultElement(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterValueOrConstraintList(Production node) throws ParseException {
    }

    protected Node exitValueOrConstraintList(Production node) throws ParseException {
        return node;
    }

    protected void childValueOrConstraintList(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterNamedNumberList(Production node) throws ParseException {
    }

    protected Node exitNamedNumberList(Production node) throws ParseException {
        return node;
    }

    protected void childNamedNumberList(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterNamedNumber(Production node) throws ParseException {
    }

    protected Node exitNamedNumber(Production node) throws ParseException {
        return node;
    }

    protected void childNamedNumber(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterNumber(Production node) throws ParseException {
    }

    protected Node exitNumber(Production node) throws ParseException {
        return node;
    }

    protected void childNumber(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterConstraintList(Production node) throws ParseException {
    }

    protected Node exitConstraintList(Production node) throws ParseException {
        return node;
    }

    protected void childConstraintList(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterConstraint(Production node) throws ParseException {
    }

    protected Node exitConstraint(Production node) throws ParseException {
        return node;
    }

    protected void childConstraint(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterValueConstraintList(Production node) throws ParseException {
    }

    protected Node exitValueConstraintList(Production node) throws ParseException {
        return node;
    }

    protected void childValueConstraintList(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterValueConstraint(Production node) throws ParseException {
    }

    protected Node exitValueConstraint(Production node) throws ParseException {
        return node;
    }

    protected void childValueConstraint(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterValueRange(Production node) throws ParseException {
    }

    protected Node exitValueRange(Production node) throws ParseException {
        return node;
    }

    protected void childValueRange(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterLowerEndPoint(Production node) throws ParseException {
    }

    protected Node exitLowerEndPoint(Production node) throws ParseException {
        return node;
    }

    protected void childLowerEndPoint(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterUpperEndPoint(Production node) throws ParseException {
    }

    protected Node exitUpperEndPoint(Production node) throws ParseException {
        return node;
    }

    protected void childUpperEndPoint(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSizeConstraint(Production node) throws ParseException {
    }

    protected Node exitSizeConstraint(Production node) throws ParseException {
        return node;
    }

    protected void childSizeConstraint(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterAlphabetConstraint(Production node) throws ParseException {
    }

    protected Node exitAlphabetConstraint(Production node) throws ParseException {
        return node;
    }

    protected void childAlphabetConstraint(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterContainedTypeConstraint(Production node) throws ParseException {
    }

    protected Node exitContainedTypeConstraint(Production node) throws ParseException {
        return node;
    }

    protected void childContainedTypeConstraint(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterInnerTypeConstraint(Production node) throws ParseException {
    }

    protected Node exitInnerTypeConstraint(Production node) throws ParseException {
        return node;
    }

    protected void childInnerTypeConstraint(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterComponentsList(Production node) throws ParseException {
    }

    protected Node exitComponentsList(Production node) throws ParseException {
        return node;
    }

    protected void childComponentsList(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterComponentsListTail(Production node) throws ParseException {
    }

    protected Node exitComponentsListTail(Production node) throws ParseException {
        return node;
    }

    protected void childComponentsListTail(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterComponentConstraint(Production node) throws ParseException {
    }

    protected Node exitComponentConstraint(Production node) throws ParseException {
        return node;
    }

    protected void childComponentConstraint(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterComponentValuePresence(Production node) throws ParseException {
    }

    protected Node exitComponentValuePresence(Production node) throws ParseException {
        return node;
    }

    protected void childComponentValuePresence(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterComponentPresence(Production node) throws ParseException {
    }

    protected Node exitComponentPresence(Production node) throws ParseException {
        return node;
    }

    protected void childComponentPresence(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterValueAssignment(Production node) throws ParseException {
    }

    protected Node exitValueAssignment(Production node) throws ParseException {
        return node;
    }

    protected void childValueAssignment(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterValue(Production node) throws ParseException {
    }

    protected Node exitValue(Production node) throws ParseException {
        return node;
    }

    protected void childValue(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterDefinedValue(Production node) throws ParseException {
    }

    protected Node exitDefinedValue(Production node) throws ParseException {
        return node;
    }

    protected void childDefinedValue(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterBuiltinValue(Production node) throws ParseException {
    }

    protected Node exitBuiltinValue(Production node) throws ParseException {
        return node;
    }

    protected void childBuiltinValue(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterNullValue(Production node) throws ParseException {
    }

    protected Node exitNullValue(Production node) throws ParseException {
        return node;
    }

    protected void childNullValue(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterBooleanValue(Production node) throws ParseException {
    }

    protected Node exitBooleanValue(Production node) throws ParseException {
        return node;
    }

    protected void childBooleanValue(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSpecialRealValue(Production node) throws ParseException {
    }

    protected Node exitSpecialRealValue(Production node) throws ParseException {
        return node;
    }

    protected void childSpecialRealValue(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterNumberValue(Production node) throws ParseException {
    }

    protected Node exitNumberValue(Production node) throws ParseException {
        return node;
    }

    protected void childNumberValue(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterBinaryValue(Production node) throws ParseException {
    }

    protected Node exitBinaryValue(Production node) throws ParseException {
        return node;
    }

    protected void childBinaryValue(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterHexadecimalValue(Production node) throws ParseException {
    }

    protected Node exitHexadecimalValue(Production node) throws ParseException {
        return node;
    }

    protected void childHexadecimalValue(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterStringValue(Production node) throws ParseException {
    }

    protected Node exitStringValue(Production node) throws ParseException {
        return node;
    }

    protected void childStringValue(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterBitOrObjectIdentifierValue(Production node) throws ParseException {
    }

    protected Node exitBitOrObjectIdentifierValue(Production node) throws ParseException {
        return node;
    }

    protected void childBitOrObjectIdentifierValue(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterBitValue(Production node) throws ParseException {
    }

    protected Node exitBitValue(Production node) throws ParseException {
        return node;
    }

    protected void childBitValue(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterObjectIdentifierValue(Production node) throws ParseException {
    }

    protected Node exitObjectIdentifierValue(Production node) throws ParseException {
        return node;
    }

    protected void childObjectIdentifierValue(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterNameValueList(Production node) throws ParseException {
    }

    protected Node exitNameValueList(Production node) throws ParseException {
        return node;
    }

    protected void childNameValueList(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterNameValueComponent(Production node) throws ParseException {
    }

    protected Node exitNameValueComponent(Production node) throws ParseException {
        return node;
    }

    protected void childNameValueComponent(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterNameOrNumber(Production node) throws ParseException {
    }

    protected Node exitNameOrNumber(Production node) throws ParseException {
        return node;
    }

    protected void childNameOrNumber(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterNameAndNumber(Production node) throws ParseException {
    }

    protected Node exitNameAndNumber(Production node) throws ParseException {
        return node;
    }

    protected void childNameAndNumber(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterDefinedMacroType(Production node) throws ParseException {
    }

    protected Node exitDefinedMacroType(Production node) throws ParseException {
        return node;
    }

    protected void childDefinedMacroType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterDefinedMacroName(Production node) throws ParseException {
    }

    protected Node exitDefinedMacroName(Production node) throws ParseException {
        return node;
    }

    protected void childDefinedMacroName(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpModuleIdentityMacroType(Production node) throws ParseException {
    }

    protected Node exitSnmpModuleIdentityMacroType(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpModuleIdentityMacroType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpObjectIdentityMacroType(Production node) throws ParseException {
    }

    protected Node exitSnmpObjectIdentityMacroType(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpObjectIdentityMacroType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpObjectTypeMacroType(Production node) throws ParseException {
    }

    protected Node exitSnmpObjectTypeMacroType(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpObjectTypeMacroType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpNotificationTypeMacroType(Production node) throws ParseException {
    }

    protected Node exitSnmpNotificationTypeMacroType(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpNotificationTypeMacroType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpTrapTypeMacroType(Production node) throws ParseException {
    }

    protected Node exitSnmpTrapTypeMacroType(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpTrapTypeMacroType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpTextualConventionMacroType(Production node) throws ParseException {
    }

    protected Node exitSnmpTextualConventionMacroType(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpTextualConventionMacroType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpObjectGroupMacroType(Production node) throws ParseException {
    }

    protected Node exitSnmpObjectGroupMacroType(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpObjectGroupMacroType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpNotificationGroupMacroType(Production node) throws ParseException {
    }

    protected Node exitSnmpNotificationGroupMacroType(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpNotificationGroupMacroType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpModuleComplianceMacroType(Production node) throws ParseException {
    }

    protected Node exitSnmpModuleComplianceMacroType(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpModuleComplianceMacroType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpAgentCapabilitiesMacroType(Production node) throws ParseException {
    }

    protected Node exitSnmpAgentCapabilitiesMacroType(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpAgentCapabilitiesMacroType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpUpdatePart(Production node) throws ParseException {
    }

    protected Node exitSnmpUpdatePart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpUpdatePart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpOrganizationPart(Production node) throws ParseException {
    }

    protected Node exitSnmpOrganizationPart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpOrganizationPart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpContactPart(Production node) throws ParseException {
    }

    protected Node exitSnmpContactPart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpContactPart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpDescrPart(Production node) throws ParseException {
    }

    protected Node exitSnmpDescrPart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpDescrPart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpRevisionPart(Production node) throws ParseException {
    }

    protected Node exitSnmpRevisionPart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpRevisionPart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpStatusPart(Production node) throws ParseException {
    }

    protected Node exitSnmpStatusPart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpStatusPart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpReferPart(Production node) throws ParseException {
    }

    protected Node exitSnmpReferPart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpReferPart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpSyntaxPart(Production node) throws ParseException {
    }

    protected Node exitSnmpSyntaxPart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpSyntaxPart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpUnitsPart(Production node) throws ParseException {
    }

    protected Node exitSnmpUnitsPart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpUnitsPart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpAccessPart(Production node) throws ParseException {
    }

    protected Node exitSnmpAccessPart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpAccessPart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpIndexPart(Production node) throws ParseException {
    }

    protected Node exitSnmpIndexPart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpIndexPart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterIndexValueList(Production node) throws ParseException {
    }

    protected Node exitIndexValueList(Production node) throws ParseException {
        return node;
    }

    protected void childIndexValueList(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterIndexValue(Production node) throws ParseException {
    }

    protected Node exitIndexValue(Production node) throws ParseException {
        return node;
    }

    protected void childIndexValue(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterIndexType(Production node) throws ParseException {
    }

    protected Node exitIndexType(Production node) throws ParseException {
        return node;
    }

    protected void childIndexType(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpDefValPart(Production node) throws ParseException {
    }

    protected Node exitSnmpDefValPart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpDefValPart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpObjectsPart(Production node) throws ParseException {
    }

    protected Node exitSnmpObjectsPart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpObjectsPart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterValueList(Production node) throws ParseException {
    }

    protected Node exitValueList(Production node) throws ParseException {
        return node;
    }

    protected void childValueList(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpEnterprisePart(Production node) throws ParseException {
    }

    protected Node exitSnmpEnterprisePart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpEnterprisePart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpVarPart(Production node) throws ParseException {
    }

    protected Node exitSnmpVarPart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpVarPart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpDisplayPart(Production node) throws ParseException {
    }

    protected Node exitSnmpDisplayPart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpDisplayPart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpNotificationsPart(Production node) throws ParseException {
    }

    protected Node exitSnmpNotificationsPart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpNotificationsPart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpModulePart(Production node) throws ParseException {
    }

    protected Node exitSnmpModulePart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpModulePart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpModuleImport(Production node) throws ParseException {
    }

    protected Node exitSnmpModuleImport(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpModuleImport(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpMandatoryPart(Production node) throws ParseException {
    }

    protected Node exitSnmpMandatoryPart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpMandatoryPart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpCompliancePart(Production node) throws ParseException {
    }

    protected Node exitSnmpCompliancePart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpCompliancePart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterComplianceGroup(Production node) throws ParseException {
    }

    protected Node exitComplianceGroup(Production node) throws ParseException {
        return node;
    }

    protected void childComplianceGroup(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterComplianceObject(Production node) throws ParseException {
    }

    protected Node exitComplianceObject(Production node) throws ParseException {
        return node;
    }

    protected void childComplianceObject(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpWriteSyntaxPart(Production node) throws ParseException {
    }

    protected Node exitSnmpWriteSyntaxPart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpWriteSyntaxPart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpProductReleasePart(Production node) throws ParseException {
    }

    protected Node exitSnmpProductReleasePart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpProductReleasePart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpModuleSupportPart(Production node) throws ParseException {
    }

    protected Node exitSnmpModuleSupportPart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpModuleSupportPart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpVariationPart(Production node) throws ParseException {
    }

    protected Node exitSnmpVariationPart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpVariationPart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    protected void enterSnmpCreationPart(Production node) throws ParseException {
    }

    protected Node exitSnmpCreationPart(Production node) throws ParseException {
        return node;
    }

    protected void childSnmpCreationPart(Production node, Node child) throws ParseException {
        node.addChild(child);
    }

    private void pad(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("  ");
        }
    }

    private String asnToString(int code) {
        switch (code) {
            case 1001: {
                return "DOT";
            }
            case 1002: {
                return "DOUBLE_DOT";
            }
            case 1003: {
                return "TRIPLE_DOT";
            }
            case 1004: {
                return "COMMA";
            }
            case 1005: {
                return "SEMI_COLON";
            }
            case 1006: {
                return "LEFT_PAREN";
            }
            case 1007: {
                return "RIGHT_PAREN";
            }
            case 1008: {
                return "LEFT_BRACE";
            }
            case 1009: {
                return "RIGHT_BRACE";
            }
            case 1010: {
                return "LEFT_BRACKET";
            }
            case 1011: {
                return "RIGHT_BRACKET";
            }
            case 1012: {
                return "MINUS";
            }
            case 1013: {
                return "LESS_THAN";
            }
            case 1014: {
                return "VERTICAL_BAR";
            }
            case 1015: {
                return "DEFINITION";
            }
            case 1016: {
                return "DEFINITIONS";
            }
            case 1017: {
                return "EXPLICIT";
            }
            case 1018: {
                return "IMPLICIT";
            }
            case 1019: {
                return "TAGS";
            }
            case 1020: {
                return "BEGIN";
            }
            case 1021: {
                return "END";
            }
            case 1022: {
                return "EXPORTS";
            }
            case 1023: {
                return "IMPORTS";
            }
            case 1024: {
                return "FROM";
            }
            case 1025: {
                return "MACRO";
            }
            case 1026: {
                return "INTEGER";
            }
            case 1027: {
                return "REAL";
            }
            case 1028: {
                return "BOOLEAN";
            }
            case 1029: {
                return "NULL";
            }
            case 1030: {
                return "BIT";
            }
            case 1031: {
                return "OCTET";
            }
            case 1032: {
                return "STRING";
            }
            case 1033: {
                return "ENUMERATED";
            }
            case 1034: {
                return "SEQUENCE";
            }
            case 1035: {
                return "SET";
            }
            case 1036: {
                return "OF";
            }
            case 1037: {
                return "CHOICE";
            }
            case 1038: {
                return "UNIVERSAL";
            }
            case 1039: {
                return "APPLICATION";
            }
            case 1040: {
                return "PRIVATE";
            }
            case 1041: {
                return "ANY";
            }
            case 1042: {
                return "DEFINED";
            }
            case 1043: {
                return "BY";
            }
            case 1044: {
                return "OBJECT";
            }
            case 1045: {
                return "IDENTIFIER";
            }
            case 1046: {
                return "INCLUDES";
            }
            case 1047: {
                return "MIN";
            }
            case 1048: {
                return "MAX";
            }
            case 1050: {
                return "WITH";
            }
            case 1051: {
                return "COMPONENT";
            }
            case 1052: {
                return "COMPONENTS";
            }
            case 1053: {
                return "PRESENT";
            }
            case 1054: {
                return "ABSENT";
            }
            case 1055: {
                return "OPTIONAL";
            }
            case 1056: {
                return "DEFAULT";
            }
            case 1057: {
                return "TRUE";
            }
            case 1058: {
                return "FALSE";
            }
            case 1059: {
                return "PLUS_INFINITY";
            }
            case 1060: {
                return "MINUS_INFINITY";
            }
            case 1061: {
                return "MODULE_IDENTITY";
            }
            case 1062: {
                return "OBJECT_IDENTITY";
            }
            case 1063: {
                return "OBJECT_TYPE";
            }
            case 1064: {
                return "NOTIFICATION_TYPE";
            }
            case 1065: {
                return "TRAP_TYPE";
            }
            case 1066: {
                return "TEXTUAL_CONVENTION";
            }
            case 1067: {
                return "OBJECT_GROUP";
            }
            case 1068: {
                return "NOTIFICATION_GROUP";
            }
            case 1069: {
                return "MODULE_COMPLIANCE";
            }
            case 1070: {
                return "AGENT_CAPABILITIES";
            }
            case 1071: {
                return "LAST_UPDATED";
            }
            case 1073: {
                return "CONTACT_INFO";
            }
            case 1074: {
                return "DESCRIPTION";
            }
            case 1075: {
                return "REVISION";
            }
            case 1076: {
                return "STATUS";
            }
            case 1077: {
                return "REFERENCE";
            }
            case 1078: {
                return "SYNTAX";
            }
            case 1079: {
                return "BITS";
            }
            case 1080: {
                return "UNITS";
            }
            case 1081: {
                return "ACCESS";
            }
            case 1082: {
                return "MAX_ACCESS";
            }
            case 1083: {
                return "MIN_ACCESS";
            }
            case 1084: {
                return "INDEX";
            }
            case 1085: {
                return "AUGMENTS";
            }
            case 1086: {
                return "IMPLIED";
            }
            case 1087: {
                return "DEFVAL";
            }
            case 1088: {
                return "OBJECTS";
            }
            case 1089: {
                return "ENTERPRISE";
            }
            case 1090: {
                return "VARIABLES";
            }
            case 1091: {
                return "DISPLAY_HINT";
            }
            case 1092: {
                return "NOTIFICATIONS";
            }
            case 1093: {
                return "MODULE";
            }
            case 1094: {
                return "MANDATORY_GROUPS";
            }
            case 1095: {
                return "GROUP";
            }
            case 1096: {
                return "WRITE_SYNTAX";
            }
            case 1097: {
                return "PRODUCT_RELEASE";
            }
            case 1098: {
                return "SUPPORTS";
            }
            case 1099: {
                return "VARIATION";
            }
            case 1100: {
                return "CREATION_REQUIRES";
            }
            case 1101: {
                return "BINARY_STRING";
            }
            case 1102: {
                return "HEXADECIMAL_STRING";
            }
            case 1103: {
                return "QUOTED_STRING";
            }
            case 1104: {
                return "IDENTIFIER_STRING";
            }
            case 1105: {
                return "NUMBER_STRING";
            }
            case 1106: {
                return "WHITESPACE";
            }
            case 1107: {
                return "COMMENT";
            }
            case 2001: {
                return "START";
            }
            case 2002: {
                return "MODULE_DEFINITION";
            }
            case 2003: {
                return "MODULE_IDENTIFIER";
            }
            case 2004: {
                return "MODULE_REFERENCE";
            }
            case 2005: {
                return "TAG_DEFAULT";
            }
            case 2006: {
                return "MODULE_BODY";
            }
            case 2007: {
                return "EXPORT_LIST";
            }
            case 2008: {
                return "IMPORT_LIST";
            }
            case 2009: {
                return "SYMBOLS_FROM_MODULE";
            }
            case 2010: {
                return "SYMBOL_LIST";
            }
            case 2011: {
                return "SYMBOL";
            }
            case 2012: {
                return "ASSIGNMENT_LIST";
            }
            case 2013: {
                return "ASSIGNMENT";
            }
            case 2014: {
                return "MACRO_DEFINITION";
            }
            case 2015: {
                return "MACRO_REFERENCE";
            }
            case 2016: {
                return "MACRO_BODY";
            }
            case 2017: {
                return "MACRO_BODY_ELEMENT";
            }
            case 2018: {
                return "TYPE_ASSIGNMENT";
            }
            case 2019: {
                return "TYPE";
            }
            case 2020: {
                return "DEFINED_TYPE";
            }
            case 2021: {
                return "BUILTIN_TYPE";
            }
            case 2022: {
                return "NULL_TYPE";
            }
            case 2023: {
                return "BOOLEAN_TYPE";
            }
            case 2024: {
                return "REAL_TYPE";
            }
            case 2025: {
                return "INTEGER_TYPE";
            }
            case 2026: {
                return "OBJECT_IDENTIFIER_TYPE";
            }
            case 2027: {
                return "STRING_TYPE";
            }
            case 2028: {
                return "BIT_STRING_TYPE";
            }
            case 2029: {
                return "BITS_TYPE";
            }
            case 2030: {
                return "SEQUENCE_TYPE";
            }
            case 2031: {
                return "SEQUENCE_OF_TYPE";
            }
            case 2032: {
                return "SET_TYPE";
            }
            case 2033: {
                return "SET_OF_TYPE";
            }
            case 2034: {
                return "CHOICE_TYPE";
            }
            case 2035: {
                return "ENUMERATED_TYPE";
            }
            case 2036: {
                return "SELECTION_TYPE";
            }
            case 2037: {
                return "TAGGED_TYPE";
            }
            case 2038: {
                return "TAG";
            }
            case 2039: {
                return "CLASS";
            }
            case 2040: {
                return "EXPLICIT_OR_IMPLICIT_TAG";
            }
            case 2041: {
                return "ANY_TYPE";
            }
            case 2042: {
                return "ELEMENT_TYPE_LIST";
            }
            case 2043: {
                return "ELEMENT_TYPE";
            }
            case 2044: {
                return "OPTIONAL_OR_DEFAULT_ELEMENT";
            }
            case 2045: {
                return "VALUE_OR_CONSTRAINT_LIST";
            }
            case 2046: {
                return "NAMED_NUMBER_LIST";
            }
            case 2047: {
                return "NAMED_NUMBER";
            }
            case 2048: {
                return "NUMBER";
            }
            case 2049: {
                return "CONSTRAINT_LIST";
            }
            case 2050: {
                return "CONSTRAINT";
            }
            case 2051: {
                return "VALUE_CONSTRAINT_LIST";
            }
            case 2052: {
                return "VALUE_CONSTRAINT";
            }
            case 2053: {
                return "VALUE_RANGE";
            }
            case 2054: {
                return "LOWER_END_POINT";
            }
            case 2055: {
                return "UPPER_END_POINT";
            }
            case 2057: {
                return "ALPHABET_CONSTRAINT";
            }
            case 2058: {
                return "CONTAINED_TYPE_CONSTRAINT";
            }
            case 2059: {
                return "INNER_TYPE_CONSTRAINT";
            }
            case 2060: {
                return "COMPONENTS_LIST";
            }
            case 2061: {
                return "COMPONENTS_LIST_TAIL";
            }
            case 2062: {
                return "COMPONENT_CONSTRAINT";
            }
            case 2063: {
                return "COMPONENT_VALUE_PRESENCE";
            }
            case 2064: {
                return "COMPONENT_PRESENCE";
            }
            case 2065: {
                return "VALUE_ASSIGNMENT";
            }
            case 2066: {
                return "VALUE";
            }
            case 2067: {
                return "DEFINED_VALUE";
            }
            case 2068: {
                return "BUILTIN_VALUE";
            }
            case 2069: {
                return "NULL_VALUE";
            }
            case 2070: {
                return "BOOLEAN_VALUE";
            }
            case 2071: {
                return "SPECIAL_REAL_VALUE";
            }
            case 2072: {
                return "NUMBER_VALUE";
            }
            case 2073: {
                return "BINARY_VALUE";
            }
            case 2074: {
                return "HEXADECIMAL_VALUE";
            }
            case 2075: {
                return "STRING_VALUE";
            }
            case 2076: {
                return "BIT_OR_OBJECT_IDENTIFIER_VALUE";
            }
            case 2077: {
                return "BIT_VALUE";
            }
            case 2078: {
                return "OBJECT_IDENTIFIER_VALUE";
            }
            case 2079: {
                return "NAME_VALUE_LIST";
            }
            case 2080: {
                return "NAME_VALUE_COMPONENT";
            }
            case 2081: {
                return "NAME_OR_NUMBER";
            }
            case 2082: {
                return "NAME_AND_NUMBER";
            }
            case 2083: {
                return "DEFINED_MACRO_TYPE";
            }
            case 2084: {
                return "DEFINED_MACRO_NAME";
            }
            case 2085: {
                return "SNMP_MODULE_IDENTITY_MACRO_TYPE";
            }
            case 2086: {
                return "SNMP_OBJECT_IDENTITY_MACRO_TYPE";
            }
            case 2087: {
                return "SNMP_OBJECT_TYPE_MACRO_TYPE";
            }
            case 2088: {
                return "SNMP_NOTIFICATION_TYPE_MACRO_TYPE";
            }
            case 2089: {
                return "SNMP_TRAP_TYPE_MACRO_TYPE";
            }
            case 2090: {
                return "SNMP_TEXTUAL_CONVENTION_MACRO_TYPE";
            }
            case 2091: {
                return "SNMP_OBJECT_GROUP_MACRO_TYPE";
            }
            case 2092: {
                return "SNMP_NOTIFICATION_GROUP_MACRO_TYPE";
            }
            case 2093: {
                return "SNMP_MODULE_COMPLIANCE_MACRO_TYPE";
            }
            case 2094: {
                return "SNMP_AGENT_CAPABILITIES_MACRO_TYPE";
            }
            case 2095: {
                return "SNMP_UPDATE_PART";
            }
            case 2097: {
                return "SNMP_CONTACT_PART";
            }
            case 2098: {
                return "SNMP_DESCR_PART";
            }
            case 2099: {
                return "SNMP_REVISION_PART";
            }
            case 2100: {
                return "SNMP_STATUS_PART";
            }
            case 2101: {
                return "SNMP_REFER_PART";
            }
            case 2102: {
                return "SNMP_SYNTAX_PART";
            }
            case 2103: {
                return "SNMP_UNITS_PART";
            }
            case 2104: {
                return "SNMP_ACCESS_PART";
            }
            case 2105: {
                return "SNMP_INDEX_PART";
            }
            case 2106: {
                return "INDEX_VALUE_LIST";
            }
            case 2107: {
                return "INDEX_VALUE";
            }
            case 2108: {
                return "INDEX_TYPE";
            }
            case 2109: {
                return "SNMP_DEF_VAL_PART";
            }
            case 2110: {
                return "SNMP_OBJECTS_PART";
            }
            case 2111: {
                return "VALUE_LIST";
            }
            case 2112: {
                return "SNMP_ENTERPRISE_PART";
            }
            case 2113: {
                return "SNMP_VAR_PART";
            }
            case 2114: {
                return "SNMP_DISPLAY_PART";
            }
            case 2115: {
                return "SNMP_NOTIFICATIONS_PART";
            }
            case 2116: {
                return "SNMP_MODULE_PART";
            }
            case 2117: {
                return "SNMP_MODULE_IMPORT";
            }
            case 2118: {
                return "SNMP_MANDATORY_PART";
            }
            case 2119: {
                return "SNMP_COMPLIANCE_PART";
            }
            case 2120: {
                return "COMPLIANCE_GROUP";
            }
            case 2121: {
                return "COMPLIANCE_OBJECT";
            }
            case 2122: {
                return "SNMP_WRITE_SYNTAX_PART";
            }
            case 2123: {
                return "SNMP_PRODUCT_RELEASE_PART";
            }
            case 2124: {
                return "SNMP_MODULE_SUPPORT_PART";
            }
            case 2125: {
                return "SNMP_VARIATION_PART";
            }
            case 2126: {
                return "SNMP_CREATION_PART";
            }
        }
        return Integer.toString(code);
    }
}

