/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpRevision;
import net.percederberg.mibble.snmp.SnmpType;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class SnmpModuleIdentity
extends SnmpType {
    private String lastUpdated;
    private String organization;
    private String contactInfo;
    private ArrayList revisions;

    public SnmpModuleIdentity(String lastUpdated, String organization, String contactInfo, String description, ArrayList revisions) {
        super("MODULE-IDENTITY", description);
        this.lastUpdated = lastUpdated;
        this.organization = organization;
        this.contactInfo = contactInfo;
        this.revisions = revisions;
    }

    @Override
    public MibType initialize(MibSymbol symbol, MibLoaderLog log) throws MibException {
        if (!(symbol instanceof MibValueSymbol)) {
            throw new MibException(symbol.getLocation(), "only values can have the " + this.getName() + " type");
        }
        for (int i = 0; i < this.revisions.size(); ++i) {
            SnmpRevision rev = (SnmpRevision)this.revisions.get(i);
            rev.initialize(log);
        }
        return this;
    }

    @Override
    public boolean isCompatible(MibValue value) {
        return value instanceof ObjectIdentifierValue;
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getContactInfo() {
        return SnmpModuleIdentity.removeIndent(this.contactInfo);
    }

    public String getUnformattedContactInfo() {
        return this.contactInfo;
    }

    public ArrayList getRevisions() {
        return this.revisions;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append(" (");
        buffer.append("\n  Last Updated: ");
        buffer.append(this.lastUpdated);
        buffer.append("\n  Organization: ");
        buffer.append(this.organization);
        buffer.append("\n  Contact Info: ");
        buffer.append(this.contactInfo);
        buffer.append("\n  Description: ");
        buffer.append(this.getDescription("               "));
        for (int i = 0; i < this.revisions.size(); ++i) {
            buffer.append("\n  Revision: ");
            buffer.append(this.revisions.get(i));
        }
        buffer.append("\n)");
        return buffer.toString();
    }
}

