/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.type.SizeConstraint;
import net.percederberg.mibble.type.StringType;

public class NumberValue
extends MibValue {
    private Number value;

    public NumberValue(Number value) {
        super("Number");
        this.value = value;
    }

    @Override
    public MibValue initialize(MibLoaderLog log, MibType type) {
        return this;
    }

    @Override
    public MibValue createReference() {
        return new NumberValue(this.value);
    }

    public int compareTo(Object obj) {
        if (obj instanceof NumberValue) {
            return this.compareToNumber(((NumberValue)obj).value);
        }
        if (obj instanceof Number) {
            return this.compareToNumber((Number)obj);
        }
        return this.toString().compareTo(obj.toString());
    }

    private int compareToNumber(Number num) {
        if (this.value instanceof Integer && num instanceof Integer) {
            return ((Integer)this.value).compareTo((Integer)num);
        }
        if (this.value instanceof Long && num instanceof Long) {
            return ((Long)this.value).compareTo((Long)num);
        }
        if (this.value instanceof BigInteger && num instanceof BigInteger) {
            return ((BigInteger)this.value).compareTo((BigInteger)num);
        }
        BigDecimal num1 = new BigDecimal(this.value.toString());
        BigDecimal num2 = new BigDecimal(num.toString());
        return num1.compareTo(num2);
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public Object toObject() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    protected int getByteSize(MibType type, int initialBytes) {
        Constraint c = null;
        int res = -1;
        if (type instanceof StringType) {
            c = ((StringType)type).getConstraint();
        }
        if (c instanceof SizeConstraint) {
            res = ((SizeConstraint)c).nextValue(initialBytes);
        }
        if (res < 0) {
            res = 1;
        }
        return res;
    }
}

