/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.ui.terminal;

import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.comm.BInfinityLine;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.ui.terminal.InfinityVt100TextController;
import com.tridium.andoverInfinity.ui.terminal.InfinityVt100TextModel;
import com.tridium.andoverInfinity.ui.terminal.InfinityVt100TextParser;
import com.tridium.util.EscUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.space.BSpace;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.text.TextParser;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"andoverInfinity:InfinityNetwork"})})
public class BInfinityVirtualTerminal
extends BWbComponentView
implements Vt100Const {
    @Generated
    public static final Type TYPE = Sys.loadType(BInfinityVirtualTerminal.class);
    boolean alive = false;
    boolean bufferChanged = false;
    BufferMonitor bufferMonitor;
    Thread bufMonThread;
    static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BInfinityVirtualTerminal.class);
    BTextEditorPane console;
    StartConsole cmdStartConsole = new StartConsole((BWidget)this);
    StopConsole cmdStopConsole = new StopConsole((BWidget)this);
    RestoreCommand cmdRestore = new RestoreCommand((BWidget)this);
    BackupCommand cmdBackup = new BackupCommand((BWidget)this);
    AbortCommand cmdAbort = new AbortCommand((BWidget)this);
    BInfinityNetwork net;
    String[] lines = new String[24];
    String[] lineFormats = new String[24];
    InfinityVt100TextController controller;
    InfinityVt100TextModel model;
    static BOrd backupDir = null;
    static BOrd backupFile = null;
    Position caretPosition = new Position(0, 0);
    private static final Logger LOG = Logger.getLogger("andoverInfinity.virtualTerminal");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BInfinityVirtualTerminal() {
        for (int i = 0; i < 24; ++i) {
            this.lines[i] = "                                                                                ";
            this.lineFormats[i] = "NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN";
        }
        this.console = new BTextEditorPane("", 24, 80, false);
        this.console.setBorderPolicy(BScrollBarPolicy.always);
        this.controller = new InfinityVt100TextController(this);
        this.model = new InfinityVt100TextModel();
        this.console.getEditor().setController((TextController)this.controller);
        this.console.getEditor().setModel((TextModel)this.model);
        this.console.getEditor().setParser((TextParser)new InfinityVt100TextParser());
        this.console.getEditor().getOptions().getColorCoding().setForeground(BColor.black);
        this.console.getEditor().getOptions().getColorCoding().setKeyword(BColor.cornflowerBlue);
        this.console.getEditor().getOptions().getColorCoding().setNumberLiteral(BColor.white);
        this.console.getEditor().getOptions().getColorCoding().setBracket(BColor.darkGrey);
        this.setTransferWidget((BTransferWidget)this.console.getEditor());
        BGridPane buttonPane = new BGridPane();
        buttonPane.setColumnCount(5);
        buttonPane.add(null, (BValue)new BButton((Command)this.cmdStartConsole));
        buttonPane.add(null, (BValue)new BButton((Command)this.cmdStopConsole));
        buttonPane.add(null, (BValue)new BButton((Command)this.cmdBackup));
        buttonPane.add(null, (BValue)new BButton((Command)this.cmdRestore));
        buttonPane.add(null, (BValue)new BButton((Command)this.cmdAbort));
        this.cmdStartConsole.setEnabled(true);
        this.cmdStopConsole.setEnabled(false);
        this.cmdBackup.setEnabled(true);
        this.cmdRestore.setEnabled(true);
        this.cmdAbort.setEnabled(false);
        BBorderPane borderPane = new BBorderPane((BWidget)this.console, new BLabel("Infinity VT100 Terminal Interface", BFont.make((String)"bold italic 20pt Times New Roman")), BBorder.DEFAULT);
        BEdgePane edge = new BEdgePane();
        edge.setCenter((BWidget)borderPane);
        edge.setBottom((BWidget)new BBorderPane((BWidget)buttonPane, 10.0, 0.0, 0.0, 0.0));
        this.setContent((BWidget)edge);
        this.registerForComponentEvents((BComponent)this.console);
    }

    public void doLoadValue(BObject object, Context cx) {
        this.net = (BInfinityNetwork)object;
        this.registerForComponentEvents((BComponent)this.net);
        this.net.refresh();
        this.console.getEditor().setCaretBlinking(true);
        if (this.bufferMonitor == null) {
            this.bufferMonitor = new BufferMonitor();
        }
        this.bufMonThread = new Thread((Runnable)this.bufferMonitor, "infinBufMon");
        this.alive = true;
        this.bufMonThread.start();
        this.console.getEditor().requestFocus();
    }

    public void deactivated() {
        if (this.cmdStopConsole.isEnabled()) {
            try {
                this.cmdStopConsole.doInvoke();
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.WARNING, "Failed to stop console", e);
                }
                LOG.log(Level.WARNING, "Failed to stop console: " + e.getMessage());
            }
        }
        if (this.console != null) {
            this.console.getEditor().setCaretBlinking(false);
        }
        this.alive = false;
        if (this.bufMonThread != null) {
            this.bufMonThread.interrupt();
            this.bufMonThread = null;
        }
    }

    public void exec(String cmd) {
        cmd = cmd.replace('\n', '\r');
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("exec: `" + ByteArrayUtil.toHexString((byte[])cmd.getBytes(StandardCharsets.UTF_8)) + "`");
        }
        try {
            if (this.net != null) {
                this.net.keystrokesCommand(BString.make((String)cmd));
            }
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.WARNING, "Failed to exec command `" + cmd + "`", e);
            }
            LOG.log(Level.WARNING, "Failed to exec command `" + cmd + "`: " + e.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void handleComponentEvent(BComponentEvent event) {
        block28: {
            super.handleComponentEvent(event);
            if (event.getSourceComponent() != this.net || event.getId() != 5) break block28;
            var2_2 = event.getSlotName();
            var3_3 = -1;
            switch (var2_2.hashCode()) {
                case 1849311143: {
                    if (!var2_2.equals("backupModeDone")) break;
                    var3_3 = 0;
                    break;
                }
                case -704478082: {
                    if (!var2_2.equals("reloadModeDone")) break;
                    var3_3 = 1;
                    break;
                }
                case -1334746465: {
                    if (!var2_2.equals("terminalUpdated")) break;
                    var3_3 = 2;
                }
            }
            switch (var3_3) {
                case 0: {
                    backupBlob = null;
                    if (event.getValue() instanceof BBlob) {
                        backupBlob = (BBlob)event.getValue();
                    }
                    if (backupBlob == null) ** GOTO lbl55
                    fileBytes = backupBlob.copyBytes();
                    if (BInfinityVirtualTerminal.LOG.isLoggable(Level.FINEST)) {
                        BInfinityVirtualTerminal.LOG.finest("blob size is " + fileBytes.length);
                        BInfinityVirtualTerminal.LOG.finest(new String(fileBytes));
                    }
                    fs = BFileSystem.INSTANCE;
                    try {
                        tmpFile = fs.makeFile(BInfinityVirtualTerminal.toFilePath(BInfinityVirtualTerminal.backupFile));
                        backupOutputStream = tmpFile.getOutputStream();
                        var9_12 = null;
                        try {
                            backupOutputStream.write(fileBytes);
                            ** GOTO lbl56
                        }
                        catch (Throwable var10_14) {
                            var9_12 = var10_14;
                            throw var10_14;
                        }
                        finally {
                            if (backupOutputStream != null) {
                                if (var9_12 != null) {
                                    try {
                                        backupOutputStream.close();
                                    }
                                    catch (Throwable var10_13) {
                                        var9_12.addSuppressed(var10_13);
                                    }
                                } else {
                                    backupOutputStream.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        if (!BInfinityVirtualTerminal.LOG.isLoggable(Level.FINE)) ** GOTO lbl53
                        BInfinityVirtualTerminal.LOG.log(Level.WARNING, "Failed to write backup file `" + BInfinityVirtualTerminal.backupFile + "`", e);
                        ** GOTO lbl56
lbl53:
                        // 1 sources

                        BInfinityVirtualTerminal.LOG.log(Level.WARNING, "Failed to write backup file `" + BInfinityVirtualTerminal.backupFile + "`: " + e.getMessage());
                    }
                    ** GOTO lbl56
lbl55:
                    // 1 sources

                    BInfinityVirtualTerminal.LOG.warning("Backup blob is null");
lbl56:
                    // 4 sources

                    BInfinityVirtualTerminal.LOG.finest("backupModeDone");
                    this.setCommandsToNormal();
                    break;
                }
                case 1: {
                    BInfinityVirtualTerminal.LOG.finest("backupModeDone");
                    this.setCommandsToNormal();
                    break;
                }
                case 2: {
                    newLine = (BInfinityLine)event.getValue();
                    this.caretPosition = new Position(newLine.getNewLineNumber(), newLine.getNewColumnNumber());
                    try {
                        this.lines[newLine.getPreviousLineNumber()] = newLine.getLineText();
                        this.lineFormats[newLine.getPreviousLineNumber()] = newLine.getLineFormat();
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        this.lines[newLine.getPreviousLineNumber()] = newLine.getLineText().substring(0, 80);
                        this.lineFormats[newLine.getPreviousLineNumber()] = newLine.getLineFormat().substring(0, 80);
                    }
                    this.bufferChanged = true;
                }
            }
        }
    }

    protected void repaintBuffer() {
        this.model.setText(this.lines, this.lineFormats);
        this.console.getEditor().moveCaretPosition(this.caretPosition);
    }

    private void setCommandsToNormal() {
        this.cmdStartConsole.setEnabled(true);
        this.cmdStopConsole.setEnabled(false);
        this.cmdBackup.setEnabled(true);
        this.cmdRestore.setEnabled(true);
        this.cmdAbort.setEnabled(false);
    }

    public static FilePath toFilePath(BOrd ord) {
        OrdQuery[] q;
        for (OrdQuery ordQuery : q = ord.parse()) {
            if (!(ordQuery instanceof FilePath)) continue;
            return (FilePath)ordQuery;
        }
        throw new IllegalStateException();
    }

    public Position getCaretPosition() {
        return this.caretPosition;
    }

    final class BufferMonitor
    implements Runnable {
        BufferMonitor() {
        }

        @Override
        public void run() {
            BInfinityVirtualTerminal.this.alive = true;
            while (BInfinityVirtualTerminal.this.alive) {
                try {
                    if (BInfinityVirtualTerminal.this.bufferChanged) {
                        BInfinityVirtualTerminal.this.bufferChanged = false;
                        BInfinityVirtualTerminal.this.repaintBuffer();
                        continue;
                    }
                    Thread.sleep(100L);
                }
                catch (NullPointerException e) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.log(Level.FINE, "Failed to repaint buffer", e);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    class AbortCommand
    extends Command {
        AbortCommand(BWidget owner) {
            super(owner, (Lexicon)lexicon, "abortCommand");
        }

        public CommandArtifact doInvoke() {
            BInfinityVirtualTerminal.this.net.abortReload();
            return null;
        }
    }

    class RestoreCommand
    extends Command {
        RestoreCommand(BWidget owner) {
            super(owner, (Lexicon)lexicon, "restoreControllerCommand");
        }

        public CommandArtifact doInvoke() throws Exception {
            BufferedReader in;
            backupDir = BInfinityVirtualTerminal.this.net.getRestoreFile();
            if (backupDir == null) {
                FilePath dirPath = new FilePath("!infinity_backups");
                backupDir = BOrd.make((OrdQuery)dirPath);
            }
            BFileChooser chooser = BFileChooser.makeSave((BWidget)this.getOwner());
            chooser.setCurrentDirectory(backupDir);
            chooser.setConfirmOverwrite(false);
            chooser.addFilter((IFileFilter)new ExtFileFilter("dmp Files", new String[]{"txt", "TXT", "dmp", "DMP"}));
            BFileSystem space = BFileSystem.INSTANCE;
            chooser.setSpaces(new BSpace[]{space});
            BOrd ord = chooser.show();
            if (ord == null) {
                return null;
            }
            if (BInfinityVirtualTerminal.this.net.getComponentSpace() == null) {
                throw new BajaRuntimeException(BInfinityVirtualTerminal.this.net + " is not mounted in a Component Space");
            }
            BInfinityVirtualTerminal.this.net.getComponentSpace().sync();
            BInfinityVirtualTerminal.this.net.lease(2, 60000L);
            try {
                BIFile restoreFile = (BIFile)ord.resolve().get();
                ByteBuffer restoreByteBuffer = this.readFile(restoreFile);
                in = new BufferedReader(new InputStreamReader(restoreByteBuffer.getInputStream()));
            }
            catch (IOException | UnresolvedException ue) {
                return null;
            }
            BInfinityVirtualTerminal.this.net.setRestoreFile(ord);
            StringBuilder sb = this.removeUnneededLines(in);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Save to file: \n" + sb);
            }
            BFileSystem fs = BFileSystem.INSTANCE;
            FilePath fp = BInfinityVirtualTerminal.toFilePath(ord);
            BIFile massagedFile = fs.makeFile(new FilePath(fp.getBody() + ".scrubbed"));
            this.writeFile(massagedFile, sb.toString().getBytes());
            BBlob resultsBlob = BBlob.make((byte[])sb.toString().getBytes());
            BInfinityVirtualTerminal.this.net.reload(resultsBlob);
            BInfinityVirtualTerminal.this.cmdStartConsole.setEnabled(false);
            BInfinityVirtualTerminal.this.cmdStopConsole.setEnabled(false);
            BInfinityVirtualTerminal.this.cmdBackup.setEnabled(false);
            this.setEnabled(false);
            BInfinityVirtualTerminal.this.cmdAbort.setEnabled(true);
            return null;
        }

        private ByteBuffer readFile(BIFile file) throws IOException {
            try (InputStream restoreFileIn = file.getInputStream();){
                ByteBuffer restoreFileBytes = new ByteBuffer(restoreFileIn.available());
                restoreFileBytes.readToEnd(restoreFileIn);
                ByteBuffer byteBuffer = restoreFileBytes;
                return byteBuffer;
            }
        }

        private void writeFile(BIFile file, byte[] fileBytes) {
            try (OutputStream backupOutputStream = file.getOutputStream();){
                backupOutputStream.write(fileBytes);
            }
            catch (IOException e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.WARNING, "Failed to write file: `" + file.getFileName() + "`", e);
                }
                LOG.log(Level.WARNING, "Failed to write file: `" + file.getFileName() + "`: " + e.getMessage());
            }
        }

        private StringBuilder removeUnneededLines(BufferedReader in) throws Exception {
            StringBuilder results;
            block16: {
                results = new StringBuilder();
                try {
                    String newLine;
                    block2: while ((newLine = in.readLine()) != null) {
                        String sectionEnd;
                        StringTokenizer lineTokenizer;
                        if (newLine.length() == 0) {
                            results.append("\n");
                            continue;
                        }
                        if (newLine.charAt(0) == '\'' || (lineTokenizer = new StringTokenizer(newLine, ":")).countTokens() < 1) continue;
                        if (newLine.startsWith("EndOfReload")) {
                            results.append(newLine).append('\n');
                            break;
                        }
                        String sectionName = EscUtil.slot.escape(lineTokenizer.nextToken().trim());
                        String ignoreOrIncludeSection = lexicon.get("Section." + sectionName);
                        if (ignoreOrIncludeSection == null) {
                            throw new Exception("lexicon entry missing:Section." + sectionName);
                        }
                        if (ignoreOrIncludeSection.startsWith("Exclude")) {
                            sectionEnd = lexicon.get("Section." + sectionName + "End");
                            if (sectionEnd == null) {
                                throw new Exception("lexicon entry missing:Section." + sectionName + "End");
                            }
                            this.excludeSection(in, sectionName, sectionEnd);
                            continue;
                        }
                        results.append(newLine).append("\n");
                        sectionEnd = lexicon.get("Section." + sectionName + "End");
                        if (sectionEnd == null) {
                            throw new Exception("lexicon entry missing:Section." + sectionName + "End");
                        }
                        while (true) {
                            if ((newLine = in.readLine()).length() == 0) {
                                results.append("\n");
                                continue;
                            }
                            if (newLine.charAt(0) == '\'') continue;
                            if (newLine.trim().startsWith(sectionEnd)) {
                                results.append(newLine).append("\n");
                                continue block2;
                            }
                            StringTokenizer st = new StringTokenizer(newLine.trim(), ":");
                            if (!st.hasMoreTokens()) continue;
                            String token = EscUtil.slot.escape(st.nextToken().trim());
                            String ignoreOrInclude = lexicon.get(sectionName + "." + token);
                            if (LOG.isLoggable(Level.FINEST)) {
                                LOG.finest("removeUnneededLines: " + sectionName + "." + token + "=" + ignoreOrInclude);
                            }
                            if (ignoreOrInclude == null || !ignoreOrInclude.equalsIgnoreCase("Exclude")) {
                                results.append(newLine).append("\n");
                                if (!token.equalsIgnoreCase("Code")) continue;
                                while (true) {
                                    if ((newLine = in.readLine()).length() == 0) {
                                        results.append("\n");
                                        continue;
                                    }
                                    if (newLine.charAt(0) == '\'') continue;
                                    results.append(newLine).append("\n");
                                    if (newLine.trim().startsWith("EndCode")) break;
                                }
                                continue;
                            }
                            if (!token.equalsIgnoreCase("Code")) continue;
                            this.excludeSection(in, "Code", "EndCode");
                        }
                    }
                }
                catch (IOException e) {
                    if (!LOG.isLoggable(Level.FINE)) break block16;
                    LOG.log(Level.FINE, "Failed to remove unneeded lines", e);
                }
            }
            return results;
        }

        private void excludeSection(BufferedReader in, String sectionName, String sectionEnd) throws IOException {
            String newLine;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("excludeSection: " + sectionName + ">" + sectionEnd);
            }
            while (!(newLine = in.readLine().trim()).startsWith(sectionEnd)) {
            }
        }
    }

    class BackupCommand
    extends Command {
        BackupCommand(BWidget owner) {
            super(owner, (Lexicon)lexicon, "backupControllerCommand");
        }

        public CommandArtifact doInvoke() {
            backupDir = BInfinityVirtualTerminal.this.net.getRestoreFile();
            BFileChooser chooser = BFileChooser.makeSave((BWidget)this.getOwner());
            chooser.setCurrentDirectory(backupDir);
            chooser.addFilter((IFileFilter)new ExtFileFilter("dmp Files", new String[]{"txt", "TXT", "dmp", "DMP"}));
            BFileSystem space = BFileSystem.INSTANCE;
            chooser.setSpaces(new BSpace[]{space});
            BOrd ord = chooser.show();
            if (ord == null) {
                return null;
            }
            backupDir = chooser.getCurrentDirectory();
            backupFile = ord;
            BInfinityVirtualTerminal.this.net.backupModeActivate();
            BInfinityVirtualTerminal.this.cmdStopConsole.setEnabled(false);
            BInfinityVirtualTerminal.this.cmdStartConsole.setEnabled(false);
            BInfinityVirtualTerminal.this.cmdRestore.setEnabled(false);
            this.setEnabled(false);
            BInfinityVirtualTerminal.this.cmdAbort.setEnabled(true);
            BInfinityVirtualTerminal.this.net.setRestoreFile(ord);
            return null;
        }
    }

    class StopConsole
    extends Command {
        StopConsole(BWidget owner) {
            super(owner, (Lexicon)lexicon, "stopVirtualTerminal");
        }

        public CommandArtifact doInvoke() {
            BInfinityVirtualTerminal.this.net.setTerminalModeActive(BBoolean.FALSE);
            BInfinityVirtualTerminal.this.cmdStartConsole.setEnabled(true);
            this.setEnabled(false);
            BInfinityVirtualTerminal.this.cmdBackup.setEnabled(true);
            BInfinityVirtualTerminal.this.cmdRestore.setEnabled(true);
            BInfinityVirtualTerminal.this.cmdAbort.setEnabled(false);
            return null;
        }
    }

    class StartConsole
    extends Command {
        BWidget owner;

        StartConsole(BWidget owner) {
            super(owner, (Lexicon)lexicon, "startVirtualTerminal");
            this.owner = owner;
        }

        public CommandArtifact doInvoke() {
            BInfinityVirtualTerminal.this.net.setTerminalModeActive(BBoolean.TRUE);
            this.setEnabled(false);
            BInfinityVirtualTerminal.this.cmdStopConsole.setEnabled(true);
            BInfinityVirtualTerminal.this.cmdBackup.setEnabled(false);
            BInfinityVirtualTerminal.this.cmdRestore.setEnabled(false);
            BInfinityVirtualTerminal.this.cmdAbort.setEnabled(false);
            this.owner.requestFocus();
            return null;
        }
    }
}

