/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jetty;

import com.tridium.authn.BAuthenticationService;
import com.tridium.jetty.BJettyWebServer;
import com.tridium.jetty.NiagaraUserIdentity;
import com.tridium.session.AuditInfo;
import com.tridium.session.NiagaraSession;
import com.tridium.session.NiagaraSessionSupplier;
import com.tridium.web.CookieUtil;
import com.tridium.web.session.WebSessionUtil;
import java.util.logging.Logger;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.security.AuthenticationException;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.web.BWebService;
import javax.security.auth.callback.CallbackHandler;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.UserIdentity;

final class NiagaraLoginService
implements LoginService {
    private String name;
    private IdentityService idService;
    private static final Logger log = Logger.getLogger(BJettyWebServer.class.getName());

    NiagaraLoginService(String realm) {
        this.name = realm;
        this.idService = new DefaultIdentityService();
    }

    public String getName() {
        return this.name;
    }

    public UserIdentity login(String username, Object credentials, ServletRequest request) {
        if (username == null) {
            return null;
        }
        BUserService userService = BUserService.getService();
        CallbackHandler handler = (CallbackHandler)request.getAttribute("com.tridium.jetty.callbackHandler");
        BAuthenticationScheme scheme = (BAuthenticationScheme)request.getAttribute("com.tridium.jetty.authenticationScheme");
        BUser user = userService.getUser(username);
        try {
            BAuthenticationService authnService = BAuthenticationService.getService();
            user = authnService.authenticate((NiagaraSessionSupplier)new LoginNiagaraSessionSupplier((HttpServletRequest)request), user, handler, scheme);
        }
        catch (AuthenticationException e) {
            if (e.getLoginFailureCause() != null) {
                HttpServletResponse response = (HttpServletResponse)request.getAttribute("com.tridium.jetty.servletResponse");
                Cookie failureCauseCookie = CookieUtil.createCookie((String)"niagara_failure_cause", (String)e.getLoginFailureCause().name(), (int)-1);
                response.addCookie(failureCauseCookie);
            }
            log.info(e.toString() + ": most likely a username/password mismatch");
            return null;
        }
        return new NiagaraUserIdentity(user);
    }

    public boolean validate(UserIdentity user) {
        return true;
    }

    public IdentityService getIdentityService() {
        return this.idService;
    }

    public void setIdentityService(IdentityService service) {
        this.idService = service;
    }

    public void logout(UserIdentity user) {
    }

    private static class LoginNiagaraSessionSupplier
    implements NiagaraSessionSupplier {
        private NiagaraSession session;
        private final HttpServletRequest request;

        public LoginNiagaraSessionSupplier(HttpServletRequest request) {
            this.request = request;
            this.session = WebSessionUtil.getSession((HttpServletRequest)request, (boolean)false);
        }

        public NiagaraSession get(boolean create) {
            if (this.session == null && create) {
                this.session = WebSessionUtil.getSession((HttpServletRequest)this.request, (boolean)true);
            }
            return this.session;
        }

        public AuditInfo getAuditInfo() {
            if (this.session != null) {
                return this.session;
            }
            return new AuditInfo(){

                public String getAuditSlotName() {
                    return request.getRemoteHost();
                }

                public String getAuditTarget() {
                    BWebService webService = BWebService.getMainService();
                    return webService.toPathString();
                }
            };
        }
    }
}

