/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jetty;

import com.tridium.jetty.ContextSessionData;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jetty.server.session.AbstractSessionDataStore;
import org.eclipse.jetty.server.session.SessionContext;
import org.eclipse.jetty.server.session.SessionData;

public class NiagaraSessionDataStore
extends AbstractSessionDataStore {
    private final ContextSessionData contextSessionData;
    private Map<String, SessionData> sessionData;

    public NiagaraSessionDataStore(ContextSessionData contextSessionData) {
        this.contextSessionData = contextSessionData;
    }

    public void initialize(SessionContext context) throws Exception {
        super.initialize(context);
        this.sessionData = this.contextSessionData.getSessionData(context);
    }

    public SessionData doLoad(String id) throws Exception {
        return this.sessionData.get(id);
    }

    public boolean delete(String id) throws Exception {
        this.sessionData.remove(id);
        return true;
    }

    public void doStore(String id, SessionData data, long lastSaveTime) throws Exception {
        this.sessionData.put(id, data);
    }

    public Set<String> doGetExpired(Set<String> candidates) {
        if (this.sessionData.isEmpty()) {
            return Collections.emptySet();
        }
        long now = System.currentTimeMillis();
        return this.sessionData.values().stream().filter(session -> session.isExpiredAt(now)).map(session -> session.getId()).collect(Collectors.toSet());
    }

    public boolean isPassivating() {
        return false;
    }

    public boolean exists(String id) {
        return this.sessionData.containsKey(id);
    }
}

