/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jetty;

import com.tridium.session.SessionManager;
import com.tridium.web.session.NiagaraWebSession;
import java.security.AccessController;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.server.session.HouseKeeper;

public class NiagaraSessionIdManager
extends DefaultSessionIdManager {
    private static final long DEFAULT_CLEANUP_SESSIONS_INTERVAL = TimeUnit.MINUTES.toSeconds(AccessController.doPrivileged(() -> Long.getLong("niagara.session.cleanup.interval", 10L)));

    public NiagaraSessionIdManager(Server server) {
        super(server);
        HouseKeeper houseKeeper = new HouseKeeper();
        try {
            houseKeeper.setIntervalSec(DEFAULT_CLEANUP_SESSIONS_INTERVAL);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setSessionHouseKeeper(houseKeeper);
    }

    public NiagaraSessionIdManager(Server server, long sessionCleanupIntervalSec) {
        super(server);
        HouseKeeper houseKeeper = new HouseKeeper();
        try {
            houseKeeper.setIntervalSec(sessionCleanupIntervalSec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setSessionHouseKeeper(houseKeeper);
    }

    public boolean isIdInUse(String id) {
        return SessionManager.sessionIdInUse((String)id, NiagaraWebSession.class);
    }

    public String newSessionId(HttpServletRequest request, long created) {
        return super.newSessionId(request, created);
    }

    public String newSessionId(long seedTerm) {
        return SessionManager.generateSessionId(NiagaraWebSession.class, (int)25);
    }
}

