/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jetty;

import com.tridium.nre.util.PrivilegedRunnable;
import java.security.AccessControlContext;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

@ManagedObject(value="A thread pool that creates privileged threads")
public class PrivilegedQueuedThreadPool
extends QueuedThreadPool {
    private AccessControlContext accessControlContext = null;

    public Thread newThread(Runnable runnable) {
        if (this.accessControlContext != null) {
            return super.newThread((Runnable)new PrivilegedRunnable(runnable, this.accessControlContext));
        }
        return super.newThread(runnable);
    }

    AccessControlContext getAccessControlContext() {
        return this.accessControlContext;
    }

    void setAccessControlContext(AccessControlContext accessControlContext) {
        this.accessControlContext = accessControlContext;
    }
}

