/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jetty;

import com.tridium.session.MutableNiagaraSession;
import com.tridium.session.SessionManager;
import com.tridium.web.session.NiagaraWebSession;
import java.util.logging.Logger;
import javax.baja.nre.util.SecurityUtil;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;

public class SessionIdChangeHandler
implements HttpSessionIdListener {
    private static final Logger LOGGER = Logger.getLogger(SessionIdChangeHandler.class.getName());

    public void sessionIdChanged(HttpSessionEvent httpSessionEvent, String oldId) {
        HttpSession httpSession = httpSessionEvent.getSession();
        NiagaraWebSession niagaraSession = (NiagaraWebSession)SessionManager.getNiagaraSession((String)oldId, NiagaraWebSession.class);
        LOGGER.fine(() -> String.format("HttpSession id changed: oldIdHash = %s, newIdHash = %s", SecurityUtil.calculateSessionIdHash((String)oldId), SecurityUtil.calculateSessionIdHash((String)httpSessionEvent.getSession().getId())));
        if (niagaraSession != null) {
            SessionManager.changeSessionId((MutableNiagaraSession)niagaraSession, NiagaraWebSession.class, (String)httpSession.getId());
            LOGGER.fine(() -> String.format("Changed NiagaraHttpSession id: oldIdHash = %s, superIdHash = %s, newIdHash = %s", SecurityUtil.calculateSessionIdHash((String)oldId), SecurityUtil.calculateSessionIdHash((String)niagaraSession.getSuperId()), SecurityUtil.calculateSessionIdHash((String)niagaraSession.getId())));
        }
    }
}

