/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.schedule.ui;

import com.tridium.obix.driver.schedule.ui.BObixScheduleManager;
import com.tridium.obix.driver.schedule.ui.ObixScheduleModel;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.obix.driver.schedule.BObixScheduleDiscoveryJob;
import javax.baja.obix.driver.schedule.BObixScheduleDiscoveryResult;
import javax.baja.obix.driver.schedule.BObixScheduleExport;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class ObixScheduleLearn
extends MgrLearn {
    private static BImage scheduleImg = BImage.make((BIcon)BIcon.std((String)"schedule.png"));
    private static BImage obixImg = BImage.make((BIcon)BIcon.std((String)"obix.png"));
    private static BImage objImg = BImage.make((BIcon)BIcon.std((String)"object.png"));
    BObixScheduleDiscoveryJob obixJob;

    public ObixScheduleLearn(BObixScheduleManager mgr) {
        super((BAbstractManager)mgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(Object discovered) {
        try {
            this.getManager().enterBusy();
            BObixScheduleDiscoveryResult r = ObixScheduleLearn.x(discovered);
            Object[] objectArray = r.getChildren(this.obixJob);
            return objectArray;
        }
        finally {
            this.getManager().exitBusy();
        }
    }

    public BImage getIcon(Object discovered) {
        if (ObixScheduleLearn.x(discovered).getSchedule()) {
            return scheduleImg;
        }
        if (ObixScheduleLearn.x(discovered).getObixName().equals("lobby")) {
            return obixImg;
        }
        return objImg;
    }

    public boolean hasChildren(Object discovered) {
        BObixScheduleDiscoveryResult r = ObixScheduleLearn.x(discovered);
        return r.getKids().getSlotCount() > 0;
    }

    public boolean isDepthExpandable(int depth) {
        return true;
    }

    public boolean isExisting(Object discovered, BComponent db) {
        BObixScheduleDiscoveryResult res = ObixScheduleLearn.x(discovered);
        if (db instanceof BObixScheduleExport) {
            return ObixScheduleLearn.proxy(db).getSubordinate().equals(res.getHref());
        }
        return false;
    }

    public boolean isGroup(Object discovered) {
        return false;
    }

    public boolean isMatchable(Object discovered, BComponent db) {
        return this.isGroup(discovered) && db instanceof BObixScheduleExport;
    }

    public void jobComplete(BJob job) {
        this.obixJob = (BObixScheduleDiscoveryJob)job;
        job.lease(Integer.MAX_VALUE);
        this.updateRoots(job.getChildComponents());
    }

    public void toRow(Object discovered, MgrEditRow row) throws Exception {
        BObixScheduleDiscoveryResult res = ObixScheduleLearn.x(discovered);
        ObixScheduleModel m = (ObixScheduleModel)this.getManager().getModel();
        row.setDefaultName(res.getObixName());
        row.setCell(m.href, (BValue)BString.make((String)res.getHref()));
    }

    public MgrTypeInfo[] toTypes(Object discovered) {
        BObixScheduleDiscoveryResult res = ObixScheduleLearn.x(discovered);
        if (res.getSchedule()) {
            return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BObixScheduleExport.TYPE)};
        }
        return new MgrTypeInfo[0];
    }

    protected MgrColumn[] makeColumns() {
        return new MgrColumn[]{new MgrColumn.Prop(BObixScheduleDiscoveryResult.obixName), new MgrColumn.Prop(BObixScheduleDiscoveryResult.href)};
    }

    private static BObixScheduleExport proxy(Object o) {
        return (BObixScheduleExport)o;
    }

    private static BObixScheduleDiscoveryResult x(Object discovered) {
        return (BObixScheduleDiscoveryResult)discovered;
    }
}

