/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.ui;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrLearn;

@NiagaraType
public class BObixLearnTable
extends BLearnTable {
    @Generated
    public static final Type TYPE = Sys.loadType(BObixLearnTable.class);
    static int sortDepth = 0;
    static final int MAX_SORT_DEPTH = 99;
    BAbstractManager manager;
    MgrColumn[] cols;
    MgrLearn learn;
    DynamicTableModel dynamicModel;
    public MyModel treeTableModel;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BObixLearnTable() {
    }

    public BObixLearnTable(MgrLearn learn) {
        super(learn);
        this.manager = learn.getManager();
        this.learn = learn;
        this.cols = learn.getColumns();
        this.treeTableModel = new MyModel();
        this.dynamicModel = new DynamicTableModel((TableModel)this.treeTableModel);
        for (int i = 0; i < this.cols.length; ++i) {
            this.dynamicModel.setShowColumn(i, !this.cols[i].isUnseen());
        }
        this.setModel((TableModel)this.dynamicModel);
    }

    public MgrColumn columnIndexToMgrColumn(int column) {
        return this.learn.getColumns()[this.dynamicModel.toRootColumnIndex(column)];
    }

    public Object getObjectAt(int row) {
        MyNode node = (MyNode)this.treeTableModel.rowToNode(row);
        if (node != null) {
            return node.discovery;
        }
        return null;
    }

    public void mouseDragStarted(BMouseEvent event) {
        int[] rows = this.getSelection().getRows();
        if (rows.length == 0) {
            return;
        }
        int rowY = this.getRowAt(event.getY());
        boolean found = false;
        for (int j : rows) {
            if (rowY != j) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        BImage[] icons = new BImage[rows.length];
        String[] text = new String[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            int row = rows[i];
            MyNode node = (MyNode)this.treeTableModel.rowToNode(row);
            icons[i] = node.getIcon();
            text[i] = String.valueOf(node.getValueAt(0));
        }
        SimpleDragRenderer dragRenderer = new SimpleDragRenderer(icons, text);
        dragRenderer.font = Theme.table().getCellFont();
        String payload = "dragFromLearn:" + this.getManager().hashCode();
        this.startDrag(event, TransferEnvelope.make((String)payload), (DragRenderer)dragRenderer);
    }

    void myResetIcons() {
        MyNode[] roots;
        for (MyNode root : roots = this.treeTableModel.roots) {
            this.myResetIcons(root);
        }
        this.repaint();
    }

    void myResetIcons(MyNode node) {
        node.icon = null;
        if (node.children != null) {
            for (int i = 0; i < node.children.length; ++i) {
                this.myResetIcons(node.children[i]);
            }
        }
    }

    static MyNode[] sort(MyNode[] roots, int col, boolean ascending) {
        MyNode[] sorted = (MyNode[])roots.clone();
        Object[] keys = new Object[sorted.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = sorted[i].getValueAt(col);
        }
        SortUtil.sort((Object[])keys, (Object[])sorted, (boolean)ascending);
        for (MyNode myNode : sorted) {
            if (++sortDepth > 99) {
                System.out.println("BObixLearnTable:max sort depth reached!!");
                break;
            }
            MyNode[] kids = myNode.children;
            if (kids != null && kids.length > 1) {
                myNode.children = BObixLearnTable.sort(kids, col, ascending);
            }
            --sortDepth;
        }
        return sorted;
    }

    class MyNode
    extends TreeTableNode {
        Object discovery;
        MyNode[] children;
        BImage icon;

        MyNode(MyModel model, Object discovery) {
            super((TreeTableModel)model);
            this.discovery = discovery;
        }

        MyNode(MyNode parent, Object discovery) {
            super((TreeTableNode)parent);
            this.discovery = discovery;
        }

        public Object getSubject() {
            return this.discovery;
        }

        public boolean isGroup() {
            return BObixLearnTable.this.learn.isGroup(this.discovery);
        }

        public boolean hasChildren() {
            return BObixLearnTable.this.learn.hasChildren(this.discovery);
        }

        public int getChildCount() {
            return this.getChildren().length;
        }

        public TreeTableNode getChild(int index) {
            return this.getChildren()[index];
        }

        TreeTableNode[] getChildren() {
            if (this.children == null) {
                Object[] kidDis = BObixLearnTable.this.learn.getChildren(this.discovery);
                MyNode[] kidNodes = new MyNode[kidDis.length];
                for (int i = 0; i < kidNodes.length; ++i) {
                    kidNodes[i] = new MyNode(this, kidDis[i]);
                }
                this.children = kidNodes;
            }
            return this.children;
        }

        public Object getValueAt(int col) {
            return BObixLearnTable.this.cols[col].get(this.discovery);
        }

        public BImage getIcon() {
            if (this.icon == null) {
                this.icon = BObixLearnTable.this.learn.getIcon(this.discovery);
                if (BObixLearnTable.this.learn.getExisting(this.discovery) != null && this.icon != null) {
                    this.icon = this.icon.getDisabledImage();
                }
            }
            return this.icon;
        }
    }

    public class MyModel
    extends TreeTableModel {
        MyNode[] roots = new MyNode[0];

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateTreeTable(boolean resize) {
            BWbShell shell = BObixLearnTable.this.getManager().getWbShell();
            shell.enterBusy();
            try {
                Object[] discovery = BObixLearnTable.this.learn.getRoots();
                MyNode[] roots = new MyNode[discovery.length];
                for (int i = 0; i < roots.length; ++i) {
                    MyNode root = this.discoveryToRoot(discovery[i]);
                    if (root == null) {
                        root = new MyNode(this, discovery[i]);
                    }
                    roots[i] = root;
                }
                int sortCol = BObixLearnTable.this.dynamicModel.toRootColumnIndex(BObixLearnTable.this.getSortColumn());
                if (sortCol >= 0) {
                    roots = BObixLearnTable.sort(roots, sortCol, BObixLearnTable.this.isSortAscending());
                }
                this.roots = roots;
                super.updateTreeTable(resize);
            }
            finally {
                shell.exitBusy();
            }
        }

        public int getRootCount() {
            return this.roots.length;
        }

        public TreeTableNode getRoot(int index) {
            return this.roots[index];
        }

        public boolean isDepthExpandable(int depth) {
            return BObixLearnTable.this.learn.isDepthExpandable(depth);
        }

        public int getColumnCount() {
            return BObixLearnTable.this.cols.length;
        }

        public String getColumnName(int col) {
            return BObixLearnTable.this.cols[col].getDisplayName();
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void sortByColumn(int col, boolean ascending) {
            this.getSelection().deselectAll();
            this.roots = BObixLearnTable.sort(this.roots, col, ascending);
            super.updateTreeTable(false);
        }

        MyNode discoveryToRoot(Object discovery) {
            MyNode[] roots;
            for (MyNode root : roots = this.roots) {
                if (root.discovery != discovery) continue;
                return root;
            }
            return null;
        }
    }
}

