/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.edgeIo.ui.point;

import com.tridium.edgeIo.datatypes.BEdgeIoPointDiscoverParams;
import com.tridium.edgeIo.enums.BEdgeIoModeEnum;
import com.tridium.edgeIo.enums.BEdgeIoTypeEnum;
import com.tridium.edgeIo.point.BEdgeIoAnalogProxyExt;
import com.tridium.edgeIo.point.BEdgeIoDigitalProxyExt;
import com.tridium.edgeIo.point.BEdgeIoPointDeviceExt;
import com.tridium.edgeIo.point.BEdgeIoProxyExt;
import com.tridium.edgeIo.point.BEdgeIoPulseInputProxyExt;
import com.tridium.edgeIo.ui.point.BEdgeIoPointManager;
import com.tridium.util.CompUtil;
import java.util.ArrayList;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class EdgeIoPointLearn
extends MgrLearn {
    MgrColumn colPointLabel = new MgrColumn.Prop(BEdgeIoPointDiscoverParams.pointLabel, 1);
    MgrColumn colPointType = new MgrColumn.Prop(BEdgeIoPointDiscoverParams.pointType, 2);
    MgrColumn colPointId = new MgrColumn.Prop(BEdgeIoPointDiscoverParams.pointId, 1);
    public static final BImage numericElementIcon = BImage.make((String)"module://icons/x16/control/numericPoint.png");
    public static final BImage booleanElementIcon = BImage.make((String)"module://icons/x16/control/booleanPoint.png");
    public static final BImage numericElementIconRo = BImage.make((String)"module://icons/x16/statusNumeric.png");
    public static final BImage booleanElementIconRo = BImage.make((String)"module://icons/x16/statusBoolean.png");

    public EdgeIoPointLearn(BAbstractManager manager) {
        super(manager);
    }

    public BImage getIcon(Object discovery) {
        BEdgeIoPointDiscoverParams disParam = (BEdgeIoPointDiscoverParams)discovery;
        BEdgeIoTypeEnum ioType = disParam.getPointType();
        switch (ioType.getOrdinal()) {
            case 0: 
            case 1: 
            case 3: {
                return numericElementIcon;
            }
            case 2: 
            case 4: {
                return numericElementIconRo;
            }
            case 5: {
                return booleanElementIcon;
            }
            case 6: {
                return booleanElementIconRo;
            }
        }
        return null;
    }

    public MgrTypeInfo[] toTypes(Object discovery) throws Exception {
        BEdgeIoPointDiscoverParams disParam = (BEdgeIoPointDiscoverParams)discovery;
        ArrayList<MgrTypeInfo> a = new ArrayList<MgrTypeInfo>();
        BEdgeIoTypeEnum ioType = disParam.getPointType();
        switch (ioType.getOrdinal()) {
            case 0: {
                a.add(this.info(BNumericWritable.TYPE));
                a.add(this.info(BNumericPoint.TYPE));
                a.add(this.info(BBooleanWritable.TYPE));
                a.add(this.info(BBooleanPoint.TYPE));
                break;
            }
            case 1: {
                a.add(this.info(BNumericWritable.TYPE));
                a.add(this.info(BBooleanWritable.TYPE));
                break;
            }
            case 2: {
                a.add(this.info(BNumericPoint.TYPE));
                a.add(this.pulseInfo());
                a.add(this.info(BBooleanPoint.TYPE));
                break;
            }
            case 3: {
                a.add(this.info(BNumericWritable.TYPE));
                break;
            }
            case 4: {
                a.add(this.info(BNumericPoint.TYPE));
                break;
            }
            case 5: {
                a.add(this.info(BBooleanWritable.TYPE));
                break;
            }
            case 6: {
                a.add(this.info(BBooleanPoint.TYPE));
            }
        }
        return a.toArray(new MgrTypeInfo[0]);
    }

    private MgrTypeInfo info(Type t) {
        return new MyTypeInfo(MgrTypeInfo.make((TypeInfo)t.getTypeInfo()), false);
    }

    private MgrTypeInfo pulseInfo() {
        return new MyTypeInfo(MgrTypeInfo.make((TypeInfo)BNumericPoint.TYPE.getTypeInfo()), true);
    }

    public void toRow(Object discovery, MgrEditRow row) throws Exception {
        BEdgeIoPointDiscoverParams disParam = (BEdgeIoPointDiscoverParams)discovery;
        BEdgeIoPointManager pm = (BEdgeIoPointManager)row.getManager();
        BControlPoint cp = (BControlPoint)row.getTarget();
        BEdgeIoTypeEnum ioTyp = disParam.getPointType();
        String discoverModes = disParam.getPointDiscoverMode();
        boolean pulse = cp.getProxyExt() instanceof BEdgeIoPulseInputProxyExt;
        String string = discoverModes = pulse ? "pulseInput" : discoverModes.replace("pulseInput", "");
        if (cp instanceof BBooleanPoint && discoverModes.indexOf("resistanceInput") > 1) {
            discoverModes = "resistanceInput," + discoverModes.replace("resistanceInput", "");
        }
        BDynamicEnum pntMode = this.getMode(discoverModes);
        BUnit dfUnit = BEdgeIoPointManager.getUnitsForMode(pntMode.getTag());
        row.setDefaultName(disParam.getPointLabel());
        row.setCell(pm.colPointLabel, (BValue)BString.make((String)disParam.getPointLabel()));
        row.setCell(pm.colPointType, (BValue)ioTyp);
        row.setCell(pm.colPointId, (BValue)BInteger.make((int)disParam.getPointId()));
        row.setCell(pm.colPointMode, (BValue)pntMode);
        row.setCell(pm.colDeviceFacets, (BValue)BFacets.make((String)"units", (BIDataValue)dfUnit));
    }

    private BDynamicEnum getMode(String discoverModes) {
        ArrayList<BEdgeIoModeEnum> modes = new ArrayList<BEdgeIoModeEnum>();
        String[] parts = discoverModes.split(",");
        for (int i = 0; i < parts.length; ++i) {
            try {
                BEdgeIoModeEnum b = (BEdgeIoModeEnum)BEdgeIoModeEnum.DEFAULT.decodeFromString(parts[i]);
                modes.add(b);
                continue;
            }
            catch (Exception b) {
                // empty catch block
            }
        }
        int cnt = modes.size();
        if (cnt == 0) {
            return BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.DEFAULT);
        }
        String[] tags = new String[cnt];
        BEnum[] enums = modes.toArray(new BEnum[0]);
        for (int i = 0; i < cnt; ++i) {
            tags[i] = enums[i].getTag();
        }
        return BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((String[])tags));
    }

    public boolean isExisting(Object discovery, BComponent target) {
        BEdgeIoPointDiscoverParams disParam = (BEdgeIoPointDiscoverParams)discovery;
        if (!(target instanceof BControlPoint)) {
            return false;
        }
        BAbstractProxyExt pext = ((BControlPoint)target).getProxyExt();
        if (!(pext instanceof BEdgeIoProxyExt)) {
            return false;
        }
        BEdgeIoProxyExt edgeIoPext = (BEdgeIoProxyExt)pext;
        return disParam.getPointId() == edgeIoPext.getPointId() && disParam.getPointType().equals((Object)edgeIoPext.getPointType());
    }

    public BComponent getExisting(Object discovery) {
        BControlPoint[] cps;
        BEdgeIoPointDeviceExt pext = ((BEdgeIoPointManager)this.getManager()).getPointDeviceExt();
        for (BControlPoint cp : cps = (BControlPoint[])CompUtil.getDescendants((BComponent)pext, BControlPoint.class)) {
            if (!this.isExisting(discovery, (BComponent)cp)) continue;
            return cp;
        }
        return null;
    }

    protected MgrColumn[] makeColumns() {
        return new MgrColumn[]{this.colPointLabel, this.colPointType, this.colPointId};
    }

    static class MyTypeInfo
    extends MgrTypeInfo {
        MgrTypeInfo mti;
        boolean pulseInput;

        MyTypeInfo(MgrTypeInfo ti, boolean pulseInput) {
            this.mti = ti;
            this.pulseInput = pulseInput;
        }

        public String getDisplayName() {
            return this.pulseInput ? "PulseInput" : this.mti.getDisplayName();
        }

        public BImage getIcon() {
            return this.mti.getIcon();
        }

        public boolean isMatchable(BComponent db) {
            return this.mti.isMatchable(db);
        }

        public BComponent newInstance() throws Exception {
            BControlPoint cp = (BControlPoint)this.mti.newInstance();
            if (cp instanceof BBooleanPoint) {
                cp.setProxyExt((BAbstractProxyExt)new BEdgeIoDigitalProxyExt());
            } else if (this.pulseInput) {
                cp.setProxyExt((BAbstractProxyExt)new BEdgeIoPulseInputProxyExt());
            } else {
                cp.setProxyExt((BAbstractProxyExt)new BEdgeIoAnalogProxyExt());
            }
            return cp;
        }

        public int hashCode() {
            return this.getDisplayName().hashCode();
        }
    }
}

