/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.ui.fe;

import com.tridium.workbench.propsheet.BPropertyEntry;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchemaBoundSlotsContainer;
import com.tridiumx.jsonToolkit.outbound.schema.config.BSlotSelectionType;
import com.tridiumx.jsonToolkit.util.BListOf;
import java.util.ArrayList;
import java.util.List;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"jsonToolkit:SlotSelectionType"})})
@NiagaraActions(value={@NiagaraAction(name="selectionChange", flags=4), @NiagaraAction(name="enterKeyPress", flags=4)})
public class BSelectedSlotsFE
extends BWbFieldEditor {
    @Generated
    public static final Action selectionChange = BSelectedSlotsFE.newAction((int)4, null);
    @Generated
    public static final Action enterKeyPress = BSelectedSlotsFE.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSelectedSlotsFE.class);
    private BEnumRange range;
    private final BListDropDown slotTypePicker = new BListDropDown();
    private BListDropDown slotsPicker;
    private BTextField slotNameField;
    private Command addCommand;
    private final BFlowPane slotPickerPane;
    private final BGridPane rightHandPane;
    private List<String> manuallySelectedSlots;
    private final String manualSlots = BSlotSelectionType.selectedSlots.getDisplayTag(null);
    private static final String SAFE_SUFFIX = "slot";

    @Generated
    public void selectionChange() {
        this.invoke(selectionChange, null, null);
    }

    @Generated
    public void enterKeyPress() {
        this.invoke(enterKeyPress, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSelectedSlotsFE() {
        this.slotPickerPane = new BFlowPane(BHalign.center);
        this.slotPickerPane.setVisible(false);
        this.rightHandPane = new BGridPane(1);
        this.resetManualOptions();
        BGridPane outerGrid = new BGridPane(2);
        outerGrid.setRowAlign(BValign.top);
        outerGrid.add("mainPicker", (BValue)this.slotTypePicker);
        outerGrid.add("manualPane", (BValue)this.rightHandPane);
        this.setContent((BWidget)outerGrid);
        this.linkTo("lk0", (BComponent)this.slotTypePicker, (Slot)BDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.slotTypePicker, (Slot)BDropDown.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk2", (BComponent)this.slotTypePicker, (Slot)BListDropDown.listActionPerformed, (Slot)selectionChange);
    }

    protected void doSetReadonly(boolean readonly) {
        this.slotTypePicker.setDropDownEnabled(!readonly);
        this.addCommand.setEnabled(!readonly);
    }

    protected void doLoadValue(BObject v, Context cx) {
        BSlotSelectionType val = (BSlotSelectionType)v;
        this.range = BSlotSelectionType.DEFAULT.getRange();
        int[] ordinals = this.range.getOrdinals();
        int sel = -1;
        this.slotTypePicker.getList().removeAllItems();
        for (int i = 0; i < ordinals.length; ++i) {
            int ordinal = ordinals[i];
            String displayTag = this.range.getDisplayTag(ordinal, null);
            this.slotTypePicker.getList().addItem((Object)displayTag);
            if (ordinal != val.getOrdinal()) continue;
            sel = i;
        }
        this.slotTypePicker.setSelectedIndex(sel);
        this.doSelectionChange();
    }

    protected BObject doSaveValue(BObject v, Context cx) {
        if (this.slotTypePicker.getSelectedItem().equals(this.manualSlots)) {
            BJsonSchemaBoundSlotsContainer container = this.getContainer();
            container.getSlotList().clear();
            BListOf slotNames = new BListOf(BString.TYPE);
            this.manuallySelectedSlots.forEach(name -> slotNames.add((BValue)BString.make((String)name)));
            container.setSlotList(slotNames);
        }
        int sel = this.slotTypePicker.getSelectedIndex();
        return this.range.get(this.range.getOrdinals()[sel]);
    }

    public void doSelectionChange() {
        this.resetManualOptions();
        if (this.slotTypePicker.getSelectedItem().equals(this.manualSlots)) {
            BJsonSchemaBoundSlotsContainer container = this.getContainer();
            if (container.getSchema().isRelative()) {
                this.slotNameField = new BTextField();
                this.linkTo((BComponent)this.slotNameField, (Slot)BTextField.actionPerformed, (Slot)enterKeyPress);
                this.slotPickerPane.add("slotNameField", (BValue)this.slotNameField);
            } else {
                this.slotsPicker = this.createSlotsPicker(container);
                this.slotPickerPane.add("slotsPicker", (BValue)this.slotsPicker);
            }
            this.addCommand = new AddCommand();
            BButton addButton = new BButton(this.addCommand);
            addButton.setButtonStyle(BButtonStyle.toolBar);
            addButton.setPadding(BInsets.NULL);
            this.addButtonEnabledState();
            this.slotPickerPane.add("add", (BValue)addButton);
            container.getSlotList().forEach(name -> this.addSlotName(name.toString(null)));
        }
        this.getContent().relayout();
        this.getContent().computePreferredSize();
    }

    public void doEnterKeyPress() {
        if (this.slotNameField != null) {
            this.addSelectedSlotName();
            this.slotNameField.setText("");
        }
    }

    protected BListDropDown createSlotsPicker(BJsonSchemaBoundSlotsContainer container) {
        BObject bindTarget;
        BListDropDown dropDown = new BListDropDown();
        OrdTarget ordTarget = container.getOrdTarget((BObject)container);
        if (ordTarget != null && (bindTarget = ordTarget.get()) instanceof BComponent) {
            BComponent comp = (BComponent)bindTarget;
            comp.lease();
            for (Property prop : comp.getPropertiesArray()) {
                dropDown.getList().addItem((Object)prop.getName());
            }
        }
        return dropDown;
    }

    protected BJsonSchemaBoundSlotsContainer getContainer() {
        BObject target;
        BComplex parent = this.getParent().getParent();
        if (parent instanceof BPropertyEntry && (target = ((BPropertyEntry)parent).getTarget()) instanceof BJsonSchemaBoundSlotsContainer) {
            BJsonSchemaBoundSlotsContainer container = (BJsonSchemaBoundSlotsContainer)target;
            container.lease(2);
            return container;
        }
        throw new BajaRuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " is being rendered in the wrong place");
    }

    private void addSelectedSlotName() {
        String manuallyTypedSlotName;
        if (this.slotsPicker != null && this.slotsPicker.getSelectedIndex() > -1) {
            String selectedSlot = (String)this.slotsPicker.getSelectedItem();
            this.addSlotName(selectedSlot);
        } else if (this.slotNameField != null && !(manuallyTypedSlotName = this.slotNameField.getText()).isEmpty()) {
            this.addSlotName(manuallyTypedSlotName);
        }
    }

    private void addSlotName(String slotName) {
        this.manuallySelectedSlots.add(slotName);
        BGridPane pane = new BGridPane(2);
        BLabel label = new BLabel();
        label.setText(slotName);
        DeleteCommand deleteCommand = new DeleteCommand(slotName);
        BButton delButton = new BButton((Command)deleteCommand);
        delButton.setButtonStyle(BButtonStyle.toolBar);
        delButton.setPadding(BInsets.NULL);
        pane.add("lbl", (BValue)label);
        pane.add("delButton", (BValue)delButton);
        this.rightHandPane.add(SAFE_SUFFIX + slotName, (BValue)pane);
        if (this.slotsPicker != null) {
            this.slotsPicker.getList().removeItem((Object)slotName);
            this.slotsPicker.setSelectedIndex(0);
        }
        this.addButtonEnabledState();
        this.getContent().relayout();
        this.getContent().computePreferredSize();
        this.setModified();
    }

    private void addButtonEnabledState() {
        this.addCommand.setEnabled(this.slotsPicker != null && this.slotsPicker.getList().getItemCount() > 0 || this.slotNameField != null);
    }

    private void resetManualOptions() {
        this.slotsPicker = null;
        this.slotPickerPane.removeAll();
        this.slotPickerPane.setVisible(this.slotTypePicker.getSelectedIndex() > -1 && this.slotTypePicker.getSelectedItem().equals(this.manualSlots));
        this.rightHandPane.removeAll();
        this.rightHandPane.add("slotPickerPane", (BValue)this.slotPickerPane);
        this.manuallySelectedSlots = new ArrayList<String>();
    }

    private class AddCommand
    extends Command {
        AddCommand() {
            super((BWidget)BSelectedSlotsFE.this, "", BImage.make((BIcon)BIcon.std((String)"add.png")), null, "");
            this.setEnabled(true);
        }

        public CommandArtifact doInvoke() {
            BSelectedSlotsFE.this.addSelectedSlotName();
            return null;
        }
    }

    private class DeleteCommand
    extends Command {
        private final String itemToDelete;

        DeleteCommand(String itemToDelete) {
            super((BWidget)BSelectedSlotsFE.this, "", BImage.make((BIcon)BIcon.std((String)"delete.png")), null, "");
            this.itemToDelete = itemToDelete;
        }

        public CommandArtifact doInvoke() {
            BSelectedSlotsFE.this.manuallySelectedSlots.remove(this.itemToDelete);
            BSelectedSlotsFE.this.rightHandPane.remove(BSelectedSlotsFE.SAFE_SUFFIX + this.itemToDelete);
            if (BSelectedSlotsFE.this.slotsPicker != null) {
                BSelectedSlotsFE.this.slotsPicker.getList().addItem((Object)this.itemToDelete);
            }
            BSelectedSlotsFE.this.addButtonEnabledState();
            BSelectedSlotsFE.this.setModified();
            BSelectedSlotsFE.this.relayout();
            return null;
        }
    }
}

