/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.ui.fe;

import com.tridium.workbench.fieldeditors.BOrdFE;
import com.tridium.workbench.ord.BComponentChooser;
import com.tridium.workbench.ord.RefFilter;
import com.tridium.workbench.propsheet.BPropertyEntry;
import com.tridiumx.jsonToolkit.util.JsonStringUtil;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BSlotOrdFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BSlotOrdFE.class);
    private static final RefFilter propertiesOnly = (parent, slot) -> slot.isProperty();
    private static final BImage browseIcon = BImage.make((String)"module://icons/x16/open.png");
    private static SlotPath lastSlotPath;
    private final BButton button;
    private final BTextField field = new BTextField("", 60);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSlotOrdFE() {
        this.button = new BButton((Command)new Browse());
        this.button.setButtonStyle(BButtonStyle.toolBar);
        BGridPane grid = new BGridPane(3);
        grid.setStretchColumn(0);
        grid.add(null, (BValue)this.field);
        grid.add(null, (BValue)this.button);
        this.setContent((BWidget)grid);
        this.linkTo("lk0", (BComponent)this.field, (Slot)BTextEditor.textModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.field, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
    }

    protected void doLoadValue(BObject value, Context cx) {
        BOrd ord = (BOrd)value;
        this.field.setText(ord.toString());
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        BOrd relativeOrd;
        String text = this.field.getText();
        if (text.isEmpty()) {
            return BOrd.NULL;
        }
        BOrd ord = BOrd.make((String)text);
        if (!ord.isNull() && BOrdFE.isRelativize((BOrd)ord, (Context)cx, (BWbShell)this.getWbShell()) && !(relativeOrd = ord.relativizeToSession()).isNull() && !relativeOrd.toString().isEmpty()) {
            ord = relativeOrd;
        }
        return ord;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.field.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    protected class Browse
    extends Command {
        Browse() {
            super((BWidget)BSlotOrdFE.this, JsonStringUtil.lexicon.get("selectOrdSource"));
        }

        public CommandArtifact doInvoke() {
            BComponent stationRoot = (BComponent)BOrd.make((String)"slot:/").get((BObject)this.getStationComponent());
            BOrd ord = BComponentChooser.prompt((BWidget)BSlotOrdFE.this, (String)JsonStringUtil.lexicon.get("selectOrdInstruction"), (BComponent)stationRoot, (SlotPath)(lastSlotPath != null ? lastSlotPath : stationRoot.getSlotPath()), (RefFilter)propertiesOnly, (RefFilter)propertiesOnly);
            if (ord != null && !ord.isNull()) {
                if (BOrdFE.isRelativize((BOrd)ord, null, (BWbShell)BSlotOrdFE.this.getWbShell())) {
                    ord = ord.relativizeToSession();
                }
                BSlotOrdFE.this.field.setText(ord.toString());
                this.setLastSlotPath(ord);
            }
            return null;
        }

        BComponent getStationComponent() {
            BObject target;
            BComplex parent = BSlotOrdFE.this.getParent().getParent();
            if (parent instanceof BPropertyEntry && (target = ((BPropertyEntry)parent).getTarget()) instanceof BComponent) {
                return (BComponent)target;
            }
            throw new BajaRuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " is being rendered in the wrong place");
        }

        private void setLastSlotPath(BOrd ord) {
            BObject target = ord.resolve((BObject)this.getStationComponent()).get();
            BComponent nearestComponent = this.getNearestParentComponent(target);
            if (nearestComponent != null) {
                lastSlotPath = nearestComponent.getSlotPath();
            }
        }

        private BComponent getNearestParentComponent(BObject obj) {
            while (true) {
                if (obj == null) {
                    return null;
                }
                if (obj.isComponent()) {
                    return obj.asComponent();
                }
                if (!obj.isComplex()) break;
                obj = obj.asComplex().getParent();
            }
            return null;
        }

        public BImage getIcon() {
            return browseIcon;
        }
    }
}

