/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tunnel;

import com.tridium.driver.util.DrByteArrayUtil;
import com.tridium.tunnel.BISerialShare;
import com.tridium.tunnel.BTunnel;
import com.tridium.tunnel.BTunnelConnection;
import com.tridium.tunnel.TunnelConst;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.serial.BISerialPort;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="identifier", type="String", defaultValue="none", flags=1)
public class BSerialTunnelShare
extends BTunnel
implements TunnelConst {
    @Generated
    public static final Property identifier = BSerialTunnelShare.newProperty((int)1, (String)"none", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSerialTunnelShare.class);
    private Log log = null;
    private boolean connected = false;
    private OutputStream comPortOut;
    private InputStream comPortIn;
    private ReadSerial rcvDriver;
    private Thread rcvThread;
    private WriteTunnel tunSndDriver;
    private Thread tunSndThread;
    private PipedInputStream pipedInput;
    private PipedOutputStream pipedOutput;
    private BufferedInputStream bufferedPipeIn;
    public static final BFacets showMilliSecs = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"showMilliseconds", (BIDataValue)BBoolean.TRUE);

    @Override
    @Generated
    public String getIdentifier() {
        return this.getString(identifier);
    }

    @Generated
    public void setIdentifier(String v) {
        this.setString(identifier, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BISerialShare;
    }

    private BISerialShare getSerialShare() {
        return (BISerialShare)this.getParent();
    }

    @Override
    public void started() throws Exception {
        this.setIdentifier(this.getSerialShare().getTunnelIdentifier());
        super.started();
    }

    @Override
    public void stopped() throws Exception {
        this.doDisconnectAll();
        super.stopped();
    }

    public void tunnelIdChanged(String id) {
        this.setIdentifier(id);
        if (this.connected) {
            this.stopSerialTunnel();
            this.startSerialTunnel();
        }
    }

    @Override
    public void service(BTunnelConnection cx) throws IOException {
        byte[] tunnelBuffer = new byte[1024];
        while (cx.isConnected()) {
            int bytesRead = cx.read(tunnelBuffer, 0, 1000);
            if (bytesRead <= 0) continue;
            this.log().trace(this.toDebugString("to Serial:   ", tunnelBuffer, bytesRead));
            if (this.comPortOut == null) {
                this.log().error("comPortOut is null");
                cx.disconnect();
                continue;
            }
            this.comPortOut.write(tunnelBuffer, 0, bytesRead);
        }
    }

    @Override
    public void sessionClosed(BTunnelConnection cx) {
    }

    @Override
    public boolean supportsConcurrentConnections() {
        return false;
    }

    @Override
    protected void addConnection(BTunnelConnection session) {
        super.addConnection(session);
        this.startSerialTunnel();
    }

    @Override
    protected void removeConnection(BTunnelConnection session) {
        super.removeConnection(session);
        this.stopSerialTunnel();
    }

    public Log log() {
        if (this.log == null) {
            this.log = Log.getLog((String)("Tunnel_" + this.getIdentifier().toLowerCase()));
        }
        return this.log;
    }

    public boolean startSerialTunnel() {
        if (!this.getEnabled()) {
            return true;
        }
        this.log().trace("start()::thread=" + Thread.currentThread().getName());
        try {
            this.log().trace("opening com port...");
            BISerialPort port = this.getSerialShare().accessPort(this);
            if (port == null) {
                throw new Exception("Unable to access comm port.");
            }
            this.comPortOut = port.getOutputStream();
            this.comPortIn = port.getInputStream();
            this.pipedInput = new PipedInputStream();
            this.pipedOutput = new PipedOutputStream(this.pipedInput);
            this.bufferedPipeIn = new BufferedInputStream(this.pipedInput, 8000);
            this.connected = true;
        }
        catch (Exception e) {
            this.log().trace("SerialTunnel exception: " + e);
            e.printStackTrace();
            this.connected = false;
            return false;
        }
        this.rcvDriver = new ReadSerial();
        this.rcvThread = new Thread((Runnable)this.rcvDriver, "tunPtoB." + this.getIdentifier());
        this.log().trace("SerialTunnel > starting ReadSerial");
        this.rcvThread.start();
        this.rcvThread.setPriority(5);
        this.tunSndDriver = new WriteTunnel();
        this.tunSndThread = new Thread((Runnable)this.tunSndDriver, "tunBtoT." + this.getIdentifier());
        this.log().trace("WriteTunnel.start()");
        this.tunSndThread.start();
        this.tunSndThread.setPriority(5);
        return true;
    }

    public void stopSerialTunnel() {
        if (!this.connected) {
            return;
        }
        this.log().trace("stop()::thread=" + Thread.currentThread().getName());
        this.connected = false;
        if (this.rcvDriver != null) {
            this.rcvThread.interrupt();
        }
        if (this.tunSndDriver != null) {
            this.tunSndThread.interrupt();
        }
        this.getSerialShare().releaseAccess(this);
        try {
            this.bufferedPipeIn.close();
            this.pipedOutput.close();
            this.pipedInput.close();
            this.bufferedPipeIn = null;
            this.pipedInput = null;
            this.pipedOutput = null;
        }
        catch (Exception e) {
            this.log().error("SerialTunnel exception: " + e);
            e.printStackTrace();
        }
        this.rcvDriver = null;
        this.tunSndDriver = null;
    }

    String toDebugString(String prefix, byte[] a, int len) {
        StringBuilder sb = new StringBuilder(30 + len * 3);
        sb.append(prefix).append(BSerialTunnelShare.timeStamp());
        sb.append("|");
        sb.append(DrByteArrayUtil.toString((byte[])a, (int)len));
        return sb.toString();
    }

    public static String timeStamp() {
        return BAbsTime.make((long)System.currentTimeMillis()).toTimeString((Context)showMilliSecs);
    }

    class WriteTunnel
    implements Runnable {
        WriteTunnel() {
        }

        @Override
        public void run() {
            byte[] data = new byte[1024];
            while (BSerialTunnelShare.this.connected) {
                int len;
                try {
                    len = BSerialTunnelShare.this.bufferedPipeIn.read(data);
                }
                catch (Exception e) {
                    if (!BSerialTunnelShare.this.connected) {
                        BSerialTunnelShare.this.log().trace("closing SerialTunnel WriteTunnel...");
                        break;
                    }
                    BSerialTunnelShare.this.log().error("Exception in SerialTunnel WriteTunnel in.read():" + e);
                    BSerialTunnelShare.this.connected = false;
                    break;
                }
                try {
                    if (len == -1) continue;
                    BSerialTunnelShare.this.log().trace(BSerialTunnelShare.this.toDebugString("to tunnel:   ", data, len));
                    BTunnelConnection[] connections = BSerialTunnelShare.this.getTunnelConnectionsArray();
                    for (int i = 0; i < connections.length; ++i) {
                        if (!BSerialTunnelShare.this.connected) continue;
                        connections[i].write(data, 0, len);
                    }
                }
                catch (Exception e) {
                    BSerialTunnelShare.this.log().error("WriteTunnel.run()while::thread=" + Thread.currentThread().getName() + " Exception:" + e);
                }
            }
            try {
                if (BSerialTunnelShare.this.bufferedPipeIn != null) {
                    BSerialTunnelShare.this.bufferedPipeIn.close();
                }
                if (BSerialTunnelShare.this.pipedInput != null) {
                    BSerialTunnelShare.this.pipedInput.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            BSerialTunnelShare.this.log().trace(Thread.currentThread().getName() + " is stopped!");
        }
    }

    class ReadSerial
    implements Runnable {
        BufferedOutputStream bufferedPipeOut;

        ReadSerial() {
            this.bufferedPipeOut = new BufferedOutputStream(BSerialTunnelShare.this.pipedOutput, 8000);
        }

        @Override
        public void run() {
            BSerialTunnelShare.this.log().trace("ReadSerial.run()::thread=" + Thread.currentThread().getName());
            byte[] data = new byte[1024];
            while (BSerialTunnelShare.this.connected) {
                int len;
                try {
                    len = BSerialTunnelShare.this.comPortIn.read(data);
                }
                catch (Exception e) {
                    if (!BSerialTunnelShare.this.connected) {
                        BSerialTunnelShare.this.log().trace("exiting " + Thread.currentThread().getName() + "...");
                        break;
                    }
                    BSerialTunnelShare.this.log().error("ReadSerial.run()::thread=" + Thread.currentThread().getName() + " Exception:" + e);
                    e.printStackTrace();
                    BSerialTunnelShare.this.connected = false;
                    break;
                }
                try {
                    if (len <= 0) continue;
                    BSerialTunnelShare.this.log().trace(BSerialTunnelShare.this.toDebugString("from Serial: ", data, len));
                    if (BSerialTunnelShare.this.connected) {
                        this.bufferedPipeOut.write(data, 0, len);
                    }
                    this.bufferedPipeOut.flush();
                }
                catch (Exception e) {
                    BSerialTunnelShare.this.log().error("ReadSerial.run()::thread=" + Thread.currentThread().getName() + " Exception:" + e);
                    e.printStackTrace();
                }
            }
            try {
                this.bufferedPipeOut.close();
                BSerialTunnelShare.this.pipedOutput.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            BSerialTunnelShare.this.log().trace(Thread.currentThread().getName() + " is stopped!");
        }
    }
}

